/*
 * Decompiled with CFR 0.152.
 */
package com.spyxar.tiptapshow.components;

import com.spyxar.tiptapshow.components.RenderableButton;
import net.minecraft.class_304;
import net.minecraft.class_332;

public class Row {
    private static final int SEPARATOR_SIZE = 1;
    private final RenderableButton[] buttons;
    private final int x;
    private int y;
    private final int width;
    private final int height;

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
        for (RenderableButton button : this.buttons) {
            if (button == null) continue;
            button.y = y;
        }
    }

    public int getHeight() {
        return this.height;
    }

    public Row(int x, int y, int width, int height, class_304 ... keyBindings) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.buttons = this.createRenderableButtonsForKeyBindings(keyBindings);
    }

    public RenderableButton[] createRenderableButtonsForKeyBindings(class_304[] keyBindings) {
        RenderableButton[] renderableButtons = new RenderableButton[keyBindings.length];
        int amountOfButtons = keyBindings.length;
        int amountOfSeparators = amountOfButtons - 1;
        int buttonWidth = (this.width - amountOfSeparators * 1) / amountOfButtons;
        for (int i = 0; i < keyBindings.length; ++i) {
            class_304 keyBinding = keyBindings[i];
            if (keyBinding == null) continue;
            int buttonX = this.x + buttonWidth * i + i * 1;
            int buttonY = this.y;
            int buttonHeight = this.height;
            renderableButtons[i] = new RenderableButton(buttonX, buttonY, buttonWidth, buttonHeight, keyBinding);
        }
        return renderableButtons;
    }

    public void render(class_332 context) {
        for (RenderableButton button : this.buttons) {
            if (button == null) continue;
            button.render(context);
        }
    }
}

