/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.audioplayer.microhttp;

import de.maxhenkel.audioplayer.microhttp.ByteMerger;
import de.maxhenkel.audioplayer.microhttp.ByteTokenizer;
import de.maxhenkel.audioplayer.microhttp.Header;
import de.maxhenkel.audioplayer.microhttp.Request;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;

class RequestParser {
    private static final byte[] CRLF = "\r\n".getBytes();
    private static final byte[] SPACE = " ".getBytes();
    private static final String HEADER_CONTENT_LENGTH = "Content-Length";
    private static final String HEADER_TRANSFER_ENCODING = "Transfer-Encoding";
    private static final String CHUNKED = "chunked";
    private static final byte[] EMPTY_BODY = new byte[0];
    private static final int RADIX_HEX = 16;
    private final ByteTokenizer tokenizer;
    private State state = State.METHOD;
    private int contentLength;
    private int chunkSize;
    private ByteMerger chunks = new ByteMerger();
    private String method;
    private String uri;
    private String version;
    private List<Header> headers = new ArrayList<Header>();
    private byte[] body;

    RequestParser(ByteTokenizer tokenizer) {
        this.tokenizer = tokenizer;
    }

    boolean parse() {
        while (this.state != State.DONE) {
            byte[] token = this.state.tokenSupplier.apply(this);
            if (token == null) {
                return false;
            }
            this.state.tokenConsumer.accept(this, token);
        }
        return true;
    }

    Request request() {
        return new Request(this.method, this.uri, this.version, this.headers, this.body);
    }

    private void parseMethod(byte[] token) {
        this.method = new String(token);
        this.state = State.URI;
    }

    private void parseUri(byte[] token) {
        this.uri = new String(token);
        this.state = State.VERSION;
    }

    private void parseVersion(byte[] token) {
        this.version = new String(token);
        this.state = State.HEADER;
    }

    private void parseHeader(byte[] token) {
        if (token.length == 0) {
            if (this.hasMultipleTransferLengths()) {
                throw new IllegalStateException("multiple message lengths");
            }
            Integer contentLength = this.findContentLength();
            if (contentLength == null) {
                if (this.hasChunkedEncodingHeader()) {
                    this.state = State.CHUNK_SIZE;
                } else {
                    this.body = EMPTY_BODY;
                    this.state = State.DONE;
                }
            } else {
                this.contentLength = contentLength;
                this.state = State.BODY;
            }
        } else {
            this.headers.add(RequestParser.parseHeaderLine(token));
        }
    }

    private static Header parseHeaderLine(byte[] line) {
        int spaceIndex;
        int colonIndex = RequestParser.indexOfColon(line);
        if (colonIndex <= 0) {
            throw new IllegalStateException("malformed header line");
        }
        for (spaceIndex = colonIndex + 1; spaceIndex < line.length && line[spaceIndex] == 32; ++spaceIndex) {
        }
        return new Header(new String(line, 0, colonIndex), new String(line, spaceIndex, line.length - spaceIndex));
    }

    private static int indexOfColon(byte[] line) {
        for (int i = 0; i < line.length; ++i) {
            if (line[i] != 58) continue;
            return i;
        }
        return -1;
    }

    private void parseChunkSize(byte[] token) {
        try {
            this.chunkSize = Integer.parseInt(new String(token), 16);
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException("invalid chunk size");
        }
        this.state = this.chunkSize == 0 ? State.CHUNK_TRAILER : State.CHUNK_DATA;
    }

    private void parseChunkData(byte[] token) {
        this.chunks.add(token);
        this.state = State.CHUNK_DATA_END;
    }

    private void parseChunkDateEnd() {
        this.state = State.CHUNK_SIZE;
    }

    private void parseChunkTrailer() {
        this.body = this.chunks.merge();
        this.state = State.DONE;
    }

    private void parseBody(byte[] token) {
        this.body = token;
        this.state = State.DONE;
    }

    private boolean hasMultipleTransferLengths() {
        int count = 0;
        for (Header header : this.headers) {
            if (!header.name().equalsIgnoreCase(HEADER_CONTENT_LENGTH) && !header.name().equalsIgnoreCase(HEADER_TRANSFER_ENCODING)) continue;
            ++count;
        }
        return count > 1;
    }

    private Integer findContentLength() {
        try {
            for (Header header : this.headers) {
                if (!header.name().equalsIgnoreCase(HEADER_CONTENT_LENGTH)) continue;
                return Integer.parseInt(header.value());
            }
            return null;
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException("invalid content-length header value");
        }
    }

    private boolean hasChunkedEncodingHeader() {
        for (Header header : this.headers) {
            if (!header.name().equalsIgnoreCase(HEADER_TRANSFER_ENCODING) || !header.value().equalsIgnoreCase(CHUNKED)) continue;
            return true;
        }
        return false;
    }

    static enum State {
        METHOD(p -> p.tokenizer.next(SPACE), RequestParser::parseMethod),
        URI(p -> p.tokenizer.next(SPACE), RequestParser::parseUri),
        VERSION(p -> p.tokenizer.next(CRLF), RequestParser::parseVersion),
        HEADER(p -> p.tokenizer.next(CRLF), RequestParser::parseHeader),
        BODY(p -> p.tokenizer.next(p.contentLength), RequestParser::parseBody),
        CHUNK_SIZE(p -> p.tokenizer.next(CRLF), RequestParser::parseChunkSize),
        CHUNK_DATA(p -> p.tokenizer.next(p.chunkSize), RequestParser::parseChunkData),
        CHUNK_DATA_END(p -> p.tokenizer.next(CRLF), (rp, token) -> rp.parseChunkDateEnd()),
        CHUNK_TRAILER(p -> p.tokenizer.next(CRLF), (rp, token) -> rp.parseChunkTrailer()),
        DONE(null, null);

        final Function<RequestParser, byte[]> tokenSupplier;
        final BiConsumer<RequestParser, byte[]> tokenConsumer;

        private State(Function<RequestParser, byte[]> tokenSupplier, BiConsumer<RequestParser, byte[]> tokenConsumer) {
            this.tokenSupplier = tokenSupplier;
            this.tokenConsumer = tokenConsumer;
        }
    }
}

