/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.audioplayer.command;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.maxhenkel.admiral.annotations.Command;
import de.maxhenkel.admiral.annotations.Name;
import de.maxhenkel.admiral.annotations.RequiresPermission;
import de.maxhenkel.audioplayer.CustomSound;
import de.maxhenkel.audioplayer.FileNameManager;
import de.maxhenkel.audioplayer.PlayerType;
import de.maxhenkel.audioplayer.command.UploadCommands;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_10710;
import net.minecraft.class_10712;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_3222;
import net.minecraft.class_6880;
import net.minecraft.class_7445;
import net.minecraft.class_7924;
import net.minecraft.class_9334;
import net.minecraft.class_9792;

@Command(value={"audioplayer"})
public class UtilityCommands {
    @RequiresPermission(value="audioplayer.apply")
    @Command(value={"set_random"})
    public void set_random(CommandContext<class_2168> context, @Name(value="enabled") boolean enabled) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        class_1799 itemInHand = player.method_5998(class_1268.field_5808);
        PlayerType playerType = PlayerType.fromItemStack(itemInHand);
        if (playerType == null) {
            ((class_2168)context.getSource()).method_9213(class_2561.method_30163((String)"Invalid Item"));
            return;
        }
        CustomSound sound = UtilityCommands.getHeldSound(context);
        if (sound == null) {
            return;
        }
        sound.setRandomization(enabled);
        sound.saveToItem(itemInHand, null, false);
        if (enabled) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Successfully enabled randomization, more sounds can now be added to this item"), false);
        } else {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Successfully disabled randomization, extra sounds have been removed"), false);
        }
    }

    @RequiresPermission(value="audioplayer.apply")
    @Command(value={"clear"})
    public void clear(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_10712 tooltipDisplay;
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        class_1799 itemInHand = player.method_5998(class_1268.field_5808);
        PlayerType playerType = PlayerType.fromItemStack(itemInHand);
        if (playerType == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Invalid item"));
            return;
        }
        if (!CustomSound.clearItem(itemInHand)) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Item does not have custom audio"));
            return;
        }
        if (itemInHand.method_57826(class_9334.field_49612)) {
            Optional holder = ((class_2168)context.getSource()).method_9211().method_30611().method_30530(class_7924.field_41275).method_46746(class_7445.field_39126);
            holder.ifPresent(instrumentReference -> itemInHand.method_57379(class_9334.field_49612, (Object)new class_10710((class_6880)instrumentReference)));
        }
        if (itemInHand.method_57826(class_9334.field_52175)) {
            class_9792 jukeboxPlayable = (class_9792)itemInHand.method_7909().method_57347().method_58694(class_9334.field_52175);
            if (jukeboxPlayable != null) {
                itemInHand.method_57379(class_9334.field_52175, (Object)jukeboxPlayable);
            } else {
                itemInHand.method_57381(class_9334.field_52175);
            }
        }
        if ((tooltipDisplay = (class_10712)itemInHand.method_58694(class_9334.field_56400)) != null) {
            LinkedHashSet hiddenComponents = new LinkedHashSet(tooltipDisplay.comp_3601());
            hiddenComponents.remove(class_9334.field_52175);
            hiddenComponents.remove(class_9334.field_49612);
            itemInHand.method_57379(class_9334.field_56400, (Object)new class_10712(tooltipDisplay.comp_3600(), hiddenComponents));
        }
        if (itemInHand.method_57826(class_9334.field_49632)) {
            itemInHand.method_57381(class_9334.field_49632);
        }
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Successfully cleared item"), false);
    }

    @Command(value={"id"})
    public void id(CommandContext<class_2168> context) throws CommandSyntaxException {
        CustomSound customSound = UtilityCommands.getHeldSound(context);
        if (customSound == null) {
            return;
        }
        if (customSound.isRandomized()) {
            ArrayList<UUID> sounds = customSound.getRandomSounds();
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Item contains %d sounds".formatted(sounds.size())), false);
            int i = 0;
            while (i < sounds.size()) {
                int finalI = i++;
                ((class_2168)context.getSource()).method_9226(() -> UploadCommands.sendUUIDMessage((UUID)sounds.get(finalI), class_2561.method_43470((String)"Sound %d.".formatted(finalI))), false);
            }
            return;
        }
        ((class_2168)context.getSource()).method_9226(() -> UploadCommands.sendUUIDMessage(customSound.getSoundId(), class_2561.method_43470((String)"Successfully extracted sound ID.")), false);
    }

    @Command(value={"name"})
    public void name(CommandContext<class_2168> context) throws CommandSyntaxException {
        CustomSound customSound = UtilityCommands.getHeldSound(context);
        if (customSound == null) {
            return;
        }
        Optional<FileNameManager> optionalMgr = FileNameManager.instance();
        if (optionalMgr.isEmpty()) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"An internal error occurred"));
            return;
        }
        FileNameManager mgr = optionalMgr.get();
        if (customSound.isRandomized()) {
            ArrayList<UUID> sounds = customSound.getRandomSounds();
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Item contains %d sounds".formatted(sounds.size())), false);
            for (UUID sound : sounds) {
                UtilityCommands.sendSoundName(context, mgr, sound);
            }
            return;
        }
        UtilityCommands.sendSoundName(context, mgr, customSound.getSoundId());
    }

    public static void sendSoundName(CommandContext<class_2168> context, FileNameManager mgr, UUID id) {
        String fileName = mgr.getFileName(id);
        if (fileName == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Custom audio does not have an associated file name"));
            return;
        }
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Audio file name: ").method_10852((class_2561)class_2561.method_43470((String)fileName).method_27694(style -> style.method_10977(class_124.field_1060).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)"Click to copy"))).method_10958((class_2558)new class_2558.class_10606(fileName)))), false);
    }

    public static CustomSound getHeldSound(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        class_1799 itemInHand = player.method_5998(class_1268.field_5808);
        PlayerType playerType = PlayerType.fromItemStack(itemInHand);
        if (playerType == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Invalid item"));
            return null;
        }
        CustomSound customSound = CustomSound.of(itemInHand);
        if (customSound == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Item does not have custom audio"));
            return null;
        }
        return customSound;
    }
}

