/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.audioplayer;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import de.maxhenkel.audioplayer.PlayerType;
import de.maxhenkel.audioplayer.configbuilder.entry.ConfigEntry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;
import net.minecraft.class_10712;
import net.minecraft.class_124;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2484;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_4844;
import net.minecraft.class_9279;
import net.minecraft.class_9290;
import net.minecraft.class_9331;
import net.minecraft.class_9334;

public class CustomSound {
    public static final String CUSTOM_SOUND = "CustomSound";
    public static final String CUSTOM_SOUND_RANDOM = "CustomSoundRandomized";
    public static final String CUSTOM_SOUND_RANGE = "CustomSoundRange";
    public static final String CUSTOM_SOUND_STATIC = "IsStaticCustomSound";
    private static final String ID = "id";
    public static final String DEFAULT_HEAD_LORE = "Has custom audio";
    protected UUID soundId;
    protected ArrayList<UUID> randomSounds;
    @Nullable
    protected Float range;
    protected boolean staticSound;

    public CustomSound(UUID soundId, @Nullable Float range, @Nullable ArrayList<UUID> randomSounds, boolean staticSound) {
        this.soundId = soundId;
        this.range = range;
        this.staticSound = staticSound;
        this.randomSounds = randomSounds;
    }

    @Nullable
    public static CustomSound of(class_1799 item) {
        class_9279 customData = (class_9279)item.method_58694(class_9334.field_49628);
        if (customData == null) {
            return null;
        }
        return CustomSound.of(customData.method_57461());
    }

    @Nullable
    public static CustomSound of(class_2487 tag) {
        if (!tag.method_10545(CUSTOM_SOUND)) {
            return null;
        }
        UUID soundId = tag.method_67491(CUSTOM_SOUND, class_4844.field_25122).orElse(null);
        ArrayList<UUID> randomSounds = null;
        if (tag.method_10545(CUSTOM_SOUND_RANDOM)) {
            randomSounds = CustomSound.readUUIDArrayFromNbt(tag, CUSTOM_SOUND_RANDOM);
        }
        Float range = tag.method_10583(CUSTOM_SOUND_RANGE).orElse(null);
        boolean staticSound = tag.method_10577(CUSTOM_SOUND_STATIC).orElse(false);
        return new CustomSound(soundId, range, randomSounds, staticSound);
    }

    public UUID getSoundId() {
        if (this.isRandomized()) {
            return this.randomSounds.get(ThreadLocalRandom.current().nextInt(this.randomSounds.size()));
        }
        return this.soundId;
    }

    public boolean isRandomized() {
        return this.randomSounds != null && !this.randomSounds.isEmpty();
    }

    public ArrayList<UUID> getRandomSounds() {
        return this.randomSounds;
    }

    public void addRandomSound(UUID id) {
        this.setRandomization(true);
        this.randomSounds.add(id);
    }

    public void setRandomization(boolean enabled) {
        if (enabled) {
            if (this.randomSounds == null) {
                this.randomSounds = new ArrayList();
                this.randomSounds.add(this.soundId);
            }
        } else {
            this.randomSounds = null;
        }
    }

    public Optional<Float> getRange() {
        return Optional.ofNullable(this.range);
    }

    public float getRange(PlayerType playerType) {
        return this.getRangeOrDefault(playerType.getDefaultRange(), playerType.getMaxRange());
    }

    public float getRangeOrDefault(ConfigEntry<Float> defaultRange, ConfigEntry<Float> maxRange) {
        if (this.range == null) {
            return defaultRange.get().floatValue();
        }
        if (this.range.floatValue() > maxRange.get().floatValue()) {
            return maxRange.get().floatValue();
        }
        return this.range.floatValue();
    }

    public boolean isStaticSound() {
        return this.staticSound;
    }

    public void saveToNbt(class_2487 tag) {
        if (this.soundId != null) {
            tag.method_67494(CUSTOM_SOUND, class_4844.field_25122, (Object)this.soundId);
        } else {
            tag.method_10551(CUSTOM_SOUND);
        }
        if (this.randomSounds != null) {
            CustomSound.saveUUIDArrayToNbt(tag, CUSTOM_SOUND_RANDOM, this.randomSounds);
        } else {
            tag.method_10551(CUSTOM_SOUND_RANDOM);
        }
        if (this.range != null) {
            tag.method_10548(CUSTOM_SOUND_RANGE, this.range.floatValue());
        } else {
            tag.method_10551(CUSTOM_SOUND_RANGE);
        }
        if (this.staticSound) {
            tag.method_10556(CUSTOM_SOUND_STATIC, true);
        } else {
            tag.method_10551(CUSTOM_SOUND_STATIC);
        }
    }

    public static void saveUUIDArrayToNbt(class_2487 tag, String id, List<UUID> uuids) {
        class_2499 uuidList = new class_2499();
        for (UUID uuid : uuids) {
            uuidList.add((Object)((class_2520)class_4844.field_25122.encodeStart((DynamicOps)class_2509.field_11560, (Object)uuid).getOrThrow()));
        }
        tag.method_10566(id, (class_2520)uuidList);
    }

    public static ArrayList<UUID> readUUIDArrayFromNbt(class_2487 tag, String id) {
        class_2499 list = tag.method_10554(id).orElse(new class_2499());
        ArrayList<UUID> uuidList = new ArrayList<UUID>(list.size());
        for (class_2520 value : list) {
            uuidList.add((UUID)((Pair)class_4844.field_25122.decode((DynamicOps)class_2509.field_11560, (Object)value).getOrThrow()).getFirst());
        }
        return uuidList;
    }

    public void saveToItemIgnoreLore(class_1799 stack) {
        this.saveToItem(stack, null, false);
    }

    public void saveToItem(class_1799 stack) {
        this.saveToItem(stack, null);
    }

    public void saveToItem(class_1799 stack, @Nullable String loreString) {
        this.saveToItem(stack, loreString, true);
    }

    public void saveToItem(class_1799 stack, @Nullable String loreString, boolean applyLore) {
        class_1747 blockItem;
        class_9279 customData = (class_9279)stack.method_58695(class_9334.field_49628, (Object)class_9279.field_49302);
        class_2487 tag = customData.method_57461();
        this.saveToNbt(tag);
        stack.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)tag));
        class_9290 l = null;
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof class_1747 && (blockItem = (class_1747)class_17922).method_7711() instanceof class_2484) {
            class_9279 blockEntityData = (class_9279)stack.method_58695(class_9334.field_49611, (Object)class_9279.field_49302);
            class_2487 blockEntityTag = blockEntityData.method_57461();
            this.saveToNbt(blockEntityTag);
            blockEntityTag.method_10582(ID, class_2591.field_11913.method_53254().method_40237().method_29177().toString());
            stack.method_57379(class_9334.field_49611, (Object)class_9279.method_57456((class_2487)blockEntityTag));
            if (loreString == null) {
                l = new class_9290(Collections.singletonList(class_2561.method_43470((String)DEFAULT_HEAD_LORE).method_27694(style -> style.method_10978(Boolean.valueOf(false))).method_27692(class_124.field_1080)));
            }
        }
        if (loreString != null) {
            l = new class_9290(Collections.singletonList(class_2561.method_43470((String)loreString).method_27694(style -> style.method_10978(Boolean.valueOf(false))).method_27692(class_124.field_1080)));
        }
        if (applyLore) {
            if (l != null) {
                stack.method_57379(class_9334.field_49632, l);
            } else {
                stack.method_57381(class_9334.field_49632);
            }
        }
        class_10712 tooltipDisplay = (class_10712)stack.method_58695(class_9334.field_56400, (Object)class_10712.field_56318);
        LinkedHashSet<class_9331> hiddenComponents = new LinkedHashSet<class_9331>(tooltipDisplay.comp_3601());
        hiddenComponents.add(class_9334.field_52175);
        hiddenComponents.add(class_9334.field_49612);
        stack.method_57379(class_9334.field_56400, (Object)new class_10712(tooltipDisplay.comp_3600(), hiddenComponents));
    }

    public CustomSound asStatic(boolean staticSound) {
        return new CustomSound(this.soundId, this.range, this.randomSounds, staticSound);
    }

    public static boolean clearItem(class_1799 stack) {
        class_9279 customData = (class_9279)stack.method_58694(class_9334.field_49628);
        if (customData == null) {
            return false;
        }
        class_2487 tag = customData.method_57461();
        if (!tag.method_10545(CUSTOM_SOUND)) {
            return false;
        }
        tag.method_10551(CUSTOM_SOUND);
        tag.method_10551(CUSTOM_SOUND_RANDOM);
        tag.method_10551(CUSTOM_SOUND_RANGE);
        tag.method_10551(CUSTOM_SOUND_STATIC);
        stack.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)tag));
        if (stack.method_7909() instanceof class_1747) {
            class_9279 blockEntityData = (class_9279)stack.method_58694(class_9334.field_49611);
            if (blockEntityData == null) {
                return true;
            }
            class_2487 blockEntityTag = blockEntityData.method_57461();
            blockEntityTag.method_10551(CUSTOM_SOUND);
            blockEntityTag.method_10551(CUSTOM_SOUND_RANDOM);
            blockEntityTag.method_10551(CUSTOM_SOUND_RANGE);
            blockEntityTag.method_10551(CUSTOM_SOUND_STATIC);
            stack.method_57379(class_9334.field_49611, (Object)class_9279.method_57456((class_2487)blockEntityTag));
        }
        return true;
    }
}

