/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.renderer.image;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import javax.imageio.ImageIO;
import net.minecraft.class_1011;
import org.tlauncher.renderer.image.ImageWrap;
import org.tlauncher.util.TextureUtils;
import org.tlauncher.util.TypeLocator;

public class NativeImageWrap
implements ImageWrap,
TypeLocator {
    private static Method readNativeImage;
    private final class_1011 nativeImage;

    public NativeImageWrap(InputStream inputStream) {
        this.nativeImage = this.readNativeImage(inputStream);
    }

    public NativeImageWrap(int width, int height) {
        this.nativeImage = new class_1011(width, height, true);
    }

    public NativeImageWrap(BufferedImage bufferedImage) {
        this.nativeImage = this.getNativeImage(bufferedImage);
    }

    private class_1011 getNativeImage(BufferedImage bufferedImage) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bufferedImage, "png", byteArrayOutputStream);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        return this.readNativeImage(byteArrayInputStream);
    }

    private class_1011 readNativeImage(InputStream inputStream) {
        if (readNativeImage == null) {
            readNativeImage = this.findMethod(class_1011.class, new TypeLocator.MethodData(true, "a", InputStream.class), new TypeLocator.MethodData(true, "read", InputStream.class), new TypeLocator.MethodData(true, "m_85058_", InputStream.class), new TypeLocator.MethodData(true, "method_4309", InputStream.class));
        }
        return (class_1011)readNativeImage.invoke(null, inputStream);
    }

    @Override
    public int getWidth() {
        return this.nativeImage.method_4307();
    }

    @Override
    public int getHeight() {
        return this.nativeImage.method_4323();
    }

    @Override
    public int getRGB(int x, int y) {
        return this.nativeImage.method_61940(x, y);
    }

    @Override
    public void setRGB(int x, int y, int color) {
        this.nativeImage.method_61941(x, y, color);
    }

    @Override
    public void allocateTexture(int textureId) {
        TextureUtils.prepareImage(textureId, this.getWidth(), this.getHeight());
    }

    @Override
    public void uploadTexture(int textureId) {
        this.nativeImage.method_4301(0, 0, 0, false);
    }

    @Override
    public void close() {
        this.nativeImage.close();
    }

    public class_1011 getNativeImage() {
        return this.nativeImage;
    }
}

