/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.util;

import com.mojang.blaze3d.buffers.BufferType;
import com.mojang.blaze3d.buffers.BufferUsage;
import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.function.Consumer;
import net.minecraft.class_1921;
import net.minecraft.class_276;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_9801;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;

public final class EasyVertexBuffer
implements AutoCloseable {
    private final RenderSystem.class_5590 shapeIndexBuffer;
    private final GpuBuffer vertexBuffer;
    private final int indexCount;

    public static EasyVertexBuffer createAndUpload(VertexFormat.class_5596 drawMode, VertexFormat format, Consumer<class_4588> callback) {
        class_287 bufferBuilder = class_289.method_1348().method_60827(drawMode, format);
        callback.accept((class_4588)bufferBuilder);
        try (class_9801 buffer = bufferBuilder.method_60794();){
            if (buffer == null) {
                EasyVertexBuffer easyVertexBuffer = new EasyVertexBuffer(drawMode);
                return easyVertexBuffer;
            }
            EasyVertexBuffer easyVertexBuffer = new EasyVertexBuffer(buffer, drawMode);
            return easyVertexBuffer;
        }
    }

    private EasyVertexBuffer(class_9801 buffer, VertexFormat.class_5596 drawMode) {
        class_9801.class_4574 drawParams = buffer.method_60822();
        this.shapeIndexBuffer = RenderSystem.getSequentialBuffer((VertexFormat.class_5596)drawParams.comp_752());
        this.indexCount = drawParams.comp_751();
        BufferType target = BufferType.VERTICES;
        BufferUsage usage = BufferUsage.STATIC_WRITE;
        this.vertexBuffer = RenderSystem.getDevice().createBuffer(null, target, usage, buffer.method_60818());
    }

    private EasyVertexBuffer(VertexFormat.class_5596 drawMode) {
        this.shapeIndexBuffer = null;
        this.indexCount = 0;
        this.vertexBuffer = null;
    }

    public void draw(class_4587 matrixStack, class_1921 layer) {
        Matrix4fStack modelViewStack = RenderSystem.getModelViewStack();
        modelViewStack.pushMatrix();
        modelViewStack.mul((Matrix4fc)matrixStack.method_23760().method_23761());
        this.draw(layer);
        modelViewStack.popMatrix();
    }

    public void draw(class_1921 layer) {
        if (this.vertexBuffer == null) {
            return;
        }
        layer.method_23516();
        class_276 framebuffer = layer.method_68494();
        RenderPipeline pipeline = layer.method_68495();
        GpuBuffer indexBuffer = this.shapeIndexBuffer.method_68274(this.indexCount);
        try (RenderPass renderPass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(framebuffer.method_30277(), OptionalInt.empty(), framebuffer.field_1478 ? framebuffer.method_30278() : null, OptionalDouble.empty());){
            renderPass.setPipeline(pipeline);
            renderPass.setVertexBuffer(0, this.vertexBuffer);
            renderPass.setIndexBuffer(indexBuffer, this.shapeIndexBuffer.method_31924());
            renderPass.drawIndexed(0, this.indexCount);
        }
        layer.method_23518();
    }

    @Override
    public void close() {
        if (this.vertexBuffer != null) {
            this.vertexBuffer.close();
        }
    }
}

