/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.test;

import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.File;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1074;
import net.minecraft.class_1157;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_276;
import net.minecraft.class_310;
import net.minecraft.class_318;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_3928;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_433;
import net.minecraft.class_437;
import net.minecraft.class_442;
import net.minecraft.class_490;
import net.minecraft.class_5498;
import net.minecraft.class_5676;
import net.minecraft.class_634;
import net.wurstclient.WurstClient;

public final class WurstClientTestHelper
extends Enum<WurstClientTestHelper> {
    private static final AtomicInteger screenshotCounter;
    private static final /* synthetic */ WurstClientTestHelper[] $VALUES;

    public static WurstClientTestHelper[] values() {
        return (WurstClientTestHelper[])$VALUES.clone();
    }

    public static WurstClientTestHelper valueOf(String name) {
        return Enum.valueOf(WurstClientTestHelper.class, name);
    }

    public static void submitAndWait(Consumer<class_310> consumer) {
        class_310 mc = class_310.method_1551();
        mc.method_20493(() -> consumer.accept(mc)).join();
    }

    public static <T> T submitAndGet(Function<class_310, T> function) {
        class_310 mc = class_310.method_1551();
        return mc.method_5385(() -> function.apply(mc)).join();
    }

    public static void wait(Duration duration) {
        try {
            Thread.sleep(duration.toMillis());
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static void waitUntil(String event, Predicate<class_310> condition, Duration maxDuration) {
        LocalDateTime startTime = LocalDateTime.now();
        LocalDateTime timeout = startTime.plus(maxDuration);
        System.out.println("Waiting until " + event);
        while (true) {
            if (WurstClientTestHelper.submitAndGet(condition::test).booleanValue()) break;
            if (LocalDateTime.now().isAfter(timeout)) {
                throw new RuntimeException("Waiting until " + event + " took too long");
            }
            WurstClientTestHelper.wait(Duration.ofMillis(50L));
        }
        double seconds = (double)Duration.between(startTime, LocalDateTime.now()).toMillis() / 1000.0;
        System.out.println("Waiting until " + event + " took " + seconds + "s");
    }

    public static void waitUntil(String event, Predicate<class_310> condition) {
        WurstClientTestHelper.waitUntil(event, condition, Duration.ofSeconds(10L));
    }

    public static void waitForScreen(Class<? extends class_437> screenClass) {
        WurstClientTestHelper.waitUntil("screen " + screenClass.getName() + " is open", mc -> screenClass.isInstance(mc.field_1755));
    }

    public static void waitForTitleScreenFade() {
        WurstClientTestHelper.waitUntil("title screen fade is complete", mc -> {
            class_437 patt0$temp = mc.field_1755;
            if (!(patt0$temp instanceof class_442)) {
                return false;
            }
            class_442 titleScreen = (class_442)patt0$temp;
            return !titleScreen.field_18222;
        });
    }

    public static void waitForResourceLoading() {
        WurstClientTestHelper.waitUntil("loading is complete", mc -> mc.method_18506() == null, Duration.ofMinutes(5L));
    }

    public static void waitForWorldLoad() {
        WurstClientTestHelper.waitUntil("world is loaded", mc -> mc.field_1687 != null && !(mc.field_1755 instanceof class_3928), Duration.ofMinutes(30L));
    }

    public static void waitForWorldTicks(int ticks) {
        long startTicks = WurstClientTestHelper.submitAndGet(mc -> mc.field_1687.method_8510());
        WurstClientTestHelper.waitUntil(ticks + " world ticks have passed", mc -> mc.field_1687.method_8510() >= startTicks + (long)ticks, Duration.ofMillis(ticks * 100).plusMinutes(5L));
    }

    public static void waitForBlock(int relX, int relY, int relZ, class_2248 block) {
        class_2338 pos = WurstClientTestHelper.submitAndGet(mc -> mc.field_1724.method_24515().method_10069(relX, relY, relZ));
        WurstClientTestHelper.waitUntil("block at ~" + relX + " ~" + relY + " ~" + relZ + " (" + pos.method_23854() + ") is " + String.valueOf(block), mc -> mc.field_1687.method_8320(pos).method_26204() == block);
    }

    public static void takeScreenshot(String name) {
        WurstClientTestHelper.takeScreenshot(name, Duration.ofMillis(50L));
    }

    public static void takeScreenshot(String name, Duration delay) {
        WurstClientTestHelper.wait(delay);
        String count = String.format("%02d", screenshotCounter.incrementAndGet());
        String filename = count + "_" + name + ".png";
        File gameDir = FabricLoader.getInstance().getGameDir().toFile();
        WurstClientTestHelper.submitAndWait(mc -> class_318.method_22690((File)gameDir, (String)filename, (class_276)mc.method_1522(), message -> {}));
    }

    public static class_4185 findButton(class_310 mc, String translationKey) {
        String message = class_1074.method_4662((String)translationKey, (Object[])new Object[0]);
        for (class_4068 drawable : mc.field_1755.field_33816) {
            class_4185 button;
            if (!(drawable instanceof class_4185) || !(button = (class_4185)drawable).method_25369().getString().equals(message)) continue;
            return button;
        }
        throw new RuntimeException(message + " button could not be found");
    }

    public static void checkButtonPosition(class_4185 button, int expectedX, int expectedY) {
        String buttonName = button.method_25369().getString();
        if (button.method_46426() != expectedX) {
            throw new RuntimeException(buttonName + " button is at the wrong X coordinate. Expected X: " + expectedX + ", actual X: " + button.method_46426());
        }
        if (button.method_46427() != expectedY) {
            throw new RuntimeException(buttonName + " button is at the wrong Y coordinate. Expected Y: " + expectedY + ", actual Y: " + button.method_46427());
        }
    }

    public static void clickButton(String translationKey) {
        String buttonText = class_1074.method_4662((String)translationKey, (Object[])new Object[0]);
        WurstClientTestHelper.waitUntil("button saying " + buttonText + " is visible", mc -> {
            class_437 screen = mc.field_1755;
            if (screen == null) {
                return false;
            }
            for (class_4068 drawable : screen.field_33816) {
                class_4185 button;
                if (!(drawable instanceof class_339)) continue;
                class_339 widget = (class_339)drawable;
                if (widget instanceof class_4185 && buttonText.equals((button = (class_4185)widget).method_25369().getString())) {
                    button.method_25306();
                    return true;
                }
                if (!(widget instanceof class_5676)) continue;
                button = (class_5676)widget;
                if (!buttonText.equals(button.field_27963.getString())) continue;
                button.method_25306();
                return true;
            }
            return false;
        });
    }

    public static void setTextFieldText(int index, String text) {
        WurstClientTestHelper.waitUntil("text field #" + index + " is visible", mc -> {
            class_437 screen = mc.field_1755;
            if (screen == null) {
                return false;
            }
            int i = 0;
            for (class_4068 drawable : screen.field_33816) {
                if (!(drawable instanceof class_342)) continue;
                class_342 textField = (class_342)drawable;
                if (i == index) {
                    textField.method_1852(text);
                    return true;
                }
                ++i;
            }
            return false;
        });
    }

    public static void closeScreen() {
        WurstClientTestHelper.submitAndWait(mc -> mc.method_1507(null));
    }

    public static void openGameMenu() {
        WurstClientTestHelper.submitAndWait(mc -> mc.method_1507((class_437)new class_433(true)));
    }

    public static void openInventory() {
        WurstClientTestHelper.submitAndWait(mc -> mc.method_1507((class_437)new class_490((class_1657)mc.field_1724)));
    }

    public static void toggleDebugHud() {
        WurstClientTestHelper.submitAndWait(mc -> mc.field_1705.method_53531().method_53539());
    }

    public static void setPerspective(class_5498 perspective) {
        WurstClientTestHelper.submitAndWait(mc -> mc.field_1690.method_31043(perspective));
    }

    public static void dismissTutorialToasts() {
        WurstClientTestHelper.submitAndWait(mc -> mc.method_1577().method_4910(class_1157.field_5653));
    }

    public static void clearChat() {
        WurstClientTestHelper.submitAndWait(mc -> mc.field_1705.method_1743().method_1808(true));
    }

    public static void runChatCommand(String command) {
        System.out.println("Running command: /" + command);
        WurstClientTestHelper.submitAndWait(mc -> {
            class_634 netHandler = mc.method_1562();
            ParseResults results = netHandler.method_2886().parse(command, (Object)netHandler.method_2875());
            if (!results.getExceptions().isEmpty()) {
                StringBuilder errors = new StringBuilder("Invalid command: " + command);
                for (CommandSyntaxException e : results.getExceptions().values()) {
                    errors.append("\n").append(e.getMessage());
                }
                throw new RuntimeException(errors.toString());
            }
            netHandler.method_45730(command);
        });
        WurstClientTestHelper.waitForWorldTicks(1);
    }

    public static void runWurstCommand(String command) {
        System.out.println("Running command: ." + command);
        WurstClientTestHelper.submitAndWait(mc -> WurstClient.INSTANCE.getCmdProcessor().process(command));
    }

    public static void rightClickInGame() {
        WurstClientTestHelper.submitAndWait(class_310::method_1583);
        WurstClientTestHelper.waitForWorldTicks(1);
    }

    public static void assertOneItemInSlot(int slot, class_1792 item) {
        WurstClientTestHelper.submitAndWait(mc -> {
            class_1799 stack = mc.field_1724.method_31548().method_5438(slot);
            if (!stack.method_31574(item) || stack.method_7947() != 1) {
                throw new RuntimeException("Expected 1 " + item.method_63680().getString() + " at slot " + slot + ", found " + stack.method_7947() + " " + stack.method_7909().method_63680().getString() + " instead");
            }
        });
    }

    public static void assertNoItemInSlot(int slot) {
        WurstClientTestHelper.submitAndWait(mc -> {
            class_1799 stack = mc.field_1724.method_31548().method_5438(slot);
            if (!stack.method_7960()) {
                throw new RuntimeException("Expected no item in slot " + slot + ", found " + stack.method_7947() + " " + stack.method_7909().method_63680().getString() + " instead");
            }
        });
    }

    private static /* synthetic */ WurstClientTestHelper[] $values() {
        return new WurstClientTestHelper[0];
    }

    static {
        $VALUES = WurstClientTestHelper.$values();
        screenshotCounter = new AtomicInteger(0);
    }
}

