/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.hacks;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_10257;
import net.minecraft.class_1297;
import net.minecraft.class_1694;
import net.minecraft.class_1700;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2601;
import net.minecraft.class_2608;
import net.minecraft.class_2609;
import net.minecraft.class_2611;
import net.minecraft.class_2614;
import net.minecraft.class_2627;
import net.minecraft.class_2646;
import net.minecraft.class_3719;
import net.minecraft.class_4587;
import net.minecraft.class_7264;
import net.minecraft.class_8172;
import net.minecraft.class_8887;
import net.wurstclient.Category;
import net.wurstclient.events.CameraTransformViewBobbingListener;
import net.wurstclient.events.RenderListener;
import net.wurstclient.events.UpdateListener;
import net.wurstclient.hack.Hack;
import net.wurstclient.hacks.chestesp.ChestEspBlockGroup;
import net.wurstclient.hacks.chestesp.ChestEspEntityGroup;
import net.wurstclient.hacks.chestesp.ChestEspGroup;
import net.wurstclient.settings.CheckboxSetting;
import net.wurstclient.settings.ColorSetting;
import net.wurstclient.settings.EspStyleSetting;
import net.wurstclient.settings.Setting;
import net.wurstclient.util.RenderUtils;
import net.wurstclient.util.chunk.ChunkUtils;

public class ChestEspHack
extends Hack
implements UpdateListener,
CameraTransformViewBobbingListener,
RenderListener {
    private final EspStyleSetting style = new EspStyleSetting();
    private final ChestEspBlockGroup basicChests = new ChestEspBlockGroup(new ColorSetting("Chest color", "Normal chests will be highlighted in this color.", Color.GREEN), null);
    private final ChestEspBlockGroup trapChests = new ChestEspBlockGroup(new ColorSetting("Trap chest color", "Trapped chests will be highlighted in this color.", new Color(0xFF8000)), new CheckboxSetting("Include trap chests", true));
    private final ChestEspBlockGroup enderChests = new ChestEspBlockGroup(new ColorSetting("Ender color", "Ender chests will be highlighted in this color.", Color.CYAN), new CheckboxSetting("Include ender chests", true));
    private final ChestEspEntityGroup chestCarts = new ChestEspEntityGroup(new ColorSetting("Chest cart color", "Minecarts with chests will be highlighted in this color.", Color.YELLOW), new CheckboxSetting("Include chest carts", true));
    private final ChestEspEntityGroup chestBoats = new ChestEspEntityGroup(new ColorSetting("Chest boat color", "Boats with chests will be highlighted in this color.", Color.YELLOW), new CheckboxSetting("Include chest boats", true));
    private final ChestEspBlockGroup barrels = new ChestEspBlockGroup(new ColorSetting("Barrel color", "Barrels will be highlighted in this color.", Color.GREEN), new CheckboxSetting("Include barrels", true));
    private final ChestEspBlockGroup pots = new ChestEspBlockGroup(new ColorSetting("Pots color", "Decorated pots will be highlighted in this color.", Color.GREEN), new CheckboxSetting("Include pots", false));
    private final ChestEspBlockGroup shulkerBoxes = new ChestEspBlockGroup(new ColorSetting("Shulker color", "Shulker boxes will be highlighted in this color.", Color.MAGENTA), new CheckboxSetting("Include shulkers", true));
    private final ChestEspBlockGroup hoppers = new ChestEspBlockGroup(new ColorSetting("Hopper color", "Hoppers will be highlighted in this color.", Color.WHITE), new CheckboxSetting("Include hoppers", false));
    private final ChestEspEntityGroup hopperCarts = new ChestEspEntityGroup(new ColorSetting("Hopper cart color", "Minecarts with hoppers will be highlighted in this color.", Color.YELLOW), new CheckboxSetting("Include hopper carts", false));
    private final ChestEspBlockGroup droppers = new ChestEspBlockGroup(new ColorSetting("Dropper color", "Droppers will be highlighted in this color.", Color.WHITE), new CheckboxSetting("Include droppers", false));
    private final ChestEspBlockGroup dispensers = new ChestEspBlockGroup(new ColorSetting("Dispenser color", "Dispensers will be highlighted in this color.", new Color(0xFF8000)), new CheckboxSetting("Include dispensers", false));
    private final ChestEspBlockGroup crafters = new ChestEspBlockGroup(new ColorSetting("Crafter color", "Crafters will be highlighted in this color.", Color.WHITE), new CheckboxSetting("Include crafters", false));
    private final ChestEspBlockGroup furnaces = new ChestEspBlockGroup(new ColorSetting("Furnace color", "Furnaces, smokers, and blast furnaces will be highlighted in this color.", Color.RED), new CheckboxSetting("Include furnaces", false));
    private final List<ChestEspGroup> groups = Arrays.asList(this.basicChests, this.trapChests, this.enderChests, this.chestCarts, this.chestBoats, this.barrels, this.pots, this.shulkerBoxes, this.hoppers, this.hopperCarts, this.droppers, this.dispensers, this.crafters, this.furnaces);
    private final List<ChestEspEntityGroup> entityGroups = Arrays.asList(this.chestCarts, this.chestBoats, this.hopperCarts);

    public ChestEspHack() {
        super("ChestESP");
        this.setCategory(Category.RENDER);
        this.addSetting(this.style);
        this.groups.stream().flatMap(ChestEspGroup::getSettings).forEach(x$0 -> this.addSetting((Setting)x$0));
    }

    @Override
    protected void onEnable() {
        EVENTS.add(UpdateListener.class, this);
        EVENTS.add(CameraTransformViewBobbingListener.class, this);
        EVENTS.add(RenderListener.class, this);
    }

    @Override
    protected void onDisable() {
        EVENTS.remove(UpdateListener.class, this);
        EVENTS.remove(CameraTransformViewBobbingListener.class, this);
        EVENTS.remove(RenderListener.class, this);
        this.groups.forEach(ChestEspGroup::clear);
    }

    @Override
    public void onUpdate() {
        this.groups.forEach(ChestEspGroup::clear);
        ArrayList blockEntities = ChunkUtils.getLoadedBlockEntities().collect(Collectors.toCollection(ArrayList::new));
        for (class_2586 blockEntity : blockEntities) {
            if (blockEntity instanceof class_2646) {
                this.trapChests.add(blockEntity);
                continue;
            }
            if (blockEntity instanceof class_2595) {
                this.basicChests.add(blockEntity);
                continue;
            }
            if (blockEntity instanceof class_2611) {
                this.enderChests.add(blockEntity);
                continue;
            }
            if (blockEntity instanceof class_2627) {
                this.shulkerBoxes.add(blockEntity);
                continue;
            }
            if (blockEntity instanceof class_3719) {
                this.barrels.add(blockEntity);
                continue;
            }
            if (blockEntity instanceof class_8172) {
                this.pots.add(blockEntity);
                continue;
            }
            if (blockEntity instanceof class_2614) {
                this.hoppers.add(blockEntity);
                continue;
            }
            if (blockEntity instanceof class_2608) {
                this.droppers.add(blockEntity);
                continue;
            }
            if (blockEntity instanceof class_2601) {
                this.dispensers.add(blockEntity);
                continue;
            }
            if (blockEntity instanceof class_8887) {
                this.crafters.add(blockEntity);
                continue;
            }
            if (!(blockEntity instanceof class_2609)) continue;
            this.furnaces.add(blockEntity);
        }
        for (class_1297 entity : ChestEspHack.MC.field_1687.method_18112()) {
            if (entity instanceof class_1694) {
                this.chestCarts.add(entity);
                continue;
            }
            if (entity instanceof class_1700) {
                this.hopperCarts.add(entity);
                continue;
            }
            if (!(entity instanceof class_7264) && !(entity instanceof class_10257)) continue;
            this.chestBoats.add(entity);
        }
    }

    @Override
    public void onCameraTransformViewBobbing(CameraTransformViewBobbingListener.CameraTransformViewBobbingEvent event) {
        if (this.style.hasLines()) {
            event.cancel();
        }
    }

    @Override
    public void onRender(class_4587 matrixStack, float partialTicks) {
        this.entityGroups.stream().filter(ChestEspGroup::isEnabled).forEach(g -> g.updateBoxes(partialTicks));
        if (this.style.hasBoxes()) {
            this.renderBoxes(matrixStack);
        }
        if (this.style.hasLines()) {
            this.renderTracers(matrixStack, partialTicks);
        }
    }

    private void renderBoxes(class_4587 matrixStack) {
        for (ChestEspGroup group : this.groups) {
            if (!group.isEnabled()) continue;
            List<class_238> boxes = group.getBoxes();
            int quadsColor = group.getColorI(64);
            int linesColor = group.getColorI(128);
            RenderUtils.drawSolidBoxes(matrixStack, boxes, quadsColor, false);
            RenderUtils.drawOutlinedBoxes(matrixStack, boxes, linesColor, false);
        }
    }

    private void renderTracers(class_4587 matrixStack, float partialTicks) {
        for (ChestEspGroup group : this.groups) {
            if (!group.isEnabled()) continue;
            List<class_238> boxes = group.getBoxes();
            List<class_243> ends = boxes.stream().map(class_238::method_1005).toList();
            int color = group.getColorI(128);
            RenderUtils.drawTracers(matrixStack, partialTicks, ends, color, false);
        }
    }
}

