/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.config.ui;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Iterators;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.architectury.registry.registries.Registries;
import dev.ftb.mods.ftblibrary.FTBLibrary;
import dev.ftb.mods.ftblibrary.config.ConfigCallback;
import dev.ftb.mods.ftblibrary.config.IntConfig;
import dev.ftb.mods.ftblibrary.config.ItemStackConfig;
import dev.ftb.mods.ftblibrary.config.NBTConfig;
import dev.ftb.mods.ftblibrary.config.ui.EditConfigFromStringScreen;
import dev.ftb.mods.ftblibrary.config.ui.ItemSearchMode;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.BlankPanel;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.PanelScrollBar;
import dev.ftb.mods.ftblibrary.ui.SimpleTextButton;
import dev.ftb.mods.ftblibrary.ui.TextBox;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.WidgetLayout;
import dev.ftb.mods.ftblibrary.ui.WidgetType;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class SelectItemStackScreen
extends BaseScreen {
    public static final ExecutorService ITEM_SEARCH = Executors.newSingleThreadExecutor(task -> {
        Thread thread = new Thread(task, "FTBLibrary-ItemSearch");
        thread.setDaemon(true);
        return thread;
    });
    public static final List<ItemSearchMode> modes = new ArrayList<ItemSearchMode>();
    private static ItemSearchMode activeMode;
    private final ItemStackConfig config;
    private final ConfigCallback callback;
    private ItemStack current;
    private final Button buttonCancel;
    private final Button buttonAccept;
    private final Panel panelStacks;
    private final PanelScrollBar scrollBar;
    private final TextBox searchBox;
    private final Panel tabs;
    public long update = Long.MAX_VALUE;

    public List<Widget> getItems(String search, Panel panel) {
        Stopwatch timer = Stopwatch.createStarted();
        if (activeMode == null) {
            return Collections.emptyList();
        }
        Collection<ItemStack> items = activeMode.getAllItems();
        ArrayList<Widget> widgets = new ArrayList<Widget>(search.isEmpty() ? items.size() + 1 : 64);
        String mod = "";
        if (search.startsWith("@")) {
            mod = search.substring(1);
        }
        ItemStackButton button = new ItemStackButton(panel, ItemStack.f_41583_);
        if (this.config.allowEmpty && button.shouldAdd(search, mod)) {
            widgets.add(new ItemStackButton(panel, ItemStack.f_41583_));
        }
        for (ItemStack stack : items) {
            if (stack.m_41619_() || !(button = new ItemStackButton(panel, stack)).shouldAdd(search, mod)) continue;
            widgets.add(button);
            int j = widgets.size() - 1;
            button.setPos(1 + j % 9 * 19, 1 + j / 9 * 19);
        }
        FTBLibrary.LOGGER.info("Done updating item list in {}\u03bcs!", (Object)timer.stop().elapsed(TimeUnit.MICROSECONDS));
        return widgets;
    }

    public SelectItemStackScreen(ItemStackConfig c, ConfigCallback cb) {
        this.setSize(211, 150);
        this.config = c;
        this.callback = cb;
        this.current = ((ItemStack)this.config.value).m_41619_() ? ItemStack.f_41583_ : ((ItemStack)this.config.value).m_41777_();
        int bsize = this.width / 2 - 10;
        this.buttonCancel = new SimpleTextButton(this, (Component)new TranslatableComponent("gui.cancel"), Icon.EMPTY){

            @Override
            public void onClicked(MouseButton button) {
                this.playClickSound();
                SelectItemStackScreen.this.doCancel();
            }

            @Override
            public boolean renderTitleInCenter() {
                return true;
            }
        };
        this.buttonCancel.setPosAndSize(8, this.height - 24, bsize, 16);
        this.buttonAccept = new SimpleTextButton(this, (Component)new TranslatableComponent("gui.accept"), Icon.EMPTY){

            @Override
            public void onClicked(MouseButton button) {
                this.playClickSound();
                SelectItemStackScreen.this.doAccept();
            }

            @Override
            public boolean renderTitleInCenter() {
                return true;
            }
        };
        this.buttonAccept.setPosAndSize(this.width - bsize - 8, this.height - 24, bsize, 16);
        this.panelStacks = new BlankPanel(this){

            @Override
            public void addWidgets() {
                SelectItemStackScreen.this.update = System.currentTimeMillis() + 100L;
            }

            @Override
            public void drawBackground(PoseStack matrixStack, Theme theme, int x, int y, int w, int h) {
                theme.drawPanelBackground(matrixStack, x, y, w, h);
            }
        };
        this.panelStacks.setPosAndSize(9, 24, 172, 96);
        this.scrollBar = new PanelScrollBar(this, this.panelStacks);
        this.scrollBar.setCanAlwaysScroll(true);
        this.scrollBar.setScrollStep(20.0);
        this.searchBox = new TextBox(this){

            @Override
            public void onTextChanged() {
                SelectItemStackScreen.this.panelStacks.refreshWidgets();
            }
        };
        this.searchBox.setPosAndSize(8, 7, this.width - 16, 12);
        this.searchBox.ghostText = I18n.m_118938_((String)"gui.search_box", (Object[])new Object[0]);
        this.searchBox.setFocused(true);
        this.tabs = new Panel(this){

            @Override
            public void addWidgets() {
                this.add(new ButtonSwitchMode(this));
                this.add(new ButtonEditData(this));
                if (!SelectItemStackScreen.this.config.singleItemOnly) {
                    this.add(new ButtonCount(this));
                }
                this.add(new ButtonNBT(this));
                this.add(new ButtonCaps(this));
            }

            @Override
            public void alignWidgets() {
                for (Widget widget : this.widgets) {
                    widget.setSize(20, 20);
                }
                this.setHeight(this.align(WidgetLayout.VERTICAL));
            }
        };
        this.tabs.setPosAndSize(-19, 8, 20, 0);
        this.updateItemWidgets(Collections.emptyList());
    }

    private void doCancel() {
        this.callback.save(false);
    }

    private void doAccept() {
        this.config.setCurrentValue(this.current);
        this.callback.save(true);
    }

    private void updateItemWidgets(List<Widget> items) {
        this.panelStacks.widgets.clear();
        this.panelStacks.addAll(items);
        this.scrollBar.setPosAndSize(this.panelStacks.posX + this.panelStacks.width + 6, this.panelStacks.posY - 1, 16, this.panelStacks.height + 2);
        this.scrollBar.setValue(0.0);
        this.scrollBar.setMaxValue(1 + Mth.m_14167_((float)((float)this.panelStacks.widgets.size() / 9.0f)) * 19);
    }

    @Override
    public void addWidgets() {
        this.add(this.tabs);
        this.add(this.panelStacks);
        this.add(this.scrollBar);
        this.add(this.searchBox);
        this.add(this.buttonCancel);
        this.add(this.buttonAccept);
    }

    @Override
    public void onClosed() {
        super.onClosed();
    }

    @Override
    public boolean onClosedByKey(Key key) {
        if (super.onClosedByKey(key)) {
            this.callback.save(false);
            return true;
        }
        return false;
    }

    @Override
    public void drawBackground(PoseStack matrixStack, Theme theme, int x, int y, int w, int h) {
        super.drawBackground(matrixStack, theme, x, y, w, h);
        long now = System.currentTimeMillis();
        if (now >= this.update) {
            this.update = Long.MAX_VALUE;
            CompletableFuture.supplyAsync(() -> this.getItems(this.searchBox.getText().toLowerCase(), this.panelStacks), ITEM_SEARCH).thenAcceptAsync(this::updateItemWidgets, (Executor)Minecraft.m_91087_());
        }
    }

    @Override
    public boolean doesGuiPauseGame() {
        Screen screen = this.getPrevScreen();
        return screen != null && screen.m_7043_();
    }

    static {
        modes.add(ItemSearchMode.ALL_ITEMS);
        modes.add(ItemSearchMode.INVENTORY);
        activeMode = null;
    }

    private class ItemStackButton
    extends Button {
        private final ItemStack stack;

        private ItemStackButton(Panel panel, ItemStack is) {
            super(panel, TextComponent.f_131282_, Icons.BARRIER);
            this.setSize(18, 18);
            this.stack = is;
            this.title = null;
            this.icon = ItemIcon.getItemIcon(is);
        }

        public boolean shouldAdd(String search, String mod) {
            if (search.isEmpty()) {
                return true;
            }
            if (!mod.isEmpty()) {
                return Registries.getId((Object)this.stack.m_41720_(), (ResourceKey)Registry.f_122904_).m_135827_().contains(mod);
            }
            return this.stack.m_41786_().getString().toLowerCase().contains(search);
        }

        @Override
        public Component getTitle() {
            if (this.title == null) {
                this.title = this.stack.m_41786_();
            }
            return this.title;
        }

        @Override
        public void addMouseOverText(TooltipList list) {
        }

        @Override
        public WidgetType getWidgetType() {
            return this.stack.m_41720_() == SelectItemStackScreen.this.current.m_41720_() && Objects.equals(this.stack.m_41783_(), SelectItemStackScreen.this.current.m_41783_()) ? WidgetType.MOUSE_OVER : super.getWidgetType();
        }

        @Override
        public void drawBackground(PoseStack matrixStack, Theme theme, int x, int y, int w, int h) {
            (this.getWidgetType() == WidgetType.MOUSE_OVER ? Color4I.LIGHT_GREEN.withAlpha(70) : Color4I.BLACK.withAlpha(50)).draw(matrixStack, x, y, w, h);
        }

        @Override
        public void onClicked(MouseButton button) {
            this.playClickSound();
            SelectItemStackScreen.this.current = this.stack.m_41777_();
        }
    }

    private class ButtonCaps
    extends ButtonStackConfig {
        public ButtonCaps(Panel panel) {
            super(panel, (Component)new TranslatableComponent("ftblibrary.select_item.caps"), ItemIcon.getItemIcon(Items.f_42146_));
        }

        @Override
        public void onClicked(MouseButton button) {
            this.playClickSound();
            CompoundTag nbt = SelectItemStackScreen.this.current.m_41739_(new CompoundTag());
            NBTConfig c = new NBTConfig();
            EditConfigFromStringScreen.open(c, (CompoundTag)nbt.m_128423_("ForgeCaps"), (CompoundTag)((ItemStack)SelectItemStackScreen.this.config.defaultValue).m_41739_(new CompoundTag()).m_128423_("ForgeCaps"), accepted -> {
                if (accepted) {
                    if (c.value == null || ((CompoundTag)c.value).m_128456_()) {
                        nbt.m_128473_("ForgeCaps");
                    } else {
                        nbt.m_128365_("ForgeCaps", (Tag)c.value);
                    }
                    SelectItemStackScreen.this.current = ItemStack.m_41712_((CompoundTag)nbt);
                }
                SelectItemStackScreen.this.run();
            });
        }
    }

    private class ButtonNBT
    extends ButtonStackConfig {
        public ButtonNBT(Panel panel) {
            super(panel, (Component)new TranslatableComponent("ftblibrary.select_item.nbt"), ItemIcon.getItemIcon(Items.f_42656_));
        }

        @Override
        public void onClicked(MouseButton button) {
            this.playClickSound();
            NBTConfig c = new NBTConfig();
            EditConfigFromStringScreen.open(c, SelectItemStackScreen.this.current.m_41783_(), ((ItemStack)SelectItemStackScreen.this.config.defaultValue).m_41783_(), accepted -> {
                if (accepted) {
                    SelectItemStackScreen.this.current.m_41751_((CompoundTag)c.value);
                }
                this.run();
            });
        }
    }

    private class ButtonCount
    extends ButtonStackConfig {
        public ButtonCount(Panel panel) {
            super(panel, (Component)new TranslatableComponent("ftblibrary.select_item.count"), ItemIcon.getItemIcon(Items.f_42516_));
        }

        @Override
        public void onClicked(MouseButton button) {
            this.playClickSound();
            IntConfig c = new IntConfig(0, SelectItemStackScreen.this.current.m_41741_());
            EditConfigFromStringScreen.open(c, SelectItemStackScreen.this.current.m_41613_(), ((ItemStack)SelectItemStackScreen.this.config.defaultValue).m_41613_(), accepted -> {
                if (accepted) {
                    SelectItemStackScreen.this.current.m_41764_(((Integer)c.value).intValue());
                }
                this.run();
            });
        }
    }

    private class ButtonEditData
    extends Button {
        public ButtonEditData(Panel panel) {
            super(panel, TextComponent.f_131282_, Icons.BUG);
        }

        @Override
        public void drawIcon(PoseStack matrixStack, Theme theme, int x, int y, int w, int h) {
            matrixStack.m_85836_();
            matrixStack.m_85837_((double)x + (double)w / 2.0, (double)y + (double)h / 2.0, 100.0);
            if (w != 16 || h != 16) {
                int s = Math.min(w, h);
                matrixStack.m_85841_((float)s / 16.0f, (float)s / 16.0f, (float)s / 16.0f);
            }
            GuiHelper.drawItem(matrixStack, SelectItemStackScreen.this.current, 0, true, null);
            matrixStack.m_85849_();
        }

        @Override
        public Component getTitle() {
            return SelectItemStackScreen.this.current.m_41786_();
        }

        @Override
        public void onClicked(MouseButton button) {
            this.playClickSound();
            NBTConfig c = new NBTConfig();
            EditConfigFromStringScreen.open(c, SelectItemStackScreen.this.current.m_41739_(new CompoundTag()), ((ItemStack)SelectItemStackScreen.this.config.defaultValue).m_41739_(new CompoundTag()), accepted -> {
                if (accepted) {
                    SelectItemStackScreen.this.current = ItemStack.m_41712_((CompoundTag)((CompoundTag)c.value));
                }
                this.run();
            });
        }
    }

    private abstract class ButtonStackConfig
    extends Button {
        public ButtonStackConfig(Panel panel, Component title, Icon icon) {
            super(panel, title, icon);
        }

        @Override
        public WidgetType getWidgetType() {
            return SelectItemStackScreen.this.current.m_41619_() ? WidgetType.DISABLED : super.getWidgetType();
        }
    }

    private class ButtonSwitchMode
    extends Button {
        private final Iterator<ItemSearchMode> modeIterator;

        public ButtonSwitchMode(Panel panel) {
            super(panel);
            this.modeIterator = Iterators.cycle(modes);
            if (activeMode == null) {
                activeMode = this.modeIterator.next();
            }
        }

        @Override
        public void drawIcon(PoseStack matrixStack, Theme theme, int x, int y, int w, int h) {
            activeMode.getIcon().draw(matrixStack, x, y, w, h);
        }

        @Override
        public Component getTitle() {
            return new TranslatableComponent("ftblibrary.select_item.list_mode");
        }

        @Override
        public void addMouseOverText(TooltipList list) {
            super.addMouseOverText(list);
            list.add((Component)activeMode.getDisplayName().m_130940_(ChatFormatting.GRAY).m_7220_((Component)new TextComponent(" [" + SelectItemStackScreen.this.panelStacks.widgets.size() + "]").m_130940_(ChatFormatting.DARK_GRAY)));
        }

        @Override
        public void onClicked(MouseButton button) {
            this.playClickSound();
            activeMode = this.modeIterator.next();
            SelectItemStackScreen.this.panelStacks.refreshWidgets();
        }
    }
}

