/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.jgltf.model.io.v1;

import de.javagl.jgltf.model.io.Buffers;
import de.javagl.jgltf.model.io.RawGltfData;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;

public class RawBinaryGltfDataReaderV1 {
    private static final int BINARY_GLTF_VERSION_1_HEADER_LENGTH_IN_BYTES = 20;
    private static final int CONTENT_FORMAT_JSON = 0;

    public static RawGltfData readBinaryGltf(ByteBuffer data) throws IOException {
        int headerLength = 20;
        if (data.capacity() < headerLength) {
            throw new IOException("Expected header of size " + headerLength + ", but only found " + data.capacity() + " bytes");
        }
        IntBuffer intData = data.asIntBuffer();
        int length = intData.get(2);
        if (length != data.capacity()) {
            throw new IOException("Data length is " + data.capacity() + ", expected " + length);
        }
        int contentLength = intData.get(3);
        int contentFormat = intData.get(4);
        if (contentFormat != 0) {
            throw new IOException("Expected content format to be JSON (0), but found " + contentFormat);
        }
        ByteBuffer contentData = Buffers.createSlice(data, headerLength, contentLength);
        int bodyByteOffset = headerLength + contentLength;
        int bodyByteLength = length - bodyByteOffset;
        ByteBuffer bodyData = null;
        if (bodyByteLength > 0) {
            bodyData = Buffers.createSlice(data, bodyByteOffset, bodyByteLength);
        }
        return new RawGltfData(contentData, bodyData);
    }

    private RawBinaryGltfDataReaderV1() {
    }
}

