/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.jgltf.model.io.v1;

import de.javagl.jgltf.impl.v1.Buffer;
import de.javagl.jgltf.impl.v1.BufferView;
import de.javagl.jgltf.impl.v1.GlTF;
import de.javagl.jgltf.impl.v1.Image;
import de.javagl.jgltf.impl.v1.Shader;
import de.javagl.jgltf.model.BufferModel;
import de.javagl.jgltf.model.ImageModel;
import de.javagl.jgltf.model.gl.ShaderModel;
import de.javagl.jgltf.model.io.Buffers;
import de.javagl.jgltf.model.io.v1.GltfAssetV1;
import de.javagl.jgltf.model.io.v1.GltfUtilsV1;
import de.javagl.jgltf.model.v1.BinaryGltfV1;
import de.javagl.jgltf.model.v1.GltfExtensionsV1;
import de.javagl.jgltf.model.v1.GltfIds;
import de.javagl.jgltf.model.v1.GltfModelV1;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;

final class BinaryAssetCreatorV1 {
    BinaryAssetCreatorV1() {
    }

    GltfAssetV1 create(GltfModelV1 gltfModel) {
        GlTF inputGltf = gltfModel.getGltf();
        GlTF outputGltf = GltfUtilsV1.copy(inputGltf);
        int binaryGltfBufferSize = BinaryAssetCreatorV1.computeBinaryGltfBufferSize(gltfModel);
        ByteBuffer binaryGltfByteBuffer = Buffers.create(binaryGltfBufferSize);
        GltfExtensionsV1.addExtensionUsed(outputGltf, BinaryGltfV1.getBinaryGltfExtensionName());
        Buffer binaryGltfBuffer = new Buffer();
        binaryGltfBuffer.setType("arraybuffer");
        binaryGltfBuffer.setUri(BinaryGltfV1.getBinaryGltfBufferId() + ".bin");
        binaryGltfBuffer.setByteLength(binaryGltfBufferSize);
        Map<String, Buffer> newBuffers = Collections.singletonMap(BinaryGltfV1.getBinaryGltfBufferId(), binaryGltfBuffer);
        Map<String, Buffer> oldBuffers = BinaryAssetCreatorV1.copy(outputGltf.getBuffers());
        Map<String, Image> oldImages = BinaryAssetCreatorV1.copy(outputGltf.getImages());
        Map<String, Shader> oldShaders = BinaryAssetCreatorV1.copy(outputGltf.getShaders());
        Map<String, Integer> bufferOffsets = BinaryAssetCreatorV1.concatBuffers(oldBuffers.keySet(), id -> gltfModel.getBufferModelById((String)id).getBufferData(), binaryGltfByteBuffer);
        Map<String, Integer> imageOffsets = BinaryAssetCreatorV1.concatBuffers(oldImages.keySet(), id -> gltfModel.getImageModelById((String)id).getImageData(), binaryGltfByteBuffer);
        Map<String, Integer> shaderOffsets = BinaryAssetCreatorV1.concatBuffers(oldShaders.keySet(), id -> gltfModel.getShaderModelById((String)id).getShaderData(), binaryGltfByteBuffer);
        binaryGltfByteBuffer.position(0);
        Map<String, BufferView> oldBufferViews = BinaryAssetCreatorV1.copy(outputGltf.getBufferViews());
        LinkedHashMap<String, BufferView> newBufferViews = new LinkedHashMap<String, BufferView>();
        for (Map.Entry<String, BufferView> entry : oldBufferViews.entrySet()) {
            String string = entry.getKey();
            BufferView oldBufferView = entry.getValue();
            BufferView newBufferView = GltfUtilsV1.copy(oldBufferView);
            newBufferView.setBuffer(BinaryGltfV1.getBinaryGltfBufferId());
            String oldBufferId = oldBufferView.getBuffer();
            int oldByteOffset = oldBufferView.getByteOffset();
            int bufferOffset = bufferOffsets.get(oldBufferId);
            int newByteOffset = oldByteOffset + bufferOffset;
            newBufferView.setByteOffset(newByteOffset);
            newBufferViews.put(string, newBufferView);
        }
        LinkedHashMap<String, Image> newImages = new LinkedHashMap<String, Image>();
        for (Map.Entry<String, Image> entry : oldImages.entrySet()) {
            String id3 = entry.getKey();
            Image oldImage = entry.getValue();
            Image newImage = GltfUtilsV1.copy(oldImage);
            ByteBuffer imageData = gltfModel.getImageModelById(id3).getImageData();
            int byteLength = imageData.capacity();
            int byteOffset = imageOffsets.get(id3);
            BufferView imageBufferView = new BufferView();
            imageBufferView.setBuffer(BinaryGltfV1.getBinaryGltfBufferId());
            imageBufferView.setByteOffset(byteOffset);
            imageBufferView.setByteLength(byteLength);
            String generatedBufferViewId = GltfIds.generateId("bufferView_for_image_" + id3, oldBufferViews.keySet());
            newBufferViews.put(generatedBufferViewId, imageBufferView);
            BinaryGltfV1.setBinaryGltfBufferViewId(newImage, generatedBufferViewId);
            BinaryGltfV1.setBinaryGltfImageProperties(newImage, imageData);
            newImages.put(id3, newImage);
        }
        LinkedHashMap<String, Shader> linkedHashMap = new LinkedHashMap<String, Shader>();
        for (Map.Entry<String, Shader> oldEntry : oldShaders.entrySet()) {
            String id4 = oldEntry.getKey();
            Shader oldShader = oldEntry.getValue();
            Shader newShader = GltfUtilsV1.copy(oldShader);
            ByteBuffer shaderData = gltfModel.getShaderModelById(id4).getShaderData();
            int byteLength = shaderData.capacity();
            int byteOffset = shaderOffsets.get(id4);
            BufferView shaderBufferView = new BufferView();
            shaderBufferView.setBuffer(BinaryGltfV1.getBinaryGltfBufferId());
            shaderBufferView.setByteOffset(byteOffset);
            shaderBufferView.setByteLength(byteLength);
            String generatedBufferViewId = GltfIds.generateId("bufferView_for_shader_" + id4, oldBufferViews.keySet());
            newBufferViews.put(generatedBufferViewId, shaderBufferView);
            BinaryGltfV1.setBinaryGltfBufferViewId(newShader, generatedBufferViewId);
            linkedHashMap.put(id4, newShader);
        }
        if (inputGltf.getBuffers() != null) {
            outputGltf.setBuffers(newBuffers);
        }
        if (inputGltf.getImages() != null) {
            outputGltf.setImages(newImages);
        }
        if (inputGltf.getShaders() != null) {
            outputGltf.setShaders(linkedHashMap);
        }
        if (!newBufferViews.isEmpty()) {
            outputGltf.setBufferViews(newBufferViews);
        }
        return new GltfAssetV1(outputGltf, binaryGltfByteBuffer);
    }

    private static int computeBinaryGltfBufferSize(GltfModelV1 gltfModel) {
        int binaryGltfBufferSize = 0;
        for (BufferModel bufferModel : gltfModel.getBufferModels()) {
            ByteBuffer bufferData = bufferModel.getBufferData();
            binaryGltfBufferSize += bufferData.capacity();
        }
        for (ImageModel imageModel : gltfModel.getImageModels()) {
            ByteBuffer imageData = imageModel.getImageData();
            binaryGltfBufferSize += imageData.capacity();
        }
        for (ShaderModel shaderModel : gltfModel.getShaderModels()) {
            ByteBuffer shaderData = shaderModel.getShaderData();
            binaryGltfBufferSize += shaderData.capacity();
        }
        return binaryGltfBufferSize;
    }

    private static <K> Map<K, Integer> concatBuffers(Iterable<K> keys, Function<? super K, ? extends ByteBuffer> keyToByteBuffer, ByteBuffer targetBuffer) {
        LinkedHashMap<K, Integer> offsets = new LinkedHashMap<K, Integer>();
        for (K key : keys) {
            ByteBuffer oldByteBuffer = keyToByteBuffer.apply(key);
            int offset = targetBuffer.position();
            offsets.put(key, offset);
            targetBuffer.put(oldByteBuffer.slice());
        }
        return offsets;
    }

    private static <K, V> Map<K, V> copy(Map<K, V> map) {
        if (map == null) {
            return Collections.emptyMap();
        }
        return new LinkedHashMap<K, V>(map);
    }
}

