/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.jgltf.model.impl.creation;

import de.javagl.jgltf.model.BufferModel;
import de.javagl.jgltf.model.impl.creation.BufferStructure;
import de.javagl.jgltf.model.io.GltfReference;
import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Consumer;
import java.util.logging.Logger;

public class BufferStructures {
    private static final Logger logger = Logger.getLogger(BufferStructures.class.getName());

    public static void resolve(Iterable<? extends GltfReference> bufferReferences, BufferStructure bufferStructure) {
        String uri;
        List<BufferModel> bufferModels = bufferStructure.getBufferModels();
        LinkedHashMap<String, BufferModel> uriToBufferModel = new LinkedHashMap<String, BufferModel>();
        for (BufferModel bufferModel : bufferModels) {
            uri = bufferModel.getUri();
            uriToBufferModel.put(uri, bufferModel);
        }
        for (GltfReference gltfReference : bufferReferences) {
            uri = gltfReference.getUri();
            BufferModel bufferModel = (BufferModel)uriToBufferModel.get(uri);
            if (bufferModel == null) {
                logger.warning("Could not resolve buffer model for URI " + uri + " in buffer structure");
                continue;
            }
            Consumer<ByteBuffer> target = gltfReference.getTarget();
            target.accept(bufferModel.getBufferData());
        }
    }

    private BufferStructures() {
    }
}

