/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.network.message;

import com.google.common.collect.ImmutableMap;
import com.mrcrayfish.framework.api.network.PlayMessage;
import com.tac.guns.client.network.ClientPlayHandler;
import com.tac.guns.common.CustomGun;
import com.tac.guns.common.CustomGunLoader;
import com.tac.guns.common.Gun;
import com.tac.guns.common.NetworkGunManager;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;
import org.apache.commons.lang3.Validate;

public class MessageUpdateGuns
extends PlayMessage<MessageUpdateGuns>
implements NetworkGunManager.IGunProvider {
    private ImmutableMap<ResourceLocation, Gun> registeredGuns;
    private ImmutableMap<ResourceLocation, CustomGun> customGuns;

    public MessageUpdateGuns() {
    }

    public MessageUpdateGuns(ImmutableMap<ResourceLocation, Gun> readRegisteredGuns, ImmutableMap<ResourceLocation, CustomGun> readCustomGuns) {
        this.registeredGuns = readRegisteredGuns;
        this.customGuns = readCustomGuns;
    }

    public void encode(MessageUpdateGuns messageUpdateGuns, FriendlyByteBuf buffer) {
        Validate.notNull((Object)((Object)NetworkGunManager.get()));
        Validate.notNull((Object)((Object)CustomGunLoader.get()));
        NetworkGunManager.get().writeRegisteredGuns(buffer);
        CustomGunLoader.get().writeCustomGuns(buffer);
    }

    public MessageUpdateGuns decode(FriendlyByteBuf buffer) {
        return new MessageUpdateGuns(NetworkGunManager.readRegisteredGuns(buffer), CustomGunLoader.readCustomGuns(buffer));
    }

    public void handle(MessageUpdateGuns messageUpdateGuns, Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> ClientPlayHandler.handleUpdateGuns(messageUpdateGuns));
        supplier.get().setPacketHandled(true);
    }

    @Override
    public ImmutableMap<ResourceLocation, Gun> getRegisteredGuns() {
        return this.registeredGuns;
    }

    @Override
    public ImmutableMap<ResourceLocation, CustomGun> getCustomGuns() {
        return this.customGuns;
    }
}

