/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.mixin.common;

import com.mojang.authlib.GameProfile;
import com.tac.guns.common.ItemStackWrapper;
import com.tac.guns.common.network.RigItemStackDataSerializer;
import com.tac.guns.duck.PlayerWithSynData;
import com.tac.guns.inventory.gear.armor.ArmorRigCapabilityProvider;
import com.tac.guns.inventory.gear.armor.RigSlotsHandler;
import com.tac.guns.item.transition.wearables.ArmorRigItem;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.extensions.IForgePlayer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Player.class})
public abstract class PlayerMixin
extends LivingEntity
implements IForgePlayer,
PlayerWithSynData {
    private static final EntityDataAccessor<ItemStackWrapper> RIG_ID = SynchedEntityData.m_135353_(Player.class, (EntityDataSerializer)RigItemStackDataSerializer.INSTANCE);
    @Shadow
    private Inventory f_36093_;

    protected PlayerMixin(EntityType<? extends LivingEntity> p_20966_, Level p_20967_) {
        super(p_20966_, p_20967_);
    }

    @Inject(method={"<init>(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;FLcom/mojang/authlib/GameProfile;)V"}, at={@At(value="RETURN")})
    public void defineSynData(Level p_36114_, BlockPos p_36115_, float p_36116_, GameProfile p_36117_, CallbackInfo ci) {
        this.f_19804_.m_135372_(RIG_ID, (Object)new ItemStackWrapper(ItemStack.f_41583_));
    }

    @Inject(method={"addAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="RETURN")})
    public void saveData(CompoundTag p_36265_, CallbackInfo ci) {
        ItemStack rig = ((ItemStackWrapper)this.f_19804_.m_135370_(RIG_ID)).itemStack();
        if (!rig.m_41619_()) {
            p_36265_.m_128365_("TacRig", (Tag)rig.m_41739_(new CompoundTag()));
        }
    }

    @Inject(method={"readAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="RETURN")})
    public void readData(CompoundTag p_36215_, CallbackInfo ci) {
        CompoundTag rigTag = p_36215_.m_128469_("TacRig");
        if (!rigTag.m_128456_()) {
            this.f_19804_.m_135381_(RIG_ID, (Object)new ItemStackWrapper(ItemStack.m_41712_((CompoundTag)rigTag)));
        }
    }

    @Inject(method={"dropEquipment()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Inventory;dropAll()V")})
    public void dropRig(CallbackInfo ci) {
        ItemStack rig = ((ItemStackWrapper)this.f_19804_.m_135370_(RIG_ID)).itemStack();
        if (!rig.m_41619_()) {
            this.f_36093_.f_35978_.m_7197_(rig, true, false);
            this.setRig(ItemStack.f_41583_);
        }
    }

    @Override
    public ItemStack getRig() {
        return ((ItemStackWrapper)this.m_20088_().m_135370_(RIG_ID)).itemStack();
    }

    @Override
    public void setRig(ItemStack newRig) {
        this.m_20088_().m_135381_(RIG_ID, (Object)new ItemStackWrapper(newRig));
    }

    @Override
    public void updateRig() {
        ItemStack rig = this.getRig();
        if (rig.m_41720_() instanceof ArmorRigItem) {
            RigSlotsHandler itemHandler = (RigSlotsHandler)rig.getCapability(ArmorRigCapabilityProvider.capability).resolve().get();
            if (rig.m_41783_() != null) {
                rig.m_41783_().m_128365_("storage", (Tag)itemHandler.serializeNBT());
            }
            this.m_20088_().m_135381_(RIG_ID, (Object)new ItemStackWrapper(rig));
        }
    }
}

