/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.mixin.client;

import com.tac.guns.client.event.PlayerModelEvent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PlayerModel.class})
public class PlayerModelMixin<T extends LivingEntity>
extends HumanoidModel<T> {
    @Shadow
    @Final
    private boolean f_103380_;
    @Shadow
    @Final
    public ModelPart f_103374_;
    @Shadow
    @Final
    public ModelPart f_103375_;
    @Shadow
    @Final
    public ModelPart f_103376_;
    @Shadow
    @Final
    public ModelPart f_103377_;
    @Shadow
    @Final
    public ModelPart f_103378_;

    public PlayerModelMixin(ModelPart part) {
        super(part);
    }

    @Inject(method={"setupAnim"}, at={@At(value="HEAD")}, cancellable=true)
    private void setRotationAnglesHead(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, CallbackInfo ci) {
        if (!(entityIn instanceof Player)) {
            return;
        }
        PlayerModel model = (PlayerModel)this;
        this.resetRotationAngles();
        if (MinecraftForge.EVENT_BUS.post((Event)new PlayerModelEvent.SetupAngles.Pre((Player)entityIn, model, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, Minecraft.m_91087_().m_91297_()))) {
            this.setupRotationAngles();
            ci.cancel();
        }
    }

    @Inject(method={"setupAnim"}, at={@At(value="TAIL")})
    private void setRotationAnglesTail(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, CallbackInfo ci) {
        if (!(entityIn instanceof Player)) {
            return;
        }
        PlayerModel model = (PlayerModel)this;
        MinecraftForge.EVENT_BUS.post((Event)new PlayerModelEvent.SetupAngles.Post((Player)entityIn, model, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, Minecraft.m_91087_().m_91297_()));
        this.setupRotationAngles();
    }

    private void setupRotationAngles() {
        this.f_103375_.m_104315_(this.f_102811_);
        this.f_103374_.m_104315_(this.f_102812_);
        this.f_103377_.m_104315_(this.f_102813_);
        this.f_103376_.m_104315_(this.f_102814_);
        this.f_103378_.m_104315_(this.f_102810_);
        this.f_102809_.m_104315_(this.f_102808_);
    }

    private void resetRotationAngles() {
        this.resetAll(this.f_102808_);
        this.resetAll(this.f_102809_);
        this.resetAll(this.f_102810_);
        this.resetAll(this.f_103378_);
        this.resetAll(this.f_102811_);
        this.f_102811_.f_104200_ = -5.0f;
        this.f_102811_.f_104201_ = this.f_103380_ ? 2.5f : 2.0f;
        this.f_102811_.f_104202_ = 0.0f;
        this.resetAll(this.f_103375_);
        this.f_103375_.f_104200_ = -5.0f;
        this.f_103375_.f_104201_ = this.f_103380_ ? 2.5f : 2.0f;
        this.f_103375_.f_104202_ = 10.0f;
        this.resetAll(this.f_102812_);
        this.f_102812_.f_104200_ = 5.0f;
        this.f_102812_.f_104201_ = this.f_103380_ ? 2.5f : 2.0f;
        this.f_102812_.f_104202_ = 0.0f;
        this.resetAll(this.f_103374_);
        this.f_103374_.f_104200_ = 5.0f;
        this.f_103374_.f_104201_ = this.f_103380_ ? 2.5f : 2.0f;
        this.f_103374_.f_104202_ = 0.0f;
        this.resetAll(this.f_102814_);
        this.f_102814_.f_104200_ = 1.9f;
        this.f_102814_.f_104201_ = 12.0f;
        this.f_102814_.f_104202_ = 0.0f;
        this.resetAll(this.f_103376_);
        this.f_103376_.m_104315_(this.f_102814_);
        this.resetAll(this.f_102813_);
        this.f_102813_.f_104200_ = -1.9f;
        this.f_102813_.f_104201_ = 12.0f;
        this.f_102813_.f_104202_ = 0.0f;
        this.resetAll(this.f_103377_);
        this.f_103377_.m_104315_(this.f_102813_);
    }

    private void resetAll(ModelPart part) {
        part.f_104203_ = 0.0f;
        part.f_104204_ = 0.0f;
        part.f_104205_ = 0.0f;
        part.f_104200_ = 0.0f;
        part.f_104201_ = 0.0f;
        part.f_104202_ = 0.0f;
    }
}

