/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.item.attachment.impl;

import com.tac.guns.interfaces.IGunModifier;
import com.tac.guns.item.attachment.IAttachment;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="tac", value={Dist.CLIENT})
public abstract class Attachment {
    private final IGunModifier[] modifiers;
    private List<Component> perks = null;

    Attachment(IGunModifier ... modifiers) {
        this.modifiers = modifiers;
    }

    public IGunModifier[] getModifiers() {
        return this.modifiers;
    }

    void setPerks(List<Component> perks) {
        if (this.perks == null) {
            this.perks = perks;
        }
    }

    List<Component> getPerks() {
        return this.perks;
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void addInformationEvent(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        if (stack.m_41720_() instanceof IAttachment) {
            int inputRate;
            double inputAdsSpeed;
            float inputHRecoil;
            float inputRecoil;
            int inputLife;
            float inputHipFireSpread;
            float inputFirstSpread;
            float inputSpread;
            double inputSpeed;
            float inputDamage;
            double inputRadius;
            IAttachment attachment = (IAttachment)stack.m_41720_();
            List<Component> perks = ((Attachment)attachment.getProperties()).getPerks();
            if (perks != null && perks.size() > 0) {
                event.getToolTip().add(new TranslatableComponent("perk.tac.title").m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}));
                event.getToolTip().addAll(perks);
                return;
            }
            IGunModifier[] modifiers = ((Attachment)attachment.getProperties()).getModifiers();
            ArrayList<Component> positivePerks = new ArrayList<Component>();
            ArrayList<Component> negativePerks = new ArrayList<Component>();
            for (IGunModifier modifier : modifiers) {
                if (!modifier.silencedFire()) continue;
                Attachment.addPerkP(positivePerks, "perk.tac.silenced.positive", new TranslatableComponent("perk.tac.silencedv2").m_130940_(ChatFormatting.GREEN));
                break;
            }
            double outputRadius = inputRadius = 10.0;
            for (IGunModifier modifier : modifiers) {
                outputRadius = modifier.modifyFireSoundRadius(outputRadius);
            }
            if (outputRadius > inputRadius) {
                Attachment.addPerkN(negativePerks, "perk.tac.sound_radius.negative", new TranslatableComponent("-").m_7220_((Component)new TranslatableComponent("perk.tac.sound_radiusv2", new Object[]{Math.round(outputRadius)}).m_130940_(ChatFormatting.RED)));
            } else if (outputRadius < inputRadius) {
                Attachment.addPerkP(positivePerks, "perk.tac.sound_radius.positive", new TranslatableComponent("+").m_7220_((Component)new TranslatableComponent("perk.tac.sound_radiusv2", new Object[]{Math.round(outputRadius)}).m_130940_(ChatFormatting.GREEN)));
            }
            float additionalDamage = 0.0f;
            for (IGunModifier modifier : modifiers) {
                additionalDamage += modifier.additionalDamage();
            }
            if (additionalDamage > 0.0f) {
                Attachment.addPerkP(positivePerks, "perk.tac.additional_damage.positivev2", ItemStack.f_41584_.format((double)additionalDamage / 2.0));
            } else if (additionalDamage < 0.0f) {
                Attachment.addPerkN(negativePerks, "perk.tac.additional_damage.negativev2", ItemStack.f_41584_.format((double)additionalDamage / 2.0));
            }
            float additionalHeadshotDamage = 0.0f;
            for (IGunModifier modifier : modifiers) {
                additionalHeadshotDamage += modifier.additionalHeadshotDamage();
            }
            if (additionalHeadshotDamage > 0.0f) {
                Attachment.addPerkP(positivePerks, "perk.tac.additional_damage.positiveh", ItemStack.f_41584_.format((double)additionalHeadshotDamage / 2.0));
            } else if (additionalHeadshotDamage < 0.0f) {
                Attachment.addPerkN(negativePerks, "perk.tac.additional_damage.negativeh", ItemStack.f_41584_.format((double)additionalHeadshotDamage / 2.0));
            }
            float outputDamage = inputDamage = 10.0f;
            for (IGunModifier modifier : modifiers) {
                outputDamage = modifier.modifyProjectileDamage(outputDamage);
            }
            if (outputDamage > inputDamage) {
                Attachment.addPerkP(positivePerks, "perk.tac.modified_damage.positive", new TranslatableComponent("perk.tac.modified_damage.positivev2", new Object[]{Float.valueOf(outputDamage)}).m_130940_(ChatFormatting.GREEN));
            } else if (outputDamage < inputDamage) {
                Attachment.addPerkN(positivePerks, "perk.tac.modified_damage.negative", new TranslatableComponent("perk.tac.modified_damage.negativev2", new Object[]{Float.valueOf(outputDamage)}).m_130940_(ChatFormatting.RED));
            }
            double outputSpeed = inputSpeed = 10.0;
            for (IGunModifier modifier : modifiers) {
                outputSpeed = modifier.modifyProjectileSpeed(outputSpeed);
            }
            if (outputSpeed > inputSpeed) {
                Attachment.addPerkP(positivePerks, "perk.tac.projectile_speed.positive", new TranslatableComponent("perk.tac.projectile_speed.positivev2", new Object[]{Math.round((10.0 - outputSpeed) * 10.0) + "%"}));
            } else if (outputSpeed < inputSpeed) {
                Attachment.addPerkN(negativePerks, "perk.tac.projectile_speed.negative", new TranslatableComponent("perk.tac.projectile_speed.negativev2", new Object[]{Math.round((10.0 - outputSpeed) * 10.0) + "%"}));
            }
            float outputSpread = inputSpread = 10.0f;
            for (IGunModifier modifier : modifiers) {
                outputSpread = modifier.modifyProjectileSpread(outputSpread);
            }
            if (outputSpread > inputSpread) {
                Attachment.addPerkN(negativePerks, "perk.tac.projectile_spread.negative", new TranslatableComponent("perk.tac.projectile_spread.negativev2", new Object[]{Math.round((10.0f - outputSpread) * 10.0f) + "%"}).m_130940_(ChatFormatting.RED));
            } else if (outputSpread < inputSpread) {
                Attachment.addPerkP(positivePerks, "perk.tac.projectile_spread.positive", new TranslatableComponent("perk.tac.projectile_spread.positivev2", new Object[]{Math.round((10.0f - outputSpread) * 10.0f) + "%"}).m_130940_(ChatFormatting.GREEN));
            }
            float outputFirstSpread = inputFirstSpread = 10.0f;
            for (IGunModifier modifier : modifiers) {
                outputFirstSpread = modifier.modifyFirstShotSpread(outputFirstSpread);
            }
            if (outputFirstSpread > inputFirstSpread) {
                Attachment.addPerkN(negativePerks, "perk.tac.projectile_spread_first.negativev2", String.valueOf(Math.round((10.0f - outputFirstSpread) * 10.0f)) + "%");
            } else if (outputFirstSpread < inputFirstSpread) {
                Attachment.addPerkP(positivePerks, "perk.tac.projectile_spread_first.positivev2", String.valueOf(Math.round((10.0f - outputFirstSpread) * 10.0f)) + "%");
            }
            float outputHipFireSpread = inputHipFireSpread = 10.0f;
            for (IGunModifier modifier : modifiers) {
                outputHipFireSpread = modifier.modifyHipFireSpread(outputHipFireSpread);
            }
            if (outputHipFireSpread > inputHipFireSpread) {
                Attachment.addPerkN(negativePerks, "perk.tac.projectile_spread_hip.negativev2", String.valueOf(Math.round((10.0f - outputHipFireSpread) * 10.0f)) + "%");
            } else if (outputHipFireSpread < inputHipFireSpread) {
                Attachment.addPerkP(positivePerks, "perk.tac.projectile_spread_hip.positivev2", String.valueOf(Math.round((10.0f - outputHipFireSpread) * 10.0f)) + "%");
            }
            int outputLife = inputLife = 100;
            for (IGunModifier modifier : modifiers) {
                outputLife = modifier.modifyProjectileLife(outputLife);
            }
            if (outputLife > inputLife) {
                Attachment.addPerkP(positivePerks, "perk.tac.projectile_life.positivev2", String.valueOf(outputLife));
            } else if (outputLife < inputLife) {
                Attachment.addPerkN(positivePerks, "perk.tac.projectile_life.negativev2", String.valueOf(outputLife));
            }
            float outputRecoil = inputRecoil = 10.0f;
            for (IGunModifier modifier : modifiers) {
                outputRecoil *= modifier.recoilModifier();
            }
            if (outputRecoil > inputRecoil) {
                Attachment.addPerkN(negativePerks, "perk.tac.recoil.negativev2", String.valueOf(Math.round((10.0f - outputRecoil) * -10.0f)) + "%");
            } else if (outputRecoil < inputRecoil) {
                Attachment.addPerkP(positivePerks, "perk.tac.recoil.positivev2", String.valueOf(Math.round((10.0f - outputRecoil) * -10.0f)) + "%");
            }
            float outputHRecoil = inputHRecoil = 10.0f;
            for (IGunModifier modifier : modifiers) {
                outputHRecoil *= modifier.horizontalRecoilModifier();
            }
            if (outputHRecoil > inputHRecoil) {
                Attachment.addPerkN(negativePerks, "perk.tac.recoilh.negativev2", String.valueOf(Math.round((10.0f - outputHRecoil) * -10.0f)) + "%");
            } else if (outputHRecoil < inputHRecoil) {
                Attachment.addPerkP(positivePerks, "perk.tac.recoilh.positivev2", String.valueOf(Math.round((10.0f - outputHRecoil) * -10.0f)) + "%");
            }
            double outputAdsSpeed = inputAdsSpeed = 10.0;
            for (IGunModifier modifier : modifiers) {
                outputAdsSpeed = modifier.modifyAimDownSightSpeed(outputAdsSpeed);
            }
            if (outputAdsSpeed > inputAdsSpeed) {
                Attachment.addPerkP(positivePerks, "perk.tac.ads_speed.positivev2", String.valueOf(Math.round((10.0 - outputAdsSpeed) * 10.0)) + "%");
            } else if (outputAdsSpeed < inputAdsSpeed) {
                Attachment.addPerkN(negativePerks, "perk.tac.ads_speed.negativev2", String.valueOf(Math.round((10.0 - outputAdsSpeed) * 10.0)) + "%");
            }
            int outputRate = inputRate = 10;
            for (IGunModifier modifier : modifiers) {
                outputRate = modifier.modifyFireRate(outputRate);
            }
            if (outputRate > inputRate) {
                Attachment.addPerkN(negativePerks, "perk.tac.rate.negative", new Object[0]);
            } else if (outputRate < inputRate) {
                Attachment.addPerkP(positivePerks, "perk.tac.rate.positive", new Object[0]);
            }
            positivePerks.addAll(negativePerks);
            ((Attachment)attachment.getProperties()).setPerks(positivePerks);
            if (positivePerks.size() > 0) {
                event.getToolTip().add(new TranslatableComponent("perk.tac.title").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.BOLD}));
                event.getToolTip().addAll(positivePerks);
            }
        }
    }

    private static void addPerk(List<Component> components, String id, Object ... params) {
        components.add((Component)new TranslatableComponent("perk.tac.entry.negative", new Object[]{new TranslatableComponent(id, params).m_130940_(ChatFormatting.AQUA)}));
    }

    private static void addPerkP(List<Component> components, String id, Object ... params) {
        components.add((Component)new TranslatableComponent(id, params).m_130940_(ChatFormatting.GREEN));
    }

    private static void addPerkN(List<Component> components, String id, Object ... params) {
        components.add((Component)new TranslatableComponent(id, params).m_130940_(ChatFormatting.RED));
    }
}

