/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.inventory.gear;

import com.tac.guns.inventory.gear.GearSlotsHandler;
import com.tac.guns.inventory.gear.IWearableItemHandler;
import com.tac.guns.inventory.gear.InventoryListener;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class WearableCapabilityProvider
implements ICapabilitySerializable<ListTag> {
    public static Capability<IWearableItemHandler> capability = InventoryListener.ITEM_HANDLER_CAPABILITY;
    private GearSlotsHandler itemHandler = new GearSlotsHandler(2);
    private LazyOptional<IWearableItemHandler> optionalStorage = LazyOptional.of(() -> this.itemHandler);

    public LazyOptional<IWearableItemHandler> getOptionalStorage() {
        return this.optionalStorage;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == capability) {
            return this.optionalStorage.cast();
        }
        return LazyOptional.empty();
    }

    public ListTag serializeNBT() {
        ListTag nbtTagList = new ListTag();
        int size = this.itemHandler.getSlots();
        for (int i = 0; i < size; ++i) {
            ItemStack stack = this.itemHandler.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            CompoundTag itemTag = new CompoundTag();
            itemTag.m_128405_("Slot", i);
            stack.m_41739_(itemTag);
            nbtTagList.add((Object)itemTag);
        }
        return nbtTagList;
    }

    public void deserializeNBT(ListTag nbt) {
        if (this.itemHandler == null) {
            throw new RuntimeException("IItemHandler instance does not implement IItemHandlerModifiable");
        }
        GearSlotsHandler itemHandlerModifiable = this.itemHandler;
        ListTag tagList = nbt;
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag itemTags = tagList.m_128728_(i);
            int j = itemTags.m_128451_("Slot");
            if (j < 0 || j >= this.itemHandler.getSlots()) continue;
            itemHandlerModifiable.setStackInSlot(j, ItemStack.m_41712_((CompoundTag)itemTags));
        }
    }
}

