/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.crafting;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.util.Pair;
import com.tac.guns.crafting.WorkbenchRecipe;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class WorkbenchRecipeSerializer
extends ForgeRegistryEntry<RecipeSerializer<?>>
implements RecipeSerializer<WorkbenchRecipe> {
    public WorkbenchRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
        String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
        ImmutableList.Builder builder = ImmutableList.builder();
        JsonArray input = GsonHelper.m_13933_((JsonObject)json, (String)"materials");
        for (int i = 0; i < input.size(); ++i) {
            int count;
            JsonObject itemObject = input.get(i).getAsJsonObject();
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)itemObject.get("item"));
            try {
                count = GsonHelper.m_13927_((JsonObject)itemObject, (String)"count");
            }
            catch (JsonSyntaxException e) {
                count = 1;
            }
            builder.add((Object)new Pair((Object)ingredient, (Object)count));
        }
        if (!json.has("result")) {
            throw new JsonSyntaxException("Missing result entry");
        }
        JsonObject resultObject = GsonHelper.m_13930_((JsonObject)json, (String)"result");
        ItemStack resultItem = ShapedRecipe.m_151278_((JsonObject)resultObject).m_7968_();
        try {
            resultItem.m_41764_(GsonHelper.m_13927_((JsonObject)resultObject, (String)"count"));
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            // empty catch block
        }
        return new WorkbenchRecipe(recipeId, resultItem, (ImmutableList<Pair<Ingredient, Integer>>)builder.build(), group);
    }

    @Nullable
    public WorkbenchRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        String group = buffer.m_130277_();
        ItemStack result = buffer.m_130267_();
        ImmutableList.Builder builder = ImmutableList.builder();
        int size = buffer.m_130242_();
        for (int i = 0; i < size; ++i) {
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            byte count = buffer.readByte();
            builder.add((Object)new Pair((Object)ingredient, (Object)count));
        }
        return new WorkbenchRecipe(recipeId, result, (ImmutableList<Pair<Ingredient, Integer>>)builder.build(), group);
    }

    public void toNetwork(FriendlyByteBuf buffer, WorkbenchRecipe recipe) {
        buffer.m_130070_(recipe.m_6076_());
        buffer.m_130055_(recipe.getItem());
        buffer.m_130130_(recipe.getMaterials().size());
        for (Pair stack : recipe.getMaterials()) {
            ((Ingredient)stack.getFirst()).m_43923_(buffer);
            buffer.writeByte(((Integer)stack.getSecond()).intValue());
        }
    }
}

