/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.tac.guns.init.ModRecipeSerializers;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.Registry;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;

public class WorkbenchRecipeBuilder {
    private final Item result;
    private final int count;
    private final List<Pair<Ingredient, Integer>> materials;
    private String group;

    public WorkbenchRecipeBuilder(ItemLike item, int count) {
        this.result = item.m_5456_();
        this.count = count;
        this.materials = new ArrayList<Pair<Ingredient, Integer>>();
    }

    public static WorkbenchRecipeBuilder workbenchRecipe(ItemLike resultIn) {
        return new WorkbenchRecipeBuilder(resultIn, 1);
    }

    public static WorkbenchRecipeBuilder workbenchRecipe(ItemLike resultIn, int countIn) {
        return new WorkbenchRecipeBuilder(resultIn, countIn);
    }

    public WorkbenchRecipeBuilder addIngredient(ItemLike itemIn) {
        return this.addIngredient(itemIn, 1);
    }

    public WorkbenchRecipeBuilder addIngredient(ItemLike item, int quantity) {
        this.materials.add((Pair<Ingredient, Integer>)new Pair((Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}), (Object)quantity));
        return this;
    }

    public WorkbenchRecipeBuilder addIngredient(TagKey<Item> item, int quantity) {
        this.materials.add((Pair<Ingredient, Integer>)new Pair((Object)Ingredient.m_204132_(item), (Object)quantity));
        return this;
    }

    public WorkbenchRecipeBuilder addIngredient(TagKey<Item> item) {
        this.materials.add((Pair<Ingredient, Integer>)new Pair((Object)Ingredient.m_204132_(item), (Object)1));
        return this;
    }

    public WorkbenchRecipeBuilder addIngredient(Ingredient itemIn) {
        return this.addIngredient(itemIn, 1);
    }

    public WorkbenchRecipeBuilder addIngredient(Ingredient item, int quantity) {
        this.materials.add((Pair<Ingredient, Integer>)new Pair((Object)item, (Object)quantity));
        return this;
    }

    public WorkbenchRecipeBuilder setGroup(String groupIn) {
        this.group = groupIn;
        return this;
    }

    public void build(Consumer<FinishedRecipe> consumerIn) {
        this.build(consumerIn, Registry.f_122827_.m_7981_((Object)this.result));
    }

    public void build(Consumer<FinishedRecipe> consumerIn, String save) {
        this.build(consumerIn, "tac", save);
    }

    public void build(Consumer<FinishedRecipe> consumerIn, String modid, String save) {
        ResourceLocation resourcelocation = Registry.f_122827_.m_7981_((Object)this.result);
        if (new ResourceLocation("tac", save).equals((Object)resourcelocation)) {
            throw new IllegalStateException("Workbench Recipe " + save + " should remove its 'save' argument");
        }
        this.build(consumerIn, new ResourceLocation(modid, "craft_" + save));
    }

    public void build(Consumer<FinishedRecipe> consumerIn, ResourceLocation id) {
        consumerIn.accept(new Result(id, (ItemLike)this.result, this.count, this.group == null ? "" : this.group, this.materials));
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final Item item;
        private final int count;
        private final String group;
        private final List<Pair<Ingredient, Integer>> materials;

        public Result(ResourceLocation id, ItemLike item, int count, String group, List<Pair<Ingredient, Integer>> materials) {
            this.id = id;
            this.item = item.m_5456_();
            this.count = count;
            this.group = group;
            this.materials = materials;
        }

        public void m_7917_(JsonObject json) {
            if (!this.group.isEmpty()) {
                json.addProperty("group", this.group);
            }
            JsonArray input = new JsonArray();
            for (Pair<Ingredient, Integer> material : this.materials) {
                JsonObject resultObject = new JsonObject();
                resultObject.add("item", ((Ingredient)material.getFirst()).m_43942_());
                if ((Integer)material.getSecond() > 1) {
                    resultObject.addProperty("count", (Number)material.getSecond());
                }
                input.add((JsonElement)resultObject);
            }
            json.add("materials", (JsonElement)input);
            JsonObject resultObject = new JsonObject();
            resultObject.addProperty("item", Registry.f_122827_.m_7981_((Object)this.item).toString());
            if (this.count > 1) {
                resultObject.addProperty("count", (Number)this.count);
            }
            json.add("result", (JsonElement)resultObject);
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)ModRecipeSerializers.WORKBENCH.get();
        }

        public JsonObject m_5860_() {
            return null;
        }

        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

