/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.common.network;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import com.tac.guns.Config;
import com.tac.guns.GunMod;
import com.tac.guns.client.handler.MovementAdaptationsHandler;
import com.tac.guns.client.screen.UpgradeBenchScreen;
import com.tac.guns.common.Gun;
import com.tac.guns.common.NetworkGunManager;
import com.tac.guns.common.ProjectileManager;
import com.tac.guns.common.Rig;
import com.tac.guns.common.SpreadTracker;
import com.tac.guns.common.container.AttachmentContainer;
import com.tac.guns.common.container.ColorBenchContainer;
import com.tac.guns.common.container.InspectionContainer;
import com.tac.guns.common.container.UpgradeBenchContainer;
import com.tac.guns.common.container.WorkbenchContainer;
import com.tac.guns.crafting.WorkbenchRecipe;
import com.tac.guns.crafting.WorkbenchRecipes;
import com.tac.guns.entity.ProjectileEntity;
import com.tac.guns.event.GunFireEvent;
import com.tac.guns.init.ModBlocks;
import com.tac.guns.init.ModEnchantments;
import com.tac.guns.init.ModItems;
import com.tac.guns.interfaces.IProjectileFactory;
import com.tac.guns.item.GunItem;
import com.tac.guns.item.IColored;
import com.tac.guns.item.IEasyColor;
import com.tac.guns.item.ScopeItem;
import com.tac.guns.item.attachment.IAttachment;
import com.tac.guns.item.transition.TimelessGunItem;
import com.tac.guns.item.transition.wearables.ArmorRigItem;
import com.tac.guns.network.PacketHandler;
import com.tac.guns.network.message.MessageBulletTrail;
import com.tac.guns.network.message.MessageGunSound;
import com.tac.guns.network.message.MessageSaveItemUpgradeBench;
import com.tac.guns.network.message.MessageShoot;
import com.tac.guns.network.message.MessageUpgradeBenchApply;
import com.tac.guns.tileentity.FlashLightSource;
import com.tac.guns.tileentity.UpgradeBenchTileEntity;
import com.tac.guns.tileentity.WorkbenchTileEntity;
import com.tac.guns.util.GunEnchantmentHelper;
import com.tac.guns.util.GunModifierHelper;
import com.tac.guns.util.InventoryUtil;
import com.tac.guns.util.WearableHelper;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerPlayHandler {
    public static final Logger LOGGER = LogManager.getLogger((String)"tac");
    private static final Predicate<LivingEntity> HOSTILE_ENTITIES = entity -> entity.m_5720_() == SoundSource.HOSTILE && !((List)Config.COMMON.aggroMobs.exemptEntities.get()).contains(entity.m_6095_().getRegistryName().toString());
    private static final UUID speedUptId = UUID.fromString("923e4567-e89b-42d3-a456-556642440000");

    public static void handleShoot(MessageShoot message, ServerPlayer player, float randP, float randY) {
        if (!player.m_5833_()) {
            net.minecraft.world.level.Level world = player.f_19853_;
            ItemStack heldItem = player.m_21120_(InteractionHand.MAIN_HAND);
            if (heldItem.m_41720_() instanceof GunItem && (Gun.hasAmmo(heldItem) || player.m_7500_())) {
                GunItem item = (GunItem)heldItem.m_41720_();
                Gun modifiedGun = item.getModifiedGun(heldItem);
                if (modifiedGun != null) {
                    int level;
                    CompoundTag tag;
                    boolean silenced;
                    ResourceLocation fireSound;
                    if (MinecraftForge.EVENT_BUS.post((Event)new GunFireEvent.Pre((Player)player, heldItem))) {
                        return;
                    }
                    player.m_146922_(message.getRotationYaw());
                    player.m_146926_(message.getRotationPitch());
                    if (!modifiedGun.getGeneral().isAlwaysSpread() && modifiedGun.getGeneral().getSpread() > 0.0f) {
                        SpreadTracker.get((Player)player).update((Player)player, item);
                    }
                    int count = modifiedGun.getGeneral().getProjectileAmount();
                    Gun.Projectile projectileProps = modifiedGun.getProjectile();
                    ProjectileEntity[] spawnedProjectiles = new ProjectileEntity[count];
                    for (int i = 0; i < count; ++i) {
                        IProjectileFactory factory = ProjectileManager.getInstance().getFactory(projectileProps.getItem());
                        ProjectileEntity projectileEntity = factory.create(world, (LivingEntity)player, heldItem, item, modifiedGun, randP, randY);
                        projectileEntity.setWeapon(heldItem);
                        projectileEntity.setAdditionalDamage(Gun.getAdditionalDamage(heldItem));
                        world.m_7967_((Entity)projectileEntity);
                        spawnedProjectiles[i] = projectileEntity;
                        projectileEntity.m_8119_();
                    }
                    if (!projectileProps.isVisible()) {
                        MessageBulletTrail messageBulletTrail = new MessageBulletTrail(spawnedProjectiles, projectileProps, player.m_142049_(), projectileProps.getSize());
                        PacketHandler.getPlayChannel().send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(player.m_20185_(), player.m_20186_(), player.m_20189_(), ((Double)Config.COMMON.network.projectileTrackingRange.get()).doubleValue(), player.f_19853_.m_46472_())), (Object)messageBulletTrail);
                    }
                    MinecraftForge.EVENT_BUS.post((Event)new GunFireEvent.Post((Player)player, heldItem));
                    if (((Boolean)Config.COMMON.aggroMobs.enabled.get()).booleanValue()) {
                        double radius = GunModifierHelper.getModifiedFireSoundRadius(heldItem, (Double)Config.COMMON.aggroMobs.range.get());
                        double x = player.m_20185_();
                        double y = player.m_20186_() + 0.5;
                        double z = player.m_20189_();
                        AABB box = new AABB(x - radius, y - radius, z - radius, x + radius, y + radius, z + radius);
                        radius *= radius;
                        for (LivingEntity entity : world.m_6443_(LivingEntity.class, box, HOSTILE_ENTITIES)) {
                            double dz;
                            double dy;
                            double dx = x - entity.m_20185_();
                            if (!(dx * dx + (dy = y - entity.m_20186_()) * dy + (dz = z - entity.m_20189_()) * dz <= radius)) continue;
                            entity.m_6703_((LivingEntity)((Boolean)Config.COMMON.aggroMobs.angerHostileMobs.get() != false ? player : entity));
                        }
                    }
                    ResourceLocation resourceLocation = fireSound = (silenced = GunModifierHelper.isSilencedFire(heldItem)) ? modifiedGun.getSounds().getSilencedFire() : modifiedGun.getSounds().getFire();
                    if (fireSound != null) {
                        double posX = player.m_20185_();
                        double posY = player.m_20186_() + (double)player.m_20192_();
                        double posZ = player.m_20189_();
                        float volume = GunModifierHelper.getFireSoundVolume(heldItem);
                        float pitch = 0.9f + world.f_46441_.nextFloat() * 0.125f;
                        double radius = GunModifierHelper.getModifiedFireSoundRadius(heldItem, (Double)Config.SERVER.gunShotMaxDistance.get());
                        boolean muzzle = modifiedGun.getDisplay().getFlash() != null;
                        MessageGunSound messageSound = new MessageGunSound(fireSound, SoundSource.PLAYERS, (float)posX, (float)posY, (float)posZ, volume, pitch, player.m_142049_(), muzzle, false);
                        PacketDistributor.TargetPoint targetPoint = new PacketDistributor.TargetPoint(posX, posY, posZ, radius, player.f_19853_.m_46472_());
                        PacketHandler.getPlayChannel().send(PacketDistributor.NEAR.with(() -> targetPoint), (Object)messageSound);
                    }
                    if (!(player.m_7500_() || (tag = heldItem.m_41784_()).m_128471_("IgnoreAmmo") || (level = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchantments.RECLAIMED.get()), (ItemStack)heldItem)) != 0 && player.f_19853_.f_46441_.nextInt(4 - Mth.m_14045_((int)level, (int)1, (int)2)) == 0)) {
                        tag.m_128405_("AmmoCount", Math.max(0, tag.m_128451_("AmmoCount") - 1));
                    }
                }
            } else {
                world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12088_, SoundSource.BLOCKS, 0.3f, 0.8f);
            }
        }
    }

    public static void handleCraft(ServerPlayer player, ResourceLocation id, BlockPos pos) {
        WorkbenchContainer workbench;
        net.minecraft.world.level.Level world = player.f_19853_;
        if (player.f_36096_ instanceof WorkbenchContainer && (workbench = (WorkbenchContainer)player.f_36096_).getPos().equals((Object)pos)) {
            WorkbenchRecipe recipe = WorkbenchRecipes.getRecipeById(world, id);
            if (recipe == null) {
                return;
            }
            ImmutableList<Pair<Ingredient, Integer>> materials = recipe.getMaterials();
            if (materials != null) {
                Pair stack2;
                for (Pair stack2 : materials) {
                    if (InventoryUtil.hasIngredient((Player)player, (Pair<Ingredient, Integer>)stack2)) continue;
                    return;
                }
                for (Pair stack2 : materials) {
                    if (InventoryUtil.removeItemStackFromIngredient((Player)player, (Pair<Ingredient, Integer>)stack2)) continue;
                    return;
                }
                WorkbenchTileEntity workbenchTileEntity = workbench.getWorkbench();
                stack2 = recipe.getItem();
                ItemStack dyeStack = (ItemStack)workbenchTileEntity.getInventory().get(0);
                if (dyeStack.m_41720_() instanceof DyeItem) {
                    DyeItem dyeItem = (DyeItem)dyeStack.m_41720_();
                    int color = dyeItem.m_41089_().m_41071_();
                    if (stack2.m_41720_() instanceof IColored && ((IColored)stack2.m_41720_()).canColor((ItemStack)stack2)) {
                        IColored colored = (IColored)stack2.m_41720_();
                        colored.setColor((ItemStack)stack2, color);
                        workbenchTileEntity.getInventory().set(0, (Object)ItemStack.f_41583_);
                    }
                }
                if (stack2.m_41720_() instanceof TimelessGunItem) {
                    if (stack2.m_41783_() == null) {
                        stack2.m_41784_();
                    }
                    GunItem gunItem = (GunItem)stack2.m_41720_();
                    Gun gun = gunItem.getModifiedGun((ItemStack)stack2);
                    int[] gunItemFireModes = stack2.m_41783_().m_128465_("supportedFireModes");
                    if (ArrayUtils.isEmpty((int[])gunItemFireModes)) {
                        gunItemFireModes = gun.getGeneral().getRateSelector();
                        stack2.m_41783_().m_128385_("supportedFireModes", gunItemFireModes);
                    } else if (!Arrays.equals(gunItemFireModes, gun.getGeneral().getRateSelector())) {
                        stack2.m_41783_().m_128385_("supportedFireModes", gun.getGeneral().getRateSelector());
                    }
                }
                Containers.m_18992_((net.minecraft.world.level.Level)world, (double)((double)pos.m_123341_() + 0.5), (double)((double)pos.m_123342_() + 1.125), (double)((double)pos.m_123343_() + 0.5), (ItemStack)stack2);
            }
        }
    }

    public static void handleUnload(ServerPlayer player) {
        ItemStack stack = player.m_21205_();
        if (stack.m_41720_() instanceof GunItem) {
            ResourceLocation reloadSound;
            CompoundTag tag = stack.m_41783_();
            GunItem gunItem = (GunItem)stack.m_41720_();
            Gun gun = gunItem.getModifiedGun(stack);
            if (tag != null && tag.m_128425_("AmmoCount", 3)) {
                int count = tag.m_128451_("AmmoCount");
                tag.m_128405_("AmmoCount", 0);
                ResourceLocation id = gun.getProjectile().getItem();
                Item item = (Item)ForgeRegistries.ITEMS.getValue(id);
                if (item == null) {
                    return;
                }
                int maxStackSize = item.m_41459_();
                int stacks = count / maxStackSize;
                for (int i = 0; i < stacks; ++i) {
                    ServerPlayHandler.spawnAmmo(player, new ItemStack((ItemLike)item, maxStackSize));
                }
                int remaining = count % maxStackSize;
                if (remaining > 0) {
                    ServerPlayHandler.spawnAmmo(player, new ItemStack((ItemLike)item, remaining));
                }
            }
            if ((reloadSound = gun.getSounds().getCock()) != null) {
                MessageGunSound message = new MessageGunSound(reloadSound, SoundSource.PLAYERS, (float)player.m_20185_(), (float)player.m_20186_() + 1.0f, (float)player.m_20189_(), 1.0f, 1.0f, player.m_142049_(), false, true);
                PacketHandler.getPlayChannel().send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(player.m_20185_(), player.m_20186_() + 1.0, player.m_20189_(), 16.0, player.f_19853_.m_46472_())), (Object)message);
            }
        }
    }

    private static void spawnAmmo(ServerPlayer player, ItemStack stack) {
        player.m_150109_().m_36054_(stack);
        if (stack.m_41613_() > 0) {
            player.f_19853_.m_7967_((Entity)new ItemEntity(player.f_19853_, player.m_20185_(), player.m_20186_(), player.m_20189_(), stack.m_41777_()));
        }
    }

    public static void handleAttachments(ServerPlayer player) {
        ItemStack heldItem = player.m_21205_();
        if (heldItem.m_41720_() instanceof GunItem || heldItem.m_41720_() instanceof IEasyColor) {
            NetworkHooks.openGui((ServerPlayer)player, (MenuProvider)new SimpleMenuProvider((windowId, playerInventory, player1) -> new AttachmentContainer(windowId, playerInventory, heldItem), (Component)new TranslatableComponent("container.tac.attachments")));
        }
    }

    public static void handleColorbenchGui(ServerPlayer player) {
        ItemStack heldItem = player.m_21205_();
        if (heldItem.m_41720_() instanceof GunItem || heldItem.m_41720_() instanceof ScopeItem) {
            NetworkHooks.openGui((ServerPlayer)player, (MenuProvider)new SimpleMenuProvider((windowId, playerInventory, player1) -> new ColorBenchContainer(windowId, playerInventory), (Component)new TranslatableComponent("container.tac.color_bench")));
        }
    }

    public static void handleInspection(ServerPlayer player) {
        ItemStack heldItem = player.m_21205_();
        if (heldItem.m_41720_() instanceof GunItem) {
            NetworkHooks.openGui((ServerPlayer)player, (MenuProvider)new SimpleMenuProvider((windowId, playerInventory, player1) -> new InspectionContainer(windowId, playerInventory, heldItem), (Component)new TranslatableComponent("container.tac.inspection")));
        }
    }

    public static void handleFireMode(ServerPlayer player) {
        ItemStack heldItem = player.m_21205_();
        try {
            if (heldItem.m_41720_() instanceof GunItem) {
                if (heldItem.m_41783_() == null) {
                    heldItem.m_41784_();
                }
                GunItem gunItem = (GunItem)heldItem.m_41720_();
                Gun gun = gunItem.getModifiedGun(heldItem);
                int[] gunItemFireModes = heldItem.m_41783_().m_128465_("supportedFireModes");
                if (ArrayUtils.isEmpty((int[])gunItemFireModes)) {
                    gunItemFireModes = gun.getGeneral().getRateSelector();
                    heldItem.m_41783_().m_128385_("supportedFireModes", gunItemFireModes);
                    heldItem.m_41783_().m_128405_("CurrentFireMode", gunItemFireModes[0]);
                } else if (!Arrays.equals(gunItemFireModes, gun.getGeneral().getRateSelector())) {
                    heldItem.m_41783_().m_128385_("supportedFireModes", gun.getGeneral().getRateSelector());
                    if (!heldItem.m_41783_().m_128441_("CurrentFireMode")) {
                        heldItem.m_41783_().m_128405_("CurrentFireMode", gunItemFireModes[0]);
                    }
                }
                int toCheck = ArrayUtils.indexOf((int[])gunItemFireModes, (int)heldItem.m_41783_().m_128451_("CurrentFireMode")) + 1;
                ServerPlayHandler.CurrentFireMode(heldItem, gunItemFireModes, toCheck);
                if (!((Boolean)Config.COMMON.gameplay.safetyExistence.get()).booleanValue() && heldItem.m_41783_().m_128451_("CurrentFireMode") == 0 && gunItemFireModes.length > 1) {
                    toCheck = ArrayUtils.indexOf((int[])gunItemFireModes, (int)heldItem.m_41783_().m_128451_("CurrentFireMode")) + 1;
                    ServerPlayHandler.CurrentFireMode(heldItem, gunItemFireModes, toCheck);
                } else if (!((Boolean)Config.COMMON.gameplay.safetyExistence.get()).booleanValue() && heldItem.m_41783_().m_128451_("CurrentFireMode") == 0) {
                    heldItem.m_41783_().m_128473_("CurrentFireMode");
                    heldItem.m_41783_().m_128405_("CurrentFireMode", gunItemFireModes[0]);
                }
                ResourceLocation fireModeSound = gun.getSounds().getCock();
                if (fireModeSound != null && player.m_6084_()) {
                    MessageGunSound messageSound = new MessageGunSound(fireModeSound, SoundSource.PLAYERS, (float)player.m_20185_(), (float)(player.m_20186_() + 1.0), (float)player.m_20189_(), 1.0f, 1.0f, player.m_142049_(), false, false);
                    PacketHandler.getPlayChannel().send(PacketDistributor.PLAYER.with(() -> player), (Object)messageSound);
                }
            }
        }
        catch (Exception e) {
            GunMod.LOGGER.log(Level.ERROR, "Fire Mode check did not function properly");
        }
    }

    private static void CurrentFireMode(ItemStack heldItem, int[] gunItemFireModes, int toCheck) {
        if (toCheck > heldItem.m_41783_().m_128465_("supportedFireModes").length - 1) {
            heldItem.m_41783_().m_128473_("CurrentFireMode");
            heldItem.m_41783_().m_128405_("CurrentFireMode", gunItemFireModes[0]);
        } else {
            heldItem.m_41783_().m_128473_("CurrentFireMode");
            heldItem.m_41783_().m_128405_("CurrentFireMode", gunItemFireModes[toCheck]);
        }
    }

    public static void EmptyMag(ServerPlayer player) {
        GunItem gunItem;
        Gun gun;
        ResourceLocation fireModeSound;
        ItemStack heldItem = player.m_21205_();
        if (heldItem.m_41720_() instanceof GunItem && (fireModeSound = (gun = (gunItem = (GunItem)heldItem.m_41720_()).getModifiedGun(heldItem)).getSounds().getCock()) != null && player.m_6084_()) {
            MessageGunSound messageSound = new MessageGunSound(fireModeSound, SoundSource.PLAYERS, (float)player.m_20185_(), (float)(player.m_20186_() + 1.0), (float)player.m_20189_(), 1.2f, 0.75f, player.m_142049_(), false, false);
            PacketHandler.getPlayChannel().send(PacketDistributor.PLAYER.with(() -> player), (Object)messageSound);
        }
    }

    public static void handleFlashLight(ServerPlayer player, int[] lookingRange) {
        if (player.m_21205_().m_41720_() instanceof GunItem && Gun.getAttachment(IAttachment.Type.SIDE_RAIL, player.m_21205_()) != null) {
            net.minecraft.world.level.Level world = player.f_19853_;
            BlockEntity tile = null;
            for (int itor : lookingRange) {
                int x = ServerPlayHandler.lookingAt((Player)player, itor).m_123341_();
                int y = ServerPlayHandler.lookingAt((Player)player, itor).m_123342_();
                int z = ServerPlayHandler.lookingAt((Player)player, itor).m_123343_();
                boolean createLight = false;
                for (int i = 0; i < 5; ++i) {
                    tile = world.m_7702_(new BlockPos(x, y, z));
                    if (tile instanceof FlashLightSource) {
                        createLight = true;
                        break;
                    }
                    if (!world.m_46859_(new BlockPos(x, y, z))) {
                        int pX = (int)player.m_20182_().m_7096_();
                        int pY = (int)player.m_20182_().m_7098_();
                        int pZ = (int)player.m_20182_().m_7094_();
                        if (pX > x) {
                            ++x;
                        } else if (pX < x) {
                            --x;
                        }
                        if (pY > y) {
                            ++y;
                        } else if (pY < y) {
                            --y;
                        }
                        if (pZ > z) {
                            ++z;
                            continue;
                        }
                        if (pZ >= z) continue;
                        --z;
                        continue;
                    }
                    if (!world.m_46859_(new BlockPos(x, y, z))) continue;
                    createLight = true;
                    break;
                }
                if (!createLight) continue;
                tile = world.m_7702_(new BlockPos(x, y, z));
                if (tile instanceof FlashLightSource) {
                    FlashLightSource cfr_ignored_0 = (FlashLightSource)tile;
                    FlashLightSource.ticks = 0;
                } else if (world.m_8055_(new BlockPos(x, y, z)).m_60734_() != ModBlocks.FLASHLIGHT_BLOCK.get()) {
                    world.m_7731_(new BlockPos(x, y, z), ((Block)ModBlocks.FLASHLIGHT_BLOCK.get()).m_49966_(), 3);
                }
                world.m_7731_(new BlockPos(x, y, z), ((Block)ModBlocks.FLASHLIGHT_BLOCK.get()).m_49966_(), 3);
            }
        }
    }

    protected static BlockPos lookingAt(Player player, int rangeL) {
        return ((BlockHitResult)player.m_19907_((double)rangeL, 0.0f, false)).m_82425_();
    }

    protected static HitResult lookingAtEntity(Player player, int rangeL) {
        return player.m_19907_((double)rangeL, 0.0f, false);
    }

    private static void changeGunSpeedMod(ServerPlayer entity, String name, double modifier) {
        AttributeModifier speedModifier = new AttributeModifier(speedUptId, name, modifier, AttributeModifier.Operation.MULTIPLY_TOTAL);
        AttributeInstance attributeInstance = entity.m_21051_(Attributes.f_22279_);
        if (attributeInstance.m_22111_(speedUptId) != null) {
            attributeInstance.m_22130_(speedModifier);
        }
        attributeInstance.m_22125_(speedModifier);
    }

    private static void removeGunSpeedMod(ServerPlayer entity, String name, double modifier) {
        AttributeModifier speedModifier = new AttributeModifier(speedUptId, name, modifier, AttributeModifier.Operation.MULTIPLY_TOTAL);
        AttributeInstance attributeInstance = entity.m_21051_(Attributes.f_22279_);
        if (attributeInstance.m_22111_(speedUptId) != null) {
            attributeInstance.m_22130_(speedModifier);
        }
    }

    public static void handleMovementUpdate(ServerPlayer player, boolean handle) {
        if (player == null) {
            return;
        }
        if (player.m_5833_()) {
            return;
        }
        if (!player.m_6084_()) {
            return;
        }
        ItemStack heldItem = player.m_21205_();
        if (player.m_21051_(Attributes.f_22279_) != null && MovementAdaptationsHandler.get().isReadyToReset()) {
            ServerPlayHandler.removeGunSpeedMod(player, "GunSpeedMod", 0.1);
            MovementAdaptationsHandler.get().setReadyToReset(false);
            MovementAdaptationsHandler.get().setReadyToUpdate(true);
        }
        player.m_6885_();
        if (!(heldItem.m_41720_() instanceof TimelessGunItem)) {
            return;
        }
        Gun gun = ((TimelessGunItem)heldItem.m_41720_()).getGun();
        if (MovementAdaptationsHandler.get().isReadyToUpdate() || MovementAdaptationsHandler.get().getPreviousWeight() != gun.getGeneral().getWeightKilo()) {
            float speed = ServerPlayHandler.calceldGunWeightSpeed(gun, heldItem);
            speed = player.m_20142_() && speed > 0.094f ? Math.max(Math.min(speed, 0.12f), 0.075f) : (player.m_20142_() ? Math.max(Math.min(speed, 0.12f), 0.075f) * 0.955f : Math.max(Math.min(speed, 0.1f), 0.075f));
            ServerPlayHandler.changeGunSpeedMod(player, "GunSpeedMod", -((0.1 - (double)speed) * 10.0));
            MovementAdaptationsHandler.get().setReadyToReset(true);
            MovementAdaptationsHandler.get().setReadyToUpdate(false);
            MovementAdaptationsHandler.get().setSpeed(speed);
        } else {
            MovementAdaptationsHandler.get().setSpeed((float)player.m_21051_(Attributes.f_22279_).m_22135_());
        }
        player.m_6885_();
        MovementAdaptationsHandler.get().setPreviousWeight(gun.getGeneral().getWeightKilo());
    }

    public static float calceldGunWeightSpeed(Gun gun, ItemStack gunStack) {
        return 0.1f / (1.0f + (gun.getGeneral().getWeightKilo() * (1.0f + GunModifierHelper.getModifierOfWeaponWeight(gunStack)) + GunModifierHelper.getAdditionalWeaponWeight(gunStack) - GunEnchantmentHelper.getWeightModifier(gunStack)) / 2.0f * 0.0275f);
    }

    public static void handleGunID(ServerPlayer player, boolean regenerate) {
        if (!player.m_6084_()) {
            return;
        }
        if (NetworkGunManager.get() != null && NetworkGunManager.get().StackIds != null && player.m_21205_().m_41720_() instanceof TimelessGunItem && player.m_21205_().m_41783_() != null) {
            if (regenerate || !player.m_21205_().m_41783_().m_128441_("ID")) {
                UUID id;
                do {
                    LOGGER.log(Level.INFO, "NEW UUID GEN FOR TAC GUN");
                } while (!NetworkGunManager.get().Ids.add(id = UUID.randomUUID()));
                player.m_21205_().m_41783_().m_128362_("ID", id);
                NetworkGunManager.get().StackIds.put(id, player.m_21205_());
            }
            ServerPlayHandler.initLevelTracking(player.m_21205_());
        }
    }

    private static void initLevelTracking(ItemStack gunStack) {
        if (gunStack.m_41783_().m_128423_("level") == null) {
            gunStack.m_41783_().m_128405_("level", 1);
        }
        if (gunStack.m_41783_().m_128423_("levelDmg") == null) {
            gunStack.m_41783_().m_128350_("levelDmg", 0.0f);
        }
    }

    public static void handleUpgradeBenchItem(MessageSaveItemUpgradeBench message, ServerPlayer player) {
        if (!player.m_5833_()) {
            net.minecraft.world.level.Level world = player.f_19853_;
            ItemStack heldItem = player.m_21120_(InteractionHand.MAIN_HAND);
            BlockEntity tileEntity = world.m_7702_(message.getPos());
            if (player.m_6047_()) {
                NetworkHooks.openGui((ServerPlayer)player, (MenuProvider)((MenuProvider)tileEntity), (BlockPos)tileEntity.m_58899_());
                return;
            }
            world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12088_, SoundSource.BLOCKS, 0.3f, 0.8f);
            if (tileEntity != null) {
                if (!(((UpgradeBenchTileEntity)tileEntity).m_8020_(0).m_41720_() instanceof GunItem) && heldItem.m_41720_() instanceof GunItem) {
                    ((UpgradeBenchTileEntity)tileEntity).m_6836_(0, heldItem);
                    player.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.f_41852_));
                    NetworkHooks.openGui((ServerPlayer)player, (MenuProvider)((MenuProvider)tileEntity), (BlockPos)tileEntity.m_58899_());
                    player.m_6915_();
                } else if (heldItem.m_41720_() == ModItems.MODULE.get() && ((UpgradeBenchTileEntity)tileEntity).m_8020_(1).m_41613_() < 3) {
                    if (((UpgradeBenchTileEntity)tileEntity).m_8020_(1).m_41720_() != ModItems.MODULE.get()) {
                        ((UpgradeBenchTileEntity)tileEntity).m_6836_(1, heldItem.m_41777_());
                        ((UpgradeBenchTileEntity)tileEntity).m_8020_(1).m_41764_(1);
                    } else {
                        ((UpgradeBenchTileEntity)tileEntity).m_8020_(1).m_41764_(((UpgradeBenchTileEntity)tileEntity).m_8020_(1).m_41613_() + 1);
                    }
                    player.m_21120_(InteractionHand.MAIN_HAND).m_41764_(player.m_21120_(InteractionHand.MAIN_HAND).m_41613_() - 1);
                    NetworkHooks.openGui((ServerPlayer)player, (MenuProvider)((MenuProvider)tileEntity), (BlockPos)tileEntity.m_58899_());
                    player.m_6915_();
                } else {
                    player.m_150109_().m_36054_(((UpgradeBenchTileEntity)tileEntity).m_8020_(0));
                    ((UpgradeBenchTileEntity)tileEntity).m_6836_(0, ItemStack.f_41583_);
                    NetworkHooks.openGui((ServerPlayer)player, (MenuProvider)((MenuProvider)tileEntity), (BlockPos)tileEntity.m_58899_());
                    player.m_6915_();
                }
            }
        }
    }

    public static void handleUpgradeBenchApply(MessageUpgradeBenchApply message, ServerPlayer player) {
        if (player.f_36096_ instanceof UpgradeBenchContainer) {
            UpgradeBenchContainer workbench = (UpgradeBenchContainer)player.f_36096_;
            UpgradeBenchScreen.RequirementItem req = GunEnchantmentHelper.upgradeableEnchs.get(message.reqKey);
            if (workbench.getPos().equals((Object)message.pos)) {
                ItemStack toUpdate = (ItemStack)workbench.getBench().getInventory().get(0);
                int currLevel = EnchantmentHelper.m_44843_((Enchantment)req.enchantment, (ItemStack)toUpdate);
                if (toUpdate.m_41783_() == null) {
                    return;
                }
                int currWeaponLevel = toUpdate.m_41783_().m_128451_("level");
                TimelessGunItem gunItem = (TimelessGunItem)toUpdate.m_41720_();
                if (workbench.getBench().m_8020_(1).m_41613_() >= req.getModuleCount()[currLevel] && currWeaponLevel >= req.getLevelReq()[currLevel] && gunItem.getGun().getGeneral().getUpgradeBenchMaxUses() > toUpdate.m_41783_().m_128451_("upgradeBenchUses")) {
                    if (currLevel > 0) {
                        Map listNBT = EnchantmentHelper.m_44882_((ListTag)toUpdate.m_41785_());
                        listNBT.replace(req.enchantment, currLevel + 1);
                        EnchantmentHelper.m_44865_((Map)listNBT, (ItemStack)toUpdate);
                    } else {
                        toUpdate.m_41663_(req.enchantment, 1);
                    }
                    workbench.getBench().m_8020_(1).m_41764_(workbench.getBench().m_8020_(1).m_41613_() - req.getModuleCount()[currLevel]);
                    toUpdate.m_41783_().m_128405_("upgradeBenchUses", toUpdate.m_41783_().m_128451_("upgradeBenchUses") + 1);
                } else {
                    player.m_5661_((Component)new TranslatableComponent("Cannot apply enchants anymore"), true);
                }
            }
        }
    }

    public static void handleArmorFixApplication(ServerPlayer player) {
        if (!WearableHelper.PlayerWornRig((Player)player).m_41619_() && !WearableHelper.isFullDurability(WearableHelper.PlayerWornRig((Player)player))) {
            Rig rig = ((ArmorRigItem)WearableHelper.PlayerWornRig((Player)player).m_41720_()).getRig();
            if (player.m_21205_().m_41720_().getRegistryName().equals((Object)rig.getRepair().getItem())) {
                WearableHelper.tickRepairCurrentDurability(WearableHelper.PlayerWornRig((Player)player));
                player.m_21205_().m_41764_(player.m_21205_().m_41613_() - 1);
                ResourceLocation repairSound = rig.getSounds().getRepair();
                if (repairSound != null && player.m_6084_()) {
                    MessageGunSound messageSound = new MessageGunSound(repairSound, SoundSource.PLAYERS, (float)player.m_20185_(), (float)(player.m_20186_() + 1.0), (float)player.m_20189_(), 1.0f, 1.0f, player.m_142049_(), false, false);
                    PacketHandler.getPlayChannel().send(PacketDistributor.PLAYER.with(() -> player), (Object)messageSound);
                }
            }
        }
    }
}

