/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.common;

import com.tac.guns.event.GunFireEvent;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="tac")
public class ShootTracker {
    private boolean isShooting = false;
    private boolean isTicked = false;
    private static final Map<Player, ShootTracker> SHOOT_TRACKER_MAP = new WeakHashMap<Player, ShootTracker>();

    public static ShootTracker getShootTracker(Player player) {
        return SHOOT_TRACKER_MAP.computeIfAbsent(player, player1 -> new ShootTracker());
    }

    @SubscribeEvent
    public static void onGunFire(GunFireEvent.Post event) {
        if (event.isClient()) {
            return;
        }
        ShootTracker tracker = ShootTracker.getShootTracker(event.getPlayer());
        tracker.isShooting = true;
        tracker.isTicked = false;
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        SHOOT_TRACKER_MAP.values().forEach(tracker -> {
            if (tracker.isTicked) {
                tracker.isShooting = false;
            } else {
                tracker.isTicked = true;
            }
        });
    }

    public boolean isShooting() {
        return this.isShooting;
    }
}

