/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.common;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.tac.guns.annotation.Optional;
import com.tac.guns.interfaces.TGExclude;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.INBTSerializable;

public final class Rig
implements INBTSerializable<CompoundTag> {
    private General general = new General();
    private Repair repair = new Repair();
    private Sounds sounds = new Sounds();
    public static ExclusionStrategy strategy = new ExclusionStrategy(){

        public boolean shouldSkipClass(Class<?> clazz) {
            return false;
        }

        public boolean shouldSkipField(FieldAttributes field) {
            return field.getAnnotation(TGExclude.class) != null;
        }
    };

    public General getGeneral() {
        return this.general;
    }

    public Repair getRepair() {
        return this.repair;
    }

    public Sounds getSounds() {
        return this.sounds;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("General", (Tag)this.general.serializeNBT());
        tag.m_128365_("Repair", (Tag)this.repair.serializeNBT());
        tag.m_128365_("Sounds", (Tag)this.sounds.serializeNBT());
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        if (tag.m_128425_("General", 10)) {
            this.general.deserializeNBT(tag.m_128469_("General"));
        }
        if (tag.m_128425_("Repair", 10)) {
            this.repair.deserializeNBT(tag.m_128469_("Repair"));
        }
        if (tag.m_128425_("Sounds", 10)) {
            this.sounds.deserializeNBT(tag.m_128469_("Sounds"));
        }
    }

    public static Rig create(CompoundTag tag) {
        Rig gun = new Rig();
        gun.deserializeNBT(tag);
        return gun;
    }

    public Rig copy() {
        Rig gun = new Rig();
        gun.general = this.general.copy();
        gun.repair = this.repair.copy();
        gun.sounds = this.sounds.copy();
        return gun;
    }

    private static boolean isAmmo(ItemStack stack, ResourceLocation id) {
        return stack != null && stack.m_41720_().getRegistryName().equals((Object)id);
    }

    public static class General
    implements INBTSerializable<CompoundTag> {
        @Optional
        private int armorClass = 1;
        @Optional
        private int ergonomics = 1;
        @Optional
        private float speedReduction = 0.0f;
        @Optional
        private float movementInaccuracy = 1.0f;

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128405_("ArmorClass", this.armorClass);
            tag.m_128405_("Ergonomics", this.ergonomics);
            tag.m_128350_("SpeedReduction", this.speedReduction);
            tag.m_128350_("MovementInaccuracy", this.movementInaccuracy);
            return tag;
        }

        public void deserializeNBT(CompoundTag tag) {
            if (tag.m_128425_("ArmorClass", 99)) {
                this.armorClass = tag.m_128451_("ArmorClass");
            }
            if (tag.m_128425_("Ergonomics", 99)) {
                this.ergonomics = tag.m_128451_("Ergonomics");
            }
            if (tag.m_128425_("SpeedReduction", 99)) {
                this.speedReduction = tag.m_128457_("SpeedReduction");
            }
            if (tag.m_128425_("MovementInaccuracy", 99)) {
                this.movementInaccuracy = tag.m_128457_("MovementInaccuracy");
            }
        }

        public General copy() {
            General general = new General();
            general.armorClass = this.armorClass;
            general.ergonomics = this.ergonomics;
            general.speedReduction = this.speedReduction;
            general.movementInaccuracy = this.movementInaccuracy;
            return general;
        }

        public int getArmorClass() {
            return this.armorClass;
        }

        public int getErgonomics() {
            return this.ergonomics;
        }

        public float getSpeedReduction() {
            return this.speedReduction;
        }

        public float getMovementInaccuracy() {
            return this.movementInaccuracy;
        }
    }

    public static class Repair
    implements INBTSerializable<CompoundTag> {
        @Optional
        private int ticksToRepair = 40;
        @Optional
        private float durability = 40.0f;
        @Optional
        private float quickRepairability = 0.5f;
        @Optional
        private boolean quickRepairable = true;
        @TGExclude
        private ResourceLocation repairItem = new ResourceLocation("tac", "armor_plate");

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("RepairItem", this.repairItem.toString());
            tag.m_128405_("TicksToRepair", this.ticksToRepair);
            tag.m_128350_("Durability", this.durability);
            tag.m_128350_("QuickRepairability", this.quickRepairability);
            tag.m_128379_("QuickRepairable", this.quickRepairable);
            return tag;
        }

        public void deserializeNBT(CompoundTag tag) {
            if (tag.m_128425_("RepairItem", 8)) {
                this.repairItem = new ResourceLocation(tag.m_128461_("RepairItem"));
            }
            if (tag.m_128425_("TicksToRepair", 99)) {
                this.ticksToRepair = tag.m_128451_("TicksToRepair");
            }
            if (tag.m_128425_("Durability", 99)) {
                this.durability = tag.m_128457_("Durability");
            }
            if (tag.m_128425_("QuickRepairability", 99)) {
                this.quickRepairability = tag.m_128457_("QuickRepairability");
            }
            if (tag.m_128425_("QuickRepairable", 99)) {
                this.quickRepairable = tag.m_128471_("QuickRepairable");
            }
        }

        public Repair copy() {
            Repair repair = new Repair();
            repair.quickRepairable = this.quickRepairable;
            repair.repairItem = this.repairItem;
            repair.durability = this.durability;
            repair.quickRepairability = this.quickRepairability;
            repair.ticksToRepair = this.ticksToRepair;
            return repair;
        }

        public ResourceLocation getItem() {
            return this.repairItem;
        }

        public int getTicksToRepair() {
            return this.ticksToRepair;
        }

        public float getDurability() {
            return this.durability;
        }

        public float getQuickRepairability() {
            return this.quickRepairability;
        }

        public boolean isQuickRepairable() {
            return this.quickRepairable;
        }
    }

    public static class Sounds
    implements INBTSerializable<CompoundTag> {
        @Optional
        @Nullable
        @TGExclude
        private ResourceLocation step;
        @Optional
        @Nullable
        @TGExclude
        private ResourceLocation on;
        @Optional
        @Nullable
        @TGExclude
        private ResourceLocation off;
        @Optional
        @Nullable
        @TGExclude
        private ResourceLocation hit;
        @Optional
        @Nullable
        @TGExclude
        private ResourceLocation broken;
        @Optional
        @Nullable
        @TGExclude
        private ResourceLocation repair;

        @Nullable
        public ResourceLocation getOn() {
            return this.on;
        }

        @Nullable
        public ResourceLocation getOff() {
            return this.off;
        }

        @Nullable
        public ResourceLocation getHit() {
            return this.hit;
        }

        @Nullable
        public ResourceLocation getBroken() {
            return this.broken;
        }

        @Nullable
        public ResourceLocation getRepair() {
            return this.repair;
        }

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            if (this.step != null) {
                tag.m_128359_("Step", this.step.toString());
            }
            if (this.on != null) {
                tag.m_128359_("On", this.on.toString());
            }
            if (this.off != null) {
                tag.m_128359_("Off", this.off.toString());
            }
            if (this.hit != null) {
                tag.m_128359_("Hit", this.hit.toString());
            }
            if (this.broken != null) {
                tag.m_128359_("Broken", this.broken.toString());
            }
            if (this.repair != null) {
                tag.m_128359_("Repair", this.repair.toString());
            }
            return tag;
        }

        public void deserializeNBT(CompoundTag tag) {
            if (tag.m_128425_("Step", 8)) {
                this.step = this.createSound(tag, "Step");
            }
            if (tag.m_128425_("On", 8)) {
                this.on = this.createSound(tag, "On");
            }
            if (tag.m_128425_("Off", 8)) {
                this.off = this.createSound(tag, "Off");
            }
            if (tag.m_128425_("Hit", 8)) {
                this.hit = this.createSound(tag, "Hit");
            }
            if (tag.m_128425_("Broken", 8)) {
                this.broken = this.createSound(tag, "Broken");
            }
            if (tag.m_128425_("Repair", 8)) {
                this.repair = this.createSound(tag, "Repair");
            }
        }

        public Sounds copy() {
            Sounds sounds = new Sounds();
            sounds.broken = this.broken;
            sounds.hit = this.hit;
            sounds.off = this.off;
            sounds.on = this.on;
            sounds.repair = this.repair;
            sounds.step = this.step;
            return sounds;
        }

        @Nullable
        private ResourceLocation createSound(CompoundTag tag, String key) {
            String sound = tag.m_128461_(key);
            return sound.isEmpty() ? null : new ResourceLocation(sound);
        }

        @Nullable
        public ResourceLocation getStep() {
            return this.step;
        }
    }
}

