/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.common;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mrcrayfish.framework.api.data.login.ILoginData;
import com.tac.guns.GunMod;
import com.tac.guns.annotation.Validator;
import com.tac.guns.common.CustomRig;
import com.tac.guns.common.JsonDeserializers;
import com.tac.guns.common.Rig;
import com.tac.guns.item.transition.wearables.ArmorRigItem;
import com.tac.guns.network.message.MessageUpdateRigs;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InvalidObjectException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.Validate;

@Mod.EventBusSubscriber(modid="tac")
public class NetworkRigManager
extends SimplePreparableReloadListener<Map<ArmorRigItem, Rig>> {
    private static final Gson GSON_INSTANCE = (Gson)Util.m_137537_(() -> {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(ResourceLocation.class, JsonDeserializers.RESOURCE_LOCATION);
        return builder.create();
    });
    private static List<ArmorRigItem> clientRegisteredrigs = new ArrayList<ArmorRigItem>();
    private static NetworkRigManager instance;
    private Map<ResourceLocation, Rig> registeredRigs = new HashMap<ResourceLocation, Rig>();
    public HashSet<UUID> Ids = new HashSet();

    protected Map<ArmorRigItem, Rig> prepare(ResourceManager resourceManager, ProfilerFiller profiler) {
        HashMap map = Maps.newHashMap();
        ForgeRegistries.ITEMS.getValues().stream().filter(item -> item instanceof ArmorRigItem).forEach(item -> {
            ResourceLocation id = item.getRegistryName();
            if (id != null) {
                ResourceLocation resourceLocation = new ResourceLocation(String.format("%s:rigs/%s.json", id.m_135827_(), id.m_135815_()));
                try (Resource resource = resourceManager.m_142591_(resourceLocation);
                     InputStream is = resource.m_6679_();
                     BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
                    Rig rig = (Rig)GsonHelper.m_13776_((Gson)GSON_INSTANCE, (Reader)reader, Rig.class);
                    if (rig != null && Validator.isValidObject(rig)) {
                        map.put((ArmorRigItem)item, rig);
                    } else {
                        GunMod.LOGGER.error("Couldn't load data file {} as it is missing or malformed. Using default rig data", (Object)resourceLocation);
                        map.put((ArmorRigItem)item, new Rig());
                    }
                }
                catch (InvalidObjectException e) {
                    GunMod.LOGGER.error("Missing required properties for {}", (Object)resourceLocation);
                    e.printStackTrace();
                }
                catch (IOException e) {
                    GunMod.LOGGER.error("Couldn't parse data file {}", (Object)resourceLocation);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        });
        return map;
    }

    protected void apply(Map<ArmorRigItem, Rig> objects, ResourceManager resourceManager, ProfilerFiller profiler) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        objects.forEach((item, rig) -> {
            Validate.notNull((Object)item.getRegistryName());
            builder.put((Object)item.getRegistryName(), rig);
            item.setRig(new Supplier((Rig)rig));
        });
        this.registeredRigs = builder.build();
    }

    public void writeRegisteredRigs(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.registeredRigs.size());
        this.registeredRigs.forEach((id, rig) -> {
            buffer.m_130085_(id);
            buffer.m_130079_(rig.serializeNBT());
        });
    }

    public static ImmutableMap<ResourceLocation, Rig> readRegisteredRigs(FriendlyByteBuf buffer) {
        int size = buffer.m_130242_();
        if (size > 0) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (int i = 0; i < size; ++i) {
                ResourceLocation id = buffer.m_130281_();
                Rig rig = Rig.create(buffer.m_130260_());
                builder.put((Object)id, (Object)rig);
            }
            return builder.build();
        }
        return ImmutableMap.of();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean updateRegisteredRigs(MessageUpdateRigs msg) {
        return NetworkRigManager.updateRegisteredRigs(msg.getRegisteredRigs());
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean updateRegisteredRigs(Map<ResourceLocation, Rig> registeredrigs) {
        clientRegisteredrigs.clear();
        if (registeredrigs != null) {
            for (Map.Entry<ResourceLocation, Rig> entry : registeredrigs.entrySet()) {
                Item item = (Item)ForgeRegistries.ITEMS.getValue(entry.getKey());
                if (!(item instanceof ArmorRigItem)) {
                    return false;
                }
                ((ArmorRigItem)item).setRig(new Supplier(entry.getValue()));
                clientRegisteredrigs.add((ArmorRigItem)item);
            }
            return true;
        }
        return false;
    }

    public Map<ResourceLocation, Rig> getRegisteredRigs() {
        return this.registeredRigs;
    }

    public static List<ArmorRigItem> getClientRegisteredRigs() {
        return ImmutableList.copyOf(clientRegisteredrigs);
    }

    @SubscribeEvent
    public static void onServerStopped(ServerStoppedEvent event) {
        instance = null;
    }

    @SubscribeEvent
    public static void addReloadListenerEvent(AddReloadListenerEvent event) {
        NetworkRigManager networkRigManager = new NetworkRigManager();
        event.addListener((PreparableReloadListener)networkRigManager);
        instance = networkRigManager;
    }

    @Nullable
    public static NetworkRigManager get() {
        return instance;
    }

    public static class Supplier {
        private Rig rig;

        private Supplier(Rig rig) {
            this.rig = rig;
        }

        public Rig getRig() {
            return this.rig;
        }
    }

    public static class LoginData
    implements ILoginData {
        public void writeData(FriendlyByteBuf buffer) {
            Validate.notNull((Object)((Object)NetworkRigManager.get()));
            NetworkRigManager.get().writeRegisteredRigs(buffer);
        }

        public Optional<String> readData(FriendlyByteBuf buffer) {
            ImmutableMap<ResourceLocation, Rig> registeredGuns = NetworkRigManager.readRegisteredRigs(buffer);
            NetworkRigManager.updateRegisteredRigs(registeredGuns);
            return Optional.empty();
        }
    }

    public static interface IRigProvider {
        public ImmutableMap<ResourceLocation, Rig> getRegisteredRigs();

        public ImmutableMap<ResourceLocation, CustomRig> getCustomRigs();
    }
}

