/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.common;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mrcrayfish.framework.api.data.login.ILoginData;
import com.tac.guns.GunMod;
import com.tac.guns.annotation.Validator;
import com.tac.guns.common.CustomGun;
import com.tac.guns.common.GripType;
import com.tac.guns.common.Gun;
import com.tac.guns.common.JsonDeserializers;
import com.tac.guns.item.GunItem;
import com.tac.guns.network.message.MessageUpdateGuns;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InvalidObjectException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.Validate;

@Mod.EventBusSubscriber(modid="tac")
public class NetworkGunManager
extends SimplePreparableReloadListener<Map<GunItem, Gun>> {
    private static final Gson GSON_INSTANCE = (Gson)Util.m_137537_(() -> {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(ResourceLocation.class, JsonDeserializers.RESOURCE_LOCATION);
        builder.registerTypeAdapter(GripType.class, JsonDeserializers.GRIP_TYPE);
        return builder.create();
    });
    private static List<GunItem> clientRegisteredGuns = new ArrayList<GunItem>();
    private static NetworkGunManager instance;
    private Map<ResourceLocation, Gun> registeredGuns = new HashMap<ResourceLocation, Gun>();
    public HashSet<UUID> Ids = new HashSet();
    public Map<UUID, ItemStack> StackIds = new HashMap<UUID, ItemStack>();

    protected Map<GunItem, Gun> prepare(ResourceManager resourceManager, ProfilerFiller profiler) {
        HashMap map = Maps.newHashMap();
        GunMod.LOGGER.info("YO_DATA_GUN");
        ForgeRegistries.ITEMS.getValues().stream().filter(item -> item instanceof GunItem).forEach(item -> {
            ResourceLocation id = item.getRegistryName();
            if (id != null) {
                ResourceLocation resourceLocation = new ResourceLocation(String.format("%s:guns/%s.json", id.m_135827_(), id.m_135815_()));
                try (Resource resource = resourceManager.m_142591_(resourceLocation);
                     InputStream is = resource.m_6679_();
                     BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
                    Gun gun = (Gun)GsonHelper.m_13776_((Gson)GSON_INSTANCE, (Reader)reader, Gun.class);
                    if (gun != null && Validator.isValidObject(gun)) {
                        map.put((GunItem)item, gun);
                    } else {
                        GunMod.LOGGER.error("Couldn't load data file {} as it is missing or malformed. Using default gun data", (Object)resourceLocation);
                        map.put((GunItem)item, new Gun());
                    }
                }
                catch (InvalidObjectException e) {
                    GunMod.LOGGER.error("Missing required properties for {}", (Object)resourceLocation);
                    e.printStackTrace();
                }
                catch (IOException e) {
                    GunMod.LOGGER.error("Couldn't parse data file {}", (Object)resourceLocation);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        });
        return map;
    }

    protected void apply(Map<GunItem, Gun> objects, ResourceManager resourceManager, ProfilerFiller profiler) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        objects.forEach((item, gun) -> {
            Validate.notNull((Object)item.getRegistryName());
            builder.put((Object)item.getRegistryName(), gun);
            item.setGun(new Supplier((Gun)gun));
        });
        this.registeredGuns = builder.build();
    }

    public void writeRegisteredGuns(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.registeredGuns.size());
        this.registeredGuns.forEach((id, gun) -> {
            buffer.m_130085_(id);
            buffer.m_130079_(gun.serializeNBT());
        });
    }

    public static ImmutableMap<ResourceLocation, Gun> readRegisteredGuns(FriendlyByteBuf buffer) {
        int size = buffer.m_130242_();
        if (size > 0) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (int i = 0; i < size; ++i) {
                ResourceLocation id = buffer.m_130281_();
                Gun gun = Gun.create(buffer.m_130260_());
                builder.put((Object)id, (Object)gun);
            }
            return builder.build();
        }
        return ImmutableMap.of();
    }

    public static boolean updateRegisteredGuns(MessageUpdateGuns message) {
        return NetworkGunManager.updateRegisteredGuns(message.getRegisteredGuns());
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean updateRegisteredGuns(Map<ResourceLocation, Gun> registeredGuns) {
        clientRegisteredGuns.clear();
        if (registeredGuns != null) {
            for (Map.Entry<ResourceLocation, Gun> entry : registeredGuns.entrySet()) {
                Item item = (Item)ForgeRegistries.ITEMS.getValue(entry.getKey());
                if (!(item instanceof GunItem)) {
                    return false;
                }
                ((GunItem)item).setGun(new Supplier(entry.getValue()));
                clientRegisteredGuns.add((GunItem)item);
            }
            return true;
        }
        return false;
    }

    public Map<ResourceLocation, Gun> getRegisteredGuns() {
        return this.registeredGuns;
    }

    public static List<GunItem> getClientRegisteredGuns() {
        return ImmutableList.copyOf(clientRegisteredGuns);
    }

    @SubscribeEvent
    public static void onServerStopped(ServerStoppedEvent event) {
        instance = null;
    }

    @SubscribeEvent
    public static void addReloadListenerEvent(AddReloadListenerEvent event) {
        NetworkGunManager networkGunManager = new NetworkGunManager();
        event.addListener((PreparableReloadListener)networkGunManager);
        instance = networkGunManager;
    }

    @Nullable
    public static NetworkGunManager get() {
        return instance;
    }

    public static class Supplier {
        private Gun gun;

        private Supplier(Gun gun) {
            this.gun = gun;
        }

        public Gun getGun() {
            return this.gun;
        }
    }

    public static class LoginData
    implements ILoginData {
        public void writeData(FriendlyByteBuf buffer) {
            Validate.notNull((Object)((Object)NetworkGunManager.get()));
            NetworkGunManager.get().writeRegisteredGuns(buffer);
        }

        public Optional<String> readData(FriendlyByteBuf buffer) {
            ImmutableMap<ResourceLocation, Gun> registeredGuns = NetworkGunManager.readRegisteredGuns(buffer);
            NetworkGunManager.updateRegisteredGuns(registeredGuns);
            return Optional.empty();
        }
    }

    public static interface IGunProvider {
        public ImmutableMap<ResourceLocation, Gun> getRegisteredGuns();

        public ImmutableMap<ResourceLocation, CustomGun> getCustomGuns();
    }
}

