/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.common;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.tac.guns.Config;
import com.tac.guns.annotation.Ignored;
import com.tac.guns.annotation.Optional;
import com.tac.guns.client.handler.command.GunEditor;
import com.tac.guns.common.GripType;
import com.tac.guns.common.WeaponType;
import com.tac.guns.interfaces.TGExclude;
import com.tac.guns.inventory.gear.armor.ArmorRigCapabilityProvider;
import com.tac.guns.inventory.gear.armor.RigSlotsHandler;
import com.tac.guns.item.attachment.IAttachment;
import com.tac.guns.item.attachment.IScope;
import com.tac.guns.item.attachment.impl.Scope;
import com.tac.guns.item.transition.wearables.ArmorRigItem;
import com.tac.guns.util.WearableHelper;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.util.thread.SidedThreadGroups;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;

public final class Gun
implements INBTSerializable<CompoundTag> {
    private General general = new General();
    private Reloads reloads = new Reloads();
    private Projectile projectile = new Projectile();
    private Sounds sounds = new Sounds();
    private Display display = new Display();
    private Modules modules = new Modules();
    public static ExclusionStrategy strategy = new ExclusionStrategy(){

        public boolean shouldSkipClass(Class<?> clazz) {
            return false;
        }

        public boolean shouldSkipField(FieldAttributes field) {
            return field.getAnnotation(TGExclude.class) != null;
        }
    };

    public General getGeneral() {
        return this.general;
    }

    public Reloads getReloads() {
        return this.reloads;
    }

    public Projectile getProjectile() {
        return this.projectile;
    }

    public Sounds getSounds() {
        return this.sounds;
    }

    public Display getDisplay() {
        return this.display;
    }

    public Modules getModules() {
        return this.modules;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("General", (Tag)this.general.serializeNBT());
        tag.m_128365_("Reloads", (Tag)this.reloads.serializeNBT());
        tag.m_128365_("Projectile", (Tag)this.projectile.serializeNBT());
        tag.m_128365_("Sounds", (Tag)this.sounds.serializeNBT());
        tag.m_128365_("Display", (Tag)this.display.serializeNBT());
        tag.m_128365_("Modules", (Tag)this.modules.serializeNBT());
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        if (tag.m_128425_("General", 10)) {
            this.general.deserializeNBT(tag.m_128469_("General"));
        }
        if (tag.m_128425_("Reloads", 10)) {
            this.reloads.deserializeNBT(tag.m_128469_("Reloads"));
        }
        if (tag.m_128425_("Projectile", 10)) {
            this.projectile.deserializeNBT(tag.m_128469_("Projectile"));
        }
        if (tag.m_128425_("Sounds", 10)) {
            this.sounds.deserializeNBT(tag.m_128469_("Sounds"));
        }
        if (tag.m_128425_("Display", 10)) {
            this.display.deserializeNBT(tag.m_128469_("Display"));
        }
        if (tag.m_128425_("Modules", 10)) {
            this.modules.deserializeNBT(tag.m_128469_("Modules"));
        }
    }

    public static Gun create(CompoundTag tag) {
        Gun gun = new Gun();
        gun.deserializeNBT(tag);
        return gun;
    }

    public Gun copy() {
        Gun gun = new Gun();
        gun.general = this.general.copy();
        gun.reloads = this.reloads.copy();
        gun.projectile = this.projectile.copy();
        gun.sounds = this.sounds.copy();
        gun.display = this.display.copy();
        gun.modules = this.modules.copy();
        return gun;
    }

    public boolean canAttachType(@Nullable IAttachment.Type type) {
        if (this.modules.attachments != null && type != null) {
            switch (type) {
                case SCOPE: {
                    return this.modules.attachments.scope != null;
                }
                case BARREL: {
                    return this.modules.attachments.barrel != null;
                }
                case STOCK: {
                    return this.modules.attachments.stock != null;
                }
                case UNDER_BARREL: {
                    return this.modules.attachments.underBarrel != null;
                }
                case GUN_SKIN: {
                    return this.modules.attachments.gunSkin != null;
                }
                case SIDE_RAIL: {
                    return this.modules.attachments.sideRail != null;
                }
                case IR_DEVICE: {
                    return this.modules.attachments.irDevice != null;
                }
                case EXTENDED_MAG: {
                    return this.modules.attachments.extendedMag != null;
                }
                case OLD_SCOPE: {
                    return this.modules.attachments.oldScope != null;
                }
                case PISTOL_SCOPE: {
                    return this.modules.attachments.pistolScope != null;
                }
                case PISTOL_BARREL: {
                    return this.modules.attachments.pistolBarrel != null;
                }
            }
        }
        return false;
    }

    @Nullable
    public ScaledPositioned getAttachmentPosition(IAttachment.Type type) {
        if (this.modules.attachments != null) {
            switch (type) {
                case SCOPE: {
                    return this.modules.attachments.scope;
                }
                case BARREL: {
                    return this.modules.attachments.barrel;
                }
                case STOCK: {
                    return this.modules.attachments.stock;
                }
                case UNDER_BARREL: {
                    return this.modules.attachments.underBarrel;
                }
                case GUN_SKIN: {
                    return this.modules.attachments.gunSkin;
                }
                case SIDE_RAIL: {
                    return this.modules.attachments.sideRail;
                }
                case IR_DEVICE: {
                    return this.modules.attachments.irDevice;
                }
                case EXTENDED_MAG: {
                    return this.modules.attachments.extendedMag;
                }
                case OLD_SCOPE: {
                    return this.modules.attachments.oldScope;
                }
                case PISTOL_SCOPE: {
                    return this.modules.attachments.pistolScope;
                }
                case PISTOL_BARREL: {
                    return this.modules.attachments.pistolBarrel;
                }
            }
        }
        return null;
    }

    public boolean canAimDownSight() {
        return this.canAttachType(IAttachment.Type.SCOPE) || this.canAttachType(IAttachment.Type.OLD_SCOPE) || this.canAttachType(IAttachment.Type.PISTOL_SCOPE) || this.modules.zoom != null;
    }

    public static boolean hasAttachmentEquipped(ItemStack stack, Gun gun, IAttachment.Type type) {
        if (!gun.canAttachType(type)) {
            return false;
        }
        CompoundTag compound = stack.m_41783_();
        if (compound != null && compound.m_128425_("Attachments", 10)) {
            CompoundTag attachment = compound.m_128469_("Attachments");
            return attachment.m_128425_(type.getTagKey(), 10);
        }
        return false;
    }

    @Nullable
    public static Scope getScope(ItemStack gun) {
        CompoundTag compound = gun.m_41783_();
        Scope scope = null;
        if (compound != null && compound.m_128425_("Attachments", 10)) {
            ItemStack OldScopeStack;
            CompoundTag attachment = compound.m_128469_("Attachments");
            if (attachment.m_128425_("Scope", 10)) {
                ItemStack scopeStack = ItemStack.m_41712_((CompoundTag)attachment.m_128469_("Scope"));
                if (scopeStack.m_41720_() instanceof IScope) {
                    scope = (Scope)((IScope)scopeStack.m_41720_()).getProperties();
                }
            } else if (attachment.m_128425_("OldScope", 10)) {
                ItemStack OldScopeStack2 = ItemStack.m_41712_((CompoundTag)attachment.m_128469_("OldScope"));
                if (OldScopeStack2.m_41720_() instanceof IScope) {
                    scope = (Scope)((IScope)OldScopeStack2.m_41720_()).getProperties();
                }
            } else if (attachment.m_128425_("PistolScope", 10) && (OldScopeStack = ItemStack.m_41712_((CompoundTag)attachment.m_128469_("PistolScope"))).m_41720_() instanceof IScope) {
                scope = (Scope)((IScope)OldScopeStack.m_41720_()).getProperties();
            }
        }
        return scope;
    }

    public static ItemStack getAttachment(IAttachment.Type type, ItemStack gun) {
        CompoundTag compound = gun.m_41783_();
        if (compound != null && compound.m_128425_("Attachments", 10)) {
            CompoundTag attachment = compound.m_128469_("Attachments");
            if (attachment.m_128425_(type.getTagKey(), 10)) {
                return ItemStack.m_41712_((CompoundTag)attachment.m_128469_(type.getTagKey()));
            }
            if (type == IAttachment.Type.SCOPE && (attachment.m_128425_(IAttachment.Type.PISTOL_SCOPE.getTagKey(), 10) || attachment.m_128425_(IAttachment.Type.OLD_SCOPE.getTagKey(), 10))) {
                return !attachment.m_128469_(IAttachment.Type.PISTOL_SCOPE.getTagKey()).m_128456_() ? ItemStack.m_41712_((CompoundTag)attachment.m_128469_(IAttachment.Type.PISTOL_SCOPE.getTagKey())) : ItemStack.m_41712_((CompoundTag)attachment.m_128469_(IAttachment.Type.OLD_SCOPE.getTagKey()));
            }
            if (type == IAttachment.Type.SIDE_RAIL && attachment.m_128425_(IAttachment.Type.IR_DEVICE.getTagKey(), 10)) {
                return ItemStack.m_41712_((CompoundTag)attachment.m_128469_(IAttachment.Type.IR_DEVICE.getTagKey()));
            }
        }
        return ItemStack.f_41583_;
    }

    public static float getAdditionalDamage(ItemStack gunStack) {
        CompoundTag tag = gunStack.m_41784_();
        return tag.m_128457_("AdditionalDamage");
    }

    public static ItemStack[] findAmmo(Player player, ResourceLocation id) {
        if (!player.m_6084_()) {
            return new ItemStack[0];
        }
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        if (player.m_7500_()) {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(id);
            stacks.add(item != null ? new ItemStack((ItemLike)item, Integer.MAX_VALUE) : ItemStack.f_41583_);
            return stacks.toArray(new ItemStack[0]);
        }
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack stack = player.m_150109_().m_8020_(i);
            if (!Gun.isAmmo(stack, id)) continue;
            stacks.add(stack);
        }
        ItemStack wornRig = WearableHelper.PlayerWornRig(player);
        if (!wornRig.m_41619_()) {
            RigSlotsHandler itemHandler = (RigSlotsHandler)wornRig.getCapability(ArmorRigCapabilityProvider.capability).resolve().get();
            NonNullList<ItemStack> list = itemHandler.getStacks();
            for (ItemStack ammoStack : list) {
                if (!Gun.isAmmo(ammoStack, id)) continue;
                stacks.add(ammoStack);
            }
        }
        return stacks.toArray(new ItemStack[0]);
    }

    public static ItemStack[] findAmmoRigOnly(ItemStack rig, ResourceLocation id) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        if (rig != null) {
            ListTag nbtTagList = (ListTag)((ArmorRigItem)rig.m_41720_()).getShareTag(rig).m_128469_("storage").m_128423_("Items");
            for (int i = 0; i < ((ArmorRigItem)rig.m_41720_()).getShareTag(rig).m_128469_("storage").m_128451_("Size"); ++i) {
                stacks.add(ItemStack.m_41712_((CompoundTag)nbtTagList.m_128728_(i)));
            }
        }
        return stacks.toArray(new ItemStack[0]);
    }

    public static int ammoCountInRig(ItemStack rig, ResourceLocation id) {
        ItemStack[] stacks;
        int counter = 0;
        for (ItemStack x : stacks = Gun.findAmmoRigOnly(rig, id)) {
            if (x == null || x == ItemStack.f_41583_ || x.m_41613_() == 0 || !Gun.isAmmo(x, id)) continue;
            counter += x.m_41613_();
        }
        return counter;
    }

    public static int ammoCountInRig(CompoundTag rigData, ResourceLocation id) {
        int counter = 0;
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        ListTag nbtTagList = (ListTag)rigData.m_128469_("storage").m_128423_("Items");
        for (int i = 0; i < rigData.m_128469_("storage").m_128451_("Size"); ++i) {
            stacks.add(ItemStack.m_41712_((CompoundTag)nbtTagList.m_128728_(i)));
        }
        for (ItemStack x : stacks) {
            if (x == null || x == ItemStack.f_41583_ || x.m_41613_() == 0 || !Gun.isAmmo(x, id)) continue;
            counter += x.m_41613_();
        }
        return counter;
    }

    public static boolean isAmmo(ItemStack stack, ResourceLocation id) {
        return stack != null && stack.m_41720_().getRegistryName().equals((Object)id);
    }

    public static boolean hasAmmo(ItemStack gunStack) {
        CompoundTag tag = gunStack.m_41784_();
        return tag.m_128471_("IgnoreAmmo") || tag.m_128451_("AmmoCount") > 0;
    }

    public static class General
    implements INBTSerializable<CompoundTag> {
        @Optional
        private boolean auto = false;
        @Optional
        private boolean boltAction = false;
        @Optional
        private int rate;
        @Optional
        private int burstRate = 8;
        @Optional
        private int burstCount = 3;
        @Optional
        private int[] rateSelector = new int[]{0, 1};
        @Optional
        private float recoilAngle = 1.0f;
        @Optional
        private float recoilKick;
        @Optional
        private float horizontalRecoilAngle = 2.0f;
        @Optional
        private float cameraRecoilModifier = 1.75f;
        @Optional
        private float recoilDuration = 0.25f;
        @Optional
        private float weaponRecoilOffset = 0.5f;
        @Optional
        private float cameraRecoilDuration = 1.0f;
        @Optional
        private float visualRecoilPercent = 0.0f;
        @Optional
        private float recoilAdsReduction = 0.2f;
        @Optional
        private int projectileAmount = 1;
        @Optional
        private int projToMinAccuracy = 5;
        @Optional
        private int msToAccuracyReset = 425;
        @Optional
        private boolean alwaysSpread = false;
        @Optional
        private float spread = 1.0f;
        @Optional
        private float firstShotSpread = 0.0f;
        @Optional
        private float weightKilo = 0.0f;
        @Ignored
        @TGExclude
        private GripType gripType = GripType.ONE_HANDED;
        @Optional
        private float movementInaccuracy = 1.0f;
        @Optional
        private float hipFireInaccuracy = 3.25f;
        @Optional
        private float levelReq = 300.0f;
        @Optional
        private int upgradeBenchMaxUses = 3;

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128379_("Auto", this.auto);
            tag.m_128379_("BoltAction", this.boltAction);
            tag.m_128405_("Rate", this.rate);
            tag.m_128405_("BurstRate", this.burstRate);
            tag.m_128405_("BurstCount", this.burstCount);
            tag.m_128385_("RateSelector", this.rateSelector);
            tag.m_128359_("GripType", this.gripType.getId().toString());
            tag.m_128350_("RecoilAngle", this.recoilAngle);
            tag.m_128350_("RecoilKick", this.recoilKick);
            tag.m_128350_("HorizontalRecoilAngle", this.horizontalRecoilAngle);
            tag.m_128350_("CameraRecoilModifier", this.cameraRecoilModifier);
            tag.m_128350_("RecoilDurationOffset", this.recoilDuration);
            tag.m_128350_("weaponRecoilOffset", this.weaponRecoilOffset);
            tag.m_128350_("CameraRecoilDuration", this.cameraRecoilDuration);
            tag.m_128350_("VisualRecoilDuration", this.visualRecoilPercent);
            tag.m_128350_("RecoilAdsReduction", this.recoilAdsReduction);
            tag.m_128405_("ProjectileAmount", this.projectileAmount);
            tag.m_128405_("ProjToMinAccuracy", this.projToMinAccuracy);
            tag.m_128405_("MsToAccuracyRest", this.msToAccuracyReset);
            tag.m_128379_("AlwaysSpread", this.alwaysSpread);
            tag.m_128350_("Spread", this.spread);
            tag.m_128350_("FirstShotSpread", this.firstShotSpread);
            tag.m_128350_("WeightKilo", this.weightKilo);
            tag.m_128350_("LevelReq", this.levelReq);
            tag.m_128405_("UpgradeBenchMaxUses", this.upgradeBenchMaxUses);
            tag.m_128350_("MovementInaccuracy", this.movementInaccuracy);
            tag.m_128350_("HipFireInaccuracy", this.hipFireInaccuracy);
            return tag;
        }

        public void deserializeNBT(CompoundTag tag) {
            if (tag.m_128425_("Auto", 99)) {
                this.auto = tag.m_128471_("Auto");
            }
            if (tag.m_128425_("BoltAction", 99)) {
                this.boltAction = tag.m_128471_("BoltAction");
            }
            if (tag.m_128425_("Rate", 99)) {
                this.rate = tag.m_128451_("Rate");
            }
            if (tag.m_128425_("BurstRate", 99)) {
                this.burstRate = tag.m_128451_("BurstRate");
            }
            if (tag.m_128425_("BurstCount", 99)) {
                this.burstCount = tag.m_128451_("BurstCount");
            }
            if (tag.m_128425_("RateSelector", 11)) {
                this.rateSelector = tag.m_128465_("RateSelector");
            }
            if (tag.m_128425_("GripType", 8)) {
                this.gripType = GripType.getType(ResourceLocation.m_135820_((String)tag.m_128461_("GripType")));
            }
            if (tag.m_128425_("RecoilAngle", 99)) {
                this.recoilAngle = tag.m_128457_("RecoilAngle");
            }
            if (tag.m_128425_("RecoilKick", 99)) {
                this.recoilKick = tag.m_128457_("RecoilKick");
            }
            if (tag.m_128425_("HorizontalRecoilAngle", 99)) {
                this.horizontalRecoilAngle = tag.m_128457_("HorizontalRecoilAngle");
            }
            if (tag.m_128425_("CameraRecoilModifier", 99)) {
                this.cameraRecoilModifier = tag.m_128457_("CameraRecoilModifier");
            }
            if (tag.m_128425_("RecoilDurationOffset", 99)) {
                this.recoilDuration = tag.m_128457_("RecoilDurationOffset");
            }
            if (tag.m_128425_("weaponRecoilOffset", 99)) {
                this.weaponRecoilOffset = tag.m_128457_("weaponRecoilOffset");
            }
            if (tag.m_128425_("CameraRecoilDuration", 99)) {
                this.cameraRecoilDuration = tag.m_128457_("CameraRecoilDuration");
            }
            if (tag.m_128425_("VisualRecoilDuration", 99)) {
                this.visualRecoilPercent = tag.m_128457_("VisualRecoilDuration");
            }
            if (tag.m_128425_("RecoilAdsReduction", 99)) {
                this.recoilAdsReduction = tag.m_128457_("RecoilAdsReduction");
            }
            if (tag.m_128425_("ProjectileAmount", 99)) {
                this.projectileAmount = tag.m_128451_("ProjectileAmount");
            }
            if (tag.m_128425_("ProjToMinAccuracy", 99)) {
                this.projToMinAccuracy = tag.m_128451_("ProjToMinAccuracy");
            }
            if (tag.m_128425_("MsToAccuracyRest", 99)) {
                this.msToAccuracyReset = tag.m_128451_("MsToAccuracyRest");
            }
            if (tag.m_128425_("UpgradeBenchMaxUses", 99)) {
                this.upgradeBenchMaxUses = tag.m_128451_("UpgradeBenchMaxUses");
            }
            if (tag.m_128425_("AlwaysSpread", 99)) {
                this.alwaysSpread = tag.m_128471_("AlwaysSpread");
            }
            if (tag.m_128425_("Spread", 99)) {
                this.spread = tag.m_128457_("Spread");
            }
            if (tag.m_128425_("FirstShotSpread", 99)) {
                this.firstShotSpread = tag.m_128457_("FirstShotSpread");
            }
            if (tag.m_128425_("WeightKilo", 99)) {
                this.weightKilo = tag.m_128457_("WeightKilo");
            }
            if (tag.m_128425_("LevelReq", 99)) {
                this.levelReq = tag.m_128457_("LevelReq");
            }
            if (tag.m_128425_("MovementInaccuracy", 99)) {
                this.movementInaccuracy = tag.m_128457_("MovementInaccuracy");
            }
            if (tag.m_128425_("HipFireInaccuracy", 99)) {
                this.hipFireInaccuracy = tag.m_128457_("HipFireInaccuracy");
            }
        }

        public General copy() {
            General general = new General();
            general.auto = this.auto;
            general.boltAction = this.boltAction;
            general.rate = this.rate;
            general.burstRate = this.burstRate;
            general.burstCount = this.burstCount;
            general.rateSelector = this.rateSelector;
            general.gripType = this.gripType;
            general.recoilAngle = this.recoilAngle;
            general.recoilKick = this.recoilKick;
            general.horizontalRecoilAngle = this.horizontalRecoilAngle;
            general.cameraRecoilModifier = this.cameraRecoilModifier;
            general.recoilDuration = this.recoilDuration;
            general.weaponRecoilOffset = this.weaponRecoilOffset;
            general.cameraRecoilDuration = this.cameraRecoilDuration;
            general.visualRecoilPercent = this.visualRecoilPercent;
            general.recoilAdsReduction = this.recoilAdsReduction;
            general.projectileAmount = this.projectileAmount;
            general.projToMinAccuracy = this.projToMinAccuracy;
            general.msToAccuracyReset = this.msToAccuracyReset;
            general.alwaysSpread = this.alwaysSpread;
            general.spread = this.spread;
            general.firstShotSpread = this.firstShotSpread;
            general.weightKilo = this.weightKilo;
            general.levelReq = this.levelReq;
            general.upgradeBenchMaxUses = this.upgradeBenchMaxUses;
            general.movementInaccuracy = this.movementInaccuracy;
            general.hipFireInaccuracy = this.hipFireInaccuracy;
            return general;
        }

        public boolean isAuto() {
            return this.auto;
        }

        public boolean isBoltAction() {
            return this.boltAction;
        }

        public int getRate() {
            return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.COMMON.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.general ? (int)((double)this.rate + GunEditor.get().getRateMod()) : this.rate;
        }

        public int getUpgradeBenchMaxUses() {
            return this.upgradeBenchMaxUses;
        }

        public int getBurstRate() {
            return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.COMMON.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.general ? (int)((double)this.burstRate + GunEditor.get().getBurstRateMod()) : this.burstRate;
        }

        public int getBurstCount() {
            return this.burstCount;
        }

        public int[] getRateSelector() {
            return this.rateSelector;
        }

        public GripType getGripType() {
            return this.gripType;
        }

        public float getRecoilAngle() {
            return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.COMMON.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.general ? this.recoilAngle + GunEditor.get().getRecoilAngleMod() : this.recoilAngle / 1.5f;
        }

        public float getRecoilKick() {
            return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.COMMON.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.general ? this.recoilKick + GunEditor.get().getRecoilKickMod() : this.recoilKick / 1.5f;
        }

        public float getHorizontalRecoilAngle() {
            return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.COMMON.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.general ? this.horizontalRecoilAngle + GunEditor.get().getHorizontalRecoilAngleMod() : this.horizontalRecoilAngle / 1.5f;
        }

        public float getCameraRecoilModifier() {
            return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.COMMON.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.general ? this.cameraRecoilModifier + GunEditor.get().getCameraRecoilModifierMod() : this.cameraRecoilModifier;
        }

        public float getRecoilDuration() {
            return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.COMMON.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.general ? this.recoilDuration + GunEditor.get().getRecoilDurationMod() : this.recoilDuration;
        }

        public float getWeaponRecoilOffset() {
            return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.COMMON.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.general ? this.weaponRecoilOffset + GunEditor.get().getWeaponRecoilDurationMod() : this.weaponRecoilOffset;
        }

        public float getCameraRecoilDuration() {
            return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.COMMON.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.general ? this.cameraRecoilDuration + GunEditor.get().getWeaponRecoilDurationMod() : this.cameraRecoilDuration;
        }

        public float getVisualRecoilPercent() {
            return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.COMMON.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.general ? this.visualRecoilPercent : this.visualRecoilPercent;
        }

        public float getRecoilAdsReduction() {
            return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.COMMON.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.general ? (this.recoilAdsReduction + GunEditor.get().getRecoilAdsReductionMod()) * 2.0f : this.recoilAdsReduction * 2.0f;
        }

        public int getProjectileAmount() {
            return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.COMMON.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.general ? (int)((double)this.projectileAmount + GunEditor.get().getProjectileAmountMod()) : this.projectileAmount;
        }

        public boolean isAlwaysSpread() {
            return this.alwaysSpread;
        }

        public float getSpread() {
            return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.COMMON.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.general ? this.spread * 0.5f + GunEditor.get().getSpreadMod() : this.spread * 0.5f;
        }

        public float getWeightKilo() {
            return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.COMMON.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.general ? this.weightKilo + GunEditor.get().getWeightKiloMod() : this.weightKilo;
        }

        public float getLevelReq() {
            return this.levelReq;
        }

        public float getMovementInaccuracy() {
            return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.COMMON.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.general ? this.movementInaccuracy : this.movementInaccuracy;
        }

        public float getHipFireInaccuracy() {
            return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.COMMON.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.general ? this.hipFireInaccuracy * 1.75f : this.hipFireInaccuracy * 1.75f;
        }

        public int getProjCountAccuracy() {
            return this.projToMinAccuracy;
        }

        public float getFirstShotSpread() {
            return this.firstShotSpread;
        }

        public int getMsToAccuracyReset() {
            return this.msToAccuracyReset;
        }
    }

    public static class Reloads
    implements INBTSerializable<CompoundTag> {
        private int maxAmmo = 20;
        @Optional
        private boolean magFed = false;
        @Optional
        private int reloadMagTimer = 20;
        @Optional
        private int additionalReloadEmptyMagTimer = 0;
        @Optional
        private int reloadAmount = 1;
        @Optional
        private int[] maxAdditionalAmmoPerOC = new int[0];
        @Optional
        private int preReloadPauseTicks = 0;
        @Optional
        private int interReloadPauseTicks = 1;
        @Optional
        private boolean openBolt = false;

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128405_("MaxAmmo", this.maxAmmo);
            tag.m_128379_("MagFed", this.magFed);
            tag.m_128405_("ReloadSpeed", this.reloadAmount);
            tag.m_128405_("ReloadMagTimer", this.reloadMagTimer);
            tag.m_128405_("AdditionalReloadEmptyMagTimer", this.additionalReloadEmptyMagTimer);
            tag.m_128385_("MaxAmmunitionPerOverCap", this.maxAdditionalAmmoPerOC);
            tag.m_128405_("ReloadPauseTicks", this.preReloadPauseTicks);
            tag.m_128405_("InterReloadPauseTicks", this.interReloadPauseTicks);
            tag.m_128379_("OpenBolt", this.openBolt);
            return tag;
        }

        public void deserializeNBT(CompoundTag tag) {
            if (tag.m_128425_("MaxAmmo", 99)) {
                this.maxAmmo = tag.m_128451_("MaxAmmo");
            }
            if (tag.m_128425_("MagFed", 99)) {
                this.magFed = tag.m_128471_("MagFed");
            }
            if (tag.m_128425_("ReloadSpeed", 99)) {
                this.reloadAmount = tag.m_128451_("ReloadSpeed");
            }
            if (tag.m_128425_("ReloadMagTimer", 99)) {
                this.reloadMagTimer = tag.m_128451_("ReloadMagTimer");
            }
            if (tag.m_128425_("AdditionalReloadEmptyMagTimer", 99)) {
                this.additionalReloadEmptyMagTimer = tag.m_128451_("AdditionalReloadEmptyMagTimer");
            }
            if (tag.m_128425_("MaxAmmunitionPerOverCap", 11)) {
                this.maxAdditionalAmmoPerOC = tag.m_128465_("MaxAmmunitionPerOverCap");
            }
            if (tag.m_128425_("ReloadPauseTicks", 99)) {
                this.preReloadPauseTicks = tag.m_128451_("ReloadPauseTicks");
            }
            if (tag.m_128425_("InterReloadPauseTicks", 99)) {
                this.interReloadPauseTicks = tag.m_128451_("InterReloadPauseTicks");
            }
            if (tag.m_128425_("OpenBolt", 99)) {
                this.openBolt = tag.m_128471_("OpenBolt");
            }
        }

        public Reloads copy() {
            Reloads reloads = new Reloads();
            reloads.magFed = this.magFed;
            reloads.maxAmmo = this.maxAmmo;
            reloads.reloadAmount = this.reloadAmount;
            reloads.reloadMagTimer = this.reloadMagTimer;
            reloads.additionalReloadEmptyMagTimer = this.additionalReloadEmptyMagTimer;
            reloads.maxAdditionalAmmoPerOC = this.maxAdditionalAmmoPerOC;
            reloads.preReloadPauseTicks = this.preReloadPauseTicks;
            reloads.interReloadPauseTicks = this.interReloadPauseTicks;
            reloads.openBolt = this.openBolt;
            return reloads;
        }

        public boolean isMagFed() {
            return this.magFed;
        }

        public int getMaxAmmo() {
            return this.maxAmmo;
        }

        public int getReloadAmount() {
            return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.COMMON.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.reloads ? (int)((double)this.reloadAmount + GunEditor.get().getReloadAmountMod()) : this.reloadAmount;
        }

        public int getReloadMagTimer() {
            return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.COMMON.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.reloads ? (int)((double)this.reloadMagTimer + GunEditor.get().getReloadMagTimerMod()) : this.reloadMagTimer;
        }

        public int getAdditionalReloadEmptyMagTimer() {
            return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.COMMON.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.reloads ? (int)((double)this.additionalReloadEmptyMagTimer + GunEditor.get().getAdditionalReloadEmptyMagTimerMod()) : this.additionalReloadEmptyMagTimer;
        }

        public int[] getMaxAdditionalAmmoPerOC() {
            return this.maxAdditionalAmmoPerOC;
        }

        public int getPreReloadPauseTicks() {
            return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.COMMON.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.reloads ? (int)((double)this.preReloadPauseTicks + GunEditor.get().getPreReloadPauseTicksMod()) : this.preReloadPauseTicks;
        }

        public int getinterReloadPauseTicks() {
            return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.COMMON.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.reloads ? (int)((double)this.interReloadPauseTicks + GunEditor.get().getInterReloadPauseTicksMod()) : this.interReloadPauseTicks;
        }

        public boolean isOpenBolt() {
            return this.openBolt;
        }
    }

    public static class Projectile
    implements INBTSerializable<CompoundTag> {
        @Optional
        private boolean visible = true;
        @Optional
        private float damage;
        @Optional
        private float armorIgnore = 1.0f;
        @Optional
        private float critical = 0.0f;
        @Optional
        private float criticalDamage = 1.0f;
        @Optional
        private float headDamage = 1.0f;
        @Optional
        private float closeDamage = 1.0f;
        @Optional
        private float decayStart = 0.0f;
        @Optional
        private float minDecayMultiplier = 0.1f;
        @Optional
        private float decayEnd = 1.0f;
        @Ignored
        private float size = 0.1f;
        @Optional
        private double speed;
        @Optional
        public int life;
        @Optional
        private boolean gravity = true;
        @Optional
        private boolean damageReduceOverLife = true;
        @Optional
        public int trailColor = 16765577;
        @Optional
        public double trailLengthMultiplier = 4.35;
        @Optional
        private float trailRotationMultiplier = 0.0175f;
        @Optional
        private boolean ricochet = true;
        @TGExclude
        private ResourceLocation item = new ResourceLocation("tac", "basic_ammo");
        @Optional
        private int bulletClass = 1;
        @Optional
        private float bluntDamagePercentage = 0.5f;

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("Item", this.item.toString());
            tag.m_128379_("Visible", this.visible);
            tag.m_128350_("Damage", this.damage);
            tag.m_128350_("ArmorIgnore", this.armorIgnore);
            tag.m_128350_("Critical", this.critical);
            tag.m_128350_("CriticalDamage", this.criticalDamage);
            tag.m_128350_("HeadDamage", this.headDamage);
            tag.m_128350_("CloseDamage", this.closeDamage);
            tag.m_128350_("DecayStart", this.decayStart);
            tag.m_128350_("MinDecayMultiplier", this.minDecayMultiplier);
            tag.m_128350_("DecayEnd", this.decayEnd);
            tag.m_128350_("Size", this.size);
            tag.m_128347_("Speed", this.speed);
            tag.m_128405_("Life", this.life);
            tag.m_128379_("Gravity", this.gravity);
            tag.m_128379_("DamageReduceOverLife", this.damageReduceOverLife);
            tag.m_128405_("TrailColor", this.trailColor);
            tag.m_128347_("TrailLengthMultiplier", this.trailLengthMultiplier);
            tag.m_128350_("TrailRotationMultiplier", this.trailRotationMultiplier);
            tag.m_128379_("Ricochet", this.ricochet);
            tag.m_128405_("BulletClass", this.bulletClass);
            tag.m_128350_("BluntDamagePercentage", this.bluntDamagePercentage);
            return tag;
        }

        public void deserializeNBT(CompoundTag tag) {
            if (tag.m_128425_("Item", 8)) {
                this.item = new ResourceLocation(tag.m_128461_("Item"));
            }
            if (tag.m_128425_("Visible", 99)) {
                this.visible = tag.m_128471_("Visible");
            }
            if (tag.m_128425_("Damage", 99)) {
                this.damage = tag.m_128457_("Damage");
            }
            if (tag.m_128425_("ArmorIgnore", 99)) {
                this.armorIgnore = tag.m_128457_("ArmorIgnore");
            }
            if (tag.m_128425_("Critical", 99)) {
                this.critical = tag.m_128457_("Critical");
            }
            if (tag.m_128425_("CriticalDamage", 99)) {
                this.criticalDamage = tag.m_128457_("CriticalDamage");
            }
            if (tag.m_128425_("HeadDamage", 99)) {
                this.headDamage = tag.m_128457_("HeadDamage");
            }
            if (tag.m_128425_("CloseDamage", 99)) {
                this.closeDamage = tag.m_128457_("CloseDamage");
            }
            if (tag.m_128425_("DecayStart", 99)) {
                this.decayStart = tag.m_128457_("DecayStart");
            }
            if (tag.m_128425_("MinDecayMultiplier", 99)) {
                this.minDecayMultiplier = tag.m_128457_("MinDecayMultiplier");
            }
            if (tag.m_128425_("DecayEnd", 99)) {
                this.decayEnd = tag.m_128457_("DecayEnd");
            }
            if (tag.m_128425_("Size", 99)) {
                this.size = tag.m_128457_("Size");
            }
            if (tag.m_128425_("Speed", 99)) {
                this.speed = tag.m_128459_("Speed");
            }
            if (tag.m_128425_("Life", 99)) {
                this.life = tag.m_128451_("Life");
            }
            if (tag.m_128425_("Gravity", 99)) {
                this.gravity = tag.m_128471_("Gravity");
            }
            if (tag.m_128425_("DamageReduceOverLife", 99)) {
                this.damageReduceOverLife = tag.m_128471_("DamageReduceOverLife");
            }
            if (tag.m_128425_("TrailColor", 99)) {
                this.trailColor = tag.m_128451_("TrailColor");
            }
            if (tag.m_128425_("TrailLengthMultiplier", 99)) {
                this.trailLengthMultiplier = tag.m_128459_("TrailLengthMultiplier");
            }
            if (tag.m_128425_("TrailRotationMultiplier", 99)) {
                this.trailRotationMultiplier = tag.m_128457_("TrailRotationMultiplier");
            }
            if (tag.m_128425_("Ricochet", 99)) {
                this.ricochet = tag.m_128471_("Ricochet");
            }
            if (tag.m_128425_("BulletClass", 99)) {
                this.bulletClass = tag.m_128451_("BulletClass");
            }
            if (tag.m_128425_("BluntDamagePercentage", 99)) {
                this.bluntDamagePercentage = tag.m_128457_("bluntDamagePercentage");
            }
        }

        public Projectile copy() {
            Projectile projectile = new Projectile();
            projectile.item = this.item;
            projectile.visible = this.visible;
            projectile.damage = this.damage;
            projectile.armorIgnore = this.armorIgnore;
            projectile.critical = this.critical;
            projectile.criticalDamage = this.criticalDamage;
            projectile.headDamage = this.headDamage;
            projectile.closeDamage = this.closeDamage;
            projectile.decayStart = this.decayStart;
            projectile.minDecayMultiplier = this.minDecayMultiplier;
            projectile.decayEnd = this.decayEnd;
            projectile.size = this.size;
            projectile.speed = this.speed;
            projectile.life = this.life;
            projectile.gravity = this.gravity;
            projectile.damageReduceOverLife = this.damageReduceOverLife;
            projectile.trailColor = this.trailColor;
            projectile.trailLengthMultiplier = this.trailLengthMultiplier;
            projectile.trailRotationMultiplier = this.trailRotationMultiplier;
            projectile.ricochet = this.ricochet;
            projectile.bulletClass = this.bulletClass;
            projectile.bluntDamagePercentage = this.bluntDamagePercentage;
            return projectile;
        }

        public ResourceLocation getItem() {
            return this.item;
        }

        public boolean isVisible() {
            return this.visible;
        }

        public float getDamage() {
            return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.COMMON.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.projectile ? this.damage + GunEditor.get().getDamageMod() : this.damage;
        }

        public float getGunArmorIgnore() {
            return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.COMMON.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.projectile ? this.armorIgnore + GunEditor.get().getArmorIgnoreMod() : this.armorIgnore;
        }

        public float getGunCritical() {
            return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.COMMON.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.projectile ? this.critical + GunEditor.get().getCriticalMod() : this.critical;
        }

        public float getGunCriticalDamage() {
            return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.COMMON.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.projectile ? this.criticalDamage + GunEditor.get().getCriticalDamageMod() : this.criticalDamage;
        }

        public float getGunHeadDamage() {
            return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.COMMON.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.projectile ? this.headDamage + GunEditor.get().getHeadDamageMod() : this.headDamage;
        }

        public float getGunCloseDamage() {
            return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.COMMON.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.projectile ? this.closeDamage + GunEditor.get().getCloseDamageMod() : this.closeDamage;
        }

        public float getGunDecayStart() {
            return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.COMMON.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.projectile ? this.decayStart + GunEditor.get().getDecayStartMod() : this.decayStart;
        }

        public float getGunMinDecayMultiplier() {
            return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.COMMON.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.projectile ? this.minDecayMultiplier + GunEditor.get().getMinDecayMultiplierMod() : this.minDecayMultiplier;
        }

        public float getGunDecayEnd() {
            return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.COMMON.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.projectile ? this.decayEnd + GunEditor.get().getDecayEndMod() : this.decayEnd;
        }

        public float getSize() {
            return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.COMMON.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.projectile ? this.size + GunEditor.get().getDamageMod() : this.size;
        }

        public double getSpeed() {
            return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.COMMON.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.projectile ? this.speed + GunEditor.get().getSpeedMod() : this.speed;
        }

        public int getLife() {
            return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.COMMON.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.projectile ? (int)((double)this.life + GunEditor.get().getLifeMod()) : this.life;
        }

        public boolean isGravity() {
            return this.gravity;
        }

        public boolean isDamageReduceOverLife() {
            return this.damageReduceOverLife;
        }

        public int getTrailColor() {
            return this.trailColor;
        }

        public double getTrailLengthMultiplier() {
            return this.trailLengthMultiplier;
        }

        public float getTrailRotationMultiplier() {
            return this.trailRotationMultiplier;
        }

        public boolean isRicochet() {
            return this.ricochet;
        }

        public int getBulletClass() {
            return this.bulletClass;
        }

        public float getBluntDamagePercentage() {
            return this.bluntDamagePercentage;
        }
    }

    public static class Sounds
    implements INBTSerializable<CompoundTag> {
        @Optional
        @Nullable
        @TGExclude
        private ResourceLocation fire;
        @Optional
        @Nullable
        @TGExclude
        private ResourceLocation reload;
        @Optional
        @Nullable
        @TGExclude
        private ResourceLocation reloadEmpty;
        @Optional
        @Nullable
        @TGExclude
        private ResourceLocation reloadNormal;
        @Optional
        @Nullable
        @TGExclude
        private ResourceLocation pump;
        @Optional
        @Nullable
        @TGExclude
        private ResourceLocation pullBolt;
        @Optional
        @Nullable
        @TGExclude
        private ResourceLocation reloadIntro;
        @Optional
        @Nullable
        @TGExclude
        private ResourceLocation reloadLoop;
        @Optional
        @Nullable
        @TGExclude
        private ResourceLocation reloadEnd;
        @Optional
        @Nullable
        @TGExclude
        private ResourceLocation reloadEndEmpty;
        @Optional
        @Nullable
        @TGExclude
        private ResourceLocation draw;
        @Optional
        @Nullable
        @TGExclude
        private ResourceLocation inspect;
        @Optional
        @Nullable
        @TGExclude
        private ResourceLocation inspectEmpty;
        @Optional
        @Nullable
        @TGExclude
        private ResourceLocation cock;
        @Optional
        @Nullable
        @TGExclude
        private ResourceLocation silencedFire;

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            if (this.fire != null) {
                tag.m_128359_("Fire", this.fire.toString());
            }
            if (this.reload != null) {
                tag.m_128359_("Reload", this.reload.toString());
            }
            if (this.cock != null) {
                tag.m_128359_("Cock", this.cock.toString());
            }
            if (this.silencedFire != null) {
                tag.m_128359_("SilencedFire", this.silencedFire.toString());
            }
            if (this.reloadEmpty != null) {
                tag.m_128359_("ReloadEmpty", this.reloadEmpty.toString());
            }
            if (this.draw != null) {
                tag.m_128359_("Draw", this.draw.toString());
            }
            if (this.inspectEmpty != null) {
                tag.m_128359_("InspectEmpty", this.inspectEmpty.toString());
            }
            if (this.inspect != null) {
                tag.m_128359_("Inspect", this.inspect.toString());
            }
            if (this.reloadNormal != null) {
                tag.m_128359_("ReloadNormal", this.reloadNormal.toString());
            }
            if (this.pump != null) {
                tag.m_128359_("Pump", this.pump.toString());
            }
            if (this.reloadIntro != null) {
                tag.m_128359_("ReloadIntro", this.reloadIntro.toString());
            }
            if (this.reloadLoop != null) {
                tag.m_128359_("ReloadLoop", this.reloadLoop.toString());
            }
            if (this.reloadEnd != null) {
                tag.m_128359_("ReloadEnd", this.reloadEnd.toString());
            }
            if (this.pullBolt != null) {
                tag.m_128359_("PullBolt", this.pullBolt.toString());
            }
            if (this.reloadEndEmpty != null) {
                tag.m_128359_("ReloadEndEmpty", this.reloadEndEmpty.toString());
            }
            return tag;
        }

        public void deserializeNBT(CompoundTag tag) {
            if (tag.m_128425_("Fire", 8)) {
                this.fire = this.createSound(tag, "Fire");
            }
            if (tag.m_128425_("Reload", 8)) {
                this.reload = this.createSound(tag, "Reload");
            }
            if (tag.m_128425_("Cock", 8)) {
                this.cock = this.createSound(tag, "Cock");
            }
            if (tag.m_128425_("SilencedFire", 8)) {
                this.silencedFire = this.createSound(tag, "SilencedFire");
            }
            if (tag.m_128425_("ReloadEmpty", 8)) {
                this.reloadEmpty = this.createSound(tag, "ReloadEmpty");
            }
            if (tag.m_128425_("Draw", 8)) {
                this.draw = this.createSound(tag, "Draw");
            }
            if (tag.m_128425_("InspectEmpty", 8)) {
                this.inspectEmpty = this.createSound(tag, "InspectEmpty");
            }
            if (tag.m_128425_("Inspect", 8)) {
                this.inspect = this.createSound(tag, "Inspect");
            }
            if (tag.m_128425_("ReloadNormal", 8)) {
                this.reloadNormal = this.createSound(tag, "ReloadNormal");
            }
            if (tag.m_128425_("Pump", 8)) {
                this.pump = this.createSound(tag, "Pump");
            }
            if (tag.m_128425_("ReloadIntro", 8)) {
                this.reloadIntro = this.createSound(tag, "ReloadIntro");
            }
            if (tag.m_128425_("ReloadLoop", 8)) {
                this.reloadLoop = this.createSound(tag, "ReloadLoop");
            }
            if (tag.m_128425_("ReloadEnd", 8)) {
                this.reloadEnd = this.createSound(tag, "ReloadEnd");
            }
            if (tag.m_128425_("PullBolt", 8)) {
                this.pullBolt = this.createSound(tag, "PullBolt");
            }
            if (tag.m_128425_("ReloadEndEmpty", 8)) {
                this.reloadEndEmpty = this.createSound(tag, "ReloadEndEmpty");
            }
        }

        public Sounds copy() {
            Sounds sounds = new Sounds();
            sounds.fire = this.fire;
            sounds.reload = this.reload;
            sounds.cock = this.cock;
            sounds.silencedFire = this.silencedFire;
            sounds.reloadEmpty = this.reloadEmpty;
            sounds.draw = this.draw;
            sounds.inspectEmpty = this.inspectEmpty;
            sounds.inspect = this.inspect;
            sounds.reloadNormal = this.reloadNormal;
            sounds.pump = this.pump;
            sounds.reloadIntro = this.reloadIntro;
            sounds.reloadLoop = this.reloadLoop;
            sounds.reloadEnd = this.reloadEnd;
            sounds.pullBolt = this.pullBolt;
            sounds.reloadEndEmpty = this.reloadEndEmpty;
            return sounds;
        }

        @Nullable
        private ResourceLocation createSound(CompoundTag tag, String key) {
            String sound = tag.m_128461_(key);
            return sound.isEmpty() ? null : new ResourceLocation(sound);
        }

        @Nullable
        public ResourceLocation getFire() {
            return this.fire;
        }

        @Nullable
        public ResourceLocation getReload() {
            return this.reload;
        }

        @Nullable
        public ResourceLocation getCock() {
            return this.cock;
        }

        @Nullable
        public ResourceLocation getSilencedFire() {
            return this.silencedFire;
        }

        @Nullable
        public ResourceLocation getReloadEmpty() {
            return this.reloadEmpty;
        }

        @Nullable
        public ResourceLocation getDraw() {
            return this.draw;
        }

        @Nullable
        public ResourceLocation getInspectEmpty() {
            return this.inspectEmpty != null ? this.inspectEmpty : this.inspect;
        }

        @Nullable
        public ResourceLocation getInspect() {
            return this.inspect;
        }

        @Nullable
        public ResourceLocation getReloadNormal() {
            return this.reloadNormal;
        }

        @Nullable
        public ResourceLocation getPump() {
            return this.pump;
        }

        @Nullable
        public ResourceLocation getReloadIntro() {
            return this.reloadIntro;
        }

        @Nullable
        public ResourceLocation getReloadLoop() {
            return this.reloadLoop;
        }

        @Nullable
        public ResourceLocation getReloadEnd() {
            return this.reloadEnd;
        }

        @Nullable
        public ResourceLocation getPullBolt() {
            return this.pullBolt;
        }

        @Nullable
        public ResourceLocation getReloadEndEmpty() {
            return this.reloadEndEmpty;
        }
    }

    public static class Display
    implements INBTSerializable<CompoundTag> {
        @Optional
        @Nullable
        private Flash flash;
        @Optional
        @Nullable
        private ShellCasing shellCasing;
        @Optional
        private int weaponType = 0;
        @Optional
        private float hipfireScale = 0.75f;
        @Optional
        private float hipfireMoveScale = 0.5f;
        @Optional
        private float hipfireRecoilScale = 1.0f;
        @Optional
        private boolean showDynamicHipfire = true;

        public float getHipfireScale() {
            return this.hipfireScale;
        }

        public float getHipfireMoveScale() {
            return this.hipfireMoveScale;
        }

        public float getHipfireRecoilScale() {
            return this.hipfireRecoilScale;
        }

        public boolean isDynamicHipfire() {
            return this.showDynamicHipfire;
        }

        public WeaponType getWeaponType() {
            return WeaponType.values()[this.weaponType];
        }

        @Nullable
        public Flash getFlash() {
            return this.flash;
        }

        @Nullable
        public ShellCasing getShellCasing() {
            return this.shellCasing;
        }

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            if (this.flash != null) {
                tag.m_128365_("Flash", (Tag)this.flash.serializeNBT());
            }
            if (this.shellCasing != null) {
                tag.m_128365_("ShellCasing", (Tag)this.shellCasing.serializeNBT());
            }
            tag.m_128350_("HipFireScale", this.hipfireScale);
            tag.m_128350_("HipFireMoveScale", this.hipfireMoveScale);
            tag.m_128350_("HipFireRecoilScale", this.hipfireRecoilScale / 2.0f);
            tag.m_128379_("ShowDynamicHipfire", this.showDynamicHipfire);
            tag.m_128405_("WeaponType", this.weaponType);
            return tag;
        }

        public void deserializeNBT(CompoundTag tag) {
            if (tag.m_128425_("Flash", 10)) {
                CompoundTag flashTag = tag.m_128469_("Flash");
                if (!flashTag.m_128456_()) {
                    Flash flash = new Flash();
                    flash.deserializeNBT(tag.m_128469_("Flash"));
                    this.flash = flash;
                } else {
                    this.flash = null;
                }
            }
            if (tag.m_128425_("ShellCasing", 10)) {
                CompoundTag casingTag = tag.m_128469_("ShellCasing");
                if (!casingTag.m_128456_()) {
                    ShellCasing shellCasing = new ShellCasing();
                    shellCasing.deserializeNBT(casingTag);
                    this.shellCasing = shellCasing;
                } else {
                    this.shellCasing = null;
                }
            }
            if (tag.m_128425_("HipFireScale", 99)) {
                this.hipfireScale = tag.m_128457_("HipFireScale");
            }
            if (tag.m_128425_("HipFireMoveScale", 99)) {
                this.hipfireMoveScale = tag.m_128457_("HipFireMoveScale");
            }
            if (tag.m_128425_("HipFireRecoilScale", 99)) {
                this.hipfireRecoilScale = tag.m_128457_("HipFireRecoilScale");
            }
            if (tag.m_128425_("ShowDynamicHipfire", 99)) {
                this.showDynamicHipfire = tag.m_128471_("ShowDynamicHipfire");
            }
            if (tag.m_128425_("WeaponType", 99)) {
                this.weaponType = tag.m_128451_("WeaponType");
            }
        }

        public Display copy() {
            Display display = new Display();
            if (this.flash != null) {
                display.flash = this.flash.copy();
            }
            if (this.shellCasing != null) {
                display.shellCasing = this.shellCasing.copy();
            }
            if (this.hipfireScale != 0.0f) {
                display.hipfireScale = this.hipfireScale;
            }
            if (this.hipfireMoveScale != 0.0f) {
                display.hipfireMoveScale = this.hipfireMoveScale;
            }
            if (this.hipfireRecoilScale != 0.0f) {
                display.hipfireRecoilScale = this.hipfireRecoilScale;
            }
            if (this.weaponType != 0) {
                display.weaponType = this.weaponType;
            }
            display.hipfireRecoilScale = this.hipfireRecoilScale;
            return display;
        }

        public static class Flash
        extends Positioned {
            private double size = 0.5;
            private double smokeSize = 2.0;
            private double trailAdjust = 1.15;

            @Override
            public CompoundTag serializeNBT() {
                CompoundTag tag = super.serializeNBT();
                tag.m_128347_("Scale", this.size);
                tag.m_128347_("SmokeSize", this.smokeSize);
                tag.m_128347_("TrailAdjust", this.trailAdjust);
                return tag;
            }

            @Override
            public void deserializeNBT(CompoundTag tag) {
                super.deserializeNBT(tag);
                if (tag.m_128425_("Scale", 99)) {
                    this.size = tag.m_128459_("Scale");
                }
                if (tag.m_128425_("TrailAdjust", 99)) {
                    this.trailAdjust = tag.m_128459_("TrailAdjust");
                }
                if (tag.m_128425_("SmokeSize", 99)) {
                    this.smokeSize = tag.m_128459_("SmokeSize");
                }
            }

            @Override
            public Flash copy() {
                Flash flash = new Flash();
                flash.size = this.size;
                flash.smokeSize = this.smokeSize;
                flash.trailAdjust = this.trailAdjust;
                flash.xOffset = this.xOffset;
                flash.yOffset = this.yOffset;
                flash.zOffset = this.zOffset;
                return flash;
            }

            public double getSize() {
                return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.COMMON.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.flash ? this.size : this.size;
            }

            @Override
            public double getXOffset() {
                return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.COMMON.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.flash ? this.xOffset + GunEditor.get().getxMod() : this.xOffset;
            }

            @Override
            public double getYOffset() {
                return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.COMMON.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.flash ? this.yOffset + GunEditor.get().getyMod() : this.yOffset;
            }

            @Override
            public double getZOffset() {
                return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.COMMON.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.flash ? this.zOffset + GunEditor.get().getzMod() : this.zOffset;
            }

            public double getTrailAdjust() {
                return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.COMMON.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.flash ? this.trailAdjust + GunEditor.get().getSizeMod() : this.trailAdjust;
            }

            public double getSmokeSize() {
                return this.smokeSize;
            }
        }
    }

    public static class Modules
    implements INBTSerializable<CompoundTag> {
        @Optional
        @Nullable
        private Zoom zoom = new Zoom();
        @Optional
        private Attachments attachments = new Attachments();

        @Nullable
        public Zoom getZoom() {
            return this.zoom.copy();
        }

        public Attachments getAttachments() {
            return this.attachments;
        }

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128365_("Zoom", (Tag)this.zoom.serializeNBT());
            tag.m_128365_("Attachments", (Tag)this.attachments.serializeNBT());
            return tag;
        }

        public void deserializeNBT(CompoundTag tag) {
            if (tag.m_128425_("Zoom", 10)) {
                this.zoom.deserializeNBT(tag.m_128469_("Zoom"));
            }
            if (tag.m_128425_("Attachments", 10)) {
                this.attachments.deserializeNBT(tag.m_128469_("Attachments"));
            }
        }

        public Modules copy() {
            Modules modules = new Modules();
            modules.zoom = this.zoom.copy();
            modules.attachments = this.attachments.copy();
            return modules;
        }

        public static class Zoom
        extends Positioned {
            @Optional
            private float fovModifier = 0.8f;
            @Optional
            private double stabilityOffset = 0.225;

            @Override
            public CompoundTag serializeNBT() {
                CompoundTag tag = super.serializeNBT();
                tag.m_128350_("FovModifier", this.fovModifier);
                tag.m_128347_("StabilityOffset", this.stabilityOffset);
                return tag;
            }

            @Override
            public void deserializeNBT(CompoundTag tag) {
                super.deserializeNBT(tag);
                if (tag.m_128425_("FovModifier", 99)) {
                    this.fovModifier = tag.m_128457_("FovModifier");
                }
                if (tag.m_128425_("StabilityOffset", 99)) {
                    this.stabilityOffset = tag.m_128459_("StabilityOffset");
                }
            }

            @Override
            public Zoom copy() {
                Zoom zoom = new Zoom();
                zoom.fovModifier = this.fovModifier;
                zoom.stabilityOffset = this.stabilityOffset;
                zoom.xOffset = this.xOffset;
                zoom.yOffset = this.yOffset;
                zoom.zOffset = this.zOffset;
                return zoom;
            }

            public float getFovModifier() {
                return this.fovModifier;
            }

            public double getStabilityOffset() {
                return this.stabilityOffset;
            }

            @Override
            public double getXOffset() {
                return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.COMMON.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.zoom ? super.getXOffset() + GunEditor.get().getxMod() : super.getXOffset();
            }

            @Override
            public double getYOffset() {
                return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.COMMON.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.zoom ? super.getYOffset() + GunEditor.get().getyMod() : super.getYOffset();
            }

            @Override
            public double getZOffset() {
                return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.COMMON.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.zoom ? super.getZOffset() + GunEditor.get().getzMod() : super.getZOffset();
            }
        }

        public static class Attachments
        implements INBTSerializable<CompoundTag> {
            @Optional
            @Nullable
            private ScaledPositioned scope;
            @Optional
            @Nullable
            private ScaledPositioned barrel;
            @Optional
            @Nullable
            private ScaledPositioned stock;
            @Optional
            @Nullable
            private ScaledPositioned underBarrel;
            @Optional
            @Nullable
            private ScaledPositioned gunSkin;
            @Optional
            @Nullable
            private ScaledPositioned sideRail;
            @Optional
            @Nullable
            private ScaledPositioned irDevice;
            @Optional
            @Nullable
            private ScaledPositioned extendedMag;
            @Optional
            @Nullable
            private ScaledPositioned oldScope;
            @Optional
            @Nullable
            private PistolScope pistolScope;
            @Optional
            @Nullable
            private ScaledPositioned pistolBarrel;

            @Nullable
            public ScaledPositioned getScope() {
                return this.scope;
            }

            @Nullable
            public ScaledPositioned getBarrel() {
                return this.barrel;
            }

            @Nullable
            public ScaledPositioned getStock() {
                return this.stock;
            }

            @Nullable
            public ScaledPositioned getUnderBarrel() {
                return this.underBarrel;
            }

            @Nullable
            public ScaledPositioned getGunSkin() {
                return this.gunSkin;
            }

            @Nullable
            public ScaledPositioned getSideRail() {
                return this.sideRail;
            }

            @Nullable
            public ScaledPositioned getIrDevice() {
                return this.irDevice;
            }

            @Nullable
            public ScaledPositioned getExtendedMag() {
                return this.extendedMag;
            }

            @Nullable
            public ScaledPositioned getOldScope() {
                return this.oldScope;
            }

            @Nullable
            public PistolScope getPistolScope() {
                return this.pistolScope;
            }

            @Nullable
            public ScaledPositioned getPistolBarrel() {
                return this.pistolBarrel;
            }

            public CompoundTag serializeNBT() {
                CompoundTag tag = new CompoundTag();
                if (this.scope != null) {
                    tag.m_128365_("Scope", (Tag)this.scope.serializeNBT());
                }
                if (this.barrel != null) {
                    tag.m_128365_("Barrel", (Tag)this.barrel.serializeNBT());
                }
                if (this.stock != null) {
                    tag.m_128365_("Stock", (Tag)this.stock.serializeNBT());
                }
                if (this.underBarrel != null) {
                    tag.m_128365_("UnderBarrel", (Tag)this.underBarrel.serializeNBT());
                }
                if (this.gunSkin != null) {
                    tag.m_128365_("GunSkin", (Tag)this.gunSkin.serializeNBT());
                }
                if (this.oldScope != null) {
                    tag.m_128365_("OldScope", (Tag)this.oldScope.serializeNBT());
                }
                if (this.sideRail != null) {
                    tag.m_128365_("SideRail", (Tag)this.sideRail.serializeNBT());
                }
                if (this.irDevice != null) {
                    tag.m_128365_("IrDevice", (Tag)this.irDevice.serializeNBT());
                }
                if (this.extendedMag != null) {
                    tag.m_128365_("ExtendedMag", (Tag)this.extendedMag.serializeNBT());
                }
                if (this.pistolScope != null) {
                    tag.m_128365_("PistolScope", (Tag)this.pistolScope.serializeNBT());
                }
                if (this.pistolBarrel != null) {
                    tag.m_128365_("PistolBarrel", (Tag)this.pistolBarrel.serializeNBT());
                }
                return tag;
            }

            public void deserializeNBT(CompoundTag tag) {
                if (tag.m_128425_("Scope", 10)) {
                    this.scope = this.createScope(tag, "Scope");
                }
                if (tag.m_128425_("Barrel", 10)) {
                    this.barrel = this.createBarrel(tag, "Barrel");
                }
                if (tag.m_128425_("Stock", 10)) {
                    this.stock = this.createScaledPositioned(tag, "Stock");
                }
                if (tag.m_128425_("UnderBarrel", 10)) {
                    this.underBarrel = this.createScaledPositioned(tag, "UnderBarrel");
                }
                if (tag.m_128425_("GunSkin", 10)) {
                    this.gunSkin = this.createScaledPositioned(tag, "GunSkin");
                }
                if (tag.m_128425_("OldScope", 10)) {
                    this.oldScope = this.createOldScope(tag, "OldScope");
                }
                if (tag.m_128425_("SideRail", 10)) {
                    this.sideRail = this.createScaledPositioned(tag, "SideRail");
                }
                if (tag.m_128425_("IrDevice", 10)) {
                    this.irDevice = this.createScaledPositioned(tag, "IrDevice");
                }
                if (tag.m_128425_("ExtendedMag", 10)) {
                    this.extendedMag = this.createScaledPositioned(tag, "ExtendedMag");
                }
                if (tag.m_128425_("PistolScope", 10)) {
                    this.pistolScope = this.createPistolScope(tag, "PistolScope");
                }
                if (tag.m_128425_("PistolBarrel", 10)) {
                    this.pistolBarrel = this.createPistolBarrel(tag, "PistolBarrel");
                }
            }

            public Attachments copy() {
                Attachments attachments = new Attachments();
                if (this.scope != null) {
                    attachments.scope = this.scope.copy();
                }
                if (this.barrel != null) {
                    attachments.barrel = this.barrel.copy();
                }
                if (this.stock != null) {
                    attachments.stock = this.stock.copy();
                }
                if (this.underBarrel != null) {
                    attachments.underBarrel = this.underBarrel.copy();
                }
                if (this.gunSkin != null) {
                    attachments.gunSkin = this.gunSkin.copy();
                }
                if (this.oldScope != null) {
                    attachments.oldScope = this.oldScope.copy();
                }
                if (this.sideRail != null) {
                    attachments.sideRail = this.sideRail.copy();
                }
                if (this.irDevice != null) {
                    attachments.irDevice = this.irDevice.copy();
                }
                if (this.extendedMag != null) {
                    attachments.extendedMag = this.extendedMag.copy();
                }
                if (this.pistolScope != null) {
                    attachments.pistolScope = this.pistolScope.copy();
                }
                if (this.pistolBarrel != null) {
                    attachments.pistolBarrel = this.pistolBarrel.copy();
                }
                return attachments;
            }

            @Nullable
            private ScaledPositioned createScaledPositioned(CompoundTag tag, String key) {
                CompoundTag attachment = tag.m_128469_(key);
                return attachment.m_128456_() ? null : new ScaledPositioned(attachment);
            }

            @Nullable
            private PistolScope createPistolScope(CompoundTag tag, String key) {
                CompoundTag attachment = tag.m_128469_(key);
                return attachment.m_128456_() ? null : new PistolScope(attachment){

                    @Override
                    public double getXOffset() {
                        return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.COMMON.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.pistolScope ? super.getXOffset() + GunEditor.get().getxMod() : super.getXOffset();
                    }

                    @Override
                    public double getYOffset() {
                        return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.COMMON.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.pistolScope ? super.getYOffset() + GunEditor.get().getyMod() : super.getYOffset();
                    }

                    @Override
                    public double getZOffset() {
                        return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.COMMON.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.pistolScope ? super.getZOffset() + GunEditor.get().getzMod() : super.getZOffset();
                    }

                    @Override
                    public double getScale() {
                        return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.COMMON.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.pistolScope ? this.scale + GunEditor.get().getSizeMod() : this.scale;
                    }
                };
            }

            @Nullable
            private ScaledPositioned createScope(CompoundTag tag, String key) {
                CompoundTag attachment = tag.m_128469_(key);
                return attachment.m_128456_() ? null : new ScaledPositioned(attachment){

                    @Override
                    public double getXOffset() {
                        return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.COMMON.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.scope ? super.getXOffset() + GunEditor.get().getxMod() : super.getXOffset();
                    }

                    @Override
                    public double getYOffset() {
                        return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.COMMON.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.scope ? super.getYOffset() + GunEditor.get().getyMod() : super.getYOffset();
                    }

                    @Override
                    public double getZOffset() {
                        return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.COMMON.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.scope ? super.getZOffset() + GunEditor.get().getzMod() : super.getZOffset();
                    }

                    @Override
                    public double getScale() {
                        return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.COMMON.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.scope ? this.scale + GunEditor.get().getSizeMod() : this.scale;
                    }
                };
            }

            @Nullable
            private ScaledPositioned createBarrel(CompoundTag tag, String key) {
                CompoundTag attachment = tag.m_128469_(key);
                return attachment.m_128456_() ? null : new ScaledPositioned(attachment){

                    @Override
                    public double getXOffset() {
                        return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.COMMON.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.barrel ? super.getXOffset() + GunEditor.get().getxMod() : super.getXOffset();
                    }

                    @Override
                    public double getYOffset() {
                        return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.COMMON.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.barrel ? super.getYOffset() + GunEditor.get().getyMod() : super.getYOffset();
                    }

                    @Override
                    public double getZOffset() {
                        return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.COMMON.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.barrel ? super.getZOffset() + GunEditor.get().getzMod() : super.getZOffset();
                    }

                    @Override
                    public double getScale() {
                        return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.COMMON.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.barrel ? this.scale + GunEditor.get().getSizeMod() : this.scale;
                    }
                };
            }

            @Nullable
            private ScaledPositioned createPistolBarrel(CompoundTag tag, String key) {
                CompoundTag attachment = tag.m_128469_(key);
                return attachment.m_128456_() ? null : new ScaledPositioned(attachment){

                    @Override
                    public double getXOffset() {
                        return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.COMMON.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.pistolBarrel ? super.getXOffset() + GunEditor.get().getxMod() : super.getXOffset();
                    }

                    @Override
                    public double getYOffset() {
                        return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.COMMON.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.pistolBarrel ? super.getYOffset() + GunEditor.get().getyMod() : super.getYOffset();
                    }

                    @Override
                    public double getZOffset() {
                        return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.COMMON.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.pistolBarrel ? super.getZOffset() + GunEditor.get().getzMod() : super.getZOffset();
                    }

                    @Override
                    public double getScale() {
                        return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.COMMON.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.pistolBarrel ? this.scale + GunEditor.get().getSizeMod() : this.scale;
                    }
                };
            }

            @Nullable
            private ScaledPositioned createOldScope(CompoundTag tag, String key) {
                CompoundTag attachment = tag.m_128469_(key);
                return attachment.m_128456_() ? null : new ScaledPositioned(attachment){

                    @Override
                    public double getXOffset() {
                        return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.COMMON.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.oldScope ? super.getXOffset() + GunEditor.get().getxMod() : super.getXOffset();
                    }

                    @Override
                    public double getYOffset() {
                        return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.COMMON.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.oldScope ? super.getYOffset() + GunEditor.get().getyMod() : super.getYOffset();
                    }

                    @Override
                    public double getZOffset() {
                        return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.COMMON.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.oldScope ? super.getZOffset() + GunEditor.get().getzMod() : super.getZOffset();
                    }

                    @Override
                    public double getScale() {
                        return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.COMMON.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.oldScope ? this.scale + GunEditor.get().getSizeMod() : this.scale;
                    }
                };
            }
        }
    }

    public static class ScaledPositioned
    extends Positioned {
        @Optional
        protected double scale = 1.0;

        public ScaledPositioned() {
        }

        public ScaledPositioned(CompoundTag tag) {
            this.deserializeNBT(tag);
        }

        @Override
        public CompoundTag serializeNBT() {
            CompoundTag tag = super.serializeNBT();
            tag.m_128347_("Scale", this.scale);
            return tag;
        }

        @Override
        public void deserializeNBT(CompoundTag tag) {
            super.deserializeNBT(tag);
            if (tag.m_128425_("Scale", 99)) {
                this.scale = tag.m_128459_("Scale");
            }
        }

        @Override
        public ScaledPositioned copy() {
            ScaledPositioned positioned = new ScaledPositioned();
            positioned.xOffset = this.xOffset;
            positioned.yOffset = this.yOffset;
            positioned.zOffset = this.zOffset;
            positioned.scale = this.scale;
            return positioned;
        }

        public double getScale() {
            return this.scale;
        }
    }

    public static class PistolScope
    extends ScaledPositioned {
        @Required
        private boolean doRenderMount;
        @Required
        private boolean doOnSlideMovement;

        public PistolScope() {
        }

        public PistolScope(CompoundTag tag) {
            this.deserializeNBT(tag);
        }

        @Override
        public CompoundTag serializeNBT() {
            CompoundTag tag = super.serializeNBT();
            tag.m_128379_("RenderMount", this.doRenderMount);
            tag.m_128379_("DoOnSlideMovement", this.doOnSlideMovement);
            return tag;
        }

        @Override
        public void deserializeNBT(CompoundTag tag) {
            super.deserializeNBT(tag);
            if (tag.m_128425_("RenderMount", 99)) {
                this.doRenderMount = tag.m_128471_("RenderMount");
            }
            if (tag.m_128425_("DoOnSlideMovement", 99)) {
                this.doOnSlideMovement = tag.m_128471_("DoOnSlideMovement");
            }
        }

        @Override
        public double getXOffset() {
            return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.COMMON.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.pistolScope ? super.getXOffset() + GunEditor.get().getxMod() : super.getXOffset();
        }

        @Override
        public double getYOffset() {
            return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.COMMON.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.pistolScope ? super.getYOffset() + GunEditor.get().getyMod() : super.getYOffset();
        }

        @Override
        public double getZOffset() {
            return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.COMMON.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.pistolScope ? super.getZOffset() + GunEditor.get().getzMod() : super.getZOffset();
        }

        @Override
        public double getScale() {
            return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.COMMON.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.pistolScope ? this.scale + GunEditor.get().getSizeMod() : this.scale;
        }

        public boolean getDoRenderMount() {
            return this.doRenderMount;
        }

        public boolean getDoOnSlideMovement() {
            return this.doOnSlideMovement;
        }

        @Override
        public PistolScope copy() {
            PistolScope positioned = new PistolScope();
            positioned.xOffset = this.xOffset;
            positioned.yOffset = this.yOffset;
            positioned.zOffset = this.zOffset;
            positioned.scale = this.scale;
            positioned.doRenderMount = this.doRenderMount;
            positioned.doOnSlideMovement = this.doOnSlideMovement;
            return positioned;
        }
    }

    public static class ShellCasing
    extends ScaledPositioned {
        @Optional
        protected float velocityX = 0.0f;
        @Optional
        protected float velocityY = 0.0f;
        @Optional
        protected float velocityZ = 0.0f;
        @Optional
        protected float rVelocityX = 0.0f;
        @Optional
        protected float rVelocityY = 0.0f;
        @Optional
        protected float rVelocityZ = 0.0f;
        @Optional
        protected float aVelocityX = 0.0f;
        @Optional
        protected float aVelocityY = 0.0f;
        @Optional
        protected float aVelocityZ = 0.0f;
        @Optional
        @Nullable
        @TGExclude
        private ResourceLocation casingModel;
        @Optional
        protected int tickLife = 40;

        public ShellCasing() {
        }

        public ShellCasing(CompoundTag tag) {
            this.deserializeNBT(tag);
        }

        @Override
        public CompoundTag serializeNBT() {
            CompoundTag tag = super.serializeNBT();
            tag.m_128350_("VelocityX", this.velocityX);
            tag.m_128350_("VelocityY", this.velocityY);
            tag.m_128350_("VelocityZ", this.velocityZ);
            tag.m_128350_("RVelocityX", this.rVelocityX);
            tag.m_128350_("RVelocityY", this.rVelocityY);
            tag.m_128350_("RVelocityZ", this.rVelocityZ);
            tag.m_128350_("AVelocityX", this.aVelocityX);
            tag.m_128350_("AVelocityY", this.aVelocityY);
            tag.m_128350_("AVelocityZ", this.aVelocityZ);
            if (this.casingModel != null) {
                tag.m_128359_("CasingModel", this.casingModel.toString());
            }
            tag.m_128405_("TickLife", this.tickLife);
            return tag;
        }

        @Override
        public void deserializeNBT(CompoundTag tag) {
            super.deserializeNBT(tag);
            if (tag.m_128425_("VelocityX", 99)) {
                this.velocityX = tag.m_128457_("VelocityX");
            }
            if (tag.m_128425_("VelocityY", 99)) {
                this.velocityY = tag.m_128457_("VelocityY");
            }
            if (tag.m_128425_("VelocityZ", 99)) {
                this.velocityZ = tag.m_128457_("VelocityZ");
            }
            if (tag.m_128425_("RVelocityX", 99)) {
                this.rVelocityX = tag.m_128457_("RVelocityX");
            }
            if (tag.m_128425_("RVelocityY", 99)) {
                this.rVelocityY = tag.m_128457_("RVelocityY");
            }
            if (tag.m_128425_("RVelocityZ", 99)) {
                this.rVelocityZ = tag.m_128457_("RVelocityZ");
            }
            if (tag.m_128425_("AVelocityX", 99)) {
                this.aVelocityX = tag.m_128457_("AVelocityX");
            }
            if (tag.m_128425_("AVelocityY", 99)) {
                this.aVelocityY = tag.m_128457_("AVelocityY");
            }
            if (tag.m_128425_("AVelocityZ", 99)) {
                this.aVelocityZ = tag.m_128457_("AVelocityZ");
            }
            if (tag.m_128425_("CasingModel", 8)) {
                this.casingModel = this.createResource(tag, "CasingModel");
            }
            if (tag.m_128425_("TickLife", 99)) {
                this.tickLife = tag.m_128451_("TickLife");
            }
        }

        @Nullable
        private ResourceLocation createResource(CompoundTag tag, String key) {
            String resource = tag.m_128461_(key);
            return resource.isEmpty() ? null : new ResourceLocation(resource);
        }

        @Override
        public ShellCasing copy() {
            ShellCasing ms = new ShellCasing();
            ms.xOffset = this.xOffset;
            ms.yOffset = this.yOffset;
            ms.zOffset = this.zOffset;
            ms.scale = this.scale;
            ms.velocityX = this.velocityX;
            ms.velocityY = this.velocityY;
            ms.velocityZ = this.velocityZ;
            ms.rVelocityX = this.rVelocityX;
            ms.rVelocityY = this.rVelocityY;
            ms.rVelocityZ = this.rVelocityZ;
            ms.aVelocityX = this.aVelocityX;
            ms.aVelocityY = this.aVelocityY;
            ms.aVelocityZ = this.aVelocityZ;
            ms.casingModel = this.casingModel;
            ms.tickLife = this.tickLife;
            return ms;
        }

        public float getVelocityX() {
            return this.velocityX;
        }

        public float getVelocityY() {
            return this.velocityY;
        }

        public float getVelocityZ() {
            return this.velocityZ;
        }

        public float getRVelocityX() {
            return this.rVelocityX;
        }

        public float getRVelocityY() {
            return this.rVelocityY;
        }

        public float getRVelocityZ() {
            return this.rVelocityZ;
        }

        public float getAVelocityX() {
            return this.aVelocityX;
        }

        public float getAVelocityY() {
            return this.aVelocityY;
        }

        public float getAVelocityZ() {
            return this.aVelocityZ;
        }

        public ResourceLocation getCasingModel() {
            return this.casingModel;
        }

        public int getTickLife() {
            return this.tickLife;
        }
    }

    public static class Positioned
    implements INBTSerializable<CompoundTag> {
        @Optional
        protected double xOffset = 0.0;
        @Optional
        protected double yOffset = 0.0;
        @Optional
        protected double zOffset = 0.0;

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128347_("XOffset", this.xOffset);
            tag.m_128347_("YOffset", this.yOffset);
            tag.m_128347_("ZOffset", this.zOffset);
            return tag;
        }

        public void deserializeNBT(CompoundTag tag) {
            if (tag.m_128425_("XOffset", 99)) {
                this.xOffset = tag.m_128459_("XOffset");
            }
            if (tag.m_128425_("YOffset", 99)) {
                this.yOffset = tag.m_128459_("YOffset");
            }
            if (tag.m_128425_("ZOffset", 99)) {
                this.zOffset = tag.m_128459_("ZOffset");
            }
        }

        public double getXOffset() {
            return this.xOffset;
        }

        public double getYOffset() {
            return this.yOffset;
        }

        public double getZOffset() {
            return this.zOffset;
        }

        public Positioned copy() {
            Positioned positioned = new Positioned();
            positioned.xOffset = this.xOffset;
            positioned.yOffset = this.yOffset;
            positioned.zOffset = this.zOffset;
            return positioned;
        }
    }
}

