/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.common;

import java.util.Dictionary;
import java.util.Hashtable;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="tac")
public class DiscardOffhand {
    public static int TICK_THRESHOLD = 10;
    public static Dictionary<LivingEntity, Integer> mapping = new Hashtable<LivingEntity, Integer>();

    @SubscribeEvent
    public static void onChange(LivingEquipmentChangeEvent event) {
        LivingEntity entity = event.getEntityLiving();
        if (entity instanceof Player && !entity.m_20193_().f_46443_ && event.getSlot() == EquipmentSlot.MAINHAND) {
            mapping.put(entity, TICK_THRESHOLD);
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Integer safeTime;
        Player entity = event.player;
        if (event.phase == TickEvent.Phase.END && !entity.m_20193_().f_46443_ && (safeTime = mapping.get(entity)) != null && safeTime != 0) {
            mapping.put((LivingEntity)entity, Math.max(mapping.get(entity) - 1, 0));
        }
    }

    @SubscribeEvent
    public static void onPlayerLogIn(PlayerEvent.PlayerLoggedInEvent event) {
        mapping.put((LivingEntity)event.getPlayer(), TICK_THRESHOLD);
    }

    @SubscribeEvent
    public static void onPlayerLogOut(PlayerEvent.PlayerLoggedOutEvent event) {
        Player entity = event.getPlayer();
        if (mapping.get(entity) != null) {
            mapping.remove(entity);
        }
    }

    public static boolean isSafeTime(Player entity) {
        Integer safeTime = mapping.get(entity);
        if (safeTime == null) {
            return true;
        }
        return safeTime != 0;
    }
}

