/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.common;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.tac.guns.GunMod;
import com.tac.guns.annotation.Validator;
import com.tac.guns.common.CustomRig;
import com.tac.guns.common.JsonDeserializers;
import java.io.InvalidObjectException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="tac")
public class CustomRigLoader
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON_INSTANCE = (Gson)Util.m_137537_(() -> {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(ResourceLocation.class, JsonDeserializers.RESOURCE_LOCATION);
        return builder.create();
    });
    private static CustomRigLoader instance;
    private Map<ResourceLocation, CustomRig> customRigMap = new HashMap<ResourceLocation, CustomRig>();

    public CustomRigLoader() {
        super(GSON_INSTANCE, "rigs");
    }

    protected void apply(Map<ResourceLocation, JsonElement> objects, ResourceManager manager, ProfilerFiller profiler) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        objects.forEach((resourceLocation, object) -> {
            try {
                CustomRig customRig = (CustomRig)GSON_INSTANCE.fromJson(object, CustomRig.class);
                if (customRig != null && Validator.isValidObject(customRig)) {
                    builder.put(resourceLocation, (Object)customRig);
                } else {
                    GunMod.LOGGER.error("Couldn't load data file {} as it is missing or malformed", resourceLocation);
                }
            }
            catch (InvalidObjectException e) {
                GunMod.LOGGER.error("Missing required properties for {}", resourceLocation);
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        });
        this.customRigMap = builder.build();
    }

    public void writeCustomRigs(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.customRigMap.size());
        this.customRigMap.forEach((id, rig) -> {
            buffer.m_130085_(id);
            buffer.m_130079_(rig.serializeNBT());
        });
    }

    public static ImmutableMap<ResourceLocation, CustomRig> readCustomRigs(FriendlyByteBuf buffer) {
        int size = buffer.m_130242_();
        if (size > 0) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (int i = 0; i < size; ++i) {
                ResourceLocation id = buffer.m_130281_();
                CustomRig customRig = new CustomRig();
                customRig.deserializeNBT(buffer.m_130260_());
                builder.put((Object)id, (Object)customRig);
            }
            return builder.build();
        }
        return ImmutableMap.of();
    }

    @SubscribeEvent
    public static void addReloadListenerEvent(AddReloadListenerEvent event) {
        CustomRigLoader customGunLoader = new CustomRigLoader();
        event.addListener((PreparableReloadListener)customGunLoader);
        instance = customGunLoader;
    }

    @Nullable
    public static CustomRigLoader get() {
        return instance;
    }
}

