/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.common;

import com.mrcrayfish.framework.common.data.SyncedEntityData;
import com.tac.guns.init.ModSyncedDataKeys;
import com.tac.guns.util.GunEnchantmentHelper;
import com.tac.guns.util.GunModifierHelper;
import java.util.Map;
import java.util.WeakHashMap;
import javax.annotation.Nullable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="tac")
public class AimingManager {
    private static AimingManager instance;
    protected final Map<Player, AimTracker> aimingMap = new WeakHashMap<Player, AimTracker>();
    private static final double MAX_AIM_PROGRESS = 4.0;

    public static AimingManager get() {
        if (instance == null) {
            instance = new AimingManager();
        }
        return instance;
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        AimTracker tracker;
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        Player player = event.player;
        if (player.m_7578_()) {
            return;
        }
        AimingManager manager = AimingManager.get();
        boolean isAiming = (Boolean)SyncedEntityData.instance().get((Entity)player, ModSyncedDataKeys.AIMING);
        if (isAiming && !manager.aimingMap.containsKey(player)) {
            manager.aimingMap.put(player, new AimTracker());
        }
        if ((tracker = manager.getAimTracker(player)) != null) {
            tracker.handleAiming(player.m_21120_(InteractionHand.MAIN_HAND), isAiming);
            tracker.tickLerpProgress();
            if (!tracker.isAiming()) {
                manager.aimingMap.remove(player);
            }
        }
    }

    @SubscribeEvent
    public static void onLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        AimingManager.get().aimingMap.remove(event.getPlayer());
    }

    @Nullable
    public AimTracker getAimTracker(Player player) {
        return this.aimingMap.get(player);
    }

    public Map<Player, AimTracker> getAimingMap() {
        return this.aimingMap;
    }

    public static class AimTracker {
        private double currentAim;
        private double previousAim;
        private double amplifier = 0.8;
        private double lerpProgress;

        public void handleAiming(ItemStack heldItem, boolean isAiming) {
            this.previousAim = this.currentAim;
            double vAmplifier = 0.1;
            if (isAiming) {
                if (this.amplifier < 1.3) {
                    this.amplifier += vAmplifier;
                }
                if (this.currentAim < 4.0) {
                    double speed = GunEnchantmentHelper.getAimDownSightSpeed(heldItem);
                    speed = GunModifierHelper.getModifiedAimDownSightSpeed(heldItem, speed);
                    this.currentAim += speed * this.amplifier;
                    if (this.currentAim > 4.0) {
                        this.amplifier = 0.5;
                        this.currentAim = 4.0;
                    }
                }
            } else if (this.currentAim > 0.0) {
                if (this.amplifier < 1.3) {
                    this.amplifier += vAmplifier;
                }
                double speed = GunEnchantmentHelper.getAimDownSightSpeed(heldItem);
                speed = GunModifierHelper.getModifiedAimDownSightSpeed(heldItem, speed);
                this.currentAim -= speed * this.amplifier;
                if (this.currentAim < 0.0) {
                    this.amplifier = 0.5;
                    this.currentAim = 0.0;
                }
            } else {
                this.amplifier = 0.8;
            }
        }

        public boolean isAiming() {
            return this.currentAim != 0.0 || this.previousAim != 0.0;
        }

        protected void tickLerpProgress() {
            this.lerpProgress += (this.getNormalProgress(1.0f) - this.lerpProgress) * 0.5;
        }

        public double getLerpProgress() {
            return this.lerpProgress;
        }

        public double getNormalProgress(float partialTicks) {
            return (this.previousAim + (this.currentAim - this.previousAim) * (double)(this.previousAim == 0.0 || this.previousAim == 4.0 ? 0.0f : partialTicks)) / 4.0;
        }
    }
}

