/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.client.screen;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Vector3f;
import com.tac.guns.client.handler.GunRenderingHandler;
import com.tac.guns.client.render.model.OverrideModelManager;
import com.tac.guns.client.screen.CheckBox;
import com.tac.guns.client.util.RenderUtil;
import com.tac.guns.common.Gun;
import com.tac.guns.common.NetworkGunManager;
import com.tac.guns.common.WeaponType;
import com.tac.guns.common.container.WorkbenchContainer;
import com.tac.guns.crafting.WorkbenchRecipe;
import com.tac.guns.crafting.WorkbenchRecipes;
import com.tac.guns.init.ModItems;
import com.tac.guns.item.GunItem;
import com.tac.guns.item.IAmmo;
import com.tac.guns.item.IColored;
import com.tac.guns.item.OldScopeItem;
import com.tac.guns.item.PistolScopeItem;
import com.tac.guns.item.ScopeItem;
import com.tac.guns.item.attachment.IAttachment;
import com.tac.guns.item.transition.TimelessGunItem;
import com.tac.guns.network.PacketHandler;
import com.tac.guns.network.message.MessageCraft;
import com.tac.guns.tileentity.WorkbenchTileEntity;
import com.tac.guns.util.InventoryUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.lwjgl.opengl.GL11;

public class WorkbenchScreen
extends AbstractContainerScreen<WorkbenchContainer> {
    private static final ResourceLocation GUI_BASE = new ResourceLocation("tac:textures/gui/workbench.png");
    private static boolean showRemaining = false;
    private Tab currentTab;
    private List<Tab> tabs = new ArrayList<Tab>();
    private List<MaterialItem> materials;
    private List<MaterialItem> filteredMaterials;
    private Inventory playerInventory;
    private WorkbenchTileEntity workbench;
    private Button btnCraft;
    private CheckBox checkBoxMaterials;
    private ItemStack displayStack;
    float posDelta = 0.1f;

    public WorkbenchScreen(WorkbenchContainer container, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)container, playerInventory, title);
        this.playerInventory = playerInventory;
        this.workbench = container.getWorkbench();
        this.f_97726_ = 256;
        this.f_97727_ = 184;
        this.materials = new ArrayList<MaterialItem>();
        this.createTabs(WorkbenchRecipes.getAll(playerInventory.f_35978_.f_19853_));
        if (!this.tabs.isEmpty()) {
            this.f_97727_ += 28;
        }
    }

    private void createTabs(NonNullList<WorkbenchRecipe> recipes) {
        ItemStack icon;
        ArrayList<WorkbenchRecipe> weapons_AR = new ArrayList<WorkbenchRecipe>();
        ArrayList<WorkbenchRecipe> weapons_HMG = new ArrayList<WorkbenchRecipe>();
        ArrayList<WorkbenchRecipe> weapons_PT = new ArrayList<WorkbenchRecipe>();
        ArrayList<WorkbenchRecipe> weapons_SG = new ArrayList<WorkbenchRecipe>();
        ArrayList<WorkbenchRecipe> weapons_SMG = new ArrayList<WorkbenchRecipe>();
        ArrayList<WorkbenchRecipe> weapons_SR = new ArrayList<WorkbenchRecipe>();
        ArrayList<WorkbenchRecipe> weapons = new ArrayList<WorkbenchRecipe>();
        ArrayList<WorkbenchRecipe> attachments = new ArrayList<WorkbenchRecipe>();
        ArrayList<WorkbenchRecipe> ammo = new ArrayList<WorkbenchRecipe>();
        ArrayList<WorkbenchRecipe> misc = new ArrayList<WorkbenchRecipe>();
        for (WorkbenchRecipe recipe : recipes) {
            ItemStack output = recipe.getItem();
            if (output.m_41720_() instanceof GunItem) {
                Gun gun = ((GunItem)output.m_41720_()).getGun();
                if (gun.getDisplay().getWeaponType() == WeaponType.AR) {
                    weapons_AR.add(recipe);
                    continue;
                }
                if (gun.getDisplay().getWeaponType() == WeaponType.MG || gun.getDisplay().getWeaponType() == WeaponType.RPG) {
                    weapons_HMG.add(recipe);
                    continue;
                }
                if (gun.getDisplay().getWeaponType() == WeaponType.PT) {
                    weapons_PT.add(recipe);
                    continue;
                }
                if (gun.getDisplay().getWeaponType() == WeaponType.SG) {
                    weapons_SG.add(recipe);
                    continue;
                }
                if (gun.getDisplay().getWeaponType() == WeaponType.SMG) {
                    weapons_SMG.add(recipe);
                    continue;
                }
                if (gun.getDisplay().getWeaponType() == WeaponType.SR) {
                    weapons_SR.add(recipe);
                    continue;
                }
                weapons.add(recipe);
                continue;
            }
            if (output.m_41720_() instanceof IAttachment) {
                attachments.add(recipe);
                continue;
            }
            if (this.isAmmo(output)) {
                ammo.add(recipe);
                continue;
            }
            misc.add(recipe);
        }
        if (!weapons_AR.isEmpty()) {
            icon = new ItemStack((ItemLike)ModItems.AK47.get());
            icon.m_41784_().m_128405_("AmmoCount", ((GunItem)ModItems.AK47.get()).getGun().getReloads().getMaxAmmo());
            this.tabs.add(new Tab(icon, "weapons_ar", weapons_AR));
        }
        if (!weapons_HMG.isEmpty()) {
            icon = new ItemStack((ItemLike)ModItems.M60.get());
            icon.m_41784_().m_128405_("AmmoCount", ((GunItem)ModItems.M60.get()).getGun().getReloads().getMaxAmmo());
            this.tabs.add(new Tab(icon, "weapons_hmg", weapons_HMG));
        }
        if (!weapons_PT.isEmpty()) {
            icon = new ItemStack((ItemLike)ModItems.GLOCK_17.get());
            icon.m_41784_().m_128405_("AmmoCount", ((TimelessGunItem)ModItems.GLOCK_17.get()).getGun().getReloads().getMaxAmmo());
            this.tabs.add(new Tab(icon, "weapons_pt", weapons_PT));
        }
        if (!weapons_SG.isEmpty()) {
            icon = new ItemStack((ItemLike)ModItems.M870_CLASSIC.get());
            icon.m_41784_().m_128405_("AmmoCount", ((TimelessGunItem)ModItems.M870_CLASSIC.get()).getGun().getReloads().getMaxAmmo());
            this.tabs.add(new Tab(icon, "weapons_sg", weapons_SG));
        }
        if (!weapons_SMG.isEmpty()) {
            icon = new ItemStack((ItemLike)ModItems.VECTOR45.get());
            icon.m_41784_().m_128405_("AmmoCount", ((GunItem)ModItems.VECTOR45.get()).getGun().getReloads().getMaxAmmo());
            this.tabs.add(new Tab(icon, "weapons_smg", weapons_SMG));
        }
        if (!weapons_SR.isEmpty()) {
            icon = new ItemStack((ItemLike)ModItems.AI_AWP.get());
            icon.m_41784_().m_128405_("AmmoCount", ((TimelessGunItem)ModItems.AI_AWP.get()).getGun().getReloads().getMaxAmmo());
            this.tabs.add(new Tab(icon, "weapons_sr", weapons_SR));
        }
        if (!weapons.isEmpty()) {
            icon = new ItemStack((ItemLike)ModItems.HK416_A5.get());
            icon.m_41784_().m_128405_("AmmoCount", ((TimelessGunItem)ModItems.HK416_A5.get()).getGun().getReloads().getMaxAmmo());
            this.tabs.add(new Tab(icon, "weapons", weapons));
        }
        if (!attachments.isEmpty()) {
            this.tabs.add(new Tab(new ItemStack((ItemLike)ModItems.COYOTE_SIGHT.get()), "attachments", attachments));
        }
        if (!ammo.isEmpty()) {
            this.tabs.add(new Tab(new ItemStack((ItemLike)ModItems.BULLET_30_WIN.get()), "ammo", ammo));
        }
        if (!misc.isEmpty()) {
            this.tabs.add(new Tab(new ItemStack((ItemLike)Items.f_42127_), "misc", misc));
        }
        if (!this.tabs.isEmpty()) {
            this.currentTab = this.tabs.get(0);
        }
    }

    private boolean isAmmo(ItemStack stack) {
        if (stack.m_41720_() instanceof IAmmo) {
            return true;
        }
        ResourceLocation id = stack.m_41720_().getRegistryName();
        Objects.requireNonNull(id);
        for (GunItem gunItem : NetworkGunManager.getClientRegisteredGuns()) {
            if (!id.equals((Object)gunItem.getModifiedGun(stack).getProjectile().getItem())) continue;
            return true;
        }
        return false;
    }

    public void m_7856_() {
        super.m_7856_();
        if (!this.tabs.isEmpty()) {
            this.f_97736_ += 28;
        }
        this.m_142416_((GuiEventListener)new Button(this.f_97735_ + 9, this.f_97736_ + 18, 15, 20, (Component)new TextComponent("<"), button -> {
            int index = this.currentTab.getCurrentIndex();
            if (index - 1 < 0) {
                this.loadItem(this.currentTab.getRecipes().size() - 1);
            } else {
                this.loadItem(index - 1);
            }
        }));
        this.m_142416_((GuiEventListener)new Button(this.f_97735_ + 153, this.f_97736_ + 18, 15, 20, (Component)new TextComponent(">"), button -> {
            int index = this.currentTab.getCurrentIndex();
            if (index + 1 >= this.currentTab.getRecipes().size()) {
                this.loadItem(0);
            } else {
                this.loadItem(index + 1);
            }
        }));
        this.btnCraft = (Button)this.m_142416_((GuiEventListener)new Button(this.f_97735_ + 195, this.f_97736_ + 16, 74, 20, (Component)new TranslatableComponent("gui.tac.workbench.assemble"), button -> {
            int index = this.currentTab.getCurrentIndex();
            WorkbenchRecipe recipe = this.currentTab.getRecipes().get(index);
            ResourceLocation registryName = recipe.m_6423_();
            PacketHandler.getPlayChannel().sendToServer((Object)new MessageCraft(registryName, this.workbench.m_58899_()));
        }));
        this.btnCraft.f_93623_ = false;
        this.checkBoxMaterials = (CheckBox)this.m_142416_((GuiEventListener)new CheckBox(this.f_97735_ + 172, this.f_97736_ + 51, (Component)new TranslatableComponent("gui.tac.workbench.show_remaining")));
        this.checkBoxMaterials.setToggled(showRemaining);
        this.loadItem(this.currentTab.getCurrentIndex());
    }

    protected void m_181908_() {
        super.m_181908_();
        for (MaterialItem material : this.materials) {
            material.update();
        }
        boolean canCraft = true;
        for (MaterialItem material : this.materials) {
            if (material.isEnabled()) continue;
            canCraft = false;
            break;
        }
        this.btnCraft.f_93623_ = canCraft;
        this.updateColor();
    }

    private void updateColor() {
        ItemStack item;
        if (this.currentTab != null && (item = this.displayStack).m_41720_() instanceof IColored && ((IColored)item.m_41720_()).canColor(item)) {
            IColored colored = (IColored)item.m_41720_();
            if (!this.workbench.m_8020_(0).m_41619_()) {
                ItemStack dyeStack = this.workbench.m_8020_(0);
                if (dyeStack.m_41720_() instanceof DyeItem) {
                    DyeColor color = ((DyeItem)dyeStack.m_41720_()).m_41089_();
                    float[] components = color.m_41068_();
                    int red = (int)(components[0] * 255.0f);
                    int green = (int)(components[1] * 255.0f);
                    int blue = (int)(components[2] * 255.0f);
                    colored.setColor(item, (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF);
                } else {
                    colored.removeColor(item);
                }
            } else {
                colored.removeColor(item);
            }
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        boolean result = super.m_6375_(mouseX, mouseY, mouseButton);
        showRemaining = this.checkBoxMaterials.isToggled();
        for (int i = 0; i < this.tabs.size(); ++i) {
            if (!RenderUtil.isMouseWithin((int)mouseX, (int)mouseY, this.f_97735_ + 28 * i, this.f_97736_ - 28, 28, 28)) continue;
            this.currentTab = this.tabs.get(i);
            this.loadItem(this.currentTab.getCurrentIndex());
            this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
            return true;
        }
        return result;
    }

    private void loadItem(int index) {
        WorkbenchRecipe recipe = this.currentTab.getRecipes().get(index);
        this.displayStack = recipe.getItem().m_41777_();
        this.updateColor();
        this.materials.clear();
        ImmutableList<Pair<Ingredient, Integer>> materials = recipe.getMaterials();
        if (materials != null) {
            for (Pair material : materials) {
                MaterialItem item = new MaterialItem((Ingredient)material.getFirst(), (Integer)material.getSecond());
                item.update();
                this.materials.add(item);
            }
            this.currentTab.setCurrentIndex(index);
        }
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        int i;
        this.m_7333_(matrixStack);
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        this.m_7025_(matrixStack, mouseX, mouseY);
        int startX = this.f_97735_;
        int startY = this.f_97736_;
        for (i = 0; i < this.tabs.size(); ++i) {
            if (!RenderUtil.isMouseWithin(mouseX, mouseY, startX + 28 * i, startY - 28, 28, 28)) continue;
            this.m_96602_(matrixStack, (Component)new TranslatableComponent(this.tabs.get(i).getTabKey()), mouseX, mouseY);
            return;
        }
        if (this.filteredMaterials == null) {
            return;
        }
        for (i = 0; i < this.filteredMaterials.size(); ++i) {
            MaterialItem materialItem;
            int itemX = startX + 172;
            int itemY = startY + i * 19 + 63;
            if (!RenderUtil.isMouseWithin(mouseX, mouseY, itemX, itemY, 80, 19) || (materialItem = this.filteredMaterials.get(i)).getStack().m_41619_()) continue;
            this.m_6057_(matrixStack, materialItem.getStack(), mouseX, mouseY);
            return;
        }
        if (RenderUtil.isMouseWithin(mouseX, mouseY, startX + 8, startY + 38, 160, 48)) {
            this.m_6057_(matrixStack, this.displayStack, mouseX, mouseY);
        }
    }

    protected void m_7027_(PoseStack matrixStack, int mouseX, int mouseY) {
        int offset = this.tabs.isEmpty() ? 0 : 28;
        this.f_96547_.m_92889_(matrixStack, this.f_96539_, (float)this.f_97728_, (float)this.f_97729_ - 28.0f + (float)offset, 0x404040);
    }

    protected void m_7286_(PoseStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        ItemStack currentItem;
        int i;
        partialTicks = Minecraft.m_91087_().m_91296_();
        int startX = this.f_97735_;
        int startY = this.f_97736_;
        RenderSystem.m_69478_();
        for (i = 0; i < this.tabs.size(); ++i) {
            Tab tab = this.tabs.get(i);
            if (tab == this.currentTab) continue;
            RenderSystem.m_157456_((int)0, (ResourceLocation)GUI_BASE);
            this.m_93228_(matrixStack, startX + 28 * i, startY - 28, 80, 184, 28, 32);
            Minecraft.m_91087_().m_91291_().m_115203_(tab.getIcon(), startX + 28 * i + 6, startY - 28 + 8);
            Minecraft.m_91087_().m_91291_().m_115174_(this.f_96547_, tab.getIcon(), startX + 28 * i + 6, startY - 28 + 8, null);
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)GUI_BASE);
        this.m_93228_(matrixStack, startX, startY, 0, 0, 173, 184);
        WorkbenchScreen.m_93160_((PoseStack)matrixStack, (int)(startX + 173), (int)startY, (int)78, (int)184, (float)173.0f, (float)0.0f, (int)1, (int)184, (int)256, (int)256);
        this.m_93228_(matrixStack, startX + 251, startY, 174, 0, 24, 184);
        this.m_93228_(matrixStack, startX + 172, startY + 16, 198, 0, 20, 20);
        if (this.currentTab != null) {
            i = this.tabs.indexOf(this.currentTab);
            int u = i == 0 ? 80 : 108;
            RenderSystem.m_157456_((int)0, (ResourceLocation)GUI_BASE);
            this.m_93228_(matrixStack, startX + 28 * i, startY - 28, u, 214, 28, 32);
            Minecraft.m_91087_().m_91291_().m_115203_(this.currentTab.getIcon(), startX + 28 * i + 6, startY - 28 + 8);
            Minecraft.m_91087_().m_91291_().m_115174_(this.f_96547_, this.currentTab.getIcon(), startX + 28 * i + 6, startY - 28 + 8, null);
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)GUI_BASE);
        if (this.workbench.m_8020_(0).m_41619_()) {
            this.m_93228_(matrixStack, startX + 174, startY + 18, 165, 199, 16, 16);
        }
        if ((currentItem = this.displayStack) == null) {
            return;
        }
        StringBuilder builder = new StringBuilder(currentItem.m_41786_().getString());
        if (currentItem.m_41613_() > 1) {
            builder.append(ChatFormatting.GOLD);
            builder.append(ChatFormatting.BOLD);
            builder.append(" x ");
            builder.append(currentItem.m_41613_());
        }
        WorkbenchScreen.m_93208_((PoseStack)matrixStack, (Font)this.f_96547_, (String)builder.toString(), (int)(startX + 88), (int)(startY + 22), (int)Color.WHITE.getRGB());
        GL11.glEnable((int)3089);
        RenderUtil.scissor(startX + 8, startY + 17, 160, 70);
        PoseStack modelViewStack = RenderSystem.m_157191_();
        modelViewStack.m_85836_();
        modelViewStack.m_85837_((double)(startX + 88), (double)(startY + 60), 100.0);
        modelViewStack.m_85841_(50.0f, -50.0f, 50.0f);
        modelViewStack.m_85845_(Vector3f.f_122223_.m_122240_(5.0f));
        modelViewStack.m_85845_(Vector3f.f_122225_.m_122240_((float)Minecraft.m_91087_().f_91074_.f_19797_ + partialTicks));
        RenderSystem.m_157182_();
        MultiBufferSource.BufferSource buffer = this.f_96541_.m_91269_().m_110104_();
        if (OverrideModelManager.hasModel(currentItem) && currentItem.m_41720_() instanceof ScopeItem || currentItem.m_41720_() instanceof OldScopeItem || currentItem.m_41720_() instanceof PistolScopeItem) {
            matrixStack.m_85841_(2.0f, 2.0f, 2.0f);
            GunRenderingHandler.get().renderScope((LivingEntity)this.f_96541_.f_91074_, currentItem, ItemTransforms.TransformType.HEAD, matrixStack, (MultiBufferSource)buffer, 0xF000F0, 0.0f);
            matrixStack.m_85841_(0.5f, 0.5f, 0.5f);
        } else if (currentItem.m_41720_() instanceof GunItem) {
            matrixStack.m_85837_(0.0, (double)this.posDelta, 0.0);
            GunRenderingHandler.get().renderWeapon((LivingEntity)this.f_96541_.f_91074_, currentItem, ItemTransforms.TransformType.FIXED, matrixStack, (MultiBufferSource)buffer, 0xF000F0, 0.0f);
        } else {
            Minecraft.m_91087_().m_91291_().m_115143_(currentItem, ItemTransforms.TransformType.FIXED, false, matrixStack, (MultiBufferSource)buffer, 0xF000F0, OverlayTexture.f_118083_, RenderUtil.getModel(currentItem));
        }
        buffer.m_109911_();
        modelViewStack.m_85849_();
        RenderSystem.m_157182_();
        GL11.glDisable((int)3089);
        this.filteredMaterials = this.getMaterials();
        for (int i2 = 0; i2 < this.filteredMaterials.size(); ++i2) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)GUI_BASE);
            MaterialItem materialItem = this.filteredMaterials.get(i2);
            ItemStack stack = materialItem.stack;
            if (stack.m_41619_()) continue;
            Lighting.m_84930_();
            if (materialItem.isEnabled()) {
                this.m_93228_(matrixStack, startX + 172, startY + i2 * 19 + 63, 0, 184, 80, 19);
            } else {
                this.m_93228_(matrixStack, startX + 172, startY + i2 * 19 + 63, 0, 222, 80, 19);
            }
            Object name = stack.m_41786_().getString();
            if (this.f_96547_.m_92895_((String)name) > 55) {
                name = this.f_96547_.m_92834_((String)name, 50).trim() + "...";
            }
            this.f_96547_.m_92883_(matrixStack, (String)name, (float)(startX + 172 + 22), (float)(startY + i2 * 19 + 6 + 63), Color.WHITE.getRGB());
            Minecraft.m_91087_().m_91291_().m_115203_(stack, startX + 172 + 2, startY + i2 * 19 + 1 + 63);
            if (this.checkBoxMaterials.isToggled()) {
                int count = InventoryUtil.getItemStackAmount((Player)Minecraft.m_91087_().f_91074_, stack);
                stack = stack.m_41777_();
                stack.m_41764_(stack.m_41613_() - count);
            }
            Minecraft.m_91087_().m_91291_().m_115174_(this.f_96547_, stack, startX + 172 + 2, startY + i2 * 19 + 1 + 63, null);
        }
    }

    private List<MaterialItem> getMaterials() {
        NonNullList materials = NonNullList.m_122780_((int)6, (Object)new MaterialItem());
        List filteredMaterials = this.materials.stream().filter(materialItem -> this.checkBoxMaterials.isToggled() ? !materialItem.isEnabled() : !materialItem.stack.m_41619_()).collect(Collectors.toList());
        for (int i = 0; i < filteredMaterials.size() && i < materials.size(); ++i) {
            materials.set(i, (MaterialItem)filteredMaterials.get(i));
        }
        return materials;
    }

    public List<Tab> getTabs() {
        return ImmutableList.copyOf(this.tabs);
    }

    private static class Tab {
        private final ItemStack icon;
        private final String id;
        private final List<WorkbenchRecipe> items;
        private int currentIndex;

        public Tab(ItemStack icon, String id, List<WorkbenchRecipe> items) {
            this.icon = icon;
            this.id = id;
            this.items = items;
        }

        public ItemStack getIcon() {
            return this.icon;
        }

        public String getTabKey() {
            return "gui.tac.workbench.tab." + this.id;
        }

        public void setCurrentIndex(int currentIndex) {
            this.currentIndex = currentIndex;
        }

        public int getCurrentIndex() {
            return this.currentIndex;
        }

        public List<WorkbenchRecipe> getRecipes() {
            return this.items;
        }
    }

    public static class MaterialItem {
        public static final MaterialItem EMPTY = new MaterialItem();
        private boolean enabled = false;
        private final int count;
        private int tickcount;
        private int index;
        private ItemStack stack;
        private final Ingredient ingredient;
        private final ItemStack[] matchingstacks;

        private MaterialItem() {
            this.ingredient = null;
            this.matchingstacks = new ItemStack[]{ItemStack.f_41583_};
            this.stack = ItemStack.f_41583_;
            this.count = 0;
        }

        private MaterialItem(Ingredient ingredient, int count) {
            this.ingredient = ingredient;
            this.matchingstacks = ingredient.m_43908_();
            this.stack = this.matchingstacks[0];
            this.count = count;
        }

        public ItemStack getStack() {
            return this.stack;
        }

        public void update() {
            if (++this.tickcount % 20 == 0) {
                this.tickcount = 0;
                ++this.index;
                if (this.index == this.matchingstacks.length) {
                    this.index = 0;
                }
                this.stack = this.matchingstacks[this.index];
            }
            if (this.ingredient != null) {
                this.stack.m_41764_(this.count);
                this.enabled = InventoryUtil.hasIngredient((Player)Minecraft.m_91087_().f_91074_, (Pair<Ingredient, Integer>)new Pair((Object)this.ingredient, (Object)this.count));
            }
        }

        public boolean isEnabled() {
            return this.stack.m_41619_() || this.enabled;
        }
    }
}

