/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.client.render.animation.module;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import com.tac.guns.client.render.animation.module.AnimationMeta;
import com.tac.guns.client.render.animation.module.AnimationSoundMeta;
import com.tac.guns.client.render.animation.module.Animations;
import com.tac.guns.common.Gun;
import com.tac.guns.item.GunItem;
import com.tac.guns.network.PacketHandler;
import com.tac.guns.network.message.MessageAnimationRun;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class GunAnimationController {
    private AnimationMeta previousAnimation;
    private AnimationSoundMeta previousSound;
    private static final Map<ResourceLocation, GunAnimationController> animationControllerMap = new HashMap<ResourceLocation, GunAnimationController>();

    protected void enableStaticState() {
        AnimationMeta staticMeta = this.getAnimationFromLabel(AnimationLabel.STATIC);
        if (staticMeta != null) {
            try {
                for (AnimationLabel label : AnimationLabel.values()) {
                    AnimationMeta meta = this.getAnimationFromLabel(label);
                    if (meta == null) continue;
                    Animations.specifyInitialModel(meta, staticMeta);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void runAnimation(AnimationMeta animationMeta, AnimationSoundMeta soundMeta, Runnable callback) {
        if (animationMeta != null) {
            Animations.runAnimation(animationMeta, callback);
            this.previousAnimation = animationMeta;
        }
        if (animationMeta != null && soundMeta != null) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player == null) {
                return;
            }
            if (animationMeta.getResourceLocation() == null || soundMeta.getResourceLocation() == null) {
                return;
            }
            MessageAnimationRun message = new MessageAnimationRun(animationMeta.getResourceLocation(), soundMeta.getResourceLocation(), true, player.m_142081_());
            PacketHandler.getPlayChannel().sendToServer((Object)message);
            this.previousSound = soundMeta;
        }
    }

    public boolean isAnimationRunning() {
        return Animations.isAnimationRunning(this.previousAnimation);
    }

    public AnimationMeta getPreviousAnimation() {
        return this.previousAnimation;
    }

    public void stopAnimation() {
        if (this.previousAnimation != null) {
            Animations.stopAnimation(this.previousAnimation);
        }
        if (this.previousAnimation != null && this.previousSound != null) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player == null) {
                return;
            }
            MessageAnimationRun message = new MessageAnimationRun(this.previousAnimation.getResourceLocation(), this.previousSound.getResourceLocation(), false, player.m_142081_());
            PacketHandler.getPlayChannel().sendToServer((Object)message);
        }
    }

    public void runAnimation(AnimationLabel label) {
        this.runAnimation(this.getAnimationFromLabel(label), this.getSoundFromLabel(label), null);
    }

    public void runAnimation(AnimationLabel label, Runnable callback) {
        this.runAnimation(this.getAnimationFromLabel(label), this.getSoundFromLabel(label), callback);
    }

    public abstract AnimationMeta getAnimationFromLabel(AnimationLabel var1);

    protected abstract int getAttachmentsNodeIndex();

    protected abstract int getRightHandNodeIndex();

    protected abstract int getLeftHandNodeIndex();

    public AnimationSoundMeta getSoundFromLabel(AnimationLabel label) {
        return null;
    }

    protected AnimationSoundMeta getSoundFromLabel(Item item, AnimationLabel label) {
        if (item instanceof GunItem) {
            GunItem gunItem = (GunItem)item;
            Gun.Sounds sounds = gunItem.getGun().getSounds();
            switch (label) {
                case RELOAD_EMPTY: {
                    return new AnimationSoundMeta(sounds.getReloadEmpty());
                }
                case RELOAD_NORMAL: {
                    return new AnimationSoundMeta(sounds.getReloadNormal());
                }
                case DRAW: {
                    return new AnimationSoundMeta(sounds.getDraw());
                }
                case INSPECT: {
                    return new AnimationSoundMeta(sounds.getInspect());
                }
                case INSPECT_EMPTY: {
                    return new AnimationSoundMeta(sounds.getInspectEmpty());
                }
            }
            return null;
        }
        return null;
    }

    public void applyAttachmentsTransform(ItemStack itemStack, ItemTransforms.TransformType transformType, LivingEntity entity, PoseStack matrixStack) {
        boolean isFirstPerson = transformType.m_111841_();
        if (isFirstPerson) {
            Animations.pushNode(this.previousAnimation, this.getAttachmentsNodeIndex());
        }
        Animations.applyAnimationTransform(itemStack, ItemTransforms.TransformType.NONE, entity, matrixStack);
        if (isFirstPerson) {
            Animations.popNode();
        }
    }

    public void applySpecialModelTransform(BakedModel model, int index, ItemTransforms.TransformType transformType, PoseStack matrixStack) {
        boolean isFirstPerson = transformType.m_111841_();
        if (isFirstPerson) {
            Animations.pushNode(this.previousAnimation, index);
        }
        Animations.applyAnimationTransform(model, ItemTransforms.TransformType.NONE, matrixStack);
        if (isFirstPerson) {
            Animations.popNode();
        }
    }

    public void applyTransform(ItemStack itemStack, int index, ItemTransforms.TransformType transformType, LivingEntity entity, PoseStack matrixStack) {
        boolean isFirstPerson = transformType.m_111841_();
        if (isFirstPerson) {
            Animations.pushNode(this.previousAnimation, index);
        }
        Animations.applyAnimationTransform(itemStack, ItemTransforms.TransformType.NONE, entity, matrixStack);
        if (isFirstPerson) {
            Animations.popNode();
        }
    }

    public void applyRightHandTransform(PoseStack matrixStack) {
        if (this.previousAnimation != null) {
            Animations.pushNode(this.previousAnimation, this.getRightHandNodeIndex());
            matrixStack.m_85837_(-0.5, -0.5, -0.5);
            Matrix4f animationTransition = new Matrix4f(Animations.peekNodeModel().computeGlobalTransform(null));
            animationTransition.m_27659_();
            matrixStack.m_85850_().m_85861_().m_27644_(animationTransition);
            Animations.popNode();
        }
    }

    public void applyLeftHandTransform(PoseStack matrixStack) {
        if (this.previousAnimation != null) {
            Animations.pushNode(this.previousAnimation, this.getLeftHandNodeIndex());
            matrixStack.m_85837_(-0.5, -0.5, -0.5);
            Matrix4f animationTransition = new Matrix4f(Animations.peekNodeModel().computeGlobalTransform(null));
            animationTransition.m_27659_();
            matrixStack.m_85850_().m_85861_().m_27644_(animationTransition);
            Animations.popNode();
        }
    }

    public boolean isAnimationRunning(AnimationLabel label) {
        if (!this.isAnimationRunning()) {
            return false;
        }
        if (this.previousAnimation == null) {
            return false;
        }
        AnimationMeta meta = this.getAnimationFromLabel(label);
        if (meta == null) {
            return false;
        }
        return meta.equals(this.previousAnimation);
    }

    public static void setAnimationControllerMap(ResourceLocation itemRegistryName, GunAnimationController animationController) {
        animationControllerMap.put(itemRegistryName, animationController);
    }

    public static GunAnimationController fromItem(Item item) {
        return animationControllerMap.get(item.getRegistryName());
    }

    public static GunAnimationController fromRegistryName(ResourceLocation registryName) {
        return animationControllerMap.get(registryName);
    }

    public static enum AnimationLabel {
        RELOAD_NORMAL,
        RELOAD_EMPTY,
        RELOAD_INTRO,
        RELOAD_LOOP,
        RELOAD_NORMAL_END,
        RELOAD_EMPTY_END,
        PUMP,
        PULL_BOLT,
        INSPECT,
        INSPECT_EMPTY,
        DRAW,
        STATIC;

    }
}

