/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.client.render.animation.module;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import com.tac.guns.client.render.animation.module.AnimationMeta;
import de.javagl.jgltf.model.GltfAnimations;
import de.javagl.jgltf.model.NodeModel;
import de.javagl.jgltf.model.animation.Animation;
import de.javagl.jgltf.model.animation.AnimationManager;
import de.javagl.jgltf.model.animation.AnimationRunner;
import de.javagl.jgltf.model.io.GltfAsset;
import de.javagl.jgltf.model.io.GltfAssetReader;
import de.javagl.jgltf.model.io.v2.GltfAssetV2;
import de.javagl.jgltf.model.v2.GltfModelV2;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class Animations {
    private static final Stack<NodeModel> nodeModelStack = new Stack();
    private static final Stack<NodeModel> initialModelStack = new Stack();
    private static final PoseStack extraMatrixStack = new PoseStack();
    private static NodeModel bind;
    private static NodeModel initial;
    private static final Map<String, GltfModelV2> gltfModelV2Map;
    private static final Map<String, GltfModelV2> initialModelMap;
    private static final Map<String, AnimationRunner> animationRunnerMap;
    private static final Map<String, AnimationManager> animationManagerMap;

    public static GltfModelV2 load(AnimationMeta animationMeta) throws IOException {
        if (animationMeta != null) {
            return Animations.load(animationMeta.getResourceLocation());
        }
        return null;
    }

    public static GltfModelV2 load(ResourceLocation resourceLocation) throws IOException {
        GltfAssetReader reader = new GltfAssetReader();
        Resource resource = Minecraft.m_91087_().m_91098_().m_142591_(resourceLocation);
        InputStream inputStream = resource.m_6679_();
        GltfAsset asset = reader.readWithoutReferences(inputStream);
        if (asset instanceof GltfAssetV2) {
            GltfModelV2 model = new GltfModelV2((GltfAssetV2)asset);
            gltfModelV2Map.put(resourceLocation.toString(), model);
            List<Animation> animations = GltfAnimations.createModelAnimations(model.getAnimationModels());
            AnimationManager animationManager = new AnimationManager(AnimationManager.AnimationPolicy.TIP_STOP);
            animationManager.addAnimations(animations);
            animationManagerMap.put(resourceLocation.toString(), animationManager);
            Animations.stopAnimation(resourceLocation);
            AnimationRunner newRunner = new AnimationRunner(animationManager);
            animationRunnerMap.put(resourceLocation.toString(), newRunner);
            GltfModelV2 model2 = new GltfModelV2((GltfAssetV2)asset);
            List<Animation> animations2 = GltfAnimations.createModelAnimations(model2.getAnimationModels());
            AnimationManager initialStateManager = new AnimationManager(AnimationManager.AnimationPolicy.TIP_STOP);
            initialStateManager.addAnimations(animations2);
            initialStateManager.reset();
            initialStateManager.performStep(1L);
            initialModelMap.put(resourceLocation.toString(), model2);
            return model;
        }
        inputStream.close();
        return null;
    }

    public static void specifyInitialModel(AnimationMeta animationMeta, AnimationMeta initialMeta) throws IOException {
        Resource initialResource = Minecraft.m_91087_().m_91098_().m_142591_(initialMeta.getResourceLocation());
        InputStream inputStream = initialResource.m_6679_();
        GltfAssetReader reader = new GltfAssetReader();
        GltfAsset asset = reader.readWithoutReferences(inputStream);
        GltfModelV2 model2 = new GltfModelV2((GltfAssetV2)asset);
        List<Animation> animations2 = GltfAnimations.createModelAnimations(model2.getAnimationModels());
        AnimationManager initialStateManager = new AnimationManager(AnimationManager.AnimationPolicy.TIP_STOP);
        initialStateManager.addAnimations(animations2);
        initialStateManager.reset();
        initialStateManager.performStep(1L);
        initialModelMap.put(animationMeta.getResourceLocation().toString(), model2);
    }

    private static GltfModelV2 getGltfModel(ResourceLocation resourceLocation) {
        return gltfModelV2Map.get(resourceLocation.toString());
    }

    private static GltfModelV2 getInitialModel(ResourceLocation resourceLocation) {
        return initialModelMap.get(resourceLocation.toString());
    }

    public static void pushNode(AnimationMeta animationMeta, int index) {
        if (animationMeta != null) {
            Animations.pushNode(animationMeta.getResourceLocation(), index);
        }
    }

    public static void pushNode(ResourceLocation gltfResource, int index) {
        if (gltfResource == null) {
            return;
        }
        GltfModelV2 gltfModel = Animations.getGltfModel(gltfResource);
        bind = gltfModel == null ? null : gltfModel.getNodeModels().get(index);
        GltfModelV2 initialModel = Animations.getInitialModel(gltfResource);
        initial = initialModel == null ? null : initialModel.getNodeModels().get(index);
        nodeModelStack.push(bind);
        initialModelStack.push(initial);
    }

    public static void popNode() {
        if (!nodeModelStack.empty()) {
            nodeModelStack.pop();
        }
        if (!initialModelStack.empty()) {
            initialModelStack.pop();
        }
        bind = nodeModelStack.empty() ? null : nodeModelStack.peek();
        initial = initialModelStack.empty() ? null : initialModelStack.peek();
    }

    public static NodeModel peekNodeModel() {
        return bind;
    }

    public static NodeModel peekInitialModel() {
        return initial;
    }

    public static AnimationRunner getAnimationRunner(ResourceLocation resourceLocation) {
        return animationRunnerMap.get(resourceLocation.toString());
    }

    public static void runAnimation(AnimationMeta animationMeta) {
        if (animationMeta != null) {
            Animations.runAnimation(animationMeta.getResourceLocation());
        }
    }

    public static void runAnimation(ResourceLocation resourceLocation) {
        Animations.runAnimation(resourceLocation, null);
    }

    public static void runAnimation(AnimationMeta animationMeta, Runnable callback) {
        if (animationMeta != null) {
            Animations.runAnimation(animationMeta.getResourceLocation(), callback);
        }
    }

    public static void runAnimation(ResourceLocation resourceLocation, Runnable callback) {
        AnimationRunner runner = Animations.getAnimationRunner(resourceLocation);
        if (runner != null) {
            if (runner.isRunning()) {
                return;
            }
            runner.start(callback);
        }
    }

    public static void stopAnimation(AnimationMeta animationMeta) {
        if (animationMeta != null) {
            Animations.stopAnimation(animationMeta.getResourceLocation());
        }
    }

    public static void stopAnimation(ResourceLocation resourceLocation) {
        AnimationManager manager;
        AnimationRunner runner = Animations.getAnimationRunner(resourceLocation);
        if (runner != null) {
            runner.stop();
        }
        if ((manager = Animations.getAnimationManager(resourceLocation)) != null) {
            manager.reset();
            manager.performStep(0L);
        }
    }

    public static boolean isAnimationRunning(AnimationMeta animationMeta) {
        if (animationMeta != null) {
            return Animations.isAnimationRunning(animationMeta.getResourceLocation());
        }
        return false;
    }

    public static boolean isAnimationRunning(ResourceLocation resourceLocation) {
        AnimationRunner runner = Animations.getAnimationRunner(resourceLocation);
        if (runner == null) {
            return false;
        }
        return runner.isRunning();
    }

    private static AnimationManager getAnimationManager(ResourceLocation resourceLocation) {
        return animationManagerMap.get(resourceLocation.toString());
    }

    public static PoseStack getExtraMatrixStack() {
        return extraMatrixStack;
    }

    public static void applyExtraTransform(PoseStack matrixStack) {
        matrixStack.m_85850_().m_85861_().m_27644_(extraMatrixStack.m_85850_().m_85861_());
        matrixStack.m_85850_().m_85864_().m_8178_(extraMatrixStack.m_85850_().m_85864_());
    }

    public static void applyAnimationTransform(ItemStack itemStack, ItemTransforms.TransformType transformType, LivingEntity entity, PoseStack matrixStack) {
        if (itemStack != null && entity != null) {
            BakedModel model = Minecraft.m_91087_().m_91291_().m_174264_(itemStack, entity.f_19853_, entity, entity.m_142049_());
            Animations.applyAnimationTransform(model, transformType, matrixStack);
        }
    }

    public static void applyAnimationTransform(BakedModel model, ItemTransforms.TransformType transformType, PoseStack matrixStack) {
        if (Animations.peekNodeModel() != null && Animations.peekInitialModel() != null) {
            ItemTransform modelTransformVec3f;
            ItemTransform itemTransform = modelTransformVec3f = model == null ? null : model.m_7442_().m_111808_(transformType);
            if (modelTransformVec3f != null) {
                matrixStack.m_85837_((double)modelTransformVec3f.f_111756_.m_122239_(), (double)modelTransformVec3f.f_111756_.m_122260_(), (double)modelTransformVec3f.f_111756_.m_122269_());
                matrixStack.m_85841_(modelTransformVec3f.f_111757_.m_122239_(), modelTransformVec3f.f_111757_.m_122260_(), modelTransformVec3f.f_111757_.m_122269_());
                matrixStack.m_85837_(-0.5, -0.5, -0.5);
            }
            Matrix4f animationTransition = new Matrix4f(Animations.peekNodeModel().computeGlobalTransform(null));
            Matrix4f initialTransition = new Matrix4f(Animations.peekInitialModel().computeGlobalTransform(null));
            animationTransition.m_27659_();
            initialTransition.m_27659_();
            initialTransition.m_27657_();
            matrixStack.m_85850_().m_85861_().m_27644_(animationTransition);
            matrixStack.m_85850_().m_85861_().m_27644_(initialTransition);
            if (modelTransformVec3f != null) {
                matrixStack.m_85837_(0.5, 0.5, 0.5);
                matrixStack.m_85841_(1.0f / modelTransformVec3f.f_111757_.m_122239_(), 1.0f / modelTransformVec3f.f_111757_.m_122260_(), 1.0f / modelTransformVec3f.f_111757_.m_122269_());
                matrixStack.m_85837_((double)(-modelTransformVec3f.f_111756_.m_122239_()), (double)(-modelTransformVec3f.f_111756_.m_122260_()), (double)(-modelTransformVec3f.f_111756_.m_122269_()));
            }
        }
        Animations.applyExtraTransform(matrixStack);
    }

    static {
        gltfModelV2Map = new HashMap<String, GltfModelV2>();
        initialModelMap = new HashMap<String, GltfModelV2>();
        animationRunnerMap = new HashMap<String, AnimationRunner>();
        animationManagerMap = new HashMap<String, AnimationManager>();
    }
}

