/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.client.render.animation.module;

import com.tac.guns.client.render.animation.module.AnimationMeta;
import com.tac.guns.client.render.animation.module.AnimationSoundMeta;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.EntityBoundSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public enum AnimationSoundManager {
    INSTANCE;

    private final Map<UUID, Map<ResourceLocation, SoundInstance>> soundsMap = new HashMap<UUID, Map<ResourceLocation, SoundInstance>>();

    public void playerSound(Player player, AnimationMeta animationMeta, AnimationSoundMeta soundMeta) {
        EntityBoundSoundInstance entityTickableSound;
        Map map = this.soundsMap.computeIfAbsent(player.m_142081_(), k -> new HashMap());
        SoundInstance sound = (SoundInstance)map.get(animationMeta.getResourceLocation());
        if (sound == null) {
            SoundEvent soundEvent = new SoundEvent(soundMeta.getResourceLocation());
            sound = new EntityBoundSoundInstance(soundEvent, SoundSource.PLAYERS, 1.0f, 1.0f, (Entity)player);
        }
        if (sound instanceof EntityBoundSoundInstance && (entityTickableSound = (EntityBoundSoundInstance)sound).m_7801_()) {
            SoundEvent soundEvent = new SoundEvent(soundMeta.getResourceLocation());
            sound = new EntityBoundSoundInstance(soundEvent, SoundSource.PLAYERS, 1.0f, 1.0f, (Entity)player);
        }
        if (Minecraft.m_91087_().m_91106_().m_120403_(sound)) {
            return;
        }
        Minecraft.m_91087_().m_91106_().m_120367_(sound);
        map.put(animationMeta.getResourceLocation(), sound);
    }

    public void onPlayerDeath(Player player) {
        Map map = this.soundsMap.computeIfAbsent(player.m_142081_(), k -> new HashMap());
        for (SoundInstance sound : map.values()) {
            Minecraft.m_91087_().m_91106_().m_120399_(sound);
        }
        this.soundsMap.remove(player.m_142081_());
    }

    public void interruptSound(Player player, AnimationMeta animationMeta) {
        Map<ResourceLocation, SoundInstance> map = this.soundsMap.get(player.m_142081_());
        if (map != null) {
            SoundInstance sound = map.get(animationMeta.getResourceLocation());
            if (sound != null) {
                Minecraft.m_91087_().m_91106_().m_120399_(sound);
            }
            map.remove(animationMeta.getResourceLocation());
        }
    }
}

