/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.client.network;

import com.tac.guns.Config;
import com.tac.guns.client.BulletTrail;
import com.tac.guns.client.CustomGunManager;
import com.tac.guns.client.CustomRigManager;
import com.tac.guns.client.audio.GunShotSound;
import com.tac.guns.client.handler.BulletTrailRenderingHandler;
import com.tac.guns.client.handler.GunRenderingHandler;
import com.tac.guns.client.handler.HUDRenderingHandler;
import com.tac.guns.client.render.animation.module.AnimationMeta;
import com.tac.guns.client.render.animation.module.AnimationSoundManager;
import com.tac.guns.client.render.animation.module.AnimationSoundMeta;
import com.tac.guns.common.NetworkGunManager;
import com.tac.guns.common.NetworkRigManager;
import com.tac.guns.init.ModParticleTypes;
import com.tac.guns.network.message.MessageBlood;
import com.tac.guns.network.message.MessageBulletTrail;
import com.tac.guns.network.message.MessageGunSound;
import com.tac.guns.network.message.MessageProjectileHitBlock;
import com.tac.guns.network.message.MessageProjectileHitEntity;
import com.tac.guns.network.message.MessageRemoveProjectile;
import com.tac.guns.network.message.MessageStunGrenade;
import com.tac.guns.network.message.MessageUpdateGuns;
import com.tac.guns.network.message.MessageUpdateRigs;
import com.tac.guns.particles.BulletHoleData;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;

public class ClientPlayHandler {
    public static void handleMessageGunSound(MessageGunSound message) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        if (message.showMuzzleFlash()) {
            GunRenderingHandler.get().showMuzzleFlashForPlayer(message.getShooterId());
        }
        if (message.getShooterId() == mc.f_91074_.m_142049_()) {
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)new SimpleSoundInstance(message.getId(), SoundSource.PLAYERS, (float)((double)message.getVolume() * (Double)Config.CLIENT.sounds.weaponsVolume.get()), message.getPitch(), false, 0, SoundInstance.Attenuation.LINEAR, 0.0, 0.0, 0.0, true));
        } else {
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)new GunShotSound(message.getId(), SoundSource.PLAYERS, message.getX(), message.getY(), message.getZ(), message.getVolume(), message.getPitch(), message.isReload()));
        }
    }

    public static void handleMessageAnimationSound(UUID fromWho, ResourceLocation animationResource, ResourceLocation soundResource, boolean play) {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (world == null) {
            return;
        }
        Player player = world.m_46003_(fromWho);
        if (player == null) {
            return;
        }
        if (animationResource == null || soundResource == null) {
            return;
        }
        AnimationMeta animationMeta = new AnimationMeta(animationResource);
        AnimationSoundMeta soundMeta = new AnimationSoundMeta(soundResource);
        if (play) {
            AnimationSoundManager.INSTANCE.playerSound(player, animationMeta, soundMeta);
        } else {
            AnimationSoundManager.INSTANCE.interruptSound(player, animationMeta);
        }
    }

    public static void handleMessageBlood(MessageBlood message) {
        if (!((Boolean)Config.CLIENT.particle.enableBlood.get()).booleanValue()) {
            return;
        }
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (world != null) {
            for (int i = 0; i < 10; ++i) {
                world.m_6493_((ParticleOptions)ModParticleTypes.BLOOD.get(), true, message.getX(), message.getY(), message.getZ(), 0.5, 0.0, 0.5);
            }
        }
    }

    public static void handleMessageBulletTrail(MessageBulletTrail message) {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (world != null) {
            int[] entityIds = message.getEntityIds();
            Vec3[] positions = message.getPositions();
            Vec3[] motions = message.getMotions();
            float[] shooterYaws = message.getShooterYaws();
            float[] shooterPitch = message.getShooterPitches();
            ItemStack item = message.getItem();
            int trailColor = message.getTrailColor();
            double trailLengthMultiplier = message.getTrailLengthMultiplier();
            int life = message.getLife();
            double gravity = message.getGravity();
            int shooterId = message.getShooterId();
            for (int i = 0; i < message.getCount(); ++i) {
                BulletTrailRenderingHandler.get().add(new BulletTrail(entityIds[i], positions[i], motions[i], shooterYaws[i], shooterPitch[i], item, trailColor, trailLengthMultiplier, life, gravity, shooterId, message.getCount()));
            }
        }
    }

    public static void handleExplosionStunGrenade(MessageStunGrenade message) {
        int i;
        Minecraft mc = Minecraft.m_91087_();
        ParticleEngine particleManager = mc.f_91061_;
        ClientLevel world = mc.f_91073_;
        double x = message.getX();
        double y = message.getY();
        double z = message.getZ();
        for (i = 0; i < 30; ++i) {
            ClientPlayHandler.spawnParticle(particleManager, (ParticleOptions)ParticleTypes.f_123796_, x, y, z, world.f_46441_, 0.2);
        }
        for (i = 0; i < 30; ++i) {
            Particle smoke = ClientPlayHandler.spawnParticle(particleManager, (ParticleOptions)ParticleTypes.f_123762_, x, y, z, world.f_46441_, 4.0);
            smoke.m_107257_((int)(8.0 / (Math.random() * 0.1 + 0.4) * 0.5));
            ClientPlayHandler.spawnParticle(particleManager, (ParticleOptions)ParticleTypes.f_123797_, x, y, z, world.f_46441_, 4.0);
        }
    }

    private static Particle spawnParticle(ParticleEngine manager, ParticleOptions data, double x, double y, double z, Random rand, double velocityMultiplier) {
        return manager.m_107370_(data, x, y, z, (rand.nextDouble() - 0.5) * velocityMultiplier, (rand.nextDouble() - 0.5) * velocityMultiplier, (rand.nextDouble() - 0.5) * velocityMultiplier);
    }

    public static void handleProjectileHitBlock(MessageProjectileHitBlock message) {
        Minecraft mc = Minecraft.m_91087_();
        ClientLevel world = mc.f_91073_;
        if (world != null) {
            BlockState state = world.m_8055_(message.getPos());
            double holeX = message.getX() + 0.005 * (double)message.getFace().m_122429_();
            double holeY = message.getY() + 0.005 * (double)message.getFace().m_122430_();
            double holeZ = message.getZ() + 0.005 * (double)message.getFace().m_122431_();
            double distance = Math.sqrt(mc.f_91074_.m_20275_(message.getX(), message.getY(), message.getZ()));
            world.m_6493_((ParticleOptions)new BulletHoleData(message.getFace(), message.getPos()), false, holeX, holeY, holeZ, 0.0, 0.0, 0.0);
            if (distance < 16.0) {
                for (int i = 0; i < 3; ++i) {
                    Vec3i normal = message.getFace().m_122436_();
                    Vec3 motion = new Vec3((double)normal.m_123341_(), (double)normal.m_123342_(), (double)normal.m_123343_());
                    motion.m_82520_(ClientPlayHandler.getRandomDir(world.f_46441_), ClientPlayHandler.getRandomDir(world.f_46441_), ClientPlayHandler.getRandomDir(world.f_46441_));
                    world.m_6493_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, state), false, message.getX(), message.getY(), message.getZ(), 0.0, 0.0, 0.0);
                }
            }
            if (distance < 32.0) {
                world.m_7785_(message.getX(), message.getY(), message.getZ(), state.m_60827_().m_56775_(), SoundSource.BLOCKS, 0.75f, 2.0f, false);
            }
        }
    }

    private static double getRandomDir(Random random) {
        return -0.25 + random.nextDouble() * 0.5;
    }

    public static void handleProjectileHitEntity(MessageProjectileHitEntity message) {
        Minecraft mc = Minecraft.m_91087_();
        ClientLevel world = mc.f_91073_;
        if (world == null) {
            return;
        }
        HUDRenderingHandler.get().hitMarkerTracker = 14.0f;
        HUDRenderingHandler.get().hitMarkerHeadshot = message.isHeadshot();
        SoundEvent event = ClientPlayHandler.getHitSound(message.isCritical(), message.isHeadshot(), message.isPlayer());
        if (event == null) {
            return;
        }
        mc.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)event, (float)1.0f, (float)(1.0f + world.f_46441_.nextFloat() * 0.2f)));
    }

    @Nullable
    private static SoundEvent getHitSound(boolean critical, boolean headshot, boolean player) {
        if (critical) {
            if (((Boolean)Config.CLIENT.sounds.playSoundWhenCritical.get()).booleanValue()) {
                SoundEvent event = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation((String)Config.CLIENT.sounds.criticalSound.get()));
                return event != null ? event : SoundEvents.f_12313_;
            }
        } else if (headshot) {
            if (((Boolean)Config.CLIENT.sounds.playSoundWhenHeadshot.get()).booleanValue()) {
                SoundEvent event = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation((String)Config.CLIENT.sounds.headshotSound.get()));
                return event != null ? event : SoundEvents.f_12314_;
            }
        } else {
            if (player) {
                return SoundEvents.f_12323_;
            }
            return SoundEvents.f_12318_;
        }
        return null;
    }

    public static void handleRemoveProjectile(MessageRemoveProjectile message) {
        BulletTrailRenderingHandler.get().remove(message.getEntityId());
    }

    public static void handleUpdateGuns(MessageUpdateGuns message) {
        NetworkGunManager.updateRegisteredGuns(message);
        CustomGunManager.updateCustomGuns(message);
    }

    public static void handleUpdateRigs(MessageUpdateRigs message) {
        NetworkRigManager.updateRegisteredRigs(message);
        CustomRigManager.updateCustomRigs(message);
    }
}

