/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.client.handler.command;

import com.google.gson.GsonBuilder;
import com.tac.guns.Config;
import com.tac.guns.GunMod;
import com.tac.guns.client.Keys;
import com.tac.guns.client.handler.command.data.ScopeData;
import com.tac.guns.common.Gun;
import com.tac.guns.common.tooling.CommandsHandler;
import com.tac.guns.item.attachment.impl.Scope;
import com.tac.guns.item.transition.TimelessGunItem;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.Level;

@Mod.EventBusSubscriber(modid="tac", value={Dist.CLIENT})
public class ScopeEditor {
    private static ScopeEditor instance;
    public HashMap<String, ScopeData> map = new HashMap();
    private ScopeData scopeData;

    public static ScopeEditor get() {
        if (instance == null) {
            instance = new ScopeEditor();
        }
        return instance;
    }

    private ScopeEditor() {
    }

    public ScopeData getScopeData() {
        return this.scopeData;
    }

    @SubscribeEvent
    public void onKeyPressed(InputEvent.KeyInputEvent event) {
        if (!((Boolean)Config.COMMON.development.enableTDev.get()).booleanValue()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        CommandsHandler ch = CommandsHandler.get();
        if (ch == null || ch.getCatCurrentIndex() != 2) {
            return;
        }
        if (mc.f_91074_.m_21205_() == null || mc.f_91074_.m_21205_() == ItemStack.f_41583_ || !(mc.f_91074_.m_21205_().m_41720_() instanceof TimelessGunItem)) {
            return;
        }
        if (((TimelessGunItem)mc.f_91074_.m_21205_().m_41720_()).isIntegratedOptic().booleanValue()) {
            if (!this.map.containsKey(mc.f_91074_.m_21205_().m_41720_().m_5524_())) {
                this.map.put(mc.f_91074_.m_21205_().m_41720_().m_5524_(), new ScopeData(mc.f_91074_.m_21205_().m_41720_().m_5524_()));
            }
            this.handleScopeMod(event, this.map.get(mc.f_91074_.m_21205_().m_41720_().m_5524_()));
            this.scopeData = this.map.get(mc.f_91074_.m_21205_().m_41720_().m_5524_());
        } else {
            Scope scopeItem = Gun.getScope(mc.f_91074_.m_21205_());
            if (scopeItem == null) {
                return;
            }
            if (!this.map.containsKey(scopeItem.getTagName())) {
                this.map.put(scopeItem.getTagName(), new ScopeData(scopeItem.getTagName()));
            }
            this.handleScopeMod(event, this.map.get(scopeItem.getTagName()));
            this.scopeData = this.map.get(scopeItem.getTagName());
        }
    }

    private void handleScopeMod(InputEvent.KeyInputEvent event, ScopeData data) {
        boolean isAltDown;
        double stepModifier = 1.0;
        boolean isLeft = Keys.LEFT.m_90857_();
        boolean isRight = Keys.RIGHT.m_90857_();
        boolean isUp = Keys.UP.m_90857_();
        boolean isDown = Keys.DOWN.m_90857_();
        boolean isControlDown = Keys.CONTROLLY.m_90857_() || Keys.CONTROLLYR.m_90857_();
        boolean isShiftDown = Keys.SHIFTY.m_90857_() || Keys.SHIFTYR.m_90857_();
        boolean bl = isAltDown = Keys.ALTY.m_90857_() || Keys.ALTYR.m_90857_();
        if (isShiftDown) {
            stepModifier *= 10.0;
        }
        if (isControlDown) {
            stepModifier /= 10.0;
        }
        boolean isPeriodDown = Keys.SIZE_OPT.m_90857_();
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (Keys.P.m_90857_()) {
            if (isShiftDown) {
                stepModifier *= 10.0;
            }
            if (isControlDown) {
                stepModifier /= 10.0;
            }
            player.m_5661_((Component)new TranslatableComponent("DR X: " + data.getDrXZoomMod() + " | DR Y: " + data.getDrYZoomMod() + " | DR Z: " + data.getDrZZoomMod()), true);
            if (isAltDown && isUp) {
                data.setDrZZoomMod(data.getDrZZoomMod() + 0.025 * stepModifier);
                player.m_5661_((Component)new TranslatableComponent("DR Z: " + data.getDrZZoomMod()).m_130940_(ChatFormatting.GREEN), true);
            } else if (isAltDown && isDown) {
                data.setDrZZoomMod(data.getDrZZoomMod() - 0.025 * stepModifier);
                player.m_5661_((Component)new TranslatableComponent("DR Z: " + data.getDrZZoomMod()).m_130940_(ChatFormatting.DARK_RED), true);
            } else if (isPeriodDown && isUp) {
                data.setDrZoomSizeMod((float)((double)data.getDrZoomSizeMod() + (double)0.0075f * (stepModifier *= 10.0)));
                player.m_5661_((Component)new TranslatableComponent("DR Size: " + data.getDrZoomSizeMod()).m_130940_(ChatFormatting.GREEN), true);
            } else if (isPeriodDown && isDown) {
                data.setDrZoomSizeMod((float)((double)data.getDrZoomSizeMod() - (double)0.0075f * (stepModifier *= 10.0)));
                player.m_5661_((Component)new TranslatableComponent("DR Size: " + data.getDrZoomSizeMod()).m_130940_(ChatFormatting.DARK_RED), true);
            } else if (isUp) {
                data.setDrYZoomMod(data.getDrYZoomMod() + 0.025 * stepModifier);
                player.m_5661_((Component)new TranslatableComponent("DR Y: " + data.getDrYZoomMod()).m_130940_(ChatFormatting.GREEN), true);
            } else if (isDown) {
                data.setDrYZoomMod(data.getDrYZoomMod() - 0.025 * stepModifier);
                player.m_5661_((Component)new TranslatableComponent("DR Y: " + data.getDrYZoomMod()).m_130940_(ChatFormatting.DARK_RED), true);
            } else if (isLeft) {
                data.setDrXZoomMod(data.getDrXZoomMod() + 0.025 * stepModifier);
                player.m_5661_((Component)new TranslatableComponent("DR X: " + data.getDrXZoomMod()).m_130940_(ChatFormatting.GREEN), true);
            } else if (isRight) {
                data.setDrXZoomMod(data.getDrXZoomMod() - 0.025 * stepModifier);
                player.m_5661_((Component)new TranslatableComponent("DR X: " + data.getDrXZoomMod()).m_130940_(ChatFormatting.DARK_RED), true);
            }
        } else if (Keys.L.m_90857_()) {
            if (isShiftDown) {
                stepModifier *= 5.0;
            }
            if (isControlDown) {
                stepModifier /= 20.0;
            }
            player.m_5661_((Component)new TranslatableComponent("Reticle X: " + data.getDrXZoomMod() + " | Reticle Y: " + data.getDrYZoomMod() + " | Reticle Z: " + data.getDrZZoomMod() + " | Reticle Size: " + data.getReticleSizeMod()), true);
            if (isAltDown && isUp) {
                data.setReticleZMod(data.getReticleZMod() + 2.5E-4 * stepModifier);
                player.m_5661_((Component)new TranslatableComponent("Reticle Z: " + data.getReticleZMod()).m_130940_(ChatFormatting.GREEN), true);
            } else if (isAltDown && isDown) {
                data.setReticleZMod(data.getReticleZMod() - 2.5E-4 * stepModifier);
                player.m_5661_((Component)new TranslatableComponent("Reticle Z: " + data.getReticleZMod()).m_130940_(ChatFormatting.DARK_RED), true);
            } else if (isPeriodDown && isUp) {
                data.setReticleSizeMod((float)((double)data.getReticleSizeMod() + (double)0.0075f * stepModifier));
                player.m_5661_((Component)new TranslatableComponent("Reticle Size: " + data.getReticleSizeMod()).m_130940_(ChatFormatting.GREEN), true);
            } else if (isPeriodDown && isDown) {
                data.setReticleSizeMod((float)((double)data.getReticleSizeMod() - (double)0.0075f * stepModifier));
                player.m_5661_((Component)new TranslatableComponent("Reticle Size: " + data.getReticleSizeMod()).m_130940_(ChatFormatting.DARK_RED), true);
            } else if (isUp) {
                data.setReticleYMod(data.getReticleYMod() + 2.5E-4 * stepModifier);
                player.m_5661_((Component)new TranslatableComponent("Reticle Y: " + data.getReticleYMod()).m_130940_(ChatFormatting.GREEN), true);
            } else if (isDown) {
                data.setReticleYMod(data.getReticleYMod() - 2.5E-4 * stepModifier);
                player.m_5661_((Component)new TranslatableComponent("Reticle Y: " + data.getReticleYMod()).m_130940_(ChatFormatting.DARK_RED), true);
            } else if (isLeft) {
                data.setReticleXMod(data.getReticleXMod() - 2.5E-4 * stepModifier);
                player.m_5661_((Component)new TranslatableComponent("Reticle X: " + data.getReticleXMod()).m_130940_(ChatFormatting.GREEN), true);
            } else if (isRight) {
                data.setReticleXMod(data.getReticleXMod() + 2.5E-4 * stepModifier);
                player.m_5661_((Component)new TranslatableComponent("Reticle X: " + data.getReticleXMod()).m_130940_(ChatFormatting.DARK_RED), true);
            }
        } else if (Keys.M.m_90857_()) {
            if (isShiftDown) {
                stepModifier *= 10.0;
            }
            if (isControlDown) {
                stepModifier /= 10.0;
            }
            player.m_5661_((Component)new TranslatableComponent("Crop: " + data.getDrZoomCropMod() + " | FOV zoom: " + data.getAdditionalZoomMod()), true);
            if (isUp) {
                data.setDrZoomCropMod((float)((double)data.getDrZoomCropMod() + 0.025 * stepModifier));
                player.m_5661_((Component)new TranslatableComponent("Crop: " + data.getDrZoomCropMod()).m_130940_(ChatFormatting.GREEN), true);
            } else if (isDown) {
                data.setDrZoomCropMod((float)((double)data.getDrZoomCropMod() - 0.025 * stepModifier));
                player.m_5661_((Component)new TranslatableComponent("Crop: " + data.getDrZoomCropMod()).m_130940_(ChatFormatting.DARK_RED), true);
            } else if (isLeft) {
                data.setAdditionalZoomMod((float)((double)data.getAdditionalZoomMod() - 0.025 * stepModifier));
                player.m_5661_((Component)new TranslatableComponent("FOV zoom: " + data.getAdditionalZoomMod()).m_130940_(ChatFormatting.GREEN), true);
            } else if (isRight) {
                data.setAdditionalZoomMod((float)((double)data.getAdditionalZoomMod() + 0.025 * stepModifier));
                player.m_5661_((Component)new TranslatableComponent("FOV zoom: " + data.getAdditionalZoomMod()).m_130940_(ChatFormatting.DARK_RED), true);
            }
        }
    }

    public void resetData() {
    }

    public void exportData() {
        this.map.forEach((name, scope) -> {
            if (this.map.get(name) == null) {
                GunMod.LOGGER.log(Level.ERROR, "SCOPE EDITOR FAILED TO EXPORT THIS BROKEN DATA. CONTACT CLUMSYALIEN.");
                return;
            }
            GsonBuilder gsonB = new GsonBuilder().setLenient().addSerializationExclusionStrategy(Gun.strategy).setPrettyPrinting();
            String jsonString = gsonB.create().toJson(scope);
            this.writeExport(jsonString, (String)name);
        });
    }

    private void writeExport(String jsonString, String name) {
        try {
            File dir = new File((String)Config.COMMON.development.TDevPath.get() + "\\tac_export\\scope_export");
            dir.mkdir();
            FileWriter dataWriter = new FileWriter(dir.getAbsolutePath() + "\\" + name + "_export.json");
            dataWriter.write(jsonString);
            dataWriter.close();
            GunMod.LOGGER.log(Level.INFO, "SCOPE EDITOR EXPORTED FILE ( " + name + "export.txt ). BE PROUD!");
        }
        catch (IOException e) {
            GunMod.LOGGER.log(Level.ERROR, "SCOPE EDITOR FAILED TO EXPORT, NO FILE CREATED!!! NO ACCESS IN PATH?. CONTACT CLUMSYALIEN.");
        }
    }
}

