/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.client.handler.command;

import com.google.gson.GsonBuilder;
import com.tac.guns.Config;
import com.tac.guns.GunMod;
import com.tac.guns.client.Keys;
import com.tac.guns.common.Gun;
import com.tac.guns.common.tooling.CommandsHandler;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.logging.log4j.Level;

public class ObjectRenderEditor {
    private static ObjectRenderEditor instance;
    public int currElement = 0;
    private HashMap<Integer, RENDER_Element> elements = new HashMap();

    public static ObjectRenderEditor get() {
        if (instance == null) {
            instance = new ObjectRenderEditor();
        }
        return instance;
    }

    private ObjectRenderEditor() {
    }

    public RENDER_Element GetFromElements(int index) {
        return this.elements.get(index);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onKeyPressed(InputEvent.KeyInputEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        if (!((Boolean)Config.COMMON.development.enableTDev.get()).booleanValue() && CommandsHandler.get().getCatCurrentIndex() == 4) {
            return;
        }
        if (event.getKey() == 49) {
            this.currElement = 1;
            return;
        }
        if (event.getKey() == 50) {
            this.currElement = 2;
            return;
        }
        if (event.getKey() == 51) {
            this.currElement = 3;
            return;
        }
        if (event.getKey() == 52) {
            this.currElement = 4;
            return;
        }
        if (event.getKey() == 53) {
            this.currElement = 5;
            return;
        }
        if (event.getKey() == 54) {
            this.currElement = 6;
            return;
        }
        if (event.getKey() == 55) {
            this.currElement = 7;
            return;
        }
        if (event.getKey() == 56) {
            this.currElement = 8;
            return;
        }
        if (event.getKey() == 57) {
            this.currElement = 9;
            return;
        }
        boolean isLeft = event.getKey() == 263;
        boolean isRight = event.getKey() == 262;
        boolean isUp = event.getKey() == 265;
        boolean isDown = event.getKey() == 264;
        boolean isControlDown = Keys.CONTROLLY.m_90857_() || Keys.CONTROLLYR.m_90857_();
        boolean isShiftDown = event.getKey() == 340;
        boolean isAltDown = Keys.ALTY.m_90857_() || Keys.ALTYR.m_90857_();
        boolean isPeriodDown = Keys.SIZE_OPT.m_90857_();
        RENDER_Element element = this.elements.size() == 0 || !this.elements.containsKey(this.currElement) ? new RENDER_Element(0.0f, 0.0f, 0.0f, 0.0f) : this.elements.get(this.currElement);
        float xMod = element.xMod;
        float yMod = element.yMod;
        float zMod = element.zMod;
        float sizeMod = element.sizeMod;
        float stepModifier = 1.0f;
        if (isShiftDown) {
            stepModifier /= 10.0f;
        }
        if (isPeriodDown && isUp) {
            sizeMod = (float)((double)sizeMod + 0.05 * (double)stepModifier);
        } else if (isPeriodDown && isDown) {
            sizeMod = (float)((double)sizeMod - 0.05 * (double)stepModifier);
        } else if (isControlDown && isUp) {
            zMod = (float)((double)zMod + 0.05 * (double)stepModifier);
        } else if (isControlDown && isDown) {
            zMod = (float)((double)zMod - 0.05 * (double)stepModifier);
        } else if (isLeft) {
            xMod = (float)((double)xMod - 0.05 * (double)stepModifier);
        } else if (isRight) {
            xMod = (float)((double)xMod + 0.05 * (double)stepModifier);
        } else if (isUp) {
            yMod = (float)((double)yMod + 0.05 * (double)stepModifier);
        } else if (isDown) {
            yMod = (float)((double)yMod - 0.05 * (double)stepModifier);
        }
        this.elements.put(this.currElement, new RENDER_Element(xMod, yMod, zMod, sizeMod));
    }

    public void exportData() {
        this.elements.forEach((name, data) -> {
            if (this.elements.get(name) == null) {
                GunMod.LOGGER.log(Level.ERROR, "OBJ_RENDER EDITOR FAILED TO EXPORT THIS BROKEN DATA. CONTACT CLUMSYALIEN.");
                return;
            }
            GsonBuilder gsonB = new GsonBuilder().setLenient().addSerializationExclusionStrategy(Gun.strategy).setPrettyPrinting();
            String jsonString = gsonB.create().toJson(data);
            this.writeExport(jsonString, "OBJ_RENDER" + name);
        });
    }

    private void writeExport(String jsonString, String name) {
        try {
            File dir = new File((String)Config.COMMON.development.TDevPath.get() + "\\tac_export\\");
            dir.mkdir();
            FileWriter dataWriter = new FileWriter(dir.getAbsolutePath() + "\\" + name + "_export.json");
            dataWriter.write(jsonString);
            dataWriter.close();
            GunMod.LOGGER.log(Level.INFO, "OBJ_RENDER EDITOR EXPORTED FILE ( " + name + "export.txt ). BE PROUD!");
        }
        catch (IOException e) {
            GunMod.LOGGER.log(Level.ERROR, "OBJ_RENDER EDITOR FAILED TO EXPORT, NO FILE CREATED!!! NO ACCESS IN PATH?. CONTACT CLUMSYALIEN.");
        }
    }

    public static class RENDER_Element {
        private float xMod = 0.0f;
        private float yMod = 0.0f;
        private float zMod = 0.0f;
        private float sizeMod = 0.0f;

        public RENDER_Element(float x, float y, float z, float sizeX) {
            this.xMod = x;
            this.zMod = z;
            this.yMod = y;
            this.sizeMod = sizeX;
        }

        public float getxMod() {
            return this.xMod;
        }

        public float getyMod() {
            return this.yMod;
        }

        public float getzMod() {
            return this.zMod;
        }

        public float getSizeMod() {
            return this.sizeMod;
        }
    }
}

