/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.client.handler;

import com.tac.guns.Config;
import com.tac.guns.client.Keys;
import com.tac.guns.client.handler.GunRenderingHandler;
import com.tac.guns.client.handler.HUDRenderingHandler;
import com.tac.guns.client.handler.RecoilHandler;
import com.tac.guns.client.render.animation.module.GunAnimationController;
import com.tac.guns.common.Gun;
import com.tac.guns.duck.CurrentFpsGetter;
import com.tac.guns.event.GunFireEvent;
import com.tac.guns.item.GunItem;
import com.tac.guns.item.transition.TimelessGunItem;
import com.tac.guns.network.PacketHandler;
import com.tac.guns.network.message.MessageEmptyMag;
import com.tac.guns.network.message.MessageShoot;
import com.tac.guns.network.message.MessageShooting;
import com.tac.guns.network.message.MessageUpdateMoveInacc;
import com.tac.guns.util.GunModifierHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ShootingHandler {
    private static ShootingHandler instance;
    private boolean shooting;
    private boolean shootErr;
    private boolean clickUp = false;
    public int burstTracker = 0;
    private int burstCooldown = 0;
    private boolean isPressed = false;
    private final int emptyCheckCoolDown = 40;
    private int emptyCheckCountDown = 40;
    private static float shootTickGapLeft;
    public static float shootMsGap;

    public static ShootingHandler get() {
        if (instance == null) {
            instance = new ShootingHandler();
        }
        return instance;
    }

    public boolean isShooting() {
        return this.shooting;
    }

    public void setShooting(boolean shooting) {
        this.shooting = shooting;
    }

    public void setShootingError(boolean shootErr) {
        this.shootErr = shootErr;
    }

    private ShootingHandler() {
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        if (!this.isInGame()) {
            return;
        }
        this.burstTracker = 0;
        this.burstCooldown = 0;
        this.clickUp = false;
        this.shootErr = false;
    }

    private boolean isInGame() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc == null || mc.f_91074_ == null) {
            return false;
        }
        if (mc.m_91265_() != null) {
            return false;
        }
        if (mc.f_91080_ != null) {
            return false;
        }
        if (!mc.f_91067_.m_91600_()) {
            return false;
        }
        return mc.m_91302_();
    }

    public float getShootTickGapLeft() {
        return shootTickGapLeft;
    }

    public float getshootMsGap() {
        return shootMsGap;
    }

    public static float calcShootTickGap(int rpm) {
        float shootTickGap = 60.0f / (float)rpm * 20.0f;
        return shootTickGap;
    }

    private static float hitmarkerCooldownMultiplier() {
        int fps = ((CurrentFpsGetter)Minecraft.m_91087_()).getCurrentFps();
        if (fps < 11) {
            return 16.0f;
        }
        if (fps < 21) {
            return 14.5f;
        }
        if (fps < 31) {
            return 4.0f;
        }
        if (fps < 61) {
            return 2.0f;
        }
        if (fps < 121) {
            return 1.0f;
        }
        if (fps < 181) {
            return 0.7f;
        }
        if (fps < 201) {
            return 0.5f;
        }
        return 0.375f;
    }

    private static float visualCooldownMultiplier() {
        int fps = ((CurrentFpsGetter)Minecraft.m_91087_()).getCurrentFps();
        if (fps < 11) {
            return 8.0f;
        }
        if (fps < 21) {
            return 6.25f;
        }
        if (fps < 31) {
            return 1.25f;
        }
        if (fps < 61) {
            return 0.95f;
        }
        if (fps < 121) {
            return 0.625f;
        }
        if (fps < 181) {
            return 0.425f;
        }
        if (fps < 201) {
            return 0.35f;
        }
        return 0.25f;
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void renderTickLow(TickEvent.RenderTickEvent evt) {
        if (!evt.type.equals((Object)TickEvent.Type.RENDER) || evt.phase.equals((Object)TickEvent.Phase.START)) {
            return;
        }
        HUDRenderingHandler.get().hitMarkerTracker = HUDRenderingHandler.get().hitMarkerTracker > 0.0f ? (HUDRenderingHandler.get().hitMarkerTracker -= evt.renderTickTime * ShootingHandler.hitmarkerCooldownMultiplier()) : 0.0f;
        if (shootMsGap > 0.0f) {
            shootMsGap -= evt.renderTickTime * ShootingHandler.visualCooldownMultiplier();
        } else if (shootMsGap < -0.05f) {
            shootMsGap = 0.0f;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void renderTick(TickEvent.RenderTickEvent evt) {
        if (Minecraft.m_91087_().f_91074_ == null || !Minecraft.m_91087_().f_91074_.m_6084_() || Minecraft.m_91087_().f_91074_.m_21205_().m_41720_() instanceof GunItem) {
            return;
        }
        GunAnimationController controller = GunAnimationController.fromItem(Minecraft.m_91087_().f_91074_.m_21205_().m_41720_());
        if (controller == null) {
            return;
        }
        if (controller.isAnimationRunning() && shootMsGap < 0.0f && this.burstTracker != 0) {
            if (controller.isAnimationRunning(GunAnimationController.AnimationLabel.PUMP) || controller.isAnimationRunning(GunAnimationController.AnimationLabel.PULL_BOLT)) {
                return;
            }
            if (((Boolean)Config.CLIENT.controls.burstPress.get()).booleanValue()) {
                this.burstTracker = 0;
            }
            this.clickUp = true;
        }
    }

    @SubscribeEvent
    public void onHandleShooting(TickEvent.ClientTickEvent evt) {
        if (evt.phase != TickEvent.Phase.START) {
            return;
        }
        if (!this.isInGame()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player != null) {
            shootTickGapLeft -= shootTickGapLeft > 0.0f ? 1.0f : 0.0f;
            ItemStack heldItem = player.m_21205_();
            if (heldItem.m_41720_() instanceof GunItem && (Gun.hasAmmo(heldItem) || player.m_7500_())) {
                boolean shooting;
                float dist = Math.abs(player.f_20902_) / 2.5f + Math.abs(player.f_20900_) / 1.25f + (player.m_20184_().f_82480_ > 0.0 ? 0.5f : 0.0f);
                PacketHandler.getPlayChannel().sendToServer((Object)new MessageUpdateMoveInacc(dist));
                boolean bl = shooting = Keys.PULL_TRIGGER.m_90857_() && GunRenderingHandler.get().sprintTransition == 0;
                if (shooting ^ this.shooting) {
                    this.shooting = shooting;
                    PacketHandler.getPlayChannel().sendToServer((Object)new MessageShooting(shooting));
                }
            } else if (this.shooting) {
                this.shooting = false;
                PacketHandler.getPlayChannel().sendToServer((Object)new MessageShooting(false));
            }
        } else {
            this.shooting = false;
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (!this.isInGame()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player != null && this.burstCooldown > 0) {
            --this.burstCooldown;
        }
        if (this.emptyCheckCountDown <= 40) {
            ++this.emptyCheckCountDown;
        }
    }

    @SubscribeEvent
    public void onClickInput(InputEvent.ClickInputEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        ItemStack heldItem = player.m_21205_();
        if (heldItem.m_41720_() instanceof TimelessGunItem && Keys.PULL_TRIGGER.m_90857_()) {
            if (event.isAttack()) {
                event.setCanceled(true);
                event.setSwingHand(false);
            }
            if (this.emptyCheckCountDown > 40 && this.magError((Player)player, heldItem)) {
                this.emptyCheckCountDown = 0;
                player.m_5661_((Component)new TranslatableComponent("info.tac.mag_error").m_130940_(ChatFormatting.UNDERLINE).m_130940_(ChatFormatting.BOLD).m_130940_(ChatFormatting.RED), true);
                PacketHandler.getPlayChannel().sendToServer((Object)new MessageEmptyMag());
                return;
            }
            if (heldItem.m_41783_().m_128451_("CurrentFireMode") == 3 && this.burstCooldown == 0 && !this.isPressed) {
                this.isPressed = true;
                this.burstTracker = ((TimelessGunItem)heldItem.m_41720_()).getGun().getGeneral().getBurstCount();
                this.fire((Player)player, heldItem);
                this.burstCooldown = ((TimelessGunItem)heldItem.m_41720_()).getGun().getGeneral().getBurstRate();
            } else if (this.burstCooldown == 0 && !this.isPressed) {
                this.isPressed = true;
                this.fire((Player)player, heldItem);
            }
            if (this.emptyCheckCountDown > 40 && heldItem.m_41783_().m_128451_("AmmoCount") <= 0) {
                this.emptyCheckCountDown = 0;
                player.m_5661_((Component)new TranslatableComponent("info.tac.out_of_ammo").m_130940_(ChatFormatting.UNDERLINE).m_130940_(ChatFormatting.BOLD).m_130940_(ChatFormatting.RED), true);
                PacketHandler.getPlayChannel().sendToServer((Object)new MessageEmptyMag());
            }
        }
    }

    @SubscribeEvent
    public void onPostClientTick(TickEvent.ClientTickEvent event) {
        ItemStack heldItem;
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (!this.isInGame()) {
            return;
        }
        if (!Keys.PULL_TRIGGER.m_90857_()) {
            this.isPressed = false;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player != null && (heldItem = player.m_21205_()).m_41720_() instanceof TimelessGunItem) {
            if (heldItem.m_41783_() == null) {
                heldItem.m_41784_();
                return;
            }
            TimelessGunItem gunItem = (TimelessGunItem)heldItem.m_41720_();
            if (heldItem.m_41783_().m_128451_("CurrentFireMode") == 3 && ((Boolean)Config.CLIENT.controls.burstPress.get()).booleanValue()) {
                if (this.burstTracker > 0) {
                    this.fire((Player)player, heldItem);
                }
                return;
            }
            if (Keys.PULL_TRIGGER.m_90857_()) {
                Gun gun = ((TimelessGunItem)heldItem.m_41720_()).getModifiedGun(heldItem);
                if (gun.getGeneral().isAuto() && heldItem.m_41783_().m_128451_("CurrentFireMode") == 2) {
                    this.fire((Player)player, heldItem);
                    return;
                }
                if (heldItem.m_41783_().m_128451_("CurrentFireMode") == 3 && !((Boolean)Config.CLIENT.controls.burstPress.get()).booleanValue() && !this.clickUp && this.burstCooldown == 0) {
                    if (this.burstTracker < gun.getGeneral().getBurstCount()) {
                        if (ShootingHandler.get().getshootMsGap() <= 0.0f) {
                            this.fire((Player)player, heldItem);
                            if (!this.shootErr) {
                                ++this.burstTracker;
                            }
                        }
                    } else if (heldItem.m_41783_().m_128451_("AmmoCount") > 0 && this.burstTracker > 0) {
                        this.burstTracker = 0;
                        this.clickUp = true;
                        this.burstCooldown = gun.getGeneral().getBurstRate();
                    }
                    return;
                }
            } else if (this.clickUp) {
                if (heldItem.m_41783_().m_128451_("CurrentFireMode") == 3 && this.burstTracker > 0) {
                    this.burstCooldown = gunItem.getGun().getGeneral().getBurstRate();
                }
                this.burstTracker = 0;
                this.clickUp = false;
            }
        }
    }

    public void fire(Player player, ItemStack heldItem) {
        if (this.magError(player, heldItem)) {
            return;
        }
        if (!(heldItem.m_41720_() instanceof GunItem)) {
            return;
        }
        if (!Gun.hasAmmo(heldItem) && !player.m_7500_()) {
            return;
        }
        if (player.m_5833_()) {
            return;
        }
        player.m_6858_(false);
        if (GunRenderingHandler.get().sprintTransition != 0) {
            this.shooting = false;
            return;
        }
        if (shootTickGapLeft <= 0.0f) {
            GunItem gunItem = (GunItem)heldItem.m_41720_();
            Gun modifiedGun = gunItem.getModifiedGun(heldItem);
            if (MinecraftForge.EVENT_BUS.post((Event)new GunFireEvent.Pre(player, heldItem))) {
                return;
            }
            float rpm = modifiedGun.getGeneral().getRate();
            shootTickGapLeft += ShootingHandler.calcShootTickGap((int)rpm);
            shootMsGap = ShootingHandler.calcShootTickGap((int)rpm);
            RecoilHandler.get().lastRandPitch = RecoilHandler.get().lastRandPitch;
            RecoilHandler.get().lastRandYaw = RecoilHandler.get().lastRandYaw;
            PacketHandler.getPlayChannel().sendToServer((Object)new MessageShoot(player.m_5675_(1.0f), player.m_5686_(1.0f), RecoilHandler.get().lastRandPitch, RecoilHandler.get().lastRandYaw));
            this.burstTracker = ((Boolean)Config.CLIENT.controls.burstPress.get()).booleanValue() ? --this.burstTracker : ++this.burstTracker;
            MinecraftForge.EVENT_BUS.post((Event)new GunFireEvent.Post(player, heldItem));
        }
    }

    private boolean magError(Player player, ItemStack heldItem) {
        int[] extraAmmo = ((TimelessGunItem)heldItem.m_41720_()).getGun().getReloads().getMaxAdditionalAmmoPerOC();
        int magMode = GunModifierHelper.getAmmoCapacity(heldItem);
        return magMode < 0 ? heldItem.m_41720_() instanceof TimelessGunItem && heldItem.m_41783_().m_128451_("AmmoCount") - 1 > ((TimelessGunItem)heldItem.m_41720_()).getGun().getReloads().getMaxAmmo() : heldItem.m_41720_() instanceof TimelessGunItem && heldItem.m_41783_().m_128451_("AmmoCount") - 1 > ((TimelessGunItem)heldItem.m_41720_()).getGun().getReloads().getMaxAmmo() + extraAmmo[magMode];
    }

    static {
        shootTickGapLeft = 0.0f;
        shootMsGap = 0.0f;
    }
}

