/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.client.handler;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import com.tac.guns.Config;
import com.tac.guns.GunMod;
import com.tac.guns.client.handler.ArmorInteractionHandler;
import com.tac.guns.common.Gun;
import com.tac.guns.common.ReloadTracker;
import com.tac.guns.duck.PlayerWithSynData;
import com.tac.guns.item.GunItem;
import com.tac.guns.item.transition.TimelessGunItem;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.Level;
import org.lwjgl.opengl.GL11;

public class HUDRenderingHandler
extends GuiComponent {
    private static HUDRenderingHandler instance;
    private static final ResourceLocation[] AMMO_ICONS;
    private static final ResourceLocation[] FIREMODE_ICONS_OLD;
    private static final ResourceLocation[] FIREMODE_ICONS;
    private static final ResourceLocation[] RELOAD_ICONS;
    private static final ResourceLocation[] NOISE_S;
    private int ammoReserveCount = 0;
    private ResourceLocation heldAmmoID = new ResourceLocation("");
    private double defaultGameGamma = 0.0;
    private static final ResourceLocation fleshHitMarker;
    public boolean hitMarkerHeadshot = false;
    public static final float hitMarkerRatio = 14.0f;
    public float hitMarkerTracker = 0.0f;

    public static HUDRenderingHandler get() {
        return instance == null ? (instance = new HUDRenderingHandler()) : instance;
    }

    private HUDRenderingHandler() {
    }

    @SubscribeEvent
    public void tick(TickEvent.ClientTickEvent e) {
        if (e.phase != TickEvent.Phase.END) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        if (Minecraft.m_91087_().f_91074_.m_21205_().m_41720_() instanceof GunItem) {
            GunItem gunItem = (GunItem)Minecraft.m_91087_().f_91074_.m_21205_().m_41720_();
            this.ammoReserveCount = ReloadTracker.calcMaxReserveAmmo(Gun.findAmmo((Player)Minecraft.m_91087_().f_91074_, gunItem.getGun().getProjectile().getItem()));
            if (player.m_7500_()) {
                return;
            }
            this.heldAmmoID = gunItem.getGun().getProjectile().getItem();
        }
    }

    private void jitterScreen(float partialTicks) {
        long time = System.nanoTime();
        float jitterX = (float)(Math.sin((double)time / 1.0E9) * 5.0E-4);
        float jitterY = (float)(Math.cos((double)time / 1.0E9) * 5.0E-4);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tessellator.m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)jitterX, (float)jitterY, (float)0.0f);
        tessellator.m_85914_();
    }

    private ResourceLocation getNoiseTypeResource(boolean doNoise) {
        long time = Math.abs(System.nanoTime() / 3000000L / 50L);
        return NOISE_S[(int)(time % (long)NOISE_S.length)];
    }

    private void renderNightVision(boolean doNightVision) {
        this.brightenScreen(doNightVision);
        if (doNightVision) {
            RenderSystem.m_69465_();
            RenderSystem.m_69458_((boolean)false);
            RenderSystem.m_69453_();
            RenderSystem.m_69465_();
            RenderSystem.m_69472_();
            RenderSystem.m_69478_();
            Tesselator tessellator = Tesselator.m_85913_();
            BufferBuilder bufferbuilder = tessellator.m_85915_();
            bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
            bufferbuilder.m_5483_(0.0, (double)Minecraft.m_91087_().m_91268_().m_85446_(), -90.0).m_5752_();
            bufferbuilder.m_5483_((double)Minecraft.m_91087_().m_91268_().m_85445_(), (double)Minecraft.m_91087_().m_91268_().m_85446_(), -90.0).m_5752_();
            bufferbuilder.m_5483_((double)Minecraft.m_91087_().m_91268_().m_85445_(), 0.0, -90.0).m_5752_();
            bufferbuilder.m_5483_(0.0, 0.0, -90.0).m_5752_();
            tessellator.m_85914_();
            RenderSystem.m_69461_();
            RenderSystem.m_69493_();
            RenderSystem.m_69482_();
            RenderSystem.m_69458_((boolean)true);
            RenderSystem.m_69482_();
        }
    }

    private void brightenScreen(boolean doNightVision) {
        if (doNightVision) {
            if (this.defaultGameGamma == 0.0) {
                this.defaultGameGamma = Minecraft.m_91087_().f_91066_.f_92071_;
            }
            Minecraft.m_91087_().f_91066_.f_92071_ = 200.0;
        } else {
            Minecraft.m_91087_().f_91066_.f_92071_ = this.defaultGameGamma;
        }
    }

    @SubscribeEvent
    public void onOverlayRender(RenderGameOverlayEvent.Post event) {
        ItemStack rig;
        if (event.getType() != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        if (Minecraft.m_91087_().f_91074_ == null) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        ItemStack heldItem = player.m_21205_();
        PoseStack stack = event.getMatrixStack();
        float anchorPointX = (float)event.getWindow().m_85445_() / 12.0f * 11.0f;
        float anchorPointY = (float)event.getWindow().m_85446_() / 10.0f * 9.0f;
        float configScaleWeaponCounter = ((Double)Config.CLIENT.weaponGUI.weaponAmmoCounter.weaponAmmoCounterSize.get()).floatValue();
        float configScaleWeaponFireMode = ((Double)Config.CLIENT.weaponGUI.weaponFireMode.weaponFireModeSize.get()).floatValue();
        float configScaleWeaponReloadBar = ((Double)Config.CLIENT.weaponGUI.weaponReloadTimer.weaponReloadTimerSize.get()).floatValue();
        float counterSize = 1.8f * configScaleWeaponCounter;
        float fireModeSize = 32.0f * configScaleWeaponFireMode;
        float ReloadBarSize = 32.0f * configScaleWeaponReloadBar;
        float hitMarkerSize = 128.0f;
        RenderSystem.m_69482_();
        BufferBuilder buffer = Tesselator.m_85913_().m_85915_();
        int width = event.getWindow().m_85443_();
        int height = event.getWindow().m_85444_();
        int centerX = event.getWindow().m_85445_() / 2;
        int centerY = event.getWindow().m_85446_() / 2;
        if (((Boolean)Config.CLIENT.display.showHitMarkers.get()).booleanValue() && this.hitMarkerTracker > 0.0f) {
            RenderSystem.m_69478_();
            stack.m_85836_();
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)fleshHitMarker);
            float opac = Math.max(Math.min(this.hitMarkerTracker / 14.0f, 100.0f), 0.2f);
            if (this.hitMarkerHeadshot) {
                RenderSystem.m_157429_((float)1.0f, (float)0.075f, (float)0.075f, (float)opac);
            } else {
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)opac);
            }
            HUDRenderingHandler.m_93133_((PoseStack)stack, (int)(centerX - 8), (int)(centerY - 8), (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            stack.m_85849_();
        }
        if (!(rig = ((PlayerWithSynData)player).getRig()).m_41619_()) {
            ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
            stack.m_85836_();
            MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
            float iconAnchorX = anchorPointX - counterSize * 32.0f / 2.0f + -((Double)Config.CLIENT.weaponGUI.weaponAmmoCounter.x.get()).floatValue();
            float iconAnchorY = anchorPointY + 5.0f + -((Double)Config.CLIENT.weaponGUI.weaponAmmoCounter.y.get()).floatValue();
            itemRenderer.m_115123_(rig, (int)iconAnchorX, (int)iconAnchorY);
            stack.m_85849_();
        }
        if (ArmorInteractionHandler.get().isRepairing()) {
            RenderSystem.m_69482_();
            buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
            stack.m_85836_();
            stack.m_85837_((double)anchorPointX - (double)ReloadBarSize * 4.35 / 4.0, (double)(anchorPointY + ReloadBarSize * 1.625f / 5.0f * 3.0f), 0.0);
            stack.m_85837_((double)(-ReloadBarSize), (double)(-ReloadBarSize), 0.0);
            stack.m_85841_(2.1f * (1.0f - ArmorInteractionHandler.get().getRepairProgress(event.getPartialTicks(), (Player)player)), 0.25f, 0.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)RELOAD_ICONS[0]);
            Matrix4f matrix = stack.m_85850_().m_85861_();
            buffer.m_85982_(matrix, 0.0f, ReloadBarSize, 0.0f).m_7421_(0.0f, 1.0f).m_85950_(1.0f, 1.0f, 1.0f, 0.99f).m_5752_();
            buffer.m_85982_(matrix, ReloadBarSize, ReloadBarSize, 0.0f).m_7421_(1.0f, 1.0f).m_85950_(1.0f, 1.0f, 1.0f, 0.99f).m_5752_();
            buffer.m_85982_(matrix, ReloadBarSize, 0.0f, 0.0f).m_7421_(1.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 0.99f).m_5752_();
            buffer.m_85982_(matrix, 0.0f, 0.0f, 0.0f).m_7421_(0.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 0.99f).m_5752_();
            buffer.m_85721_();
            BufferUploader.m_85761_((BufferBuilder)buffer);
            stack.m_85849_();
        }
        if (!(Minecraft.m_91087_().f_91074_.m_21120_(InteractionHand.MAIN_HAND).m_41720_() instanceof TimelessGunItem)) {
            return;
        }
        TimelessGunItem gunItem = (TimelessGunItem)heldItem.m_41720_();
        Gun gun = gunItem.getGun();
        if (!((Boolean)Config.CLIENT.weaponGUI.weaponGui.get()).booleanValue()) {
            return;
        }
        if (((Boolean)Config.CLIENT.weaponGUI.weaponFireMode.showWeaponFireMode.get()).booleanValue()) {
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            RenderSystem.m_157427_(GameRenderer::m_172820_);
            buffer = Tesselator.m_85913_().m_85915_();
            buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
            stack.m_85836_();
            stack.m_85837_((double)(anchorPointX - fireModeSize * 2.0f / 4.0f), (double)(anchorPointY - fireModeSize * 2.0f / 5.0f * 3.0f), 0.0);
            stack.m_85837_((double)(-fireModeSize) + -62.7 + (double)(-((Double)Config.CLIENT.weaponGUI.weaponFireMode.x.get()).floatValue()), (double)(-fireModeSize) + 52.98 + (double)(-((Double)Config.CLIENT.weaponGUI.weaponFireMode.y.get()).floatValue()), 0.0);
            stack.m_85837_(20.0, 5.0, 0.0);
            int fireMode = 0;
            if (player.m_21205_().m_41720_() instanceof GunItem) {
                try {
                    int[] gunItemFireModes;
                    if (heldItem.m_41783_() == null) {
                        heldItem.m_41784_();
                    }
                    if (ArrayUtils.isEmpty((int[])(gunItemFireModes = heldItem.m_41783_().m_128465_("supportedFireModes")))) {
                        gunItemFireModes = gun.getGeneral().getRateSelector();
                        heldItem.m_41783_().m_128385_("supportedFireModes", gunItemFireModes);
                        heldItem.m_41783_().m_128405_("CurrentFireMode", gunItemFireModes[0]);
                    } else if (!Arrays.equals(gunItemFireModes, gun.getGeneral().getRateSelector())) {
                        heldItem.m_41783_().m_128385_("supportedFireModes", gun.getGeneral().getRateSelector());
                        if (!heldItem.m_41783_().m_128441_("CurrentFireMode")) {
                            heldItem.m_41783_().m_128405_("CurrentFireMode", gunItemFireModes[0]);
                        }
                    }
                    if (player.m_21205_().m_41783_() == null) {
                        fireMode = !((Boolean)Config.COMMON.gameplay.safetyExistence.get()).booleanValue() && Objects.requireNonNull(player.m_21205_().m_41783_()).m_128451_("CurrentFireMode") == 0 && gunItemFireModes.length > 1 ? gunItemFireModes[1] : gunItemFireModes[0];
                    } else if (player.m_21205_().m_41783_().m_128451_("CurrentFireMode") == 0 && gunItemFireModes.length > 1) {
                        if (!((Boolean)Config.COMMON.gameplay.safetyExistence.get()).booleanValue()) {
                            fireMode = gunItemFireModes[0];
                            if (fireMode == 0) {
                                fireMode = gunItemFireModes[1];
                            }
                        } else {
                            fireMode = gunItemFireModes[0];
                        }
                    } else {
                        fireMode = Objects.requireNonNull(player.m_21205_().m_41783_()).m_128451_("CurrentFireMode");
                        if (!((Boolean)Config.COMMON.gameplay.safetyExistence.get()).booleanValue() && fireMode == 0 && (fireMode = gunItemFireModes[0]) == 0) {
                            fireMode = gunItemFireModes[1];
                        }
                    }
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    fireMode = gun.getGeneral().getRateSelector()[0];
                }
                catch (Exception e) {
                    fireMode = 0;
                    GunMod.LOGGER.log(Level.ERROR, "TaC HUD_RENDERER has failed obtaining the fire mode");
                }
                RenderSystem.m_157456_((int)0, (ResourceLocation)FIREMODE_ICONS[fireMode]);
                Matrix4f matrix = stack.m_85850_().m_85861_();
                buffer.m_85982_(matrix, 0.0f, fireModeSize / 2.0f, 0.0f).m_7421_(0.0f, 1.0f).m_85950_(1.0f, 1.0f, 1.0f, 0.99f).m_5752_();
                buffer.m_85982_(matrix, fireModeSize / 2.0f, fireModeSize / 2.0f, 0.0f).m_7421_(1.0f, 1.0f).m_85950_(1.0f, 1.0f, 1.0f, 0.99f).m_5752_();
                buffer.m_85982_(matrix, fireModeSize / 2.0f, 0.0f, 0.0f).m_7421_(1.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 0.99f).m_5752_();
                buffer.m_85982_(matrix, 0.0f, 0.0f, 0.0f).m_7421_(0.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 0.99f).m_5752_();
            }
            stack.m_85849_();
            buffer.m_85721_();
            BufferUploader.m_85761_((BufferBuilder)buffer);
        }
        if (((Boolean)Config.CLIENT.weaponGUI.weaponAmmoCounter.showWeaponAmmoCounter.get()).booleanValue()) {
            stack.m_85836_();
            stack.m_85837_((double)(anchorPointX - counterSize * 32.0f / 2.0f + -((Double)Config.CLIENT.weaponGUI.weaponAmmoCounter.x.get()).floatValue()), (double)(anchorPointY - counterSize * 32.0f / 4.0f + -((Double)Config.CLIENT.weaponGUI.weaponAmmoCounter.y.get()).floatValue()), 0.0);
            if (player.m_21205_().m_41783_() != null) {
                MutableComponent reserveAmmo;
                MutableComponent currentAmmo;
                int ammo = player.m_21205_().m_41783_().m_128451_("AmmoCount");
                if (player.m_21205_().m_41783_().m_128451_("AmmoCount") <= gun.getReloads().getMaxAmmo() / 4 && this.ammoReserveCount <= gun.getReloads().getMaxAmmo()) {
                    currentAmmo = HUDRenderingHandler.byPaddingZeros(ammo).m_7220_((Component)new TranslatableComponent("" + ammo)).m_130940_(ChatFormatting.RED);
                    reserveAmmo = HUDRenderingHandler.byPaddingZeros(this.ammoReserveCount > 10000 ? 10000 : this.ammoReserveCount).m_7220_((Component)new TranslatableComponent("" + (this.ammoReserveCount > 10000 ? 9999 : this.ammoReserveCount))).m_130940_(ChatFormatting.RED);
                } else if (this.ammoReserveCount <= gun.getReloads().getMaxAmmo()) {
                    currentAmmo = HUDRenderingHandler.byPaddingZeros(ammo).m_7220_((Component)new TranslatableComponent("" + ammo).m_130940_(ChatFormatting.WHITE));
                    reserveAmmo = HUDRenderingHandler.byPaddingZeros(this.ammoReserveCount > 10000 ? 10000 : this.ammoReserveCount).m_7220_((Component)new TranslatableComponent("" + (this.ammoReserveCount > 10000 ? 9999 : this.ammoReserveCount))).m_130940_(ChatFormatting.RED);
                } else if (player.m_21205_().m_41783_().m_128451_("AmmoCount") <= gun.getReloads().getMaxAmmo() / 4) {
                    currentAmmo = HUDRenderingHandler.byPaddingZeros(ammo).m_7220_((Component)new TranslatableComponent("" + ammo)).m_130940_(ChatFormatting.RED);
                    reserveAmmo = HUDRenderingHandler.byPaddingZeros(this.ammoReserveCount > 10000 ? 10000 : this.ammoReserveCount).m_7220_((Component)new TranslatableComponent("" + (this.ammoReserveCount > 10000 ? 9999 : this.ammoReserveCount))).m_130940_(ChatFormatting.GRAY);
                } else {
                    currentAmmo = HUDRenderingHandler.byPaddingZeros(ammo).m_7220_((Component)new TranslatableComponent("" + ammo).m_130940_(ChatFormatting.WHITE));
                    reserveAmmo = HUDRenderingHandler.byPaddingZeros(this.ammoReserveCount > 10000 ? 10000 : this.ammoReserveCount).m_7220_((Component)new TranslatableComponent("" + (this.ammoReserveCount > 10000 ? 9999 : this.ammoReserveCount))).m_130940_(ChatFormatting.GRAY);
                }
                stack.m_85841_(counterSize, counterSize, counterSize);
                stack.m_85836_();
                stack.m_85837_(-21.15, 0.0, 0.0);
                HUDRenderingHandler.m_93243_((PoseStack)stack, (Font)Minecraft.m_91087_().f_91062_, (Component)currentAmmo, (int)0, (int)0, (int)0xFFFFFF);
                stack.m_85849_();
                stack.m_85836_();
                stack.m_85841_(0.7f, 0.7f, 0.7f);
                stack.m_85837_(3.7, 3.4, 0.0);
                HUDRenderingHandler.m_93243_((PoseStack)stack, (Font)Minecraft.m_91087_().f_91062_, (Component)reserveAmmo, (int)0, (int)0, (int)0xFFFFFF);
                stack.m_85849_();
            }
            stack.m_85849_();
            stack.m_85836_();
            buffer = Tesselator.m_85913_().m_85915_();
            RenderSystem.m_157427_(GameRenderer::m_172820_);
            buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
            stack.m_85837_((double)anchorPointX - (double)ReloadBarSize * 4.35 / 4.0, (double)(anchorPointY + ReloadBarSize * 1.625f / 5.0f * 3.0f), 0.0);
            stack.m_85837_((double)(-ReloadBarSize), (double)(-ReloadBarSize), 0.0);
            stack.m_85837_(-23.55, 1.75, 0.0);
            stack.m_85841_(3.05f, 0.028f, 0.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)RELOAD_ICONS[0]);
            Matrix4f matrix = stack.m_85850_().m_85861_();
            buffer.m_85982_(matrix, 0.0f, ReloadBarSize, 0.0f).m_7421_(0.0f, 1.0f).m_85950_(1.0f, 1.0f, 1.0f, 0.99f).m_5752_();
            buffer.m_85982_(matrix, ReloadBarSize, ReloadBarSize, 0.0f).m_7421_(1.0f, 1.0f).m_85950_(1.0f, 1.0f, 1.0f, 0.99f).m_5752_();
            buffer.m_85982_(matrix, ReloadBarSize, 0.0f, 0.0f).m_7421_(1.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 0.99f).m_5752_();
            buffer.m_85982_(matrix, 0.0f, 0.0f, 0.0f).m_7421_(0.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 0.99f).m_5752_();
            stack.m_85837_(19.25, -619.0, 0.0);
            stack.m_85841_(0.0095f, 20.028f, 0.0f);
            buffer.m_85982_(matrix, 0.0f, ReloadBarSize, 0.0f).m_7421_(0.0f, 1.0f).m_85950_(1.0f, 1.0f, 1.0f, 0.99f).m_5752_();
            buffer.m_85982_(matrix, ReloadBarSize, ReloadBarSize, 0.0f).m_7421_(1.0f, 1.0f).m_85950_(1.0f, 1.0f, 1.0f, 0.99f).m_5752_();
            buffer.m_85982_(matrix, ReloadBarSize, 0.0f, 0.0f).m_7421_(1.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 0.99f).m_5752_();
            buffer.m_85982_(matrix, 0.0f, 0.0f, 0.0f).m_7421_(0.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 0.99f).m_5752_();
            buffer.m_85721_();
            BufferUploader.m_85761_((BufferBuilder)buffer);
            stack.m_85849_();
        }
    }

    private static MutableComponent byPaddingZeros(int number) {
        String text = String.format("%0" + (HUDRenderingHandler.byPaddingZerosCount(number) + 1) + "d", 1);
        text = text.substring(0, text.length() - 1);
        return new TranslatableComponent(text).m_130940_(ChatFormatting.GRAY);
    }

    private static int byPaddingZerosCount(int length) {
        if (length < 10) {
            return 2;
        }
        if (length < 100) {
            return 1;
        }
        if (length < 1000) {
            return 0;
        }
        return 0;
    }

    static {
        AMMO_ICONS = new ResourceLocation[]{new ResourceLocation("tac", "textures/gui/counterassule_rifle.png"), new ResourceLocation("tac", "textures/gui/counterlmg.png"), new ResourceLocation("tac", "textures/gui/counterpistol.png"), new ResourceLocation("tac", "textures/gui/countershotgun.png"), new ResourceLocation("tac", "textures/gui/countersmg.png"), new ResourceLocation("tac", "textures/gui/countersniper.png")};
        FIREMODE_ICONS_OLD = new ResourceLocation[]{new ResourceLocation("tac", "textures/gui/safety.png"), new ResourceLocation("tac", "textures/gui/semi.png"), new ResourceLocation("tac", "textures/gui/full.png"), new ResourceLocation("tac", "textures/gui/burst.png")};
        FIREMODE_ICONS = new ResourceLocation[]{new ResourceLocation("tac", "textures/gui/firemode_safety.png"), new ResourceLocation("tac", "textures/gui/firemode_semi.png"), new ResourceLocation("tac", "textures/gui/firemode_auto.png"), new ResourceLocation("tac", "textures/gui/firemode_burst.png")};
        RELOAD_ICONS = new ResourceLocation[]{new ResourceLocation("tac", "textures/gui/reloadbar.png")};
        NOISE_S = new ResourceLocation[]{new ResourceLocation("tac", "textures/screen_effect/noise1.png"), new ResourceLocation("tac", "textures/screen_effect/noise2.png")};
        fleshHitMarker = new ResourceLocation("tac", "textures/crosshair_hit/hit_marker_no_opac.png");
    }
}

