/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.client.handler;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.tac.guns.Config;
import com.tac.guns.client.handler.ShootingHandler;
import com.tac.guns.client.render.crosshair.Crosshair;
import com.tac.guns.client.render.crosshair.DynamicScalingTexturedCrosshair;
import com.tac.guns.client.render.crosshair.TechCrosshair;
import com.tac.guns.client.render.crosshair.TexturedCrosshair;
import com.tac.guns.item.GunItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class CrosshairHandler {
    private static CrosshairHandler instance;
    private final Map<ResourceLocation, Crosshair> idToCrosshair = new HashMap<ResourceLocation, Crosshair>();
    private final List<Crosshair> registeredCrosshairs = new ArrayList<Crosshair>();
    private Crosshair currentCrosshair = null;

    public static CrosshairHandler get() {
        if (instance == null) {
            instance = new CrosshairHandler();
        }
        return instance;
    }

    private CrosshairHandler() {
        this.register(new TexturedCrosshair(new ResourceLocation("tac", "better_default")));
        this.register(new TexturedCrosshair(new ResourceLocation("tac", "circle")));
        this.register(new TexturedCrosshair(new ResourceLocation("tac", "filled_circle"), false));
        this.register(new TexturedCrosshair(new ResourceLocation("tac", "square")));
        this.register(new TexturedCrosshair(new ResourceLocation("tac", "round")));
        this.register(new TexturedCrosshair(new ResourceLocation("tac", "arrow")));
        this.register(new TexturedCrosshair(new ResourceLocation("tac", "dot")));
        this.register(new TexturedCrosshair(new ResourceLocation("tac", "box")));
        this.register(new TexturedCrosshair(new ResourceLocation("tac", "line")));
        this.register(new TexturedCrosshair(new ResourceLocation("tac", "t")));
        this.register(new TexturedCrosshair(new ResourceLocation("tac", "smiley")));
        this.register(new DynamicScalingTexturedCrosshair(new ResourceLocation("tac", "dynamic_default")));
        this.register(new DynamicScalingTexturedCrosshair(new ResourceLocation("tac", "clean_no_crosshair")));
        this.register(new TechCrosshair());
    }

    public void register(Crosshair crosshair) {
        if (!this.idToCrosshair.containsKey(crosshair.getLocation())) {
            this.idToCrosshair.put(crosshair.getLocation(), crosshair);
            this.registeredCrosshairs.add(crosshair);
        }
    }

    public void setCrosshair(ResourceLocation id) {
        this.currentCrosshair = this.idToCrosshair.getOrDefault(id, Crosshair.DEFAULT);
    }

    @Nullable
    public Crosshair getCurrentCrosshair() {
        if (this.currentCrosshair == null && this.registeredCrosshairs.size() > 0) {
            ResourceLocation id = ResourceLocation.m_135820_((String)((String)Config.CLIENT.display.crosshair.get()));
            this.currentCrosshair = id != null ? this.idToCrosshair.getOrDefault(id, Crosshair.DEFAULT) : Crosshair.DEFAULT;
        }
        return this.currentCrosshair;
    }

    public ImmutableList<Crosshair> getRegisteredCrosshairs() {
        return ImmutableList.copyOf(this.registeredCrosshairs);
    }

    @SubscribeEvent
    public void onRenderOverlay(RenderGameOverlayEvent.PreLayer event) {
        if (event.getOverlay() != ForgeIngameGui.CROSSHAIR_ELEMENT) {
            return;
        }
        Crosshair crosshair = this.getCurrentCrosshair();
        if (crosshair == null || crosshair.isDefault()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        ItemStack heldItem = mc.f_91074_.m_21205_();
        if (!(heldItem.m_41720_() instanceof GunItem)) {
            return;
        }
        if (!((Boolean)Config.COMMON.development.permanentCrosshair.get()).booleanValue()) {
            event.setCanceled(true);
        }
        if (!mc.f_91066_.m_92176_().m_90612_()) {
            return;
        }
        PoseStack stack = event.getMatrixStack();
        stack.m_85836_();
        int scaledWidth = event.getWindow().m_85445_();
        int scaledHeight = event.getWindow().m_85446_();
        crosshair.render(mc, stack, scaledWidth, scaledHeight, event.getPartialTicks());
        stack.m_85849_();
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Crosshair crosshair = this.getCurrentCrosshair();
        if (crosshair == null || crosshair.isDefault()) {
            return;
        }
        if (ShootingHandler.get().isShooting()) {
            crosshair.onGunFired();
        }
        crosshair.tick();
    }
}

