/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.client.handler;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import com.tac.guns.Config;
import com.tac.guns.client.BulletTrail;
import com.tac.guns.client.GunRenderType;
import com.tac.guns.client.handler.AimingHandler;
import com.tac.guns.client.handler.GunRenderingHandler;
import com.tac.guns.client.handler.ShootingHandler;
import com.tac.guns.client.util.RenderUtil;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class BulletTrailRenderingHandler {
    private static BulletTrailRenderingHandler instance;
    private Map<Integer, BulletTrail> bullets = new HashMap<Integer, BulletTrail>();

    public static BulletTrailRenderingHandler get() {
        if (instance == null) {
            instance = new BulletTrailRenderingHandler();
        }
        return instance;
    }

    private BulletTrailRenderingHandler() {
    }

    public void add(BulletTrail trail) {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (world != null) {
            this.bullets.put(trail.getEntityId(), trail);
        }
    }

    public void remove(int entityId) {
        this.bullets.remove(entityId);
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (world != null) {
            if (event.phase == TickEvent.Phase.END) {
                this.bullets.values().forEach(BulletTrail::tick);
                this.bullets.values().removeIf(BulletTrail::isDead);
            }
        } else if (!this.bullets.isEmpty()) {
            this.bullets.clear();
        }
    }

    public void render(PoseStack stack, float partialSticks) {
        for (BulletTrail bulletTrail : this.bullets.values()) {
            this.renderBulletTrail(bulletTrail, stack, partialSticks);
        }
    }

    @SubscribeEvent
    public void onRespawn(ClientPlayerNetworkEvent.RespawnEvent event) {
        this.bullets.clear();
    }

    @SubscribeEvent
    public void onLoggedOut(ClientPlayerNetworkEvent.LoggedOutEvent event) {
        this.bullets.clear();
    }

    private void renderBulletTrail(BulletTrail bulletTrail, PoseStack matrixStack, float partialTicks) {
        Minecraft mc = Minecraft.m_91087_();
        Entity entity = mc.m_91288_();
        if (entity == null || bulletTrail.isDead() || bulletTrail.getAge() < 2) {
            return;
        }
        if (entity == null || bulletTrail.isDead() || !((Boolean)Config.CLIENT.display.showBulletTrails.get()).booleanValue()) {
            return;
        }
        if (!((Boolean)Config.CLIENT.display.showFirstPersonBulletTrails.get()).booleanValue() && Minecraft.m_91087_().f_91074_.m_7306_(entity)) {
            return;
        }
        matrixStack.m_85836_();
        Vec3 view = mc.f_91063_.m_109153_().m_90583_();
        Vec3 position = bulletTrail.getPosition();
        Vec3 motion = bulletTrail.getMotion();
        double bulletX = position.f_82479_ + motion.f_82479_ * (double)partialTicks;
        double bulletY = position.f_82480_ + motion.f_82480_ * (double)partialTicks;
        double bulletZ = position.f_82481_ + motion.f_82481_ * (double)partialTicks;
        Vec3 motionVec = new Vec3(motion.f_82479_, motion.f_82480_, motion.f_82481_);
        float length = (float)motionVec.m_82553_();
        if (Minecraft.m_91087_().f_91074_.m_7306_(entity)) {
            if (mc.f_91074_.m_20154_().f_82480_ > 0.945) {
                length = (float)((double)length * 0.25);
            } else if (mc.f_91074_.m_20154_().f_82480_ > 0.385) {
                matrixStack.m_85837_(0.0, (double)-0.115f * mc.f_91074_.m_20154_().f_82480_, 0.0);
            }
        }
        if (ShootingHandler.get().isShooting() && Minecraft.m_91087_().f_91074_.m_7306_(entity) && bulletTrail.getAge() < 1) {
            matrixStack.m_85837_(bulletX - view.m_7096_(), bulletY - view.m_7098_() - (double)0.145f, bulletZ - view.m_7094_());
            if (AimingHandler.get().isAiming()) {
                matrixStack.m_85837_(0.0, (double)-0.685f, 0.0);
            }
        } else {
            matrixStack.m_85837_(bulletX - view.m_7096_(), bulletY - view.m_7098_() - 0.125, bulletZ - view.m_7094_());
        }
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(bulletTrail.getYaw()));
        matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(-bulletTrail.getPitch() + 90.105f));
        float trailLength = (float)((double)(length / 3.0f) * bulletTrail.getTrailLengthMultiplier());
        float red = (float)(bulletTrail.getTrailColor() >> 16 & 0xFF) / 255.0f;
        float green = (float)(bulletTrail.getTrailColor() >> 8 & 0xFF) / 255.0f;
        float blue = (float)(bulletTrail.getTrailColor() & 0xFF) / 255.0f;
        float alpha = ((Double)Config.CLIENT.display.bulletTrailOpacity.get()).floatValue();
        Entity shooter = bulletTrail.getShooter();
        if (shooter != null && Minecraft.m_91087_().f_91074_.m_7306_(shooter)) {
            trailLength = AimingHandler.get().getNormalisedAdsProgress() > 0.4 ? (float)Math.min((double)(trailLength + 0.6f), shooter.m_20299_(partialTicks).m_82554_(new Vec3(bulletX, bulletY, bulletZ)) / (double)1.175f) : (float)Math.min((double)(trailLength + 0.6f), shooter.m_20299_(partialTicks).m_82554_(new Vec3(bulletX, bulletY, bulletZ)) / (double)1.0975f);
        }
        Matrix4f matrix4f = matrixStack.m_85850_().m_85861_();
        MultiBufferSource.BufferSource renderTypeBuffer = mc.m_91269_().m_110104_();
        if (bulletTrail.getAge() < 1 && Minecraft.m_91087_().f_91074_.m_7306_(entity) && !AimingHandler.get().isAiming()) {
            bulletType = GunRenderType.getBulletTrail();
            builder = renderTypeBuffer.m_6299_(bulletType);
            float posSize = 0.1f;
            builder.m_85982_(matrix4f, 0.0f, trailLength / 1.325f, 0.0f).m_85950_(red, green, blue, alpha).m_85969_(0xF000F0).m_5752_();
            builder.m_85982_(matrix4f, 0.0f, 0.0f, -(posSize *= bulletTrail.getSize() * 10.0f)).m_85950_(red, green, blue, alpha).m_85969_(0xF000F0).m_5752_();
            matrixStack.m_85841_(1.5f, 1.5f, 1.825f);
            matrixStack.m_85837_(GunRenderingHandler.get().sizeZ / 17.25, -GunRenderingHandler.get().sizeZ / 2.0, 0.0);
            matrixStack.m_85837_(GunRenderingHandler.get().displayX, GunRenderingHandler.get().displayY, GunRenderingHandler.get().displayZ);
            matrixStack.m_85837_(0.0, 0.0, GunRenderingHandler.get().adjustedTrailZ - 0.02);
            builder.m_85982_(matrix4f, 0.0f, -trailLength / 1.325f, 0.0f).m_85950_(red, green, blue, alpha).m_85969_(0xF000F0).m_5752_();
            builder.m_85982_(matrix4f, 0.0f, 0.0f, posSize).m_85950_(red, green, blue, alpha).m_85969_(0xF000F0).m_5752_();
            Minecraft.m_91087_().m_91269_().m_110104_().m_109912_(bulletType);
        } else {
            bulletType = GunRenderType.getBulletTrail();
            builder = renderTypeBuffer.m_6299_(bulletType);
            builder.m_85982_(matrix4f, 0.0f, 0.0f, 0.225f).m_85950_(red, green, blue, alpha).m_85969_(0xF000F0).m_5752_();
            builder.m_85982_(matrix4f, 0.0f, 0.0f, -0.225f).m_85950_(red, green, blue, alpha).m_85969_(0xF000F0).m_5752_();
            builder.m_85982_(matrix4f, 0.0f, trailLength * 1.15f, 0.0f).m_85950_(red, green, blue, alpha).m_85969_(0xF000F0).m_5752_();
            builder.m_85982_(matrix4f, 0.0f, -trailLength * 1.15f, 0.0f).m_85950_(red, green, blue, alpha).m_85969_(0xF000F0).m_5752_();
            builder.m_85982_(matrix4f, 0.0f, 0.0f, -0.225f).m_85950_(red, green, blue, alpha).m_85969_(0xF000F0).m_5752_();
            builder.m_85982_(matrix4f, 0.0f, 0.0f, 0.225f).m_85950_(red, green, blue, alpha).m_85969_(0xF000F0).m_5752_();
            builder.m_85982_(matrix4f, -0.225f, 0.0f, 0.0f).m_85950_(red, green, blue, alpha).m_85969_(0xF000F0).m_5752_();
            builder.m_85982_(matrix4f, 0.225f, 0.0f, 0.0f).m_85950_(red, green, blue, alpha).m_85969_(0xF000F0).m_5752_();
            builder.m_85982_(matrix4f, 0.0f, trailLength * 1.15f, 0.0f).m_85950_(red, green, blue, alpha).m_85969_(0xF000F0).m_5752_();
            builder.m_85982_(matrix4f, 0.0f, -trailLength * 1.15f, 0.0f).m_85950_(red, green, blue, alpha).m_85969_(0xF000F0).m_5752_();
            Minecraft.m_91087_().m_91269_().m_110104_().m_109912_(bulletType);
        }
        if (!bulletTrail.getItem().m_41619_() && !bulletTrail.isTrailVisible()) {
            matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(((float)bulletTrail.getAge() + partialTicks) * 50.0f));
            matrixStack.m_85841_(0.25f, 0.25f, 0.25f);
            int combinedLight = LevelRenderer.m_109541_((BlockAndTintGetter)entity.f_19853_, (BlockPos)new BlockPos(entity.m_20182_()));
            ItemStack stack = bulletTrail.getItem();
            RenderUtil.renderModel(stack, ItemTransforms.TransformType.NONE, matrixStack, (MultiBufferSource)renderTypeBuffer, combinedLight, OverlayTexture.f_118083_, null, null);
        }
        matrixStack.m_85849_();
    }
}

