/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.client.handler;

import com.mrcrayfish.framework.common.data.SyncedEntityData;
import com.tac.guns.client.Keys;
import com.tac.guns.client.handler.CrosshairHandler;
import com.tac.guns.client.render.crosshair.Crosshair;
import com.tac.guns.common.Rig;
import com.tac.guns.init.ModSyncedDataKeys;
import com.tac.guns.item.transition.wearables.ArmorRigItem;
import com.tac.guns.network.PacketHandler;
import com.tac.guns.network.message.MessageArmorRepair;
import com.tac.guns.network.message.MessageArmorUpdate;
import com.tac.guns.util.WearableHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ArmorInteractionHandler {
    private static ArmorInteractionHandler instance;
    private static final double MAX_AIM_PROGRESS = 4.0;
    private double normalisedRepairProgress;
    private boolean repairing = false;
    private int repairTime = -1;
    private int prevRepairTime = 0;

    public static ArmorInteractionHandler get() {
        if (instance == null) {
            instance = new ArmorInteractionHandler();
        }
        return instance;
    }

    private ArmorInteractionHandler() {
        Keys.ARMOR_REPAIRING.addPressCallback(() -> {
            if (!Keys.noConflict(Keys.ARMOR_REPAIRING)) {
                return;
            }
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91074_ != null && !WearableHelper.PlayerWornRig((Player)mc.f_91074_).m_41619_() && !WearableHelper.isFullDurability(WearableHelper.PlayerWornRig((Player)mc.f_91074_))) {
                this.repairing = true;
                this.repairTime = ((ArmorRigItem)WearableHelper.PlayerWornRig((Player)mc.f_91074_).m_41720_()).getRig().getRepair().getTicksToRepair();
            }
        });
    }

    public float getRepairProgress(float partialTicks, Player player) {
        return this.repairTime != 0 ? ((float)this.prevRepairTime + (float)(this.repairTime - this.prevRepairTime) * partialTicks) / (float)((ArmorRigItem)WearableHelper.PlayerWornRig(player).m_41720_()).getRig().getRepair().getTicksToRepair() : 1.0f;
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        PacketHandler.getPlayChannel().sendToServer((Object)new MessageArmorUpdate());
        this.prevRepairTime = this.repairTime;
        if (Keys.ARMOR_REPAIRING.m_90857_() && this.repairTime > 0) {
            --this.repairTime;
        } else if (this.repairTime == 0) {
            PacketHandler.getPlayChannel().sendToServer((Object)new MessageArmorRepair(true, true));
            this.repairTime = -1;
            return;
        }
        if (Keys.AIM_HOLD.m_90857_()) {
            if (!this.repairing) {
                SyncedEntityData.instance().set((Entity)player, ModSyncedDataKeys.QREPAIRING, (Object)true);
                PacketHandler.getPlayChannel().sendToServer((Object)new MessageArmorRepair(true, false));
                this.repairing = true;
            }
        } else if (this.repairing && !Keys.AIM_HOLD.m_90857_()) {
            SyncedEntityData.instance().set((Entity)player, ModSyncedDataKeys.QREPAIRING, (Object)false);
            PacketHandler.getPlayChannel().sendToServer((Object)new MessageArmorRepair(false, false));
            this.repairing = false;
        }
    }

    public void onRenderOverlay(RenderGameOverlayEvent.PreLayer event) {
        Crosshair crosshair = CrosshairHandler.get().getCurrentCrosshair();
        if (this.repairing && event.getOverlay() == ForgeIngameGui.CROSSHAIR_ELEMENT && (crosshair == null || crosshair.isDefault())) {
            event.setCanceled(true);
        }
    }

    public boolean isRepairing() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return false;
        }
        if (mc.f_91074_.m_5833_()) {
            return false;
        }
        if (mc.f_91080_ != null) {
            return false;
        }
        if (WearableHelper.PlayerWornRig((Player)mc.f_91074_).m_41619_()) {
            return false;
        }
        Rig rig = ((ArmorRigItem)WearableHelper.PlayerWornRig((Player)mc.f_91074_).m_41720_()).getRig();
        return this.repairTime != 0 && mc.f_91074_.m_21205_().m_41720_().getRegistryName().equals((Object)rig.getRepair().getItem()) && !WearableHelper.isFullDurability(WearableHelper.PlayerWornRig((Player)mc.f_91074_));
    }

    public double getNormalisedRepairProgress() {
        return this.normalisedRepairProgress;
    }
}

