/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns;

import com.tac.guns.Config;
import com.tac.guns.client.ClientHandler;
import com.tac.guns.client.CustomGunManager;
import com.tac.guns.client.CustomRigManager;
import com.tac.guns.client.render.model.IOverrideModel;
import com.tac.guns.client.render.model.OverrideModelManager;
import com.tac.guns.client.render.pose.OneHandedPoseHighRes_m1851;
import com.tac.guns.client.render.pose.OneHandedPoseHighRes_m1873;
import com.tac.guns.client.render.pose.OneHandedPoseHighRes_m1911;
import com.tac.guns.client.render.pose.TwoHandedPoseHighRes_ak47;
import com.tac.guns.client.render.pose.TwoHandedPoseHighRes_m1894;
import com.tac.guns.client.render.pose.TwoHandedPoseHighRes_m1928;
import com.tac.guns.client.render.pose.TwoHandedPoseHighRes_m60;
import com.tac.guns.client.render.pose.TwoHandedPoseHighRes_mosin;
import com.tac.guns.client.render.pose.TwoHandedPoseHighRes_vector;
import com.tac.guns.common.BoundingBoxManager;
import com.tac.guns.common.GripType;
import com.tac.guns.common.ProjectileManager;
import com.tac.guns.common.tooling.CommandsHandler;
import com.tac.guns.common.tooling.CommandsManager;
import com.tac.guns.crafting.RecipeType;
import com.tac.guns.datagen.BlockTagGen;
import com.tac.guns.datagen.ItemTagGen;
import com.tac.guns.datagen.LanguageGen;
import com.tac.guns.datagen.LootTableGen;
import com.tac.guns.datagen.RecipeGen;
import com.tac.guns.enchantment.EnchantmentTypes;
import com.tac.guns.entity.MissileEntity;
import com.tac.guns.entity.ProjectileEntity;
import com.tac.guns.init.ModBlocks;
import com.tac.guns.init.ModContainers;
import com.tac.guns.init.ModEffects;
import com.tac.guns.init.ModEnchantments;
import com.tac.guns.init.ModEntities;
import com.tac.guns.init.ModItems;
import com.tac.guns.init.ModParticleTypes;
import com.tac.guns.init.ModRecipeSerializers;
import com.tac.guns.init.ModSounds;
import com.tac.guns.init.ModSyncedDataKeys;
import com.tac.guns.init.ModTileEntities;
import com.tac.guns.inventory.gear.IWearableItemHandler;
import com.tac.guns.inventory.gear.armor.IAmmoItemHandler;
import com.tac.guns.item.GunItem;
import com.tac.guns.item.transition.TimelessGunItem;
import com.tac.guns.network.PacketHandler;
import java.lang.reflect.Field;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.core.NonNullList;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.forge.event.lifecycle.GatherDataEvent;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Mod(value="tac")
public class GunMod {
    public static boolean controllableLoaded = false;
    public static final Logger LOGGER = LogManager.getLogger((String)"tac");
    public static final CreativeModeTab GROUP = new CreativeModeTab("tac"){

        @NotNull
        public ItemStack m_6976_() {
            return new ItemStack((ItemLike)ModItems.VORTEX_LPVO_3_6.get());
        }

        public void m_6151_(NonNullList<ItemStack> items) {
            super.m_6151_(items);
            CustomGunManager.fill(items);
            CustomRigManager.fill(items);
        }
    }.m_40781_(new EnchantmentCategory[]{EnchantmentTypes.GUN, EnchantmentTypes.SEMI_AUTO_GUN});
    public static final CreativeModeTab PISTOL = new CreativeModeTab("Pistols"){

        public ItemStack m_6976_() {
            ItemStack stack = new ItemStack((ItemLike)ModItems.GLOCK_17.get());
            stack.m_41784_().m_128405_("AmmoCount", ((TimelessGunItem)ModItems.GLOCK_17.get()).getGun().getReloads().getMaxAmmo());
            return stack;
        }

        public void m_6151_(NonNullList<ItemStack> items) {
            super.m_6151_(items);
            CustomGunManager.fill(items);
        }
    };
    public static final CreativeModeTab SMG = new CreativeModeTab("SMGs"){

        public ItemStack m_6976_() {
            ItemStack stack = new ItemStack((ItemLike)ModItems.VECTOR45.get());
            stack.m_41784_().m_128405_("AmmoCount", ((GunItem)ModItems.VECTOR45.get()).getGun().getReloads().getMaxAmmo());
            return stack;
        }

        public void m_6151_(NonNullList<ItemStack> items) {
            super.m_6151_(items);
            CustomGunManager.fill(items);
        }
    };
    public static final CreativeModeTab RIFLE = new CreativeModeTab("AssaultRifles"){

        public ItemStack m_6976_() {
            ItemStack stack = new ItemStack((ItemLike)ModItems.AK47.get());
            stack.m_41784_().m_128405_("AmmoCount", ((GunItem)ModItems.AK47.get()).getGun().getReloads().getMaxAmmo());
            return stack;
        }

        public void m_6151_(NonNullList<ItemStack> items) {
            super.m_6151_(items);
            CustomGunManager.fill(items);
        }
    };
    public static final CreativeModeTab SNIPER = new CreativeModeTab("MarksmanRifles"){

        public ItemStack m_6976_() {
            ItemStack stack = new ItemStack((ItemLike)ModItems.AI_AWP.get());
            stack.m_41784_().m_128405_("AmmoCount", ((TimelessGunItem)ModItems.AI_AWP.get()).getGun().getReloads().getMaxAmmo());
            return stack;
        }

        public void m_6151_(NonNullList<ItemStack> items) {
            super.m_6151_(items);
            CustomGunManager.fill(items);
        }
    };
    public static final CreativeModeTab SHOTGUN = new CreativeModeTab("Shotguns"){

        public ItemStack m_6976_() {
            ItemStack stack = new ItemStack((ItemLike)ModItems.M1014.get());
            stack.m_41784_().m_128405_("AmmoCount", ((TimelessGunItem)ModItems.M1014.get()).getGun().getReloads().getMaxAmmo());
            return stack;
        }

        public void m_6151_(NonNullList<ItemStack> items) {
            super.m_6151_(items);
            CustomGunManager.fill(items);
        }
    };
    public static final CreativeModeTab HEAVY_MATERIAL = new CreativeModeTab("HeavyWeapons"){

        public ItemStack m_6976_() {
            ItemStack stack = new ItemStack((ItemLike)ModItems.M60.get());
            stack.m_41784_().m_128405_("AmmoCount", ((GunItem)ModItems.M60.get()).getGun().getReloads().getMaxAmmo());
            return stack;
        }

        public void m_6151_(NonNullList<ItemStack> items) {
            super.m_6151_(items);
            CustomGunManager.fill(items);
        }
    };
    public static final CreativeModeTab AMMO = new CreativeModeTab("Ammo"){

        public ItemStack m_6976_() {
            ItemStack stack = new ItemStack((ItemLike)ModItems.BULLET_308.get());
            return stack;
        }

        public void m_6151_(NonNullList<ItemStack> items) {
            super.m_6151_(items);
            CustomGunManager.fill(items);
        }
    };
    public static final CreativeModeTab EXPLOSIVES = new CreativeModeTab("Explosives"){

        public ItemStack m_6976_() {
            ItemStack stack = new ItemStack((ItemLike)ModItems.BASEBALL_GRENADE.get());
            return stack;
        }

        public void m_6151_(NonNullList<ItemStack> items) {
            super.m_6151_(items);
            CustomGunManager.fill(items);
        }
    };
    public static final CreativeModeTab SKINS = new CreativeModeTab("Skins"){

        public ItemStack m_6976_() {
            ItemStack stack = new ItemStack((ItemLike)ModItems.BLANK_SKIN_MOD_LVL1.get());
            return stack;
        }

        public void m_6151_(NonNullList<ItemStack> items) {
            super.m_6151_(items);
            CustomGunManager.fill(items);
        }
    };
    public static IModInfo modInfo = null;

    public GunMod() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)Config.clientSpec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.commonSpec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)Config.serverSpec);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        ModBlocks.init();
        ModBlocks.REGISTER.register(bus);
        ModContainers.REGISTER.register(bus);
        ModEffects.REGISTER.register(bus);
        ModEnchantments.REGISTER.register(bus);
        ModEntities.REGISTER.register(bus);
        ModItems.REGISTER.register(bus);
        ModParticleTypes.REGISTER.register(bus);
        ModRecipeSerializers.REGISTER.register(bus);
        ModSounds.REGISTER.register(bus);
        ModTileEntities.REGISTER.register(bus);
        ModSyncedDataKeys.register();
        bus.addListener(this::onCommonSetup);
        bus.addListener(this::onClientSetup);
        bus.addListener(this::dataSetup);
        controllableLoaded = ModList.get().isLoaded("controllable");
        modInfo = ModLoadingContext.get().getActiveContainer().getModInfo();
    }

    private void onCommonSetup(FMLCommonSetupEvent event) {
        ProjectileManager.getInstance().registerFactory((Item)ModItems.RPG7_MISSILE.get(), (worldIn, entity, weapon, item, modifiedGun, randP, randY) -> new MissileEntity((EntityType<? extends ProjectileEntity>)((EntityType)ModEntities.RPG7_MISSILE.get()), worldIn, entity, weapon, item, modifiedGun, 1.5f));
        PacketHandler.init();
        RecipeType.init();
        if (((Boolean)Config.COMMON.gameplay.improvedHitboxes.get()).booleanValue()) {
            MinecraftForge.EVENT_BUS.register((Object)new BoundingBoxManager());
        }
        GripType.registerType(new GripType(new ResourceLocation("tac", "one_handed_m1911"), new OneHandedPoseHighRes_m1911()));
        GripType.registerType(new GripType(new ResourceLocation("tac", "one_handed_m1851"), new OneHandedPoseHighRes_m1851()));
        GripType.registerType(new GripType(new ResourceLocation("tac", "two_handed_m1894"), new TwoHandedPoseHighRes_m1894()));
        GripType.registerType(new GripType(new ResourceLocation("tac", "two_handed_m1928"), new TwoHandedPoseHighRes_m1928()));
        GripType.registerType(new GripType(new ResourceLocation("tac", "two_handed_mosin"), new TwoHandedPoseHighRes_mosin()));
        GripType.registerType(new GripType(new ResourceLocation("tac", "two_handed_ak47"), new TwoHandedPoseHighRes_ak47()));
        GripType.registerType(new GripType(new ResourceLocation("tac", "two_handed_m60"), new TwoHandedPoseHighRes_m60()));
        GripType.registerType(new GripType(new ResourceLocation("tac", "two_handed_vector"), new TwoHandedPoseHighRes_vector()));
        GripType.registerType(new GripType(new ResourceLocation("tac", "one_handed_m1873"), new OneHandedPoseHighRes_m1873()));
        MinecraftForge.EVENT_BUS.register(CommandsManager.class);
        MinecraftForge.EVENT_BUS.register(CommandsHandler.class);
    }

    private void dataSetup(GatherDataEvent event) {
        DataGenerator dataGenerator = event.getGenerator();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        BlockTagGen blockTagGen = new BlockTagGen(dataGenerator, existingFileHelper);
        dataGenerator.m_123914_((DataProvider)new RecipeGen(dataGenerator));
        dataGenerator.m_123914_((DataProvider)new LootTableGen(dataGenerator));
        dataGenerator.m_123914_((DataProvider)blockTagGen);
        dataGenerator.m_123914_((DataProvider)new ItemTagGen(dataGenerator, blockTagGen, existingFileHelper));
        dataGenerator.m_123914_((DataProvider)new LanguageGen(dataGenerator));
    }

    private void onClientSetup(FMLClientSetupEvent event) {
        ClientHandler.setup(Minecraft.m_91087_());
        for (Field field : ModItems.class.getDeclaredFields()) {
            RegistryObject object;
            try {
                object = (RegistryObject)field.get(null);
            }
            catch (ClassCastException | IllegalAccessException e) {
                continue;
            }
            if (!TimelessGunItem.class.isAssignableFrom(object.get().getClass())) continue;
            try {
                OverrideModelManager.register((Item)object.get(), (IOverrideModel)Class.forName("com.tac.guns.client.render.model.gun." + field.getName().toLowerCase(Locale.ENGLISH) + "_animation").newInstance());
            }
            catch (ClassNotFoundException e) {
                LOGGER.warn("Could not load animations for gun - " + field.getName());
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public void onCapabilitySetup(RegisterCapabilitiesEvent event) {
        event.register(IAmmoItemHandler.class);
        event.register(IWearableItemHandler.class);
    }
}

