/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns;

import com.tac.guns.client.render.crosshair.Crosshair;
import java.util.Collections;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class Config {
    static final ForgeConfigSpec clientSpec;
    public static final Client CLIENT;
    static final ForgeConfigSpec commonSpec;
    public static final Common COMMON;
    static final ForgeConfigSpec serverSpec;
    public static final Server SERVER;

    public static void saveClientConfig() {
        clientSpec.save();
    }

    static {
        Pair clientSpecPair = new ForgeConfigSpec.Builder().configure(Client::new);
        clientSpec = (ForgeConfigSpec)clientSpecPair.getRight();
        CLIENT = (Client)clientSpecPair.getLeft();
        Pair commonSpecPair = new ForgeConfigSpec.Builder().configure(Common::new);
        commonSpec = (ForgeConfigSpec)commonSpecPair.getRight();
        COMMON = (Common)commonSpecPair.getLeft();
        Pair serverSpecPair = new ForgeConfigSpec.Builder().configure(Server::new);
        serverSpec = (ForgeConfigSpec)serverSpecPair.getRight();
        SERVER = (Server)serverSpecPair.getLeft();
    }

    public static class Client {
        public final Sounds sounds;
        public final Display display;
        public final Particle particle;
        public final Controls controls;
        public final WeaponGUI weaponGUI;
        public final Quality quality;
        public final RightClickUse rightClickUse;

        public Client(ForgeConfigSpec.Builder builder) {
            builder.push("client");
            this.sounds = new Sounds(builder);
            this.display = new Display(builder);
            this.particle = new Particle(builder);
            this.controls = new Controls(builder);
            this.quality = new Quality(builder);
            this.weaponGUI = new WeaponGUI(builder);
            this.rightClickUse = new RightClickUse(builder);
            builder.pop();
        }
    }

    public static class Common {
        public final Gameplay gameplay;
        public final Network network;
        public final AggroMobs aggroMobs;
        public final Missiles missiles;
        public final Grenades grenades;
        public final StunGrenades stunGrenades;
        public final ProjectileSpread projectileSpread;
        public final Development development;

        public Common(ForgeConfigSpec.Builder builder) {
            builder.push("common");
            this.gameplay = new Gameplay(builder);
            this.network = new Network(builder);
            this.aggroMobs = new AggroMobs(builder);
            this.missiles = new Missiles(builder);
            this.grenades = new Grenades(builder);
            this.stunGrenades = new StunGrenades(builder);
            this.projectileSpread = new ProjectileSpread(builder);
            this.development = new Development(builder);
            builder.pop();
        }
    }

    public static class Server {
        public final ForgeConfigSpec.IntValue alphaOverlay;
        public final ForgeConfigSpec.IntValue alphaFadeThreshold;
        public final ForgeConfigSpec.DoubleValue soundPercentage;
        public final ForgeConfigSpec.IntValue soundFadeThreshold;
        public final ForgeConfigSpec.DoubleValue ringVolume;
        public final ForgeConfigSpec.DoubleValue gunShotMaxDistance;
        public final ForgeConfigSpec.BooleanValue enableCameraRecoil;

        public Server(ForgeConfigSpec.Builder builder) {
            builder.push("server");
            builder.comment("Stun Grenade related properties").push("grenade");
            this.alphaOverlay = builder.comment("After the duration drops to this many ticks, the transparency of the overlay when blinded will gradually fade to 0 alpha.").defineInRange("alphaOverlay", 255, 0, 255);
            this.alphaFadeThreshold = builder.comment("Transparency of the overlay when blinded will be this alpha value, before eventually fading to 0 alpha.").defineInRange("alphaFadeThreshold", 40, 0, Integer.MAX_VALUE);
            this.soundPercentage = builder.comment("Volume of most game sounds when deafened will play at this percent, before eventually fading back to %100.").defineInRange("soundPercentage", 0.05, 0.0, 1.0);
            this.soundFadeThreshold = builder.comment("After the duration drops to this many ticks, the ringing volume will gradually fade to 0 and other sound volumes will fade back to %100.").defineInRange("soundFadeThreshold", 90, 0, Integer.MAX_VALUE);
            this.ringVolume = builder.comment("Volume of the ringing sound when deafened will play at this volume, before eventually fading to 0.").defineInRange("ringVolume", 1.0, 0.0, 1.0);
            builder.pop();
            builder.comment("Audio properties").push("audio");
            this.gunShotMaxDistance = builder.comment("The maximum distance weapons can be heard by players.").defineInRange("gunShotMaxDistance", 100.0, 0.0, Double.MAX_VALUE);
            builder.pop();
            this.enableCameraRecoil = builder.comment("If true, enables camera recoil when firing a weapon").define("enableCameraRecoil", true);
            builder.pop();
        }
    }

    public static class ProjectileSpread {
        public final ForgeConfigSpec.IntValue spreadThreshold;
        public final ForgeConfigSpec.IntValue maxCount;
        public final ForgeConfigSpec.BooleanValue movementInaccuracy;

        public ProjectileSpread(ForgeConfigSpec.Builder builder) {
            builder.comment("Properties relating to projectile spread").push("projectile_spread");
            this.spreadThreshold = builder.comment("The amount of time in milliseconds before logic to apply spread is skipped. The value indicates a reasonable amount of time before a weapon is considered stable again.").defineInRange("spreadThreshold", 300, 0, 1000);
            this.maxCount = builder.comment("The amount of times a player has to shoot within the spread threshold before the maximum amount of spread is applied. Setting the value higher means it will take longer for the spread to be applied.").defineInRange("maxCount", 3, 1, Integer.MAX_VALUE);
            this.movementInaccuracy = builder.comment("Weapon grows more inaccurate depending if the player is in motion (Forward, Strafing, Jumping)").define("movementInaccuracy", true);
            builder.pop();
        }
    }

    public static class EffectCriteria {
        public final ForgeConfigSpec.DoubleValue radius;
        public final ForgeConfigSpec.IntValue durationMax;
        public final ForgeConfigSpec.IntValue durationMin;
        public final ForgeConfigSpec.DoubleValue angleEffect;
        public final ForgeConfigSpec.DoubleValue angleAttenuationMax;
        public final ForgeConfigSpec.BooleanValue raytraceOpaqueBlocks;

        public EffectCriteria(ForgeConfigSpec.Builder builder, double radius, int durationMax, int durationMin, double angleEffect, double angleAttenuationMax, boolean raytraceOpaqueBlocks) {
            builder.push("effect_criteria");
            this.radius = builder.comment("Grenade must be no more than this many meters away to have an effect.").defineInRange("radius", radius, 0.0, Double.MAX_VALUE);
            this.durationMax = builder.comment("Effect will have this duration (in ticks) if the grenade is directly at the player's eyes while looking directly at it.").defineInRange("durationMax", durationMax, 0, Integer.MAX_VALUE);
            this.durationMin = builder.comment("Effect will have this duration (in ticks) if the grenade is the maximum distance from the player's eyes while looking directly at it.").defineInRange("durationMin", durationMin, 0, Integer.MAX_VALUE);
            this.angleEffect = builder.comment("Angle between the eye/looking direction and the eye/grenade direction must be no more than half this many degrees to have an effect.").defineInRange("angleEffect", angleEffect, 0.0, 360.0);
            this.angleAttenuationMax = builder.comment("After duration is attenuated by distance, it will be further attenuated depending on the angle (in degrees) between the eye/looking direction and the eye/grenade direction. This is done by multiplying it by 1 (no attenuation) if the angle is 0; and by this value if the angle is the maximum within the angle of effect.").defineInRange("angleAttenuationMax", angleAttenuationMax, 0.0, 1.0);
            this.raytraceOpaqueBlocks = builder.comment("If true, the effect is only applied if the line between the eyes and the grenade does not intersect any non-liquid blocks with an opacity greater than 0.").define("raytraceOpaqueBlocks", raytraceOpaqueBlocks);
            builder.pop();
        }
    }

    public static class Deafen {
        public final EffectCriteria criteria;
        public final ForgeConfigSpec.BooleanValue panicMobs;

        public Deafen(ForgeConfigSpec.Builder builder) {
            builder.comment("Deafening properties of stun grenades").push("deafen");
            this.criteria = new EffectCriteria(builder, 15.0, 280, 100, 360.0, 0.75, false);
            this.panicMobs = builder.comment("If true, peaceful mobs will panic upon being deafened by a stun grenade.").define("panicMobs", true);
            builder.pop();
        }
    }

    public static class Blind {
        public final EffectCriteria criteria;
        public final ForgeConfigSpec.BooleanValue blindMobs;

        public Blind(ForgeConfigSpec.Builder builder) {
            builder.comment("Blinding properties of stun grenades").push("blind");
            this.criteria = new EffectCriteria(builder, 15.0, 220, 10, 170.0, 0.75, true);
            this.blindMobs = builder.comment("If true, hostile mobs will be unable to target entities while they are blinded by a stun grenade.").define("blindMobs", true);
            builder.pop();
        }
    }

    public static class StunGrenades {
        public final Blind blind;
        public final Deafen deafen;

        public StunGrenades(ForgeConfigSpec.Builder builder) {
            builder.comment("Properties relating to stun grenades").push("stun_grenades");
            this.blind = new Blind(builder);
            this.deafen = new Deafen(builder);
            builder.pop();
        }
    }

    public static class Grenades {
        public final ForgeConfigSpec.DoubleValue explosionRadius;

        public Grenades(ForgeConfigSpec.Builder builder) {
            builder.comment("Properties relating to grenades").push("grenades");
            this.explosionRadius = builder.comment("The max distance which the explosion is effective to").defineInRange("explosionRadius", 5.0, 0.0, Double.MAX_VALUE);
            builder.pop();
        }
    }

    public static class Missiles {
        public final ForgeConfigSpec.DoubleValue explosionRadius;

        public Missiles(ForgeConfigSpec.Builder builder) {
            builder.comment("Properties relating to missiles").push("missiles");
            this.explosionRadius = builder.comment("The max distance which the explosion is effective to").defineInRange("explosionRadius", 5.0, 0.0, Double.MAX_VALUE);
            builder.pop();
        }
    }

    public static class AggroMobs {
        public final ForgeConfigSpec.BooleanValue enabled;
        public final ForgeConfigSpec.BooleanValue angerHostileMobs;
        public final ForgeConfigSpec.DoubleValue range;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> exemptEntities;

        public AggroMobs(ForgeConfigSpec.Builder builder) {
            builder.comment("Properties relating to mob aggression").push("aggro_mobs");
            this.enabled = builder.comment("If true, nearby mobs are angered and/or scared by the firing of guns.").define("enabled", true);
            this.angerHostileMobs = builder.comment("If true, in addition to causing peaceful mobs to panic, firing a gun will also cause nearby hostile mobs to target the shooter.").define("angerHostileMobs", true);
            this.range = builder.comment("Any mobs within a sphere of this radius will aggro on the shooter of an unsilenced gun.").defineInRange("unsilencedRange", 20.0, 0.0, Double.MAX_VALUE);
            this.exemptEntities = builder.comment("Any mobs of defined will not aggro on shooters").defineList("exemptMobs", Collections.emptyList(), o -> true);
            builder.pop();
        }
    }

    public static class Network {
        public final ForgeConfigSpec.DoubleValue projectileTrackingRange;

        public Network(ForgeConfigSpec.Builder builder) {
            builder.comment("Properties relating to network").push("network");
            this.projectileTrackingRange = builder.comment("The distance players need to be within to be able to track new projectiles trails. Higher values means you can see projectiles from that start from further away.").defineInRange("projectileTrackingRange", 200.0, 1.0, Double.MAX_VALUE);
            builder.pop();
        }
    }

    public static class Development {
        public final ForgeConfigSpec.BooleanValue permanentCrosshair;
        public final ForgeConfigSpec.BooleanValue enableTDev;
        public final ForgeConfigSpec.ConfigValue<String> TDevPath;
        public final ForgeConfigSpec.BooleanValue bulletSelfHarm;

        public Development(ForgeConfigSpec.Builder builder) {
            builder.comment("Development").push("development");
            this.permanentCrosshair = builder.comment("If enabled any crosshair will continue to render on aim.").define("permanentCrosshair", false);
            this.enableTDev = builder.comment("If enabled, /tdev will both be registered (Upon restart), and function! Used as well to speed up tag checks").define("enableTDev", false);
            this.TDevPath = builder.comment("Directory to build all TaC sub-directories, these will contain export data from /tdev functions").define("tDevPath", (Object)"");
            this.bulletSelfHarm = builder.comment("Wether the shooters bullets can harm the shooter, great for testing armor and onhit effects with the development gun").define("bulletSelfHarm", false);
            builder.pop();
        }
    }

    public static class Gameplay {
        public final ForgeConfigSpec.BooleanValue enableGunGriefing;
        public final ForgeConfigSpec.DoubleValue growBoundingBoxAmountV2;
        public final ForgeConfigSpec.BooleanValue enableHeadShots;
        public final ForgeConfigSpec.DoubleValue headShotDamageMultiplier;
        public final ForgeConfigSpec.DoubleValue criticalDamageMultiplier;
        public final ForgeConfigSpec.BooleanValue ignoreLeaves;
        public final ForgeConfigSpec.BooleanValue enableKnockback;
        public final ForgeConfigSpec.DoubleValue knockbackStrength;
        public final ForgeConfigSpec.BooleanValue improvedHitboxes;
        public final ForgeConfigSpec.BooleanValue realisticLowPowerFovHandling;
        public final ForgeConfigSpec.BooleanValue realisticIronSightFovHandling;
        public final ForgeConfigSpec.BooleanValue realisticAimedBreathing;
        public final ForgeConfigSpec.BooleanValue safetyExistence;
        public final ForgeConfigSpec.BooleanValue bulletsIgnoreStandardArmor;
        public final ForgeConfigSpec.DoubleValue percentDamageIgnoresStandardArmor;
        public final ForgeConfigSpec.BooleanValue renderTaCArmor;
        public final ForgeConfigSpec.BooleanValue armorBluntDamage;
        public final ForgeConfigSpec.BooleanValue forceCameraShakeOnFire;
        public final ForgeConfigSpec.BooleanValue canSeeLaserThirdSight;
        public final ForgeConfigSpec.BooleanValue glassDrop;

        public Gameplay(ForgeConfigSpec.Builder builder) {
            builder.comment("Properties relating to gameplay").push("gameplay");
            this.enableGunGriefing = builder.comment("If enable, allows guns to shoot out glass and remove blocks on explosions").define("enableGunGriefing", true);
            this.growBoundingBoxAmountV2 = builder.comment("The extra amount to expand an entity's bounding box when checking for projectile collision. Setting this value higher will make it easier to hit entities").defineInRange("growBoundingBoxAmountV2", 0.0, 0.0, 1.0);
            this.enableHeadShots = builder.comment("Enables the check for head shots for players. Projectiles that hit the head of a player will have increased damage.").define("enableHeadShots", true);
            this.headShotDamageMultiplier = builder.comment("The value to multiply the damage by if projectile hit the players head").defineInRange("headShotDamageMultiplier", 2.0, 1.0, Double.MAX_VALUE);
            this.criticalDamageMultiplier = builder.comment("The value to multiply the damage by if projectile is a critical hit").defineInRange("criticalDamageMultiplier", 2.0, 1.0, Double.MAX_VALUE);
            this.ignoreLeaves = builder.comment("If true, projectiles will ignore leaves when checking for collision").define("ignoreLeaves", true);
            this.enableKnockback = builder.comment("If true, projectiles will cause knockback when an entity is hit. By default this is set to true to match the behaviour of Minecraft.").define("enableKnockback", true);
            this.knockbackStrength = builder.comment("Sets the strength of knockback when shot by a bullet projectile. Knockback must be enabled for this to take effect. If value is equal to zero, knockback will use default minecraft value").defineInRange("knockbackStrength", 0.15, 0.0, 1.0);
            this.improvedHitboxes = builder.comment("If true, improves the accuracy of weapons by considering the ping of the player. This has no affect on singleplayer. This will add a little overhead if enabled.").define("improvedHitboxes", false);
            this.safetyExistence = builder.comment("Enables the safe mode on weapons, false completely nullifies the existence of the safety").define("safetyExistence", false);
            this.realisticLowPowerFovHandling = builder.comment("Optics with 0 fov modification will not affect the players fov at all").define("realisticLowPowerFovHandling", false);
            this.realisticIronSightFovHandling = builder.comment("Iron sights fov modification will not affect the players fov at all").define("realisticIronSightFovHandling", false);
            this.realisticAimedBreathing = builder.comment("Aiming will present a breathing animation, moving the weapon over time, crouch to lower it's effects").define("realisticAimedBreathing", false);
            this.bulletsIgnoreStandardArmor = builder.comment("Bullets completely ignore Minecraft armor, forcing you to use our armor system.").define("bulletsIgnoreStandardArmor", true);
            this.percentDamageIgnoresStandardArmor = builder.comment("The percent of the damage to be applied standard, AKA Minecraft armor reduces this portion of the damage, while the rest passes through freely, only active when either armor hits 0 or no TaC armor worn at all, 0 = Minecraft armor effectiveness doesn't change, 1 = Minecraft armor never effects bullet damage.").defineInRange("percentDamageIgnoresStandardArmor", 0.5, 0.0, 1.0);
            this.renderTaCArmor = builder.comment("Enable rendering of TaC armor on the player, useful if other armors are taking priority, doesn't fit gameplay theme, or not performant enough.").define("renderTaCArmor", true);
            this.armorBluntDamage = builder.comment("All weapons have a percentage of damage applied, no matter the class match up, false means blunt damage is never applied before armor calc.").define("armorBluntDamage", true);
            this.forceCameraShakeOnFire = builder.comment("Force camera shake on for all players, since control over the weapon is reduced with this off, having a client only options could lead to balance issues.").define("forceCameraShakeOnFire", false);
            this.canSeeLaserThirdSight = builder.comment("Allow players to see the laser sight when they are third person sight, false means they can't see it.").define("canSeeLaserThirdSight", true);
            this.glassDrop = builder.comment("Allow glass to be dropped, false means it will be totally broken.").define("glassDrop", true);
            builder.pop();
        }
    }

    public static class Quality {
        public final ForgeConfigSpec.BooleanValue reducedQualityHotBar;
        public final ForgeConfigSpec.BooleanValue worldRerenderPiPAlpha;

        public Quality(ForgeConfigSpec.Builder builder) {
            builder.comment("Properties relating to improving graphical performance (Currently unsupported, do not attempt to change these settings until announcements are made about these features!)").push("quality");
            this.reducedQualityHotBar = builder.comment("If enabled all main weapons will be unloaded and replaced with lower quality and legacy models, not all guns maybe replaced with this mode!").define("reducedQualityHotBar", true);
            this.worldRerenderPiPAlpha = builder.comment("WARNING ALPHA!... If enabled the DR of scopes will use a new rendering method, this has some ability to work with shaders, however unlikely, best performance is found in vanilla. RESTART REQUIRED").define("worldRerenderPiPAlpha", false);
            builder.pop();
        }
    }

    public static class Controls {
        public final ForgeConfigSpec.DoubleValue aimDownSightSensitivity;
        public final ForgeConfigSpec.BooleanValue holdToAim;
        public final ForgeConfigSpec.BooleanValue burstPress;

        public Controls(ForgeConfigSpec.Builder builder) {
            builder.comment("Properties relating to controls").push("controls");
            this.aimDownSightSensitivity = builder.comment("A value to multiple the mouse sensitivity by when aiming down weapon sights. Go to (Options > Controls > Mouse Settings > ADS Sensitivity) in game to change this!").defineInRange("aimDownSightSensitivity", 1.0, 0.0, 2.0);
            this.holdToAim = builder.comment("If true, you need to hold the aim key to aim, false to toggle the aim state by aim key").define("holdToAim", true);
            this.burstPress = builder.comment("Press to use a burst fire a gun, if false, burst will become semi shoot").define("burstPress", true);
            builder.pop();
        }
    }

    public static class Particle {
        public final ForgeConfigSpec.IntValue bulletHoleLifeMin;
        public final ForgeConfigSpec.IntValue bulletHoleLifeMax;
        public final ForgeConfigSpec.DoubleValue bulletHoleFadeThreshold;
        public final ForgeConfigSpec.BooleanValue enableBlood;

        public Particle(ForgeConfigSpec.Builder builder) {
            builder.comment("Properties relating to particles").push("particle");
            this.bulletHoleLifeMin = builder.comment("The minimum duration in ticks before bullet holes will disappear").defineInRange("bulletHoleLifeMin", 250, 0, Integer.MAX_VALUE);
            this.bulletHoleLifeMax = builder.comment("The maximum duration in ticks before bullet holes will disappear").defineInRange("bulletHoleLifeMax", 800, 0, Integer.MAX_VALUE);
            this.bulletHoleFadeThreshold = builder.comment("The percentage of the maximum life that must pass before particles begin fading away. 0 makes the particles always fade and 1 removes facing completely").defineInRange("bulletHoleFadeThreshold", 0.98, 0.0, 1.0);
            this.enableBlood = builder.comment("If true, blood will will spawn from entities that are hit from a projectile").define("enableBlood", false);
            builder.pop();
        }
    }

    public static class WeaponReloadTimer {
        public final ForgeConfigSpec.BooleanValue showWeaponReloadTimer;
        public final ForgeConfigSpec.DoubleValue weaponReloadTimerSize;
        public final ForgeConfigSpec.DoubleValue x;
        public final ForgeConfigSpec.DoubleValue y;

        public WeaponReloadTimer(ForgeConfigSpec.Builder builder) {
            builder.comment("Configuration for HUD reloading timer bar").push("weaponReloadTimer");
            this.showWeaponReloadTimer = builder.comment("Display the amount of ammunition your weapon holds and can hold on your HUD.").define("showWeaponAmmoCounter", true);
            this.weaponReloadTimerSize = builder.comment("Size of the weapon ammunition counter on your HUD").defineInRange("weaponAmmoCounterSize", 1.0, 0.01, 4.0);
            this.x = builder.comment("X Position on your HUD.").defineInRange("XLocation", 0.0, -500.0, 500.0);
            this.y = builder.comment("Y Position on your HUD.").defineInRange("YLocation", 0.0, -500.0, 500.0);
            builder.pop();
        }
    }

    public static class WeaponFireMode {
        public final ForgeConfigSpec.BooleanValue showWeaponFireMode;
        public final ForgeConfigSpec.DoubleValue weaponFireModeSize;
        public final ForgeConfigSpec.DoubleValue x;
        public final ForgeConfigSpec.DoubleValue y;

        public WeaponFireMode(ForgeConfigSpec.Builder builder) {
            builder.comment("Configuration for HUD additions").push("weaponFireMode");
            this.showWeaponFireMode = builder.comment("Display the weapon's fire mode on your HUD.").define("showWeaponFireMode", true);
            this.weaponFireModeSize = builder.comment("Size of the weapon's fire mode on your HUD").defineInRange("weaponFireModeSize", 1.0, 0.01, 4.0);
            this.x = builder.comment("X Position on your HUD.").defineInRange("XLocation", 0.0, -500.0, 500.0);
            this.y = builder.comment("Y Position on your HUD.").defineInRange("YLocation", 0.0, -500.0, 500.0);
            builder.pop();
        }
    }

    public static class WeaponAmmoCounter {
        public final ForgeConfigSpec.BooleanValue showWeaponAmmoCounter;
        public final ForgeConfigSpec.DoubleValue weaponAmmoCounterSize;
        public final ForgeConfigSpec.DoubleValue x;
        public final ForgeConfigSpec.DoubleValue y;

        public WeaponAmmoCounter(ForgeConfigSpec.Builder builder) {
            builder.comment("Configuration for HUD additions").push("weaponAmmoCounter");
            this.showWeaponAmmoCounter = builder.comment("Display the amount of ammunition your weapon holds and can hold on your HUD.").define("showWeaponAmmoCounter", true);
            this.weaponAmmoCounterSize = builder.comment("Size of the weapon ammunition counter on your HUD").defineInRange("weaponAmmoCounterSize", 1.0, 0.01, 4.0);
            this.x = builder.comment("X Position on your HUD.").defineInRange("XLocation", 0.0, -500.0, 500.0);
            this.y = builder.comment("Y Position on your HUD.").defineInRange("YLocation", 0.0, -500.0, 500.0);
            builder.pop();
        }
    }

    public static class WeaponTypeIcon {
        public final ForgeConfigSpec.BooleanValue showWeaponIcon;
        public final ForgeConfigSpec.DoubleValue weaponIconSize;
        public final ForgeConfigSpec.DoubleValue x;
        public final ForgeConfigSpec.DoubleValue y;

        public WeaponTypeIcon(ForgeConfigSpec.Builder builder) {
            builder.comment("Configuration for HUD additions").push("weaponTypeIcon");
            this.showWeaponIcon = builder.comment("Display the weapon type Icon on your HUD.").define("showWeaponIcon", true);
            this.weaponIconSize = builder.comment("Size of the weapon type Icon on your HUD").defineInRange("weaponIconSize", 1.0, 0.01, 4.0);
            this.x = builder.comment("X Position on your HUD.").defineInRange("XLocation", 0.0, -500.0, 500.0);
            this.y = builder.comment("Y Position on your HUD.").defineInRange("YLocation", 0.0, -500.0, 500.0);
            builder.pop();
        }
    }

    public static class RightClickUse {
        public final ForgeConfigSpec.BooleanValue allowRestUse;
        public final ForgeConfigSpec.BooleanValue allowChests;
        public final ForgeConfigSpec.BooleanValue allowLever;
        public final ForgeConfigSpec.BooleanValue allowButton;
        public final ForgeConfigSpec.BooleanValue allowDoors;
        public final ForgeConfigSpec.BooleanValue allowTrapDoors;
        public final ForgeConfigSpec.BooleanValue allowCraftingTable;
        public final ForgeConfigSpec.BooleanValue allowFenceGates;

        public RightClickUse(ForgeConfigSpec.Builder builder) {
            builder.comment("Control what can interact with when holding gun in hand.").push("rightClickUses");
            this.allowChests = builder.comment("Whether allow chest use").define("allowChests", false);
            this.allowLever = builder.comment("Whether allow lever use").define("allowLever", true);
            this.allowButton = builder.comment("Whether allow button use").define("allowButton", true);
            this.allowDoors = builder.comment("Whether allow door use").define("allowDoors", false);
            this.allowTrapDoors = builder.comment("Whether allow trap door use").define("allowTrapDoors", false);
            this.allowCraftingTable = builder.comment("Whether allow crafting table use").define("allowCraftingTable", false);
            this.allowFenceGates = builder.comment("Whether allow fence gates use").define("allowFenceGates", false);
            this.allowRestUse = builder.comment("Whether allow to interact with rest stuffs.").define("allowRestUse", false);
            builder.pop();
        }
    }

    public static class WeaponGUI {
        public final ForgeConfigSpec.BooleanValue weaponGui;
        public final WeaponTypeIcon weaponTypeIcon;
        public final WeaponFireMode weaponFireMode;
        public final WeaponAmmoCounter weaponAmmoCounter;
        public final WeaponReloadTimer weaponReloadTimer;

        public WeaponGUI(ForgeConfigSpec.Builder builder) {
            builder.comment("Configuration for HUD additions").push("weaponGui");
            this.weaponGui = builder.comment("Show your ammunition as numbers, reloading timer, weapon icon, and fire mode all on the HUD.").define("weaponGui", true);
            this.weaponTypeIcon = new WeaponTypeIcon(builder);
            this.weaponFireMode = new WeaponFireMode(builder);
            this.weaponAmmoCounter = new WeaponAmmoCounter(builder);
            this.weaponReloadTimer = new WeaponReloadTimer(builder);
            builder.pop();
        }
    }

    public static class Display {
        public final ForgeConfigSpec.BooleanValue oldAnimations;
        public final ForgeConfigSpec.ConfigValue<String> crosshair;
        public final ForgeConfigSpec.BooleanValue weaponAmmoBar;
        public final ForgeConfigSpec.BooleanValue gameplayEnchancedScopeOffset;
        public final ForgeConfigSpec.BooleanValue scopeDoubleRender;
        public final ForgeConfigSpec.BooleanValue redDotSquishUpdate;
        public final ForgeConfigSpec.BooleanValue sight1xRealisticPosition;
        public final ForgeConfigSpec.IntValue cameraShakeOnHit;
        public final ForgeConfigSpec.BooleanValue cameraShakeOptionGlobal;
        public final ForgeConfigSpec.BooleanValue cameraShakeOnFire;
        public final ForgeConfigSpec.BooleanValue weaponDelayedSway;
        public final ForgeConfigSpec.BooleanValue showFirstPersonBulletTrails;
        public final ForgeConfigSpec.DoubleValue weaponDelayedSwayMaximum;
        public final ForgeConfigSpec.DoubleValue weaponDelayedSwayMultiplier;
        public final ForgeConfigSpec.BooleanValue weaponDelayedSwayDirection;
        public final ForgeConfigSpec.BooleanValue weaponDelayedSwayYNOptical;
        public final ForgeConfigSpec.BooleanValue showBulletTrails;
        public final ForgeConfigSpec.DoubleValue bulletTrailOpacity;
        public final ForgeConfigSpec.BooleanValue showHitMarkers;

        public Display(ForgeConfigSpec.Builder builder) {
            builder.comment("Configuration for display related options").push("display");
            this.oldAnimations = builder.comment("If true, uses the old animation poses for weapons. This is only for nostalgic reasons and not recommended to switch back.").define("oldAnimations", false);
            this.crosshair = builder.comment("The custom crosshair to use for weapons. Go to (Options > Controls > Mouse Settings > Crosshair) in game to change this!").define("crosshair", (Object)Crosshair.DEFAULT.getLocation().toString());
            this.weaponAmmoBar = builder.comment("Show % of your ammo in your gun via a colored durability bar. Set to false to remove bar entirely for more realistic gameplay").define("weaponAmmoBar", false);
            this.gameplayEnchancedScopeOffset = builder.comment("Scopes are brought closer to the shooter to help fill FOV with a scope view at all times").define("gameplayEnchancedScopeOffset", true);
            this.scopeDoubleRender = builder.comment("Enable picture in picture rendering for scopes, saves on some performance and issues with Optifine").define("scopeDoubleRender", false);
            this.redDotSquishUpdate = builder.comment("Enable 0 fov multiplied sights (Dot/Holo sights) to render in 2d when aimed like the scopeDoubleRender(false) effect.").define("redDotSquishUpdate", false);
            this.sight1xRealisticPosition = builder.comment("Enable 0 fov multiplied sights (Dot/Holo sights) to be viewed realisticly, with the players head static for iron sights, and 1x optics").define("sight1xRealisticPostion", false);
            this.cameraShakeOnHit = builder.comment("Shake camera when hit, 0 = no camera shake when you are hit, while holding a gun, meant to help reduce jarring feel when attempting to aim.").defineInRange("cameraShakeOnHit", 6, 0, 10);
            this.cameraShakeOptionGlobal = builder.comment("Enable the cameraShakeOnHit option to always take effect, holding a gun or not, keep false for vanilla gameplay to remain vanilla.").define("cameraShakeOptionGlobal", false);
            this.cameraShakeOnFire = builder.comment("Shake camera when firing the weapon, currently in beta but will be expanded on in the future, if it causes vomit, DISABLE, else enjoy!").define("cameraShakeOnFire", true);
            this.showFirstPersonBulletTrails = builder.comment("Attempt to show bullet trails from your own gun, currently ALPHA, doesn't map to the barrel of weapons and maybe distracting.").define("showFirstPersonBulletTrails", true);
            this.weaponDelayedSway = builder.comment("When looking around the weapon sways smoothly in delay with the camera movement. Disable if distracting with scopes.").define("weaponDelayedSway", true);
            this.weaponDelayedSwayMaximum = builder.comment("Maximum degrees the weapon's delayed sway can rotate the weapon.").defineInRange("weaponDelayedSwayMaximum", 3.35, 0.5, 10.0);
            this.weaponDelayedSwayMultiplier = builder.comment("Adjusts the sensitivity of the weapon's delayed sway, depending on mouse / head, movement.").defineInRange("weaponDelayedSwayMultiplier", -0.1, -0.4, -0.05);
            this.weaponDelayedSwayDirection = builder.comment("If true, the weapon will drag against the aiming point, false will drag the aiming point on sway.").define("weaponDelayedSwayDirection", false);
            this.weaponDelayedSwayYNOptical = builder.comment("If true, the weapon will drag against the aiming point ONLY if an optic is added.").define("weaponDelayedSwayYNOptical", false);
            this.showBulletTrails = builder.comment("Choose to see any bullet trails, trails by you or any other player / bot will not appear. Helps with Shader compatability.").define("showBulletTrails", true);
            this.bulletTrailOpacity = builder.comment("Adjusts the opacity, AKA how see through the bullet trails are seen as, higher values can be seen better indoors or at daytime.").defineInRange("bulletTrailOpacity", 0.5, 0.1, 1.0);
            this.showHitMarkers = builder.comment("If enabled, when a bullet hits an entity, a cross will be briefly displayed at the center of the screen to indicate that the target has been hit.").define("showHitMarkers", true);
            builder.pop();
        }
    }

    public static class Sounds {
        public final ForgeConfigSpec.BooleanValue playSoundWhenHeadshot;
        public final ForgeConfigSpec.ConfigValue<String> headshotSound;
        public final ForgeConfigSpec.BooleanValue playSoundWhenCritical;
        public final ForgeConfigSpec.ConfigValue<String> criticalSound;
        public final ForgeConfigSpec.DoubleValue weaponsVolume;

        public Sounds(ForgeConfigSpec.Builder builder) {
            builder.comment("Control sounds triggered by guns").push("sounds");
            this.weaponsVolume = builder.comment("Show your ammunition as numbers, reloading timer, weapon icon, and fire mode all on the HUD.").defineInRange("weaponsVolume", 1.0, 0.0, 1.0);
            this.playSoundWhenHeadshot = builder.comment("If true, a sound will play when you successfully hit a headshot on a entity with a gun").define("playSoundWhenHeadshot", true);
            this.headshotSound = builder.comment("The sound to play when a headshot occurs").define("headshotSound", (Object)"minecraft:entity.player.attack.crit");
            this.playSoundWhenCritical = builder.comment("If true, a sound will play when you successfully hit a critical on a entity with a gun").define("playSoundWhenCritical", true);
            this.criticalSound = builder.comment("The sound to play when a critical occurs").define("criticalSound", (Object)"minecraft:entity.player.attack.crit");
            builder.pop();
        }
    }
}

