/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;

public interface TypeLocator {
    default public Method tryFindMethod(Class<?> aClass, MethodData ... methodData) {
        try {
            return this.findMethod(aClass, methodData);
        }
        catch (RuntimeException e) {
            int i;
            for (i = 97; i <= 122; ++i) {
                try {
                    this.findMethod(aClass, new MethodData(methodData[0].isDeclared, "" + (char)i, aClass));
                    continue;
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
            for (i = 65; i <= 90; ++i) {
                try {
                    this.findMethod(aClass, new MethodData(methodData[0].isDeclared, "" + (char)i, aClass));
                    continue;
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
            throw e;
        }
    }

    default public Method findMethod(Class<?> aClass, MethodData ... methodData) {
        for (MethodData md : methodData) {
            try {
                return md.get(aClass);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
        }
        throw new RuntimeException("Method not found: " + aClass.getName() + " " + Arrays.toString(methodData));
    }

    default public Method findMethod(ClassNames classNames, MethodData ... methodData) {
        for (MethodData md : methodData) {
            for (String name : classNames.names) {
                try {
                    return md.get(Class.forName(name));
                }
                catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {
                }
            }
        }
        throw new RuntimeException("Method not found: " + classNames + " " + Arrays.toString(methodData));
    }

    default public Class<?> findClass(String ... names) {
        for (String name : names) {
            try {
                return Class.forName(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        throw new RuntimeException("Class not found: " + Arrays.toString(names) + " " + Arrays.toString(names));
    }

    default public ConstructorContainer<?> findConstructor(ClassNames classNames, ParamsData paramsData) {
        for (String name : classNames.names) {
            try {
                return new ConstructorContainer(Class.forName(name).getConstructor(paramsData.params));
            }
            catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {
            }
        }
        throw new RuntimeException("Class not found: " + classNames + " " + paramsData);
    }

    public static class MethodData
    extends ParamsData {
        protected final String name;
        protected final boolean isDeclared;

        public MethodData(String name, Class<?> ... params) {
            this(false, name, params);
        }

        public MethodData(boolean isDeclared, String name, Class<?> ... params) {
            super(params);
            this.name = name;
            this.isDeclared = isDeclared;
        }

        public Method get(Class<?> aClass) throws NoSuchMethodException {
            return this.isDeclared ? aClass.getDeclaredMethod(this.name, this.params) : aClass.getMethod(this.name, this.params);
        }

        @Override
        public String toString() {
            return "TypeLocator.MethodData(super=" + super.toString() + ", name=" + this.name + ", isDeclared=" + this.isDeclared + ")";
        }
    }

    public static class ClassNames {
        protected final String[] names;

        public ClassNames(String ... names) {
            this.names = names;
        }

        public String toString() {
            return "TypeLocator.ClassNames(names=" + Arrays.deepToString(this.names) + ")";
        }
    }

    public static class ConstructorContainer<T> {
        private final Constructor<T> constructor;

        public ConstructorContainer(Constructor<T> constructor) {
            this.constructor = constructor;
        }

        public T newInstance(Object ... objects) {
            try {
                return this.constructor.newInstance(objects);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }

        public Constructor<T> getConstructor() {
            return this.constructor;
        }
    }

    public static class ParamsData {
        protected final Class<?>[] params;

        public ParamsData(Class<?> ... params) {
            this.params = params;
        }

        public String toString() {
            return "TypeLocator.ParamsData(params=" + Arrays.deepToString(this.params) + ")";
        }
    }
}

