/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.connector;

import com.google.common.collect.Maps;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ConnectScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.TransferState;
import net.minecraft.client.multiplayer.resolver.ServerAddress;
import org.tlauncher.connector.AbstractConnector;
import org.tlauncher.connector.ExtendedServerListData;
import org.tlauncher.util.TLModCfg;
import org.tlauncher.util.TypeLocator;

public class ForgeConnector
extends AbstractConnector
implements TypeLocator {
    private final Minecraft client;
    private Map<ServerData, ExtendedServerListData> serverDataTag;

    public void showGuiScreen(@Nullable Object clientGuiElement) {
        try {
            Method method = this.client.getClass().getMethod("m_91152_", TitleScreen.class);
            method.invoke((Object)this.client, clientGuiElement);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public void setupServerList() {
        this.serverDataTag = Collections.synchronizedMap(Maps.newHashMap());
    }

    @Override
    public void connectToServer(String host, int port) {
        this.setupServerList();
        if (TLModCfg.getMinecraftVersion().isGreaterThanOrEquals("1.20.6")) {
            try {
                Class<?> typeClass = Class.forName("net.minecraft.client.multiplayer.ServerData$Type");
                ServerData serverData = (ServerData)ServerData.class.getConstructor(String.class, String.class, typeClass).newInstance("Command Line", host + ":" + port, typeClass.getEnumConstants()[0]);
                this.connectToServer(host, port, serverData);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        } else {
            ServerData serverData = new ServerData("Command Line", host + ":" + port, false);
            this.connectToServer(null, serverData);
        }
    }

    private void connectToServer(String host, int port, ServerData serverData) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        ServerAddress serverAddress = new ServerAddress(host, port);
        ConnectScreen.class.getDeclaredMethod("startConnecting", Screen.class, Minecraft.class, ServerAddress.class, ServerData.class, Boolean.TYPE, TransferState.class).invoke(null, null, this.client, serverAddress, serverData, false, null);
    }

    public void connectToServer(Object guiMultiplayer, ServerData serverEntry) {
        ExtendedServerListData extendedData = this.serverDataTag.get(serverEntry);
        if (extendedData != null && extendedData.isBlocked) {
            this.showGuiScreen(null);
        } else {
            Object clientGuiElement = this.findConstructor(new TypeLocator.ClassNames("net.minecraft.client.gui.screens.ConnectScreen"), new TypeLocator.ParamsData(TitleScreen.class, Minecraft.class, ServerData.class)).newInstance(guiMultiplayer, this.client, serverEntry);
            this.showGuiScreen(clientGuiElement);
        }
    }

    public ForgeConnector(Minecraft client) {
        this.client = client;
    }
}

