/*
 * Decompiled with CFR 0.152.
 */
package by.gdev.http.download.impl;

import by.gdev.http.download.exeption.UploadFileException;
import by.gdev.http.download.handler.PostHandler;
import by.gdev.http.upload.download.downloader.DownloadElement;
import by.gdev.http.upload.download.downloader.DownloadFile;
import by.gdev.http.upload.download.downloader.DownloaderStatusEnum;
import by.gdev.util.InternetServerMap;
import com.google.common.eventbus.EventBus;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.LocalTime;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadRunnableImpl
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(DownloadRunnableImpl.class);
    private volatile DownloaderStatusEnum status;
    private Queue<DownloadElement> downloadElements;
    private List<DownloadElement> processedElements;
    private CloseableHttpClient httpclient;
    private RequestConfig requestConfig;
    private EventBus eventBus;
    private InternetServerMap workedServers;
    private int downloadMaxAttemps;
    private boolean resumeDownload;

    public DownloadRunnableImpl(Queue<DownloadElement> downloadElements, List<DownloadElement> processedElements, CloseableHttpClient httpclient, RequestConfig requestConfig, EventBus eventBus, InternetServerMap workedServers, int downloadMaxAttemps, boolean resumeDownloadFile) {
        this.downloadElements = downloadElements;
        this.processedElements = processedElements;
        this.httpclient = httpclient;
        this.requestConfig = requestConfig;
        this.eventBus = eventBus;
        this.workedServers = workedServers;
        this.downloadMaxAttemps = downloadMaxAttemps;
        this.resumeDownload = resumeDownloadFile;
    }

    @Override
    public void run() {
        DownloadElement element;
        while (this.status.equals((Object)DownloaderStatusEnum.WORK) && !this.status.equals((Object)DownloaderStatusEnum.CANCEL) && Objects.nonNull(element = this.downloadElements.poll())) {
            Throwable ex = null;
            this.processedElements.add(element);
            for (String repo : this.workedServers.getAliveDomainsOrUseAll(element.getRepo().getRepositories())) {
                try {
                    this.download(element, repo);
                    for (PostHandler h : element.getHandlers()) {
                        h.postProcessDownloadElement(element);
                    }
                    ex = null;
                    break;
                }
                catch (Throwable e1) {
                    ex = e1;
                }
            }
            if (!Objects.nonNull(ex)) continue;
            element.setError(ex);
        }
    }

    /*
     * Loose catch block
     */
    private void download(DownloadElement element, String repo) throws IOException, InterruptedException {
        File file = new File(element.getPathToDownload() + element.getMetadata().getPath());
        String url = null;
        for (int attempt = 0; attempt < this.downloadMaxAttemps; ++attempt) {
            try {
                CloseableHttpResponse response;
                HttpGet httpGet;
                BufferedOutputStream out;
                BufferedInputStream in;
                block15: {
                    element.setDownloadBytes(0L);
                    in = null;
                    out = null;
                    boolean resume = false;
                    url = repo + element.getMetadata().getRelativeUrl();
                    log.trace(url);
                    httpGet = new HttpGet(url);
                    if (!file.getParentFile().exists()) {
                        file.getParentFile().mkdirs();
                    }
                    if (this.resumeDownload) {
                        resume = this.tryDownloadPart(element, file, httpGet);
                    }
                    response = this.httpclient.execute((HttpUriRequest)httpGet);
                    StatusLine sl = response.getStatusLine();
                    if (sl.getStatusCode() != 200) {
                        throw new IOException(String.format("code %s phrase %s %s", sl.getStatusCode(), sl.getReasonPhrase(), url));
                    }
                    HttpEntity entity = response.getEntity();
                    in = new BufferedInputStream(entity.getContent());
                    out = new BufferedOutputStream(new FileOutputStream(file, resume));
                    byte[] buffer = new byte[1024];
                    int curread = in.read(buffer);
                    while (curread != -1 && !this.status.equals((Object)DownloaderStatusEnum.CANCEL)) {
                        out.write(buffer, 0, curread);
                        curread = in.read(buffer);
                        element.setDownloadBytes(element.getDownloadBytes() + (long)curread);
                    }
                    this.eventBus.post((Object)new DownloadFile(url, file.toString(), element.getDownloadBytes()));
                    LocalTime endTime = LocalTime.now();
                    element.setEnd(endTime);
                    if (response == null) break block15;
                    response.close();
                }
                httpGet.abort();
                IOUtils.closeQuietly((OutputStream)out);
                IOUtils.closeQuietly((InputStream)in);
                return;
                {
                    catch (Throwable throwable) {
                        try {
                            if (response != null) {
                                try {
                                    response.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Throwable throwable3) {
                            httpGet.abort();
                            IOUtils.closeQuietly(out);
                            IOUtils.closeQuietly(in);
                            throw throwable3;
                        }
                    }
                }
            }
            catch (Exception e) {
                if (attempt != this.downloadMaxAttemps - 1) continue;
                throw new UploadFileException(url, file.toString(), e.getMessage());
            }
        }
    }

    private boolean tryDownloadPart(DownloadElement element, File file, HttpGet httpGet) throws ClientProtocolException, IOException {
        if (file.exists() && Objects.nonNull(element.getMetadata().getSha1()) && file.length() < element.getMetadata().getSize()) {
            HttpHead hh = new HttpHead(httpGet.getURI());
            try (CloseableHttpResponse response = this.httpclient.execute((HttpUriRequest)hh);){
                Header h = response.getFirstHeader("accept-ranges");
                if (Objects.nonNull(h) && "bytes".equals(h.getValue())) {
                    log.info("download part with accept-ranges current size {}, full size {}", (Object)file.length(), (Object)element.getMetadata().getSize());
                    httpGet.addHeader("Range", "bytes= " + file.length() + "-" + element.getMetadata().getSize());
                    boolean bl = true;
                    return bl;
                }
            }
        }
        return false;
    }

    public DownloaderStatusEnum getStatus() {
        return this.status;
    }

    public Queue<DownloadElement> getDownloadElements() {
        return this.downloadElements;
    }

    public List<DownloadElement> getProcessedElements() {
        return this.processedElements;
    }

    public CloseableHttpClient getHttpclient() {
        return this.httpclient;
    }

    public RequestConfig getRequestConfig() {
        return this.requestConfig;
    }

    public EventBus getEventBus() {
        return this.eventBus;
    }

    public InternetServerMap getWorkedServers() {
        return this.workedServers;
    }

    public int getDownloadMaxAttemps() {
        return this.downloadMaxAttemps;
    }

    public boolean isResumeDownload() {
        return this.resumeDownload;
    }

    public void setStatus(DownloaderStatusEnum status) {
        this.status = status;
    }

    public void setDownloadElements(Queue<DownloadElement> downloadElements) {
        this.downloadElements = downloadElements;
    }

    public void setProcessedElements(List<DownloadElement> processedElements) {
        this.processedElements = processedElements;
    }

    public void setHttpclient(CloseableHttpClient httpclient) {
        this.httpclient = httpclient;
    }

    public void setRequestConfig(RequestConfig requestConfig) {
        this.requestConfig = requestConfig;
    }

    public void setEventBus(EventBus eventBus) {
        this.eventBus = eventBus;
    }

    public void setWorkedServers(InternetServerMap workedServers) {
        this.workedServers = workedServers;
    }

    public void setDownloadMaxAttemps(int downloadMaxAttemps) {
        this.downloadMaxAttemps = downloadMaxAttemps;
    }

    public void setResumeDownload(boolean resumeDownload) {
        this.resumeDownload = resumeDownload;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DownloadRunnableImpl)) {
            return false;
        }
        DownloadRunnableImpl other = (DownloadRunnableImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getDownloadMaxAttemps() != other.getDownloadMaxAttemps()) {
            return false;
        }
        if (this.isResumeDownload() != other.isResumeDownload()) {
            return false;
        }
        DownloaderStatusEnum this$status = this.getStatus();
        DownloaderStatusEnum other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
            return false;
        }
        Queue<DownloadElement> this$downloadElements = this.getDownloadElements();
        Queue<DownloadElement> other$downloadElements = other.getDownloadElements();
        if (this$downloadElements == null ? other$downloadElements != null : !this$downloadElements.equals(other$downloadElements)) {
            return false;
        }
        List<DownloadElement> this$processedElements = this.getProcessedElements();
        List<DownloadElement> other$processedElements = other.getProcessedElements();
        if (this$processedElements == null ? other$processedElements != null : !((Object)this$processedElements).equals(other$processedElements)) {
            return false;
        }
        CloseableHttpClient this$httpclient = this.getHttpclient();
        CloseableHttpClient other$httpclient = other.getHttpclient();
        if (this$httpclient == null ? other$httpclient != null : !this$httpclient.equals(other$httpclient)) {
            return false;
        }
        RequestConfig this$requestConfig = this.getRequestConfig();
        RequestConfig other$requestConfig = other.getRequestConfig();
        if (this$requestConfig == null ? other$requestConfig != null : !this$requestConfig.equals(other$requestConfig)) {
            return false;
        }
        EventBus this$eventBus = this.getEventBus();
        EventBus other$eventBus = other.getEventBus();
        if (this$eventBus == null ? other$eventBus != null : !this$eventBus.equals(other$eventBus)) {
            return false;
        }
        InternetServerMap this$workedServers = this.getWorkedServers();
        InternetServerMap other$workedServers = other.getWorkedServers();
        return !(this$workedServers == null ? other$workedServers != null : !((Object)this$workedServers).equals(other$workedServers));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DownloadRunnableImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getDownloadMaxAttemps();
        result = result * 59 + (this.isResumeDownload() ? 79 : 97);
        DownloaderStatusEnum $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        Queue<DownloadElement> $downloadElements = this.getDownloadElements();
        result = result * 59 + ($downloadElements == null ? 43 : $downloadElements.hashCode());
        List<DownloadElement> $processedElements = this.getProcessedElements();
        result = result * 59 + ($processedElements == null ? 43 : ((Object)$processedElements).hashCode());
        CloseableHttpClient $httpclient = this.getHttpclient();
        result = result * 59 + ($httpclient == null ? 43 : $httpclient.hashCode());
        RequestConfig $requestConfig = this.getRequestConfig();
        result = result * 59 + ($requestConfig == null ? 43 : $requestConfig.hashCode());
        EventBus $eventBus = this.getEventBus();
        result = result * 59 + ($eventBus == null ? 43 : $eventBus.hashCode());
        InternetServerMap $workedServers = this.getWorkedServers();
        result = result * 59 + ($workedServers == null ? 43 : ((Object)$workedServers).hashCode());
        return result;
    }

    public String toString() {
        return "DownloadRunnableImpl(status=" + (Object)((Object)this.getStatus()) + ", downloadElements=" + this.getDownloadElements() + ", processedElements=" + this.getProcessedElements() + ", httpclient=" + this.getHttpclient() + ", requestConfig=" + this.getRequestConfig() + ", eventBus=" + this.getEventBus() + ", workedServers=" + this.getWorkedServers() + ", downloadMaxAttemps=" + this.getDownloadMaxAttemps() + ", resumeDownload=" + this.isResumeDownload() + ")";
    }
}

