/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbessentials.util;

import dev.ftb.mods.ftbessentials.util.FTBEPlayerData;
import dev.ftb.mods.ftbessentials.util.TeleportPos;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class WarmupCooldownTeleporter {
    public final FTBEPlayerData playerData;
    public final ToIntFunction<ServerPlayer> cooldownConfig;
    private final ToIntFunction<ServerPlayer> warmupConfig;
    public long cooldown;
    private static final Map<UUID, Warmup> WARMUPS = new HashMap<UUID, Warmup>();

    public WarmupCooldownTeleporter(FTBEPlayerData playerData, ToIntFunction<ServerPlayer> cooldownConfig, ToIntFunction<ServerPlayer> warmupConfig) {
        this.playerData = playerData;
        this.cooldownConfig = cooldownConfig;
        this.warmupConfig = warmupConfig;
        this.cooldown = 0L;
    }

    public TeleportPos.TeleportResult checkCooldown() {
        long now = System.currentTimeMillis();
        if (now < this.cooldown) {
            return () -> this.cooldown - now;
        }
        return TeleportPos.TeleportResult.SUCCESS;
    }

    public TeleportPos.TeleportResult teleport(ServerPlayer player, Function<ServerPlayer, TeleportPos> positionGetter) {
        TeleportPos.TeleportResult cooldownResult = this.checkCooldown();
        if (!cooldownResult.isSuccess()) {
            return cooldownResult;
        }
        int warmupTime = this.warmupConfig.applyAsInt(player);
        if (warmupTime == 0) {
            return this.teleportNow(player, positionGetter);
        }
        WARMUPS.put(player.m_142081_(), new Warmup(System.currentTimeMillis() + (long)warmupTime * 1000L, this, player.m_20182_(), positionGetter));
        return TeleportPos.TeleportResult.SUCCESS;
    }

    private TeleportPos.TeleportResult teleportNow(ServerPlayer player, Function<ServerPlayer, TeleportPos> positionGetter) {
        this.cooldown = System.currentTimeMillis() + Math.max(0L, (long)this.cooldownConfig.applyAsInt(player) * 1000L);
        TeleportPos teleportPos = positionGetter.apply(player);
        TeleportPos currentPos = new TeleportPos((Entity)player);
        TeleportPos.TeleportResult res = teleportPos.teleport(player);
        if (!res.isSuccess()) {
            return res;
        }
        if (this == this.playerData.backTeleporter) {
            this.playerData.popTeleportHistory();
        } else {
            this.playerData.addTeleportHistory(player, currentPos);
        }
        return res;
    }

    public static void tickWarmups(MinecraftServer server) {
        if (WARMUPS.isEmpty()) {
            return;
        }
        HashSet<UUID> toRemove = new HashSet<UUID>();
        long now = System.currentTimeMillis();
        for (Map.Entry<UUID, Warmup> entry : WARMUPS.entrySet()) {
            UUID playerId = entry.getKey();
            ServerPlayer player = server.m_6846_().m_11259_(playerId);
            if (player != null) {
                Warmup warmup = entry.getValue();
                if (warmup.when() <= now) {
                    TeleportPos.TeleportResult res = warmup.teleporter().teleportNow(player, warmup.positionGetter());
                    toRemove.add(playerId);
                    res.runCommand(player);
                    continue;
                }
                if (player.m_20182_().m_82557_(warmup.initialPos) > 0.25) {
                    toRemove.add(playerId);
                    player.m_5661_((Component)new TextComponent("Teleportation interrupted!").m_130940_(ChatFormatting.RED), true);
                    continue;
                }
                long seconds = (warmup.when() - now) / 1000L;
                String secStr = seconds == 1L ? "second" : "seconds";
                player.m_5661_((Component)new TextComponent(String.format("Teleporting in %d %s", seconds, secStr)).m_130940_(ChatFormatting.YELLOW), true);
                continue;
            }
            toRemove.add(playerId);
        }
        toRemove.forEach(WARMUPS::remove);
    }

    public static void cancelWarmup(ServerPlayer player) {
        if (WARMUPS.remove(player.m_142081_()) != null) {
            player.m_5661_((Component)new TextComponent("Teleportation interrupted!").m_130940_(ChatFormatting.RED), true);
        }
    }

    private record Warmup(long when, WarmupCooldownTeleporter teleporter, Vec3 initialPos, Function<ServerPlayer, TeleportPos> positionGetter) {
    }
}

