/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.util;

import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import org.tlauncher.TLSkinCape;
import org.tlauncher.util.MinecraftVersion;

public final class TLModCfg {
    private static final String BUILD_TIMESTAMP = "1752514167370";
    private static String MINECRAFT_VERSION_RAW = "fabric1.20.2";
    private static GameVersionCategory GAME_VERSION_CATEGORY;
    private static boolean isForgeDetected;
    private static boolean isOptiFineDetected;
    private static boolean isFabricDetected;
    private static final MinecraftVersion minecraftVersion;

    private static void defineGameVersionCategory(ClassLoader classLoader) {
        GAME_VERSION_CATEGORY = GameVersionCategory.CAVES_AND_CLIFFS;
    }

    public static boolean isElytraSupported() {
        return !MINECRAFT_VERSION_RAW.startsWith("1.8");
    }

    public static boolean isNativeImageSupported() {
        return !MINECRAFT_VERSION_RAW.startsWith("1.8") && !MINECRAFT_VERSION_RAW.equals("1.12.2");
    }

    public static GameVersionCategory getGameVersionCategory() {
        if (GAME_VERSION_CATEGORY == null) {
            TLModCfg.defineGameVersionCategory(TLSkinCape.getMinecraftInstance().getClass().getClassLoader());
        }
        return GAME_VERSION_CATEGORY;
    }

    private static String getBuildTimestamp() {
        try {
            return Instant.ofEpochMilli(Long.parseLong(BUILD_TIMESTAMP)).atZone(ZoneId.systemDefault()).format(DateTimeFormatter.ISO_DATE_TIME);
        }
        catch (Throwable t) {
            return String.format("unknown(%s)", BUILD_TIMESTAMP);
        }
    }

    private TLModCfg() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static boolean isForgeDetected() {
        return isForgeDetected;
    }

    public static boolean isOptiFineDetected() {
        return isOptiFineDetected;
    }

    public static boolean isFabricDetected() {
        return isFabricDetected;
    }

    public static MinecraftVersion getMinecraftVersion() {
        return minecraftVersion;
    }

    static {
        System.out.printf("[TLSkinCape] Current TLSkinCape version is 1.36 built at %s.%n", TLModCfg.getBuildTimestamp());
        minecraftVersion = new MinecraftVersion(MINECRAFT_VERSION_RAW);
        if (TLModCfg.getMinecraftVersion().isForge()) {
            isForgeDetected = true;
            MINECRAFT_VERSION_RAW = MINECRAFT_VERSION_RAW.replace("forge", "");
        }
        if (TLModCfg.getMinecraftVersion().isFabric()) {
            isFabricDetected = true;
            MINECRAFT_VERSION_RAW = MINECRAFT_VERSION_RAW.replace("fabric", "");
        }
        System.out.printf("[TLSkinCape] Current Minecraft version is %s#%s.%n", TLModCfg.getMinecraftVersion(), TLModCfg.getMinecraftVersion().getVersionIndex());
        try {
            Class.forName("net.optifine.shaders.ShadersTex", false, TLModCfg.class.getClassLoader());
            isOptiFineDetected = true;
            System.out.println("[TLSkinCape] OptiFine detected.");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public static enum GameVersionCategory {
        CAVES_AND_CLIFFS;

    }
}

