/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.configuration;

import by.gdev.http.download.config.HttpClientConfig;
import by.gdev.http.download.impl.FileCacheServiceImpl;
import by.gdev.http.download.impl.GsonServiceImpl;
import by.gdev.http.download.impl.HttpServiceImpl;
import by.gdev.http.download.service.FileCacheService;
import by.gdev.http.download.service.GsonService;
import by.gdev.http.download.service.HttpService;
import by.gdev.util.DesktopUtil;
import by.gdev.util.DesktopUtilZone;
import by.gdev.util.InternetServerMap;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.http.impl.client.CloseableHttpClient;

public class ModConfiguration {
    private List<String> domains;
    private final int ttl = 100000;
    private final int repeatRequest = 3;
    private InternetServerMap internetServerMap;
    private HttpService httpService;
    private Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private Path cacheDirectory = Paths.get("cache", new String[0]).toAbsolutePath();
    private GsonService gsonService;
    private CloseableHttpClient client = HttpClientConfig.getInstanceHttpClient(5000, 30000, 5, 20);
    private FileCacheService fileCacheService;

    public ModConfiguration() {
        this.domains = DesktopUtilZone.removeRuZoneFromOther(System.getProperty("country"), Lists.newArrayList((Object[])new String[]{"https://auth.tlauncher.org/", "https://auth.tlauncher.ru/"}));
        this.internetServerMap = DesktopUtil.testServers(this.domains.stream().map(e -> e + "skin/api/check.bin").collect(Collectors.toList()), this.client);
        this.httpService = new HttpServiceImpl(null, this.client, this.internetServerMap.values().stream().anyMatch(e -> e) ? 3 : 1);
        this.fileCacheService = new FileCacheServiceImpl(this.httpService, this.gson, StandardCharsets.UTF_8, this.cacheDirectory, 100000, this.internetServerMap);
        this.gsonService = new GsonServiceImpl(this.gson, this.fileCacheService, this.httpService, this.internetServerMap);
    }

    public List<String> getDomains() {
        return this.domains;
    }

    public GsonService getGsonService() {
        return this.gsonService;
    }

    public CloseableHttpClient getClient() {
        return this.client;
    }

    public FileCacheService getFileCacheService() {
        return this.fileCacheService;
    }
}

