/*
 * Decompiled with CFR 0.152.
 */
package io.grayray75.mods.fpsdisplay.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.grayray75.mods.fpsdisplay.config.ConfigData;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.fabricmc.loader.api.FabricLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConfigManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static ConfigData config;

    public static ConfigData getConfig() {
        return config;
    }

    private static File getFilePath() {
        Path path = Paths.get(FabricLoader.getInstance().getConfigDir().toString(), "fpsdisplay.json");
        return new File(path.toString());
    }

    public static ConfigData loadConfig() {
        try {
            BufferedReader br = new BufferedReader(new FileReader(ConfigManager.getFilePath()));
            ConfigData parsed = (ConfigData)GSON.fromJson((Reader)br, ConfigData.class);
            if (parsed != null) {
                config = parsed;
            }
        }
        catch (FileNotFoundException ex) {
            LOGGER.info("[fpsdisplay] Couldn't load configuration file, reverting to defaults!");
        }
        catch (Exception ex) {
            LOGGER.info("[fpsdisplay] Couldn't load configuration file, reverting to defaults!");
            ex.printStackTrace();
        }
        if (config == null) {
            config = new ConfigData();
            ConfigManager.saveConfig();
        }
        return config;
    }

    public static void saveConfig() {
        try {
            String jsonString = GSON.toJson((Object)config);
            FileWriter fileWriter = new FileWriter(ConfigManager.getFilePath());
            fileWriter.write(jsonString);
            fileWriter.flush();
            fileWriter.close();
        }
        catch (IOException e) {
            LOGGER.info("[fpsdisplay] Couldn't save configuration file.");
            e.printStackTrace();
        }
    }
}

