/*
 * Decompiled with CFR 0.152.
 */
package com.spyxar.tiptapshow.components;

import com.mojang.blaze3d.systems.RenderSystem;
import com.spyxar.tiptapshow.ClickCounter;
import com.spyxar.tiptapshow.TipTapShowMod;
import com.spyxar.tiptapshow.config.TipTapShowConfig;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_757;

public class RenderableButton {
    private static final int ROUNDED_CORNER_RADIUS = 5;
    private static final int ROUNDED_CORNER_SAMPLES = 40;
    private final int x;
    public int y;
    private final int width;
    private final int height;
    private final class_304 key;
    private final String displayText;
    private static final Map<String, Integer> cachedRainbowColors = new HashMap<String, Integer>();
    private static long lastUsedRainbowMillis = 0L;
    private static int rainbowFramesSkipped = 0;
    private static final float[][] cornerCache = new float[4][3];

    public RenderableButton(int x, int y, int width, int height, class_304 key) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.key = key;
        this.displayText = RenderableButton.getDisplayText(key);
    }

    public void render(class_332 context) {
        int textColor;
        int fillColor;
        boolean isPressed = this.key.method_1434();
        int n = fillColor = isPressed ? TipTapShowMod.config.pressedBackgroundColor : TipTapShowMod.config.backgroundColor;
        if (TipTapShowMod.config.rainbowMode) {
            this.maybeClearRainbowCache();
            textColor = this.getRainbowColor(this.x);
        } else {
            textColor = isPressed ? TipTapShowMod.config.pressedKeyColor : TipTapShowMod.config.keyColor;
        }
        if (TipTapShowMod.config.roundedBackground) {
            RenderableButton.renderRoundedRectangle(context.method_51448(), fillColor, this.x, this.y, this.width, this.height, 5.0f, 40.0f);
        } else {
            context.method_51739(class_1921.method_51785(), this.x, this.y, this.x + this.width, this.y + this.height, fillColor);
        }
        if (this.displayText.equals("{jumpKey}")) {
            RenderableButton.renderJump(context, this, textColor);
            return;
        }
        class_310 client = class_310.method_1551();
        if (this.displayText.contains("\n")) {
            String[] splitText = this.displayText.split("\n", 2);
            String firstLine = splitText[0];
            String secondLine = splitText[1];
            float firstLineX = (float)this.width / 2.0f + (float)this.x - (float)client.field_1772.method_1727(firstLine) / 2.0f;
            float secondLineX = (float)this.width / 2.0f + (float)this.x - (float)client.field_1772.method_1727(secondLine) / 2.0f;
            float f = (float)this.height / 2.0f + (float)this.y;
            Objects.requireNonNull(client.field_1772);
            float lineY = f - (float)(9 * 2) / 2.0f;
            RenderableButton.renderText(context, firstLine, firstLineX, lineY, textColor);
            Objects.requireNonNull(client.field_1772);
            RenderableButton.renderText(context, secondLine, secondLineX, lineY + 9.0f, textColor);
            return;
        }
        int letterWidth = client.field_1772.method_1727(this.displayText);
        float lineX = (float)this.width / 2.0f + (float)this.x - (float)letterWidth / 2.0f;
        float f = (float)this.height / 2.0f + (float)this.y;
        Objects.requireNonNull(client.field_1772);
        float lineY = f - 9.0f / 2.0f;
        RenderableButton.renderText(context, this.displayText, lineX, lineY, textColor);
    }

    private static void renderJump(class_332 context, RenderableButton button, int textColor) {
        int letterWidth = (int)((double)button.width * 0.6);
        float lineX = (float)button.width / 2.0f + (float)button.x;
        float lineY = (float)button.height / 2.0f + (float)button.y;
        context.method_25294(Math.round(lineX - (float)letterWidth / 2.0f), (int)lineY - 1, Math.round(lineX + (float)letterWidth / 2.0f), (int)lineY, textColor);
    }

    private static void renderText(class_332 context, String text, float lineX, float lineY, int textColor) {
        if (TipTapShowMod.config.keyShadow) {
            context.method_27535(class_310.method_1551().field_1772, class_2561.method_30163((String)text), (int)lineX, (int)lineY, textColor);
            return;
        }
        context.method_51433(class_310.method_1551().field_1772, text, (int)lineX, (int)lineY, textColor, false);
    }

    private static String getDisplayText(class_304 key) {
        if (key.method_1435(class_310.method_1551().field_1690.field_1886)) {
            return RenderableButton.getDisplayTextForUseOrAttackKey(key, ClickCounter.getLeftCps(), "text.tiptapshow.lmb");
        }
        if (key.method_1435(class_310.method_1551().field_1690.field_1904)) {
            return RenderableButton.getDisplayTextForUseOrAttackKey(key, ClickCounter.getRightCps(), "text.tiptapshow.rmb");
        }
        if (key.method_1435(class_310.method_1551().field_1690.field_1903)) {
            return "{jumpKey}";
        }
        return key.method_16007().getString().toUpperCase();
    }

    private static String getDisplayTextForUseOrAttackKey(class_304 key, int clicks, String label) {
        if (!RenderableButton.shouldRenderCps(clicks)) {
            return key.method_1427() ? class_2561.method_43471((String)label).getString() : key.method_16007().getString().toUpperCase();
        }
        return (key.method_1427() ? class_2561.method_43471((String)label).getString() : key.method_16007().getString().toUpperCase()) + "\n" + clicks + " " + class_2561.method_43471((String)"text.tiptapshow.cps").getString();
    }

    private static boolean shouldRenderCps(int clicks) {
        return TipTapShowMod.config.cpsType == TipTapShowConfig.CpsType.ALWAYS || TipTapShowMod.config.cpsType == TipTapShowConfig.CpsType.ON_CLICK && clicks != 0;
    }

    public int getRainbowColor(double offset) {
        if (cachedRainbowColors.containsKey(this.displayText)) {
            return cachedRainbowColors.get(this.displayText);
        }
        float hue = (float)((double)(lastUsedRainbowMillis % 1000L) / 1000.0) + (float)((double)this.width + offset / (double)this.width * ((double)TipTapShowMod.config.rainbowOffset / 10.0));
        int newColor = Color.HSBtoRGB(hue, 1.0f, 1.0f);
        cachedRainbowColors.put(this.displayText, newColor);
        return newColor;
    }

    public void maybeClearRainbowCache() {
        int framesToSkip = (6 - TipTapShowMod.config.rainbowSpeed) * 7;
        if (framesToSkip <= rainbowFramesSkipped) {
            cachedRainbowColors.clear();
            lastUsedRainbowMillis += (long)(1000 / Math.max(class_310.method_1551().method_47599(), 60));
            rainbowFramesSkipped = 0;
        }
        ++rainbowFramesSkipped;
    }

    private static void renderRoundedRectangle(class_4587 stack, int color, float x, float y, float width, float height, float radius, float samples) {
        RenderableButton.renderRoundedRectangle(stack, x, y, width, height, radius, radius, radius, radius, color, samples);
    }

    private static void renderRoundedRectangle(class_4587 matrices, float x, float y, float width, float height, float radiusTL, float radiusTR, float radiusBL, float radiusBR, int color, float samples) {
        RenderSystem.disableCull();
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShader(class_757::method_34540);
        class_289 tessellator = class_289.method_1348();
        class_287 bufferBuilder = tessellator.method_1349();
        bufferBuilder.method_1328(class_293.class_5596.field_27381, class_290.field_1576);
        float endX = x + width;
        float endY = y + height;
        RenderableButton.fillCornerCache(radiusBR, endX - radiusBR, endY - radiusBR, 0);
        RenderableButton.fillCornerCache(radiusTR, endX - radiusTR, y + radiusTR, 1);
        RenderableButton.fillCornerCache(radiusTL, x + radiusTL, y + radiusTL, 2);
        RenderableButton.fillCornerCache(radiusBL, x + radiusBL, endY - radiusBL, 3);
        for (int i = 0; i < 4; ++i) {
            float[] current = cornerCache[i];
            float radius = current[0];
            for (float angle = (float)(i * 90); angle <= (float)((i + 1) * 90); angle += 90.0f / samples) {
                float radianAngle = (float)Math.toRadians(angle);
                float sin = (float)(Math.sin(radianAngle) * (double)radius);
                float cos = (float)(Math.cos(radianAngle) * (double)radius);
                bufferBuilder.method_22918(matrices.method_23760().method_23761(), current[1] + sin, current[2] + cos, 0.0f).method_39415(color).method_1344();
            }
        }
        tessellator.method_1350();
        RenderSystem.enableCull();
        RenderSystem.disableBlend();
    }

    private static void fillCornerCache(float a, float b, float c, int i) {
        RenderableButton.cornerCache[i][0] = a;
        RenderableButton.cornerCache[i][1] = b;
        RenderableButton.cornerCache[i][2] = c;
    }
}

